/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ScrollableThumbnail
extends Thumbnail {
    private FigureListener figureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            ScrollableThumbnail.this.reconfigureSelectorBounds();
        }
    };
    private KeyListener keyListener = new KeyListener.Stub(){

        public void keyPressed(KeyEvent ke) {
            int moveX = ((ScrollableThumbnail)ScrollableThumbnail.this).viewport.getClientArea().width / 4;
            int moveY = ((ScrollableThumbnail)ScrollableThumbnail.this).viewport.getClientArea().height / 4;
            if (ke.keycode == 0x1000007 || (ScrollableThumbnail.this.isMirrored() ? ke.keycode == 0x1000004 : ke.keycode == 0x1000003)) {
                ScrollableThumbnail.this.viewport.setViewLocation(ScrollableThumbnail.this.viewport.getViewLocation().translate(-moveX, 0));
            } else if (ke.keycode == 0x1000008 || (ScrollableThumbnail.this.isMirrored() ? ke.keycode == 0x1000003 : ke.keycode == 0x1000004)) {
                ScrollableThumbnail.this.viewport.setViewLocation(ScrollableThumbnail.this.viewport.getViewLocation().translate(moveX, 0));
            } else if (ke.keycode == 0x1000001 || ke.keycode == 0x1000005) {
                ScrollableThumbnail.this.viewport.setViewLocation(ScrollableThumbnail.this.viewport.getViewLocation().translate(0, -moveY));
            } else if (ke.keycode == 0x1000002 || ke.keycode == 0x1000006) {
                ScrollableThumbnail.this.viewport.setViewLocation(ScrollableThumbnail.this.viewport.getViewLocation().translate(0, moveY));
            }
        }
    };
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            ScrollableThumbnail.this.reconfigureSelectorBounds();
        }
    };
    private SelectorFigure selector;
    private ScrollSynchronizer syncher;
    private Viewport viewport;

    public ScrollableThumbnail() {
        this.initialize();
    }

    public ScrollableThumbnail(Viewport port) {
        this.setViewport(port);
        this.initialize();
    }

    public void deactivate() {
        this.viewport.removePropertyChangeListener("viewLocation", this.propListener);
        this.viewport.removeFigureListener(this.figureListener);
        this.remove(this.selector);
        this.selector.dispose();
        super.deactivate();
    }

    private double getViewportScaleX() {
        return (double)this.targetSize.width / (double)this.viewport.getContents().getBounds().width;
    }

    private double getViewportScaleY() {
        return (double)this.targetSize.height / (double)this.viewport.getContents().getBounds().height;
    }

    private void initialize() {
        this.selector = new SelectorFigure();
        this.syncher = new ScrollSynchronizer();
        this.selector.addMouseListener(this.syncher);
        this.selector.addMouseMotionListener(this.syncher);
        this.selector.setFocusTraversable(true);
        this.selector.addKeyListener(this.keyListener);
        this.add(this.selector);
        ClickScrollerAndDragTransferrer transferrer = new ClickScrollerAndDragTransferrer();
        this.addMouseListener(transferrer);
        this.addMouseMotionListener(transferrer);
    }

    private void reconfigureSelectorBounds() {
        Rectangle rect = new Rectangle();
        Point offset = this.viewport.getViewLocation();
        offset.x -= this.viewport.getHorizontalRangeModel().getMinimum();
        offset.y -= this.viewport.getVerticalRangeModel().getMinimum();
        rect.setLocation(offset);
        rect.setSize(this.viewport.getClientArea().getSize());
        rect.scale(this.getViewportScaleX(), this.getViewportScaleY());
        rect.translate(this.getClientArea().getLocation());
        this.selector.setBounds(rect);
    }

    protected void setScales(float scaleX, float scaleY) {
        if (scaleX == this.getScaleX() && scaleY == this.getScaleY()) {
            return;
        }
        super.setScales(scaleX, scaleY);
        this.reconfigureSelectorBounds();
    }

    public void setViewport(Viewport port) {
        port.addPropertyChangeListener("viewLocation", this.propListener);
        port.addFigureListener(this.figureListener);
        this.viewport = port;
    }

    private class ClickScrollerAndDragTransferrer
    extends MouseMotionListener.Stub
    implements MouseListener {
        private boolean dragTransfer;

        private ClickScrollerAndDragTransferrer() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            if (this.dragTransfer) {
                ScrollableThumbnail.this.syncher.mouseDragged(me);
            }
        }

        public void mousePressed(MouseEvent me) {
            if (!ScrollableThumbnail.this.getClientArea().contains(me.getLocation())) {
                return;
            }
            Dimension selectorCenter = ScrollableThumbnail.this.selector.getBounds().getSize().scale(0.5);
            Point scrollPoint = me.getLocation().getTranslated(ScrollableThumbnail.this.getLocation().getNegated()).translate(selectorCenter.negate()).scale(1.0 / ScrollableThumbnail.this.getViewportScaleX(), 1.0 / ScrollableThumbnail.this.getViewportScaleY()).translate(ScrollableThumbnail.this.viewport.getHorizontalRangeModel().getMinimum(), ScrollableThumbnail.this.viewport.getVerticalRangeModel().getMinimum());
            ScrollableThumbnail.this.viewport.setViewLocation(scrollPoint);
            ScrollableThumbnail.this.syncher.mousePressed(me);
            this.dragTransfer = true;
        }

        public void mouseReleased(MouseEvent me) {
            ScrollableThumbnail.this.syncher.mouseReleased(me);
            this.dragTransfer = false;
        }
    }

    private class ScrollSynchronizer
    extends MouseMotionListener.Stub
    implements MouseListener {
        private Point startLocation;
        private Point viewLocation;

        private ScrollSynchronizer() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            if (this.startLocation != null) {
                Dimension d = me.getLocation().getDifference(this.startLocation);
                d.scale(1.0 / ScrollableThumbnail.this.getViewportScaleX(), 1.0 / ScrollableThumbnail.this.getViewportScaleY());
                ScrollableThumbnail.this.viewport.setViewLocation(this.viewLocation.getTranslated(d));
                me.consume();
            }
        }

        public void mousePressed(MouseEvent me) {
            this.startLocation = me.getLocation();
            this.viewLocation = ScrollableThumbnail.this.viewport.getViewLocation();
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
        }
    }

    private class SelectorFigure
    extends Figure {
        private Rectangle iBounds;
        private Image image;

        private SelectorFigure() {
            Display display = Display.getCurrent();
            PaletteData pData = new PaletteData(255, 65280, 0xFF0000);
            RGB rgb = ColorConstants.menuBackgroundSelected.getRGB();
            int fillColor = pData.getPixel(rgb);
            ImageData iData = new ImageData(1, 1, 24, pData);
            iData.setPixel(0, 0, fillColor);
            iData.setAlpha(0, 0, 55);
            this.image = new Image((Device)display, iData);
            this.iBounds = new Rectangle(0, 0, 1, 1);
        }

        protected void dispose() {
            this.image.dispose();
        }

        public void paintFigure(Graphics g) {
            Rectangle bounds = this.getBounds().getCopy();
            if (bounds.width < 5 || bounds.height < 5) {
                return;
            }
            Dimension thumbnailSize = new Dimension(ScrollableThumbnail.this.getThumbnailImage());
            Dimension size = this.getSize().getExpanded(1, 1);
            if (size.contains(thumbnailSize)) {
                return;
            }
            --bounds.height;
            --bounds.width;
            g.drawImage(this.image, this.iBounds, bounds);
            g.setForegroundColor(ColorConstants.menuBackgroundSelected);
            g.drawRectangle(bounds);
        }
    }
}

