/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import java.util.Vector;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQuery;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQueryHint;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmQuery<X extends XmlQuery>
extends AbstractOrmXmlContextNode
implements OrmQuery {
    protected final X xmlQuery;
    protected String name;
    protected String query;
    protected final Vector<OrmQueryHint> hints = new Vector();
    protected final HintContainerAdapter hintContainerAdapter = new HintContainerAdapter();

    protected AbstractOrmQuery(XmlContextNode parent, X xmlQuery) {
        super(parent);
        this.xmlQuery = xmlQuery;
        this.name = xmlQuery.getName();
        this.query = this.getUnescapedQuery();
        this.initializeHints();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlQuery.getName());
        this.setQuery_(this.getUnescapedQuery());
        this.syncHints();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getHints());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlQuery.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        this.setQuery_(query);
        this.xmlQuery.setQuery(this.convertToEscapeQuery(query));
    }

    protected void setQuery_(String query) {
        String old = this.query;
        this.query = query;
        this.firePropertyChanged("query", old, query);
    }

    protected String getUnescapedQuery() {
        String queryString = this.xmlQuery.getQuery();
        if (StringTools.stringIsNotEmpty((String)queryString)) {
            queryString = ExpressionTools.unescape((CharSequence)queryString, (int[])new int[1]);
        }
        return queryString;
    }

    protected String convertToEscapeQuery(String queryString) {
        if (StringTools.stringIsNotEmpty((String)queryString)) {
            queryString = ExpressionTools.escape((CharSequence)queryString, (int[])new int[1]);
        }
        return queryString;
    }

    @Override
    public ListIterable<OrmQueryHint> getHints() {
        return new LiveCloneListIterable(this.hints);
    }

    @Override
    public int getHintsSize() {
        return this.hints.size();
    }

    @Override
    public OrmQueryHint addHint() {
        return this.addHint(this.hints.size());
    }

    @Override
    public OrmQueryHint addHint(int index) {
        XmlQueryHint xmlHint = this.buildXmlQueryHint();
        OrmQueryHint hint = this.addHint_(index, xmlHint);
        this.xmlQuery.getHints().add(index, (Object)xmlHint);
        return hint;
    }

    protected XmlQueryHint buildXmlQueryHint() {
        return OrmFactory.eINSTANCE.createXmlQueryHint();
    }

    @Override
    public void removeHint(QueryHint hint) {
        this.removeHint(this.hints.indexOf(hint));
    }

    @Override
    public void removeHint(int index) {
        this.removeHint_(index);
        this.xmlQuery.getHints().remove(index);
    }

    protected void removeHint_(int index) {
        this.removeItemFromList(index, this.hints, "hints");
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.hints, "hints");
        this.xmlQuery.getHints().move(targetIndex, sourceIndex);
    }

    protected void initializeHints() {
        for (XmlQueryHint xmlHint : this.getXmlHints()) {
            this.hints.add(this.buildHint(xmlHint));
        }
    }

    protected OrmQueryHint buildHint(XmlQueryHint xmlHint) {
        return this.getContextNodeFactory().buildOrmQueryHint(this, xmlHint);
    }

    protected void syncHints() {
        ContextContainerTools.synchronizeWithResourceModel(this.hintContainerAdapter);
    }

    protected Iterable<XmlQueryHint> getXmlHints() {
        return new LiveCloneIterable(this.xmlQuery.getHints());
    }

    protected void moveHint_(int index, OrmQueryHint hint) {
        this.moveItemInList(index, hint, this.hints, "hints");
    }

    protected OrmQueryHint addHint_(int index, XmlQueryHint xmlHint) {
        OrmQueryHint hint = this.buildHint(xmlHint);
        this.addItemToList(index, hint, this.hints, "hints");
        return hint;
    }

    protected void removeHint_(OrmQueryHint hint) {
        this.removeHint_(this.hints.indexOf(hint));
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages);
        this.validateQuery(messages, reporter);
    }

    protected void validateName(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_NAME_UNDEFINED", EMPTY_STRING_ARRAY, this, this.getNameTextRange()));
        }
    }

    protected void validateQuery(List<IMessage> messages, IReporter reporter) {
        if (StringTools.stringIsEmpty((String)this.query)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_STATEMENT_UNDEFINED", new String[]{this.name}, this, this.getNameTextRange()));
        } else {
            this.validateQuery_(messages, reporter);
        }
    }

    protected abstract void validateQuery_(List<IMessage> var1, IReporter var2);

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlQuery.getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.xmlQuery.getNameTextRange());
    }

    @Override
    public TextRange getQueryTextRange() {
        return this.getValidationTextRange(this.xmlQuery.getQueryTextRange());
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    public X getXmlQuery() {
        return this.xmlQuery;
    }

    @Override
    public boolean overrides(Query other) {
        return MappingTools.nodeOverrides(this, other, PRECEDENCE_TYPE_LIST);
    }

    @Override
    public boolean duplicates(Query other) {
        return MappingTools.nodesAreDuplicates(this, other);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HintContainerAdapter
    implements ContextContainerTools.Adapter<OrmQueryHint, XmlQueryHint> {
        protected HintContainerAdapter() {
        }

        @Override
        public Iterable<OrmQueryHint> getContextElements() {
            return AbstractOrmQuery.this.getHints();
        }

        @Override
        public Iterable<XmlQueryHint> getResourceElements() {
            return AbstractOrmQuery.this.getXmlHints();
        }

        @Override
        public XmlQueryHint getResourceElement(OrmQueryHint contextElement) {
            return contextElement.getXmlQueryHint();
        }

        @Override
        public void moveContextElement(int index, OrmQueryHint element) {
            AbstractOrmQuery.this.moveHint_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlQueryHint resourceElement) {
            AbstractOrmQuery.this.addHint_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmQueryHint element) {
            AbstractOrmQuery.this.removeHint_(element);
        }
    }
}

