/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.ExceptionHandler;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeData;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeDataUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreePopulationUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class XMLTreeViewer {
    private Button btnSingleAdd;
    private Button btnMultiAdd;
    private TreeViewer treeViewer;
    private Composite btnComposite;
    private String xPathExpression = "";
    private boolean includeAttr;

    XMLTreeViewer(Composite parent, boolean supportMultiSelection) {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(47, -5);
        data.bottom = new FormAttachment(100, -5);
        Group treeGroup = new Group(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        treeGroup.setLayout((Layout)layout);
        treeGroup.setLayoutData((Object)data);
        this.treeViewer = supportMultiSelection ? new TreeViewer((Composite)treeGroup, 268438274) : new TreeViewer((Composite)treeGroup, 268438276);
        FormData data2 = new FormData();
        data2.left = new FormAttachment((Control)treeGroup, 5);
        data2.bottom = new FormAttachment(50);
        this.btnComposite = new Composite(parent, 0);
        this.btnComposite.setLayoutData((Object)data2);
        GridLayout btnLayout = new GridLayout();
        btnLayout.verticalSpacing = 25;
        this.btnComposite.setLayout((Layout)btnLayout);
        this.btnSingleAdd = new Button(this.btnComposite, 0);
        this.btnSingleAdd.setText(">");
        this.btnSingleAdd.setEnabled(false);
        this.btnMultiAdd = new Button(this.btnComposite, 0);
        this.btnMultiAdd.setText(">>");
        this.btnMultiAdd.setToolTipText(Messages.getString("ColumnMappingPage.AddAllButton.tooltip"));
        this.btnMultiAdd.setEnabled(true);
        int width = Math.max(45, this.btnMultiAdd.computeSize((int)-1, (int)-1).x);
        GridData btnGd = new GridData();
        btnGd.widthHint = width;
        this.btnSingleAdd.setLayoutData((Object)btnGd);
        GridData btnGd2 = new GridData();
        btnGd2.widthHint = width;
        this.btnMultiAdd.setLayoutData((Object)btnGd2);
        if (!supportMultiSelection) {
            this.btnMultiAdd.setVisible(false);
        }
        treeGroup.setText(Messages.getString("xPathChoosePage.messages.xmlStructure"));
        this.treeViewer.getTree().addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem currentItem = (TreeItem)event.item;
                TreeNodeData treeNodeData = (TreeNodeData)currentItem.getData();
                if (treeNodeData.hasBeenExpandedOnce()) {
                    return;
                }
                treeNodeData.setHasBeenExpandedOnce();
                currentItem.removeAll();
                try {
                    Object[] children = treeNodeData.getTreeNode().getChildren();
                    if (children != null && children.length > 0) {
                        TreePopulationUtil.populateTreeItems(currentItem, treeNodeData.getTreeNode().getChildren(), XMLTreeViewer.this.xPathExpression, XMLTreeViewer.this.includeAttr);
                    }
                }
                catch (OdaException e) {
                    ExceptionHandler.showException(null, Messages.getString("error.label"), e.getMessage(), e);
                }
            }
        });
        this.treeViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TreeItem[] items = XMLTreeViewer.this.treeViewer.getTree().getItems();
                int i = 0;
                while (i < items.length) {
                    if (((TreeNodeData)items[i].getData()).getXPathStatus()) {
                        if (items[i].getFont() != null) {
                            items[i].getFont().dispose();
                        }
                        if (items[i].getBackground() != null) {
                            items[i].getBackground().dispose();
                        }
                    }
                    ++i;
                }
            }
        });
    }

    void populateTree(ATreeNode treeNode, String xPathExpression, boolean includeAttribute, boolean needExpand) throws OdaException {
        this.xPathExpression = xPathExpression;
        this.includeAttr = includeAttribute;
        Object[] childs = treeNode.getChildren();
        if (needExpand) {
            this.populateTreeItems(this.treeViewer.getTree(), childs, 0, xPathExpression, includeAttribute);
        } else {
            TreePopulationUtil.populateTreeItems(this.treeViewer.getTree(), childs, xPathExpression, this.includeAttr);
        }
    }

    Button getSingleButton() {
        return this.btnSingleAdd;
    }

    Button getMultiButton() {
        return this.btnMultiAdd;
    }

    Tree getTree() {
        return this.treeViewer.getTree();
    }

    Composite getBtnComposite() {
        return this.btnComposite;
    }

    private void populateTreeItems(Object tree, Object[] node, int level, String xPathExpression, boolean includeAttribute) throws OdaException {
        ATreeNode treeNode;
        ++level;
        TreeNodeData[] children = new TreeNodeData[node.length];
        TreeItem[] treeItems = new TreeItem[node.length];
        boolean findXPathNode = false;
        int i = 0;
        while (i < children.length) {
            block18: {
                treeNode = (ATreeNode)node[i];
                children[i] = new TreeNodeData(treeNode);
                int type = treeNode.getType();
                switch (type) {
                    case 2: {
                        if (includeAttribute) {
                            treeItems[i] = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
                            treeItems[i].setData((Object)children[i]);
                            treeItems[i].setImage(TreeNodeDataUtil.getColumnImage());
                            treeItems[i].setText("@" + treeNode.getValue().toString());
                            break;
                        }
                        break block18;
                    }
                    case 1: {
                        treeItems[i] = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
                        treeItems[i].setData((Object)children[i]);
                        if (treeNode.getParent() != null && "ROOT".equals(treeNode.getParent().getValue())) {
                            treeItems[i].setImage(TreeNodeDataUtil.getSourceFileImage());
                        } else if (treeNode.getChildren() == null || treeNode.getChildren().length == 0) {
                            treeItems[i].setImage(TreeNodeDataUtil.getColumnImage());
                        } else {
                            treeItems[i].setImage(TreeNodeDataUtil.getXmlElementImage());
                        }
                        treeItems[i].setText(treeNode.getValue().toString());
                        break;
                    }
                    default: {
                        treeItems[i] = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
                        treeItems[i].setData((Object)children[i]);
                        treeItems[i].setText(treeNode.getValue().toString());
                    }
                }
                ATreeNode aTreeNode = ((TreeNodeData)treeItems[i].getData()).getTreeNode();
                String rootPath = TreePopulationUtil.getRootPathWithOutFilter(xPathExpression);
                String columnPath = TreePopulationUtil.generateXpathFromATreeNode(aTreeNode);
                if (TreePopulationUtil.doesMatchXPath(rootPath, columnPath)) {
                    FontData fontData = new FontData("", 8, 1);
                    treeItems[i].setFont(new Font(null, fontData));
                    treeItems[i].setBackground(TreePopulationUtil.getBackGroundColor());
                    treeItems[i].setForeground(TreePopulationUtil.getForeGroundColor());
                    if (this.treeViewer.getTree().getSelection().length == 0) {
                        this.treeViewer.getTree().setSelection(new TreeItem[]{treeItems[i]});
                    }
                    this.treeViewer.getTree().setFocus();
                    children[i].setXPathStatus(true);
                    findXPathNode = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            treeNode = children[i].getTreeNode();
            if (treeNode.getChildren() != null && treeNode.getChildren().length > 0) {
                if (level > (xPathExpression == null || xPathExpression.split("/").length < 5 ? 5 : xPathExpression.split("/").length)) {
                    new TreeItem(treeItems[i], 0);
                } else {
                    children[i].setHasBeenExpandedOnce();
                    if (!findXPathNode || children[i].getXPathStatus()) {
                        this.populateTreeItems(treeItems[i], treeNode.getChildren(), level, xPathExpression, includeAttribute);
                    } else {
                        TreePopulationUtil.populateTreeItems(treeItems[i], treeNode.getChildren(), xPathExpression, includeAttribute);
                    }
                }
            }
            ++i;
        }
    }
}

