/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperTypesOfSingleton
extends TypeSet {
    private TType fLowerBound;
    private EnumeratedTypeSet fEnumCache = null;

    SuperTypesOfSingleton(TType t, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        this.fLowerBound = t;
    }

    @Override
    public boolean isUniverse() {
        return false;
    }

    @Override
    public TypeSet makeClone() {
        return this;
    }

    @Override
    protected TypeSet specialCasesIntersectedWith(TypeSet other) {
        if (other.isSingleton() && other.anyMember().equals(this.fLowerBound)) {
            return other;
        }
        if (other instanceof SuperTypesOfSingleton) {
            SuperTypesOfSingleton otherSuper = (SuperTypesOfSingleton)other;
            if (TTypes.canAssignTo(otherSuper.fLowerBound, this.fLowerBound)) {
                return this;
            }
            if (TTypes.canAssignTo(this.fLowerBound, otherSuper.fLowerBound)) {
                return otherSuper;
            }
        } else if (other.hasUniqueUpperBound()) {
            TType otherUpper = other.uniqueUpperBound();
            if (otherUpper.equals(this.fLowerBound)) {
                return new SingletonTypeSet(this.fLowerBound, this.getTypeSetEnvironment());
            }
            if (otherUpper != this.fLowerBound && TTypes.canAssignTo(otherUpper, this.fLowerBound) || !TTypes.canAssignTo(this.fLowerBound, otherUpper)) {
                return this.getTypeSetEnvironment().getEmptyTypeSet();
            }
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public TypeSet upperBound() {
        return new SingletonTypeSet(this.getJavaLangObject(), this.getTypeSetEnvironment());
    }

    @Override
    public TypeSet lowerBound() {
        return new SingletonTypeSet(this.fLowerBound, this.getTypeSetEnvironment());
    }

    @Override
    public boolean hasUniqueLowerBound() {
        return true;
    }

    @Override
    public boolean hasUniqueUpperBound() {
        return true;
    }

    @Override
    public TType uniqueLowerBound() {
        return this.fLowerBound;
    }

    @Override
    public TType uniqueUpperBound() {
        return this.getJavaLangObject();
    }

    @Override
    public TypeSet superTypes() {
        return this;
    }

    @Override
    public boolean contains(TType t) {
        if (t.equals(this.fLowerBound)) {
            return true;
        }
        if (t.equals(this.getJavaLangObject())) {
            return true;
        }
        return TTypes.canAssignTo(this.fLowerBound, t);
    }

    @Override
    public boolean containsAll(TypeSet other) {
        if (other instanceof SuperTypesOfSingleton) {
            SuperTypesOfSingleton otherSuper = (SuperTypesOfSingleton)other;
            return TTypes.canAssignTo(this.fLowerBound, otherSuper.fLowerBound);
        }
        if (other instanceof SuperTypesSet) {
            SuperTypesSet otherSuper = (SuperTypesSet)other;
            TypeSet otherLowerBounds = otherSuper.lowerBound();
            Iterator<TType> iter = otherLowerBounds.iterator();
            while (iter.hasNext()) {
                TType t = iter.next();
                if (TTypes.canAssignTo(this.fLowerBound, t)) continue;
                return false;
            }
            return true;
        }
        if (other.isUniverse()) {
            return false;
        }
        Iterator<TType> iter = other.iterator();
        while (iter.hasNext()) {
            TType t = iter.next();
            if (TTypes.canAssignTo(this.fLowerBound, t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<TType> iterator() {
        return this.enumerate().iterator();
    }

    @Override
    public boolean isSingleton() {
        return this.fLowerBound.equals(this.getJavaLangObject());
    }

    @Override
    public TType anyMember() {
        return this.fLowerBound;
    }

    @Override
    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            if (this.fLowerBound instanceof ArrayType) {
                ArrayType at = (ArrayType)this.fLowerBound;
                this.fEnumCache = EnumeratedTypeSet.makeArrayTypesForElements(TTypes.getAllSuperTypesIterator(at.getComponentType()), this.getTypeSetEnvironment());
                this.fEnumCache.add(this.getJavaLangObject());
            } else {
                this.fEnumCache = new EnumeratedTypeSet(TTypes.getAllSuperTypesIterator(this.fLowerBound), this.getTypeSetEnvironment());
            }
            this.fEnumCache.add(this.fLowerBound);
            this.fEnumCache.initComplete();
        }
        return this.fEnumCache;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SuperTypesOfSingleton)) {
            return false;
        }
        SuperTypesOfSingleton other = (SuperTypesOfSingleton)o;
        return other.fLowerBound.equals(this.fLowerBound);
    }

    @Override
    public int hashCode() {
        return this.fLowerBound.hashCode();
    }

    @Override
    public String toString() {
        return "<" + this.fID + ": superTypes(" + this.fLowerBound.getPrettySignature() + ")>";
    }
}

