/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakContinueTargetFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String ID = "BreakContinueTargetFinder";
    private ASTNode fSelected;
    private boolean fIsBreak;
    private SimpleName fLabel;
    private String fDescription;
    private CompilationUnit fASTRoot;
    private static final Class<?>[] STOPPERS = new Class[]{MethodDeclaration.class, Initializer.class};
    private static final Class<?>[] BREAKTARGETS = new Class[]{ForStatement.class, EnhancedForStatement.class, WhileStatement.class, DoStatement.class, SwitchStatement.class};
    private static final Class<?>[] CONTINUETARGETS = new Class[]{ForStatement.class, EnhancedForStatement.class, WhileStatement.class, DoStatement.class};
    private static final int BRACE_LENGTH = 1;

    @Override
    public String initialize(CompilationUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, (int)offset, (int)length));
    }

    @Override
    public String initialize(CompilationUnit root, ASTNode node) {
        ASTNode controlNode = this.getBreakOrContinueNode(node);
        if (controlNode != null) {
            this.fASTRoot = root;
            try {
                if (root.getTypeRoot() == null || root.getTypeRoot().getBuffer() == null) {
                    return SearchMessages.BreakContinueTargetFinder_cannot_highlight;
                }
            }
            catch (JavaModelException javaModelException) {
                return SearchMessages.BreakContinueTargetFinder_cannot_highlight;
            }
            this.fSelected = controlNode;
            this.fIsBreak = this.fSelected instanceof BreakStatement;
            this.fLabel = this.getLabel();
            this.fDescription = Messages.format(SearchMessages.BreakContinueTargetFinder_occurrence_description, BasicElementLabels.getJavaElementName(ASTNodes.asString(this.fSelected)));
            return null;
        }
        return SearchMessages.BreakContinueTargetFinder_no_break_or_continue_selected;
    }

    private ASTNode getBreakOrContinueNode(ASTNode selectedNode) {
        if (selectedNode instanceof BreakStatement) {
            return selectedNode;
        }
        if (selectedNode instanceof ContinueStatement) {
            return selectedNode;
        }
        if (selectedNode instanceof SimpleName && selectedNode.getParent() instanceof BreakStatement) {
            return selectedNode.getParent();
        }
        if (selectedNode instanceof SimpleName && selectedNode.getParent() instanceof ContinueStatement) {
            return selectedNode.getParent();
        }
        return null;
    }

    private SimpleName getLabel() {
        if (this.fIsBreak) {
            BreakStatement bs = (BreakStatement)this.fSelected;
            return bs.getLabel();
        }
        ContinueStatement cs = (ContinueStatement)this.fSelected;
        return cs.getLabel();
    }

    @Override
    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        ASTNode targetNode = this.findTargetNode(this.fSelected);
        if (!this.isEnclosingStatement(targetNode)) {
            return null;
        }
        ArrayList<IOccurrencesFinder.OccurrenceLocation> list = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
        IOccurrencesFinder.OccurrenceLocation location = this.getLocationForFirstToken(targetNode);
        if (location != null) {
            list.add(location);
        }
        if (this.fIsBreak && (location = this.getLocationForClosingBrace(targetNode)) != null) {
            list.add(location);
        }
        if (!list.isEmpty()) {
            return list.toArray(new IOccurrencesFinder.OccurrenceLocation[list.size()]);
        }
        return null;
    }

    private boolean isEnclosingStatement(ASTNode targetNode) {
        return targetNode != null && !(targetNode instanceof MethodDeclaration) && !(targetNode instanceof Initializer);
    }

    private ASTNode findTargetNode(ASTNode node) {
        while (this.keepWalkingUp(node = node.getParent())) {
        }
        return node;
    }

    private IOccurrencesFinder.OccurrenceLocation getLocationForFirstToken(ASTNode node) {
        try {
            int nextEndOffset = new TokenScanner(this.fASTRoot.getTypeRoot()).getNextEndOffset(node.getStartPosition(), true);
            return new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), nextEndOffset - node.getStartPosition(), 0, this.fDescription);
        }
        catch (CoreException coreException) {
            return new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), node.getLength(), 0, this.fDescription);
        }
    }

    private IOccurrencesFinder.OccurrenceLocation getLocationForClosingBrace(ASTNode targetNode) {
        int offset = ASTNodes.getExclusiveEnd(targetNode) - 1;
        return new IOccurrencesFinder.OccurrenceLocation(offset, 1, 0, this.fDescription);
    }

    private boolean keepWalkingUp(ASTNode node) {
        if (node == null) {
            return false;
        }
        if (BreakContinueTargetFinder.isAnyInstanceOf(STOPPERS, node)) {
            return false;
        }
        if (this.fLabel != null && LabeledStatement.class.isInstance(node)) {
            LabeledStatement ls = (LabeledStatement)node;
            return !BreakContinueTargetFinder.areEqualLabels(ls.getLabel(), this.fLabel);
        }
        if (this.fLabel == null) {
            if (BreakContinueTargetFinder.isAnyInstanceOf(this.fIsBreak ? BREAKTARGETS : CONTINUETARGETS, node)) {
                return node.getParent() instanceof LabeledStatement;
            }
            if (node instanceof LabeledStatement) {
                return false;
            }
        }
        return true;
    }

    private static boolean areEqualLabels(SimpleName labelToMatch, SimpleName labelSelected) {
        return labelSelected.getIdentifier().equals(labelToMatch.getIdentifier());
    }

    private static boolean isAnyInstanceOf(Class<?>[] continueTargets, ASTNode node) {
        int i = 0;
        while (i < continueTargets.length) {
            if (continueTargets[i].isInstance(node)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public CompilationUnit getASTRoot() {
        return this.fASTRoot;
    }

    @Override
    public String getElementName() {
        return ASTNodes.asString(this.fSelected);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getJobLabel() {
        return SearchMessages.BreakContinueTargetFinder_job_label;
    }

    @Override
    public int getSearchKind() {
        return 9;
    }

    @Override
    public String getUnformattedPluralLabel() {
        if (this.fIsBreak) {
            return SearchMessages.BreakContinueTargetFinder_break_label_plural;
        }
        return SearchMessages.BreakContinueTargetFinder_continue_label_plural;
    }

    @Override
    public String getUnformattedSingularLabel() {
        if (this.fIsBreak) {
            return SearchMessages.BreakContinueTargetFinder_break_label_singular;
        }
        return SearchMessages.BreakContinueTargetFinder_continue_label_singular;
    }
}

