/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class ShowInPackageViewAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ShowInPackageViewAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.ShowInPackageViewAction_label);
        this.setDescription(ActionMessages.ShowInPackageViewAction_description);
        this.setToolTipText(ActionMessages.ShowInPackageViewAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.show_in_packageview_action_context");
    }

    public ShowInPackageViewAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IJavaElement;
    }

    public void run(ITextSelection selection) {
        try {
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null) {
                this.run(element);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            String message = ActionMessages.ShowInPackageViewAction_error_message;
            ErrorDialog.openError((Shell)this.getShell(), (String)ShowInPackageViewAction.getDialogTitle(), (String)message, (IStatus)e.getStatus());
        }
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run((IJavaElement)selection.getFirstElement());
    }

    public void run(IJavaElement element) {
        if (element == null) {
            return;
        }
        PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
        view.tryToReveal(element);
    }

    private static String getDialogTitle() {
        return ActionMessages.ShowInPackageViewAction_dialog_title;
    }
}

