/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompilableSource;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileContributorManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileType;
import org.eclipse.rse.internal.useractions.ui.compile.SystemDefaultCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemDefaultCompileCommands;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemCompileProfile {
    private SystemCompileManager parentManager;
    private String profileName;
    private Vector compileTypes;
    private String[] srcTypes;
    private boolean isRead;
    private Object associatedData;

    public SystemCompileProfile(SystemCompileManager manager, String profileName) {
        this.parentManager = manager;
        this.profileName = profileName;
        this.doPreRead();
        this.readFromDisk();
    }

    public void setProfileName(String name) {
        this.profileName = name;
    }

    public void setAssociatedData(Object data) {
        this.associatedData = data;
    }

    public Object getAssociatedData() {
        return this.associatedData;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public ISystemProfile getProfile() {
        return RSECorePlugin.getTheSystemRegistry().getSystemProfile(this.profileName);
    }

    public SystemCompileManager getParentManager() {
        return this.parentManager;
    }

    public void addCompileType(SystemCompileType type) {
        this.compileTypes.add(type);
        this.flushCache();
    }

    public void removeCompileType(SystemCompileType type) {
        this.compileTypes.remove(type);
        this.flushCache();
    }

    public Vector getCompileTypes() {
        return this.compileTypes;
    }

    public String[] getCompileTypesArray() {
        if (this.srcTypes == null || this.srcTypes.length != this.compileTypes.size()) {
            this.srcTypes = new String[this.compileTypes.size()];
            int idx = 0;
            while (idx < this.srcTypes.length) {
                this.srcTypes[idx] = ((SystemCompileType)this.compileTypes.elementAt(idx)).getType();
                ++idx;
            }
        }
        return this.srcTypes;
    }

    public SystemCompileType getCompileType(String typeString) {
        int i = 0;
        while (i < this.compileTypes.size()) {
            SystemCompileType compileType = (SystemCompileType)this.compileTypes.get(i);
            if (compileType.getType().equalsIgnoreCase(typeString)) {
                return compileType;
            }
            ++i;
        }
        return null;
    }

    public void writeToDisk() {
        ISystemProfile systemProfile = RSECorePlugin.getTheSystemProfileManager().getSystemProfile(this.profileName);
        this.write(this.compileTypes, systemProfile);
        this.isRead = false;
    }

    public IFolder getCompileFolder() {
        return this.parentManager.getCompileProfileFolder(this);
    }

    public abstract SystemCompilableSource getCompilableSourceObject(Shell var1, Object var2, SystemCompileCommand var3, boolean var4, Viewer var5);

    protected void doPreRead() {
    }

    private void readFromDisk() {
        if (!this.isRead) {
            this.compileTypes = this.read();
            this.isRead = true;
        }
    }

    private void flushCache() {
        this.srcTypes = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector read() {
        Vector types = null;
        String osType = this.getParentManager().getOSType();
        String compileCommandPropertySetName = "CompileCommand." + osType;
        ISystemProfile systemProfile = RSECorePlugin.getTheSystemProfileManager().getSystemProfile(this.profileName);
        IPropertySet compileCommandPropertySet = systemProfile.getPropertySet(compileCommandPropertySetName);
        if (compileCommandPropertySet != null) return this.getTypes(systemProfile);
        if (!this.parentManager.wantToPrimeWithDefaults(this)) return new Vector();
        return this.writeDefaults(systemProfile);
    }

    private Vector getTypes(ISystemProfile systemProfile) {
        Vector<SystemCompileType> types = new Vector<SystemCompileType>();
        String osType = this.getParentManager().getOSType();
        String compileCommandPropertySetName = "CompileCommand." + osType;
        IPropertySet compileCommandPropertySet = systemProfile.getPropertySet(compileCommandPropertySetName);
        if (compileCommandPropertySet == null) {
            return null;
        }
        IPropertySet[] list = compileCommandPropertySet.getPropertySets();
        if (list == null) {
            return types;
        }
        int i = 0;
        while (i < list.length) {
            IPropertySet compileType = list[i];
            IPropertySet[] compileNameList = compileType.getPropertySets();
            IProperty typeProperty = compileType.getProperty("sourcetype");
            String type = typeProperty.getValue();
            IProperty lastUsedProperty = compileType.getProperty("lastcompilename");
            String lastUsed = lastUsedProperty.getValue();
            SystemCompileType newType = new SystemCompileType(this, type);
            int j = 0;
            while (j < compileNameList.length) {
                IPropertySet compileName = compileNameList[j];
                IProperty labelProperty = compileName.getProperty("name");
                String name = labelProperty.getValue();
                IProperty natureProperty = compileName.getProperty("nature");
                String nature = natureProperty.getValue();
                IProperty defaultProperty = compileName.getProperty("default");
                String defaultString = defaultProperty != null ? defaultProperty.getValue() : "";
                IProperty currentProperty = compileName.getProperty("current");
                String currentString = currentProperty.getValue();
                IProperty menuProperty = compileName.getProperty("menu");
                String menuOption = menuProperty.getValue();
                IProperty jobenvProperty = compileName.getProperty("jobenv");
                String jobEnv = null;
                if (jobenvProperty != null) {
                    jobEnv = jobenvProperty.getValue();
                }
                IProperty orderProperty = compileName.getProperty("order");
                int order = j;
                if (orderProperty != null) {
                    order = Integer.valueOf(orderProperty.getValue());
                }
                IProperty idProperty = compileName.getProperty("id");
                String id = null;
                if (idProperty != null) {
                    id = idProperty.getValue();
                }
                IProperty labelEditableProperty = compileName.getProperty("labeleditable");
                String labelEditable = null;
                if (labelEditableProperty != null) {
                    labelEditable = labelEditableProperty.getValue();
                }
                IProperty stringEditableProperty = compileName.getProperty("stringeditable");
                String stringEditable = null;
                if (stringEditableProperty != null) {
                    stringEditable = stringEditableProperty.getValue();
                }
                SystemCompileCommand newCmd = new SystemCompileCommand(newType, id, name, nature, defaultString, currentString, menuOption, order);
                if (labelEditable != null) {
                    boolean isLabelEditable = Boolean.valueOf(labelEditable);
                    newCmd.setLabelEditable(isLabelEditable);
                }
                if (stringEditable != null) {
                    boolean isStringEditable = Boolean.valueOf(stringEditable);
                    newCmd.setCommandStringEditable(isStringEditable);
                }
                if (jobEnv != null) {
                    newCmd.setJobEnvironment(jobEnv);
                }
                if (name.equalsIgnoreCase(lastUsed)) {
                    newType.setLastUsedCompileCommand(newCmd);
                }
                newType.addCompileCommandInOrder(newCmd);
                ++j;
            }
            types.add(newType);
            ++i;
        }
        return types;
    }

    public void addContributions(Object element) {
        if (this.parentManager.wantToPrimeWithDefaults(this)) {
            SystemCompileContributorManager.getInstance().contributeCompileCommands(this, element);
        }
    }

    protected SystemCompileCommand migrateCompileCommand(SystemCompileCommand oldCmd, String oldVrm) {
        return oldCmd;
    }

    protected String sub(String string, String subOld, String subNew) {
        if (string == null) {
            return string;
        }
        StringBuffer temp = new StringBuffer();
        int lastHit = 0;
        int newHit = 0;
        newHit = string.indexOf(subOld, lastHit);
        while (newHit != -1) {
            if (newHit >= 0) {
                temp.append(string.substring(lastHit, newHit));
            }
            temp.append(subNew);
            lastHit = newHit += subOld.length();
            newHit = string.indexOf(subOld, lastHit);
        }
        if (lastHit >= 0) {
            temp.append(string.substring(lastHit));
        }
        return temp.toString();
    }

    private void write(Vector types, ISystemProfile systemProfile) {
        String osType = this.getParentManager().getOSType();
        String compileCommandPropertySetName = "CompileCommand." + osType;
        IPropertySet compileCommandPropertySet = systemProfile.getPropertySet(compileCommandPropertySetName);
        if (compileCommandPropertySet == null) {
            compileCommandPropertySet = systemProfile.createPropertySet(compileCommandPropertySetName);
            String compileCommandPropertySetLabel = "Compile Commands - " + osType;
            compileCommandPropertySet.addProperty("name", compileCommandPropertySetLabel);
        }
        int i = 0;
        while (i < types.size()) {
            SystemCompileType compileType = (SystemCompileType)types.get(i);
            SystemCompileCommand lastUsedCompileName = compileType.getLastUsedCompileCommand();
            String lastUsedName = null;
            lastUsedName = lastUsedCompileName == null ? "" : lastUsedCompileName.getLabel();
            IPropertySet thisCompileTypePropertySet = compileCommandPropertySet.createPropertySet(compileType.getType());
            thisCompileTypePropertySet.addProperty("type", "compiletype");
            thisCompileTypePropertySet.addProperty("name", compileType.getType());
            thisCompileTypePropertySet.addProperty("lastcompilename", lastUsedName);
            thisCompileTypePropertySet.addProperty("sourcetype", compileType.getType());
            Vector cmds = compileType.getCompileCommands();
            int j = 0;
            while (j < cmds.size()) {
                SystemCompileCommand cmd = (SystemCompileCommand)cmds.get(j);
                IPropertySet thisCompileCommandPropertySet = thisCompileTypePropertySet.createPropertySet(String.valueOf(cmd.getLabel()) + j);
                if (cmd.getId() != null) {
                    thisCompileCommandPropertySet.addProperty("id", cmd.getId());
                }
                thisCompileCommandPropertySet.addProperty("name", cmd.getLabel());
                thisCompileCommandPropertySet.addProperty("type", "compilename");
                thisCompileCommandPropertySet.addProperty("nature", cmd.getNature());
                thisCompileCommandPropertySet.addProperty("default", cmd.getDefaultString());
                thisCompileCommandPropertySet.addProperty("current", cmd.getCurrentString());
                thisCompileCommandPropertySet.addProperty("id", cmd.getId());
                thisCompileCommandPropertySet.addProperty("menu", cmd.getMenuOption());
                thisCompileCommandPropertySet.addProperty("order", String.valueOf(j));
                thisCompileCommandPropertySet.addProperty("labeleditable", String.valueOf(cmd.isLabelEditable()));
                if (cmd.getJobEnvironment() != null) {
                    thisCompileCommandPropertySet.addProperty("jobenv", cmd.getJobEnvironment());
                }
                ++j;
            }
            ++i;
        }
        systemProfile.commit();
    }

    private Vector writeDefaults(ISystemProfile systemProfile) {
        SystemDefaultCompileCommands allCmds = this.parentManager.getDefaultCompileCommands();
        if (allCmds == null) {
            return null;
        }
        String[] defaultTypes = allCmds.getAllDefaultSuppliedSourceTypes();
        Vector<SystemCompileType> types = new Vector<SystemCompileType>();
        int i = 0;
        while (i < defaultTypes.length) {
            SystemCompileType type = new SystemCompileType(this, defaultTypes[i]);
            SystemDefaultCompileCommand[] defaultCmds = allCmds.getCommandsForSrcType(defaultTypes[i]);
            if (defaultCmds == null || defaultCmds.length == 0) {
                types.add(type);
            } else {
                SystemCompileCommand[] cmds = new SystemCompileCommand[defaultCmds.length];
                int j = 0;
                while (j < defaultCmds.length) {
                    String cmdName = defaultCmds[j].getLabel();
                    String commandString = defaultCmds[j].getCommandWithParameters();
                    cmds[j] = new SystemCompileCommand(type, null, cmdName, "IBM defined", commandString, commandString, "Both", j);
                    type.addCompileCommandInOrder(cmds[j]);
                    String jobEnv = defaultCmds[j].getJobEnvironment();
                    if (jobEnv != null) {
                        cmds[j].setJobEnvironment(jobEnv);
                    }
                    if (j == 0) {
                        type.setLastUsedCompileCommand(cmds[j]);
                    }
                    ++j;
                }
                types.add(type);
            }
            ++i;
        }
        this.write(types, systemProfile);
        return types;
    }

    public void printCommandsByType(Vector compileTypes) {
        System.out.println();
        System.out.println("Compile commands");
        System.out.println("-----------------");
        int idx = 0;
        while (idx < compileTypes.size()) {
            SystemCompileType type = (SystemCompileType)compileTypes.elementAt(idx);
            System.out.println("Type: " + type.getType());
            int jdx = 0;
            while (jdx < type.getNumOfCommands()) {
                SystemCompileCommand cmd = type.getCompileCommand(jdx);
                cmd.printCommand("  ");
                ++jdx;
            }
            ++idx;
        }
        System.out.println();
    }
}

