/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.validation.Friend;
import org.eclipse.wst.validation.IPerformanceMonitor;
import org.eclipse.wst.validation.IValidatorGroupListener;
import org.eclipse.wst.validation.PerformanceCounters;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ContentTypeWrapper;
import org.eclipse.wst.validation.internal.EventManager;
import org.eclipse.wst.validation.internal.ExtensionValidators;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.IProjectChangeListener;
import org.eclipse.wst.validation.internal.IValChangedListener;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ProjectUnavailableError;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.ValProperty;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidatorGroupExtensionReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.model.GlobalPreferences;
import org.eclipse.wst.validation.internal.model.GlobalPreferencesValues;
import org.eclipse.wst.validation.internal.model.IValidatorVisitor;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.eclipse.wst.validation.internal.operations.ManualValidatorsOperation;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValManager
implements IValChangedListener,
IFacetedProjectListener,
IProjectChangeListener {
    private final Map<IProject, ProjectPreferences> _projectPreferences = Collections.synchronizedMap(new HashMap(50));
    private final AtomicReference<GlobalPreferences> _globalPreferences = new AtomicReference();
    private final AtomicInteger _configNumber = new AtomicInteger();
    private final ValidatorIdManager _idManager = new ValidatorIdManager();
    private final ValidatorCache _cache = new ValidatorCache();
    private static final QualifiedName StatusBuild = new QualifiedName("org.eclipse.wst.validation", "sb");
    private static final QualifiedName StatusManual = new QualifiedName("org.eclipse.wst.validation", "sm");

    public static ValManager getDefault() {
        return Singleton.valManager;
    }

    private ValManager() {
        ValPrefManagerGlobal.getDefault().addListener(this);
        ValPrefManagerProject.addListener(this);
        FacetedProjectFramework.addListener((IFacetedProjectListener)this, (IFacetedProjectEvent.Type[])new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_MODIFIED});
        EventManager.getManager().addProjectChangeListener(this);
    }

    public void dispose() {
        ValPrefManagerGlobal.getDefault().removeListener(this);
        ValPrefManagerProject.removeListener(this);
        FacetedProjectFramework.removeListener((IFacetedProjectListener)this);
        EventManager.getManager().removeProjectChangeListener(this);
    }

    public Validator[] getValidators() {
        return this.getValidators(null);
    }

    public Validator[] getValidatorsCopy() {
        Validator[] orig = this.getValidators();
        Validator[] copy = new Validator[orig.length];
        int i = 0;
        while (i < orig.length) {
            copy[i] = orig[i].copy();
            ++i;
        }
        return copy;
    }

    public Validator[] getValidators(IProject project, boolean respectOverrideSettings) throws ProjectUnavailableError {
        return this.getValidators(project);
    }

    public Validator[] getValidators(IProject project) throws ProjectUnavailableError {
        return this._cache.getValidatorsCached(project);
    }

    private Validator[] getValidatorsNotCached(IProject project) throws ProjectUnavailableError {
        Map<String, Validator> v2Vals = this.getV2Validators(project, UseProjectPreferences.Normal);
        TreeSet<Validator> sorted = new TreeSet<Validator>();
        sorted.addAll(v2Vals.values());
        try {
            ValidationConfiguration vc = ConfigurationManager.getManager().getConfiguration(project);
            if (project == null) {
                ValidatorMetaData[] vmds;
                ValidatorMetaData[] validatorMetaDataArray = vmds = vc.getValidators();
                int n = vmds.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidatorMetaData vmd = validatorMetaDataArray[n2];
                    Validator v = Validator.create(vmd, vc, project);
                    sorted.add(v);
                    ++n2;
                }
            } else {
                ManualValidatorsOperation mvo = new ManualValidatorsOperation(project);
                Set<ValidatorMetaData> vmds = mvo.getEnabledValidators();
                for (ValidatorMetaData vmd : vmds) {
                    Validator v = Validator.create(vmd, vc, project);
                    sorted.add(v);
                }
            }
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        Validator[] vals = new Validator[sorted.size()];
        sorted.toArray(vals);
        return vals;
    }

    public Validator[] getValidatorsConfiguredForProject(IProject project, boolean mustUseProjectSettings) throws ProjectUnavailableError {
        UseProjectPreferences useProject = UseProjectPreferences.Normal;
        return this.getValidatorsConfiguredForProject(project, useProject);
    }

    public Validator[] getValidatorsConfiguredForProject(IProject project, UseProjectPreferences useProject) throws ProjectUnavailableError {
        Map<String, Validator> v2Vals = this.getV2Validators(project, useProject);
        TreeSet<Validator> sorted = new TreeSet<Validator>();
        sorted.addAll(v2Vals.values());
        if (useProject == UseProjectPreferences.MustNotUse) {
            sorted.addAll(ExtensionValidators.instance().getV1Validators(project));
        } else {
            try {
                ValidatorMetaData[] vmds;
                ProjectConfiguration vc = ConfigurationManager.getManager().getProjectConfiguration(project);
                ValidatorMetaData[] validatorMetaDataArray = vmds = ((ValidationConfiguration)vc).getValidators();
                int n = vmds.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidatorMetaData vmd = validatorMetaDataArray[n2];
                    Validator v = Validator.create(vmd, vc, project);
                    sorted.add(v);
                    ++n2;
                }
            }
            catch (InvocationTargetException e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
        LinkedList<Validator> list = new LinkedList<Validator>();
        for (Validator v : sorted) {
            if (!v.shouldValidateProject(project, false, false)) continue;
            list.add(v);
        }
        Validator[] vals = new Validator[list.size()];
        list.toArray(vals);
        return vals;
    }

    private Map<String, Validator> getV2Validators(IProject project, UseProjectPreferences useProject) {
        Map<String, Validator> extVals = ExtensionValidators.instance().getMapV2Copy();
        try {
            List<Validator> vals = ValPrefManagerGlobal.getDefault().getValidators();
            for (Validator v : vals) {
                extVals.put(v.getId(), v);
            }
            if (!(useProject == UseProjectPreferences.MustNotUse || useProject != UseProjectPreferences.MustUse && this.mustUseGlobalValidators(project))) {
                ValPrefManagerProject vpm = new ValPrefManagerProject(project);
                vals = vpm.getValidators(extVals);
                for (Validator v : vals) {
                    extVals.put(v.getId(), v);
                }
                Validator[] validatorArray = this.getProjectPreferences(project).getValidators();
                int n = validatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Validator v;
                    v = validatorArray[n2];
                    extVals.put(v.getId(), v);
                    ++n2;
                }
            }
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        return extVals;
    }

    public boolean mustUseGlobalValidators(IProject project) {
        if (project == null) {
            return true;
        }
        if (!this.getGlobalPreferences().getOverride()) {
            return true;
        }
        ProjectPreferences pp = this._projectPreferences.get(project);
        if (pp != null) {
            return !pp.getOverride();
        }
        ValPrefManagerProject vpm = new ValPrefManagerProject(project);
        return !vpm.getOverride();
    }

    public Validator getValidator(String id, IProject project) {
        Validator[] vals;
        Validator[] validatorArray = vals = this.getValidators(project);
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            if (v.getId().equals(id)) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    public Validator getValidatorWithId(String id, IProject project) {
        Validator[] vals;
        Validator[] validatorArray = vals = this.getValidators(project);
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            if (v.getId().equals(id)) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasValidators(IResource resource, boolean isManual, boolean isBuild) {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            return ValManager.getDefault().getValidators(project).length > 0;
        }
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            HasValidatorVisitor v = new HasValidatorVisitor(isManual, isBuild);
            return v.hasValidator(folder);
        }
        ContentTypeWrapper ctw = new ContentTypeWrapper();
        Validator[] validatorArray = ValManager.getDefault().getValidators(resource.getProject());
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (Friend.shouldValidate(val, resource, isManual, isBuild, ctw)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isDisabled(IProject project) {
        GlobalPreferences gp = this.getGlobalPreferences();
        if (!gp.getOverride() || project == null) {
            return gp.getDisableAllValidation();
        }
        ProjectPreferences pp = this._projectPreferences.get(project);
        if (pp == null) {
            return gp.getDisableAllValidation();
        }
        return pp.getSuspend();
    }

    public static Validator[] getDefaultValidators() throws InvocationTargetException {
        Map<String, Validator> extVals = ExtensionValidators.instance().getMapV2();
        TreeSet<Validator> sorted = new TreeSet<Validator>();
        for (Validator v : extVals.values()) {
            sorted.add(v);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        GlobalConfiguration gc = new GlobalConfiguration(root);
        gc.resetToDefault();
        ValidatorMetaData[] validatorMetaDataArray = gc.getValidators();
        int n = validatorMetaDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            Validator v = Validator.create(vmd, gc, null);
            v.setBuildValidation(vmd.isBuildValidation());
            v.setManualValidation(vmd.isManualValidation());
            sorted.add(v);
            ++n2;
        }
        Validator[] val = new Validator[sorted.size()];
        sorted.toArray(val);
        return val;
    }

    public static Validator[] getDefaultValidators(IProject project) throws InvocationTargetException {
        Map<String, Validator> extVals = ExtensionValidators.instance().getMap(project);
        Validator[] val = new Validator[extVals.size()];
        extVals.values().toArray(val);
        return val;
    }

    private void configHasChanged() {
        this._configNumber.incrementAndGet();
        ValidatorProjectManager.reset();
        this._cache.reset();
    }

    public GlobalPreferences getGlobalPreferences() {
        ValPrefManagerGlobal vpm;
        GlobalPreferences gp = this._globalPreferences.get();
        if (gp == null && !this._globalPreferences.compareAndSet(null, gp = (vpm = ValPrefManagerGlobal.getDefault()).loadGlobalPreferences())) {
            gp = this._globalPreferences.get();
        }
        return gp;
    }

    public int replace(GlobalPreferencesValues values) {
        GlobalPreferences gp = new GlobalPreferences(values);
        GlobalPreferences old = this.getGlobalPreferences();
        int changes = old.compare(gp);
        if (changes != 0) {
            this._globalPreferences.set(gp);
        }
        return changes;
    }

    public ProjectPreferences getProjectPreferences(IProject project) {
        ProjectPreferences pp = this._projectPreferences.get(project);
        if (pp != null) {
            return pp;
        }
        Map<String, Validator> extVals = ExtensionValidators.instance().getMapV2Copy();
        try {
            List<Validator> vals = ValPrefManagerGlobal.getDefault().getValidators();
            for (Validator v : vals) {
                extVals.put(v.getId(), v);
            }
            pp = this.getProjectPreferences(project, extVals);
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        return pp;
    }

    private ProjectPreferences getProjectPreferences(IProject project, Map<String, Validator> baseValidators) throws BackingStoreException {
        ProjectPreferences pp = this._projectPreferences.get(project);
        if (pp != null) {
            return pp;
        }
        ValPrefManagerProject vpm = new ValPrefManagerProject(project);
        pp = vpm.loadProjectPreferences(project, baseValidators);
        this._projectPreferences.put(project, pp);
        return pp;
    }

    public void validate(IProject project, final IResource resource, final int kind, ValType valType, int buildKind, ValOperation operation, IProgressMonitor monitor) {
        MarkerManager.getDefault().deleteMarkers(resource, operation.getStarted(), 0);
        IValidatorVisitor visitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType vt, ValOperation operation, IProgressMonitor monitor) {
                Validator.V1 v1 = validator.asV1Validator();
                if (vt == ValType.Build && v1 != null) {
                    return;
                }
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                String task = NLS.bind((String)ValMessages.LogValStart, (Object)validator.getName(), (Object)resource.getName());
                subMonitor.beginTask(task, 1);
                if (project.isOpen()) {
                    ValManager.this.validate(validator, operation, resource, kind, (IProgressMonitor)subMonitor.newChild(1), null);
                }
            }
        };
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getValidators(project).length);
        this.accept(visitor, project, resource, valType, operation, (IProgressMonitor)sm);
    }

    public void validate(Validator validator, ValOperation operation, IResource resource, int kind, IProgressMonitor monitor, ValidationEvent event) {
        if (operation.isValidated(validator.getId(), resource)) {
            return;
        }
        long time = 0L;
        long cpuTime = -1L;
        String msg1 = NLS.bind((String)ValMessages.LogValStart, (Object)validator.getName(), (Object)resource.getName());
        monitor.subTask(msg1);
        IPerformanceMonitor pm = ValidationFramework.getDefault().getPerformanceMonitor();
        if (pm.isCollecting()) {
            time = System.currentTimeMillis();
            cpuTime = Misc.getCPUTime();
        }
        if (Tracing.matchesExtraDetail(validator.getId())) {
            Tracing.log("ValManager-03: validating ", resource);
        }
        if (resource.exists()) {
            ValidationResult vr = validator.validate(resource, kind, operation, monitor, event);
            if (pm.isCollecting()) {
                if (cpuTime != -1L) {
                    cpuTime = Misc.getCPUTime() - cpuTime;
                }
                int num = 0;
                if (vr != null) {
                    num = vr.getNumberOfValidatedResources();
                }
                PerformanceCounters pc = new PerformanceCounters(validator.getId(), validator.getName(), resource.getName(), num, System.currentTimeMillis() - time, cpuTime);
                pm.add(pc);
            }
            if (ValidationPlugin.getPlugin().isDebugging() && !pm.isCollecting()) {
                String msg = time != 0L ? NLS.bind((String)ValMessages.LogValEndTime, (Object[])new Object[]{validator.getName(), validator.getId(), resource, Misc.getTimeMS(System.currentTimeMillis() - time)}) : NLS.bind((String)ValMessages.LogValEnd, (Object)validator.getName(), (Object)resource);
                Tracing.log("ValManager-01: " + msg);
            }
            if (vr != null) {
                operation.mergeResults(vr);
                if (vr.getSuspendValidation() != null) {
                    operation.suspendValidation(vr.getSuspendValidation(), validator);
                }
            }
        }
    }

    public void accept(IValidatorVisitor visitor, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
        if (this.isDisabled(project)) {
            return;
        }
        Validator[] validatorArray = this.getValidators(project);
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (ValidatorProjectManager.get().shouldValidate(val, project, valType) && !operation.isSuspended(val, project)) {
                try {
                    visitor.visit(val, project, valType, operation, monitor);
                }
                catch (Exception e) {
                    ValidationPlugin.getPlugin().handleException(e);
                }
            }
            ++n2;
        }
    }

    public void accept(IValidatorVisitor visitor, IProject project, IResource resource, ValType valType, ValOperation operation, IProgressMonitor monitor) {
        if (this.isDisabled(project)) {
            return;
        }
        HashMap<String, IValidatorGroupListener[]> groupListeners = new HashMap<String, IValidatorGroupListener[]>();
        ValProperty vp = this.getValProperty(resource, valType, this._configNumber.get());
        if (vp != null) {
            BitSet bs = vp.getConfigSet();
            Validator[] validatorArray = this.getValidators(project);
            int n = validatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Validator val = validatorArray[n2];
                if (!monitor.isCanceled() && bs.get(this._idManager.getIndex(val.getId())) && !operation.isSuspended(val, project)) {
                    Validator.V2 v2 = val.asV2Validator();
                    if (v2 != null) {
                        this.notifyGroupListenersStarting(resource, operation.getState(), monitor, groupListeners, v2);
                    }
                    try {
                        visitor.visit(val, project, valType, operation, monitor);
                    }
                    catch (Exception e) {
                        ValidationPlugin.getPlugin().handleException(e);
                    }
                }
                ++n2;
            }
            this.notifyGroupFinishing(resource, operation.getState(), monitor, groupListeners);
            return;
        }
        vp = new ValProperty();
        vp.setConfigNumber(this._configNumber.get());
        ContentTypeWrapper ctw = new ContentTypeWrapper();
        Validator[] validatorArray = this.getValidators(project);
        int n = validatorArray.length;
        int n3 = 0;
        while (n3 < n) {
            Validator val = validatorArray[n3];
            if (!monitor.isCanceled() && ValidatorProjectManager.get().shouldValidate(val, project, valType) && Friend.shouldValidate(val, resource, valType, ctw)) {
                vp.getConfigSet().set(this._idManager.getIndex(val.getId()));
                if (!operation.isSuspended(val, project)) {
                    Validator.V2 v2 = val.asV2Validator();
                    if (v2 != null) {
                        this.notifyGroupListenersStarting(resource, operation.getState(), monitor, groupListeners, v2);
                    }
                    try {
                        visitor.visit(val, project, valType, operation, monitor);
                    }
                    catch (Exception e) {
                        ValidationPlugin.getPlugin().handleException(e);
                    }
                }
            }
            ++n3;
        }
        this.notifyGroupFinishing(resource, operation.getState(), monitor, groupListeners);
        this.putValProperty(vp, resource, valType);
    }

    private void notifyGroupListenersStarting(final IResource resource, final ValidationState state, final IProgressMonitor monitor, Map<String, IValidatorGroupListener[]> groupListeners, Validator.V2 v2) {
        String[] groups;
        String[] stringArray = groups = v2.getValidatorGroups();
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            if (!groupListeners.containsKey(group)) {
                IValidatorGroupListener[] createdListeners = null;
                try {
                    createdListeners = ValidatorGroupExtensionReader.getDefault().createListeners(group);
                }
                catch (CoreException e) {
                    String msg = NLS.bind((String)ValMessages.ErrConfig, (Object)v2.getId());
                    Status status = new Status(4, "org.eclipse.wst.validation", msg);
                    CoreException core = new CoreException((IStatus)status);
                    ValidationPlugin.getPlugin().handleException(core);
                    ValidationPlugin.getPlugin().handleException(e);
                    createdListeners = new IValidatorGroupListener[]{};
                }
                IValidatorGroupListener[] listeners = createdListeners;
                groupListeners.put(group, listeners);
                IValidatorGroupListener[] iValidatorGroupListenerArray = listeners;
                int n3 = listeners.length;
                int n4 = 0;
                while (n4 < n3) {
                    final IValidatorGroupListener listener = iValidatorGroupListenerArray[n4];
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            listener.validationStarting(resource, monitor, state);
                        }

                        public void handleException(Throwable exception) {
                            ValidationPlugin.getPlugin().handleException(exception);
                        }
                    });
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void notifyGroupFinishing(final IResource resource, final ValidationState state, final IProgressMonitor monitor, Map<String, IValidatorGroupListener[]> groupListeners) {
        Iterator<IValidatorGroupListener[]> iterator = groupListeners.values().iterator();
        while (iterator.hasNext()) {
            IValidatorGroupListener[] listeners;
            IValidatorGroupListener[] iValidatorGroupListenerArray = listeners = iterator.next();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                final IValidatorGroupListener listener = iValidatorGroupListenerArray[n2];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.validationFinishing(resource, monitor, state);
                    }

                    public void handleException(Throwable exception) {
                        ValidationPlugin.getPlugin().handleException(exception);
                    }
                });
                ++n2;
            }
        }
    }

    private ValProperty getValProperty(IResource resource, ValType valType, int configNumber) {
        ValProperty vp = null;
        try {
            if (valType == ValType.Build) {
                vp = (ValProperty)resource.getSessionProperty(StatusBuild);
            } else if (valType == ValType.Manual) {
                vp = (ValProperty)resource.getSessionProperty(StatusManual);
            }
        }
        catch (CoreException coreException) {}
        if (vp == null) {
            return null;
        }
        if (vp.getConfigNumber() != this._configNumber.get()) {
            return null;
        }
        return vp;
    }

    public void projectChanged(IProject project) {
        ValidatorProjectManager.reset();
        this._projectPreferences.remove(project);
        this._cache.reset(project);
    }

    public void projectRemoved(IProject project) {
        ValidatorProjectManager.reset();
        this._projectPreferences.remove(project);
        this._cache.reset(project);
    }

    public void clearValProperty(IResource resource) {
        if (!resource.isAccessible()) {
            return;
        }
        try {
            resource.setSessionProperty(StatusBuild, null);
            resource.setSessionProperty(StatusManual, null);
        }
        catch (CoreException coreException) {}
    }

    private void putValProperty(ValProperty vp, IResource resource, ValType valType) {
        block6: {
            try {
                if (!resource.isAccessible()) {
                    return;
                }
                if (valType == ValType.Build) {
                    resource.setSessionProperty(StatusBuild, (Object)vp);
                } else if (valType == ValType.Manual) {
                    resource.setSessionProperty(StatusManual, (Object)vp);
                }
            }
            catch (CoreException e) {
                if (e.getStatus().equals(368)) break block6;
                ValidationPlugin.getPlugin().handleException(e, 2);
            }
        }
    }

    void clean(IProject project, ValOperation operation, IProgressMonitor monitor) {
        IValidatorVisitor visitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                validator.clean(project, operation, monitor);
            }
        };
        this.accept(visitor, project, ValType.Build, operation, monitor);
    }

    public void clean(IProject project, IProgressMonitor monitor) {
        IValidatorVisitor visitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                validator.clean(project, operation, monitor);
            }
        };
        ValidationFramework.getDefault().getDependencyIndex().clear(project);
        ValOperation operation = new ValOperation();
        this.accept(visitor, project, ValType.Build, operation, monitor);
    }

    @Override
    public void validatorsForProjectChanged(IProject project, boolean validationSettingChanged) {
        if (validationSettingChanged) {
            if (project != null) {
                this._projectPreferences.remove(project);
            }
            this.configHasChanged();
        }
    }

    public void handleEvent(IFacetedProjectEvent event) {
        this._configNumber.incrementAndGet();
        this.projectChanged(event.getProject().getProject());
    }

    @Override
    public void projectChanged(IProject project, int type) {
        switch (type) {
            case 2: 
            case 4: {
                this.projectRemoved(project);
                break;
            }
            case 1: 
            case 8: 
            case 16: {
                this.projectChanged(project);
            }
        }
    }

    /* synthetic */ ValManager(ValManager valManager) {
        this();
    }

    private final class HasValidatorVisitor
    implements IResourceVisitor {
        private boolean _hasValidator;
        private final boolean _isManual;
        private final boolean _isBuild;

        public HasValidatorVisitor(boolean isManual, boolean isBuild) {
            this._isManual = isManual;
            this._isBuild = isBuild;
        }

        public boolean hasValidator(IFolder folder) {
            try {
                folder.accept((IResourceVisitor)this);
            }
            catch (CoreException e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
            return this._hasValidator;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFolder) {
                return true;
            }
            if (ValManager.this.hasValidators(resource, this._isManual, this._isBuild)) {
                this._hasValidator = true;
                return false;
            }
            return true;
        }
    }

    private static class Singleton {
        static ValManager valManager = new ValManager(null);

        private Singleton() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UseProjectPreferences {
        Normal,
        MustUse,
        MustNotUse;

    }

    private final class ValidatorCache {
        private final ConcurrentMap<IProject, Validator[]> _cache = new ConcurrentHashMap<IProject, Validator[]>(50);
        private final AtomicReference<Validator[]> _global = new AtomicReference();

        private ValidatorCache() {
        }

        public Validator[] getValidatorsCached(IProject project) throws ProjectUnavailableError {
            Validator[] vals = null;
            if (project == null) {
                vals = this._global.get();
                if (vals == null) {
                    vals = ValManager.this.getValidatorsNotCached(project);
                    this._global.set(vals);
                }
            } else {
                vals = (Validator[])this._cache.get(project);
                if (vals == null) {
                    vals = ValManager.this.getValidatorsNotCached(project);
                    this._cache.put(project, vals);
                }
            }
            return vals;
        }

        public void reset() {
            this._cache.clear();
            this._global.set(null);
        }

        public void reset(IProject project) {
            if (project != null) {
                this._cache.remove(project);
            }
        }
    }

    private static final class ValidatorIdManager {
        private final Map<String, Integer> _map = new HashMap<String, Integer>(100);
        private final Map<Integer, String> _reverseMap = new HashMap<Integer, String>(100);
        private int _next;

        private ValidatorIdManager() {
        }

        public synchronized int getIndex(String id) {
            Integer i = this._map.get(id);
            if (i != null) {
                return i;
            }
            i = this._next++;
            this._map.put(id, i);
            this._reverseMap.put(i, id);
            return i;
        }

        public synchronized String getId(Integer index) {
            return this._reverseMap.get(index);
        }

        public synchronized void reset() {
            this._map.clear();
            this._reverseMap.clear();
            this._next = 0;
        }

        public synchronized String[] getIds(BitSet bs) {
            LinkedList<String> list = new LinkedList<String>();
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                String id = this.getId(i);
                if (id != null) {
                    list.add(id);
                }
                i = bs.nextSetBit(i + 1);
            }
            String[] s = new String[list.size()];
            return list.toArray(s);
        }
    }

    private static final class ValidatorProjectManager {
        private static final AtomicReference<ValidatorProjectManager> _me = new AtomicReference();
        private static final AtomicInteger _counter = new AtomicInteger();
        private final ValProjectMap _manual = new ValProjectMap(ValType.Manual);
        private final ValProjectMap _build = new ValProjectMap(ValType.Build);
        private final int _sequence;

        public static ValidatorProjectManager get() {
            ValidatorProjectManager vpm = _me.get();
            if (vpm != null) {
                return vpm;
            }
            int next = _counter.incrementAndGet();
            ValidatorProjectManager newVpm = null;
            boolean looking = true;
            while (looking) {
                vpm = _me.get();
                if (vpm == null || next > vpm.getSequence()) {
                    if (newVpm == null) {
                        newVpm = new ValidatorProjectManager(next);
                    }
                    if (!_me.compareAndSet(vpm, newVpm)) continue;
                    return newVpm;
                }
                looking = false;
            }
            return vpm;
        }

        public static void reset() {
            int next = _counter.incrementAndGet();
            ValidatorProjectManager vpm = _me.get();
            if (vpm == null) {
                return;
            }
            if (next > vpm.getSequence()) {
                _me.compareAndSet(vpm, null);
            }
        }

        private ValidatorProjectManager(int sequence) {
            this._sequence = sequence;
        }

        int getSequence() {
            return this._sequence;
        }

        public boolean shouldValidate(Validator validator, IProject project, ValType type) {
            if (type == ValType.Build) {
                return this._build.shouldValidate(validator, project);
            }
            if (type == ValType.Manual) {
                return this._manual.shouldValidate(validator, project);
            }
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ValProjectMap {
            private final Map<String, Set<IProject>> _map;
            private final ValType _type;

            public ValProjectMap(ValType type) {
                this._type = type;
                this._map = this.load();
            }

            public boolean shouldValidate(Validator validator, IProject project) {
                String vid = validator.getId();
                Set<IProject> projects = this._map.get(vid);
                if (projects == null) {
                    return false;
                }
                if (project == null) {
                    return projects.size() > 0;
                }
                return projects.contains(project);
            }

            private Map<String, Set<IProject>> load() {
                HashMap<String, Set<IProject>> map = new HashMap<String, Set<IProject>>(50);
                ValManager vm = ValManager.getDefault();
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                Tracing.log("ValManager-02: loading " + projects.length + " projects");
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (project.isOpen()) {
                        Validator[] vals;
                        Validator[] validatorArray = vals = vm.getValidators(project);
                        int n3 = vals.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Validator v = validatorArray[n4];
                            String vid = v.getId();
                            HashSet<IProject> set = (HashSet<IProject>)map.get(vid);
                            if (set == null) {
                                set = new HashSet<IProject>(50);
                                map.put(vid, set);
                            }
                            if (v.shouldValidateProject(project, this._type)) {
                                set.add(project);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                return map;
            }
        }
    }
}

