/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.log.DefaultSessionLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSPackager;

public class XRPackager
implements DBWSPackager {
    public static NullOutputStream __nullStream = new NullOutputStream();
    protected DBWSBuilder builder;
    protected String[] additionalArgs;
    protected File stageDir;
    protected String sessionsFileName;
    protected boolean hasAttachments;
    protected DBWSPackager.Archiver archiver;
    protected String packagerLabel;
    protected DBWSPackager.ArchiveUse archiveUse;

    public XRPackager() {
        this(null, "xr", DBWSPackager.ArchiveUse.noArchive);
    }

    protected XRPackager(DBWSPackager.Archiver archiver, String packagerLabel, DBWSPackager.ArchiveUse useJavaArchive) {
        this.archiver = archiver;
        if (archiver != null) {
            archiver.setPackager(this);
        }
        this.packagerLabel = packagerLabel;
        this.archiveUse = useJavaArchive;
    }

    @Override
    public void setDBWSBuilder(DBWSBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void setAdditionalArgs(String[] additionalArgs) {
        this.additionalArgs = additionalArgs;
        if (additionalArgs != null) {
            this.processAdditionalArgs();
        }
    }

    public void processAdditionalArgs() {
        if (this.additionalArgs.length > 0) {
            this.setArchiveFilename(this.additionalArgs[0]);
        } else {
            this.setArchiveFilename(this.builder.getProjectName());
        }
    }

    @Override
    public File getStageDir() {
        return this.stageDir;
    }

    @Override
    public void setStageDir(File stageDir) {
        this.stageDir = stageDir;
    }

    @Override
    public String getSessionsFileName() {
        return this.sessionsFileName;
    }

    @Override
    public void setSessionsFileName(String sessionsFileName) {
        this.sessionsFileName = sessionsFileName;
    }

    @Override
    public boolean hasAttachments() {
        return this.hasAttachments;
    }

    @Override
    public void setHasAttachments(boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
    }

    public DBWSPackager.Archiver getArchiver() {
        return this.archiver;
    }

    public void setArchiver(DBWSPackager.Archiver archiver) {
        this.archiver = archiver;
    }

    @Override
    public void setArchiveUse(DBWSPackager.ArchiveUse packagerUse) {
        this.archiveUse = packagerUse;
        this.processArchiveUse();
    }

    public void processArchiveUse() {
        switch (this.archiveUse) {
            case archive: {
                this.setArchiver(this.buildDefaultArchiver());
                break;
            }
            case noArchive: {
                this.setArchiver(null);
            }
        }
    }

    public DBWSPackager.Archiver buildDefaultArchiver() {
        return null;
    }

    @Override
    public String getArchiveFilename() {
        if (this.archiver != null) {
            return this.archiver.getFilename();
        }
        return null;
    }

    @Override
    public void setArchiveFilename(String archiveFilename) {
        if (this.archiver != null) {
            this.archiver.setFilename(archiveFilename);
        }
    }

    @Override
    public String getPackagerLabel() {
        return this.packagerLabel;
    }

    public String getArchiverLabel() {
        return this.archiveUse.name();
    }

    @Override
    public String getUsage() {
        StringBuilder sb = new StringBuilder("-packageAs:[default=");
        sb.append(this.getArchiverLabel());
        sb.append("] ");
        sb.append(this.getPackagerLabel());
        String additionalUsage = this.getAdditionalUsage();
        if (additionalUsage != null) {
            sb.append(additionalUsage);
        }
        return sb.toString();
    }

    public String getAdditionalUsage() {
        return " [jarFilename]";
    }

    @Override
    public void start() {
        if (this.stageDir == null) {
            throw new DBWSException(this.getClass().getSimpleName() + " stageDir cannot be null");
        }
    }

    @Override
    public OutputStream getSchemaStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "eclipselink-dbws-schema.xsd"));
    }

    @Override
    public void closeSchemaStream(OutputStream schemaStream) {
        this.closeStream(schemaStream);
    }

    @Override
    public OutputStream getSessionsStream(String sessionsFileName) throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, sessionsFileName));
    }

    @Override
    public SessionConfigs buildSessionsXML(OutputStream dbwsSessionsStream, DBWSBuilder builder) {
        SessionConfigs ts = new SessionConfigs();
        ts.setVersion(Version.getVersion());
        DatabaseSessionConfig orSessionConfig = new DatabaseSessionConfig();
        String projectName = builder.getProjectName();
        orSessionConfig.setName(projectName + "-" + "dbws-or-session");
        ProjectConfig orProjectConfig = builder.buildORProjectConfig();
        orSessionConfig.setPrimaryProject(orProjectConfig);
        String orSessionCustomizerClassName = builder.getOrSessionCustomizerClassName();
        if (orSessionCustomizerClassName != null && !"".equals(orSessionCustomizerClassName)) {
            orSessionConfig.setSessionCustomizerClass(orSessionCustomizerClassName);
        }
        DatabaseLoginConfig dlc = new DatabaseLoginConfig();
        dlc.setBindAllParameters(true);
        dlc.setStreamsForBinding(true);
        dlc.setJdbcBatchWriting(true);
        dlc.setConnectionURL(builder.getUrl());
        dlc.setDriverClass(builder.getDriver());
        dlc.setUsername(builder.getUsername());
        dlc.setEncryptedPassword(builder.getPassword());
        dlc.setPlatformClass(builder.getPlatformClassname());
        orSessionConfig.setLoginConfig((LoginConfig)dlc);
        DefaultSessionLogConfig orLogConfig = new DefaultSessionLogConfig();
        orLogConfig.setLogLevel(builder.getLogLevel());
        orSessionConfig.setLogConfig((LogConfig)orLogConfig);
        ts.addSessionConfig((SessionConfig)orSessionConfig);
        DatabaseSessionConfig oxSessionConfig = new DatabaseSessionConfig();
        oxSessionConfig.setName(projectName + "-" + "dbws-ox-session");
        ProjectConfig oxProjectConfig = builder.buildOXProjectConfig();
        oxSessionConfig.setPrimaryProject(oxProjectConfig);
        DefaultSessionLogConfig oxLogConfig = new DefaultSessionLogConfig();
        oxLogConfig.setLogLevel("off");
        oxSessionConfig.setLogConfig((LogConfig)oxLogConfig);
        String oxSessionCustomizerClassName = builder.getOxSessionCustomizerClassName();
        if (oxSessionCustomizerClassName != null && !"".equals(oxSessionCustomizerClassName)) {
            oxSessionConfig.setSessionCustomizerClass(oxSessionCustomizerClassName);
        }
        ts.addSessionConfig((SessionConfig)oxSessionConfig);
        return ts;
    }

    @Override
    public void closeSessionsStream(OutputStream sessionsStream) {
        this.closeStream(sessionsStream);
    }

    @Override
    public OutputStream getServiceStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "eclipselink-dbws.xml"));
    }

    @Override
    public void closeServiceStream(OutputStream serviceStream) {
        this.closeStream(serviceStream);
    }

    @Override
    public OutputStream getOrStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "eclipselink-dbws-or.xml"));
    }

    @Override
    public String getOrProjectPathPrefix() {
        if (this.archiver == null) {
            return null;
        }
        return this.archiver.getOrProjectPathPrefix();
    }

    @Override
    public void closeOrStream(OutputStream orStream) {
        this.closeStream(orStream);
    }

    @Override
    public OutputStream getOxStream() throws FileNotFoundException {
        return new FileOutputStream(new File(this.stageDir, "eclipselink-dbws-ox.xml"));
    }

    @Override
    public String getOxProjectPathPrefix() {
        if (this.archiver == null) {
            return null;
        }
        return this.archiver.getOxProjectPathPrefix();
    }

    @Override
    public void closeOxStream(OutputStream oxStream) {
        this.closeStream(oxStream);
    }

    @Override
    public OutputStream getWSDLStream() throws FileNotFoundException {
        return __nullStream;
    }

    @Override
    public String getWSDLPathPrefix() {
        if (this.archiver == null) {
            return null;
        }
        return this.archiver.getWSDLPathPrefix();
    }

    @Override
    public void closeWSDLStream(OutputStream wsdlStream) {
        this.closeStream(wsdlStream);
    }

    @Override
    public OutputStream getSWARefStream() throws FileNotFoundException {
        if (!this.hasAttachments) {
            return __nullStream;
        }
        return new FileOutputStream(new File(this.stageDir, "swaref.xsd"));
    }

    @Override
    public void closeSWARefStream(OutputStream swarefStream) {
        this.closeStream(swarefStream);
    }

    @Override
    public OutputStream getWebXmlStream() throws FileNotFoundException {
        return __nullStream;
    }

    @Override
    public void writeWebXml(OutputStream webXmlStream, DBWSBuilder dbwsBuilder) {
    }

    @Override
    public void closeWebXmlStream(OutputStream webXmlStream) {
        this.closeStream(webXmlStream);
    }

    @Override
    public OutputStream getProviderSourceStream() throws FileNotFoundException {
        return __nullStream;
    }

    @Override
    public void closeProviderSourceStream(OutputStream sourceProviderStream) {
        this.closeStream(sourceProviderStream);
    }

    @Override
    public OutputStream getProviderClassStream() throws FileNotFoundException {
        return __nullStream;
    }

    @Override
    public void closeProviderClassStream(OutputStream classProviderStream) {
        this.closeStream(classProviderStream);
    }

    @Override
    public OutputStream getProviderListenerSourceStream() throws FileNotFoundException {
        return __nullStream;
    }

    @Override
    public void closeProviderListenerSourceStream(OutputStream sourceProviderListenerStream) {
        this.closeStream(sourceProviderListenerStream);
    }

    @Override
    public OutputStream getProviderListenerClassStream() throws FileNotFoundException {
        return __nullStream;
    }

    @Override
    public void closeProviderListenerClassStream(OutputStream classProviderListenerStream) {
        this.closeStream(classProviderListenerStream);
    }

    @Override
    public void writeProvider(OutputStream sourceProviderStream, OutputStream classProviderStream, OutputStream sourceProviderListenerStream, OutputStream classProviderListenerStream, DBWSBuilder builder) {
    }

    protected void closeStream(OutputStream outputStream) {
        if (outputStream != null && outputStream != __nullStream) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void end() {
        if (this.archiver != null) {
            this.archiver.archive();
        }
    }

    protected static class NullOutputStream
    extends OutputStream {
        protected NullOutputStream() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int i, int l) {
        }

        @Override
        public void write(int b) {
        }
    }
}

