/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractReplyToCommentAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorRichTextPart;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskEditorDescriptionPart
extends TaskEditorRichTextPart {
    public TaskEditorDescriptionPart() {
        this.setPartName(Messages.TaskEditorDescriptionPart_Description);
    }

    private void addDuplicateDetection(Composite composite, FormToolkit toolkit) {
        ArrayList<AbstractDuplicateDetector> allCollectors = new ArrayList<AbstractDuplicateDetector>();
        if (this.getDuplicateSearchCollectorsList() != null) {
            allCollectors.addAll(this.getDuplicateSearchCollectorsList());
        }
        if (!allCollectors.isEmpty()) {
            int style = 514;
            if (this.getTaskData().isNew()) {
                style |= 0x40;
            }
            Section duplicatesSection = toolkit.createSection(composite, style);
            duplicatesSection.setText(Messages.TaskEditorDescriptionPart_Duplicate_Detection);
            duplicatesSection.setLayout((Layout)new GridLayout());
            GridDataFactory.fillDefaults().indent(-1, 15).applyTo((Control)duplicatesSection);
            Composite relatedBugsComposite = toolkit.createComposite((Composite)duplicatesSection);
            relatedBugsComposite.setLayout((Layout)new GridLayout(4, false));
            relatedBugsComposite.setLayoutData((Object)new GridData(256));
            duplicatesSection.setClient((Control)relatedBugsComposite);
            Label duplicateDetectorLabel = new Label(relatedBugsComposite, 16384);
            duplicateDetectorLabel.setText(Messages.TaskEditorDescriptionPart_Detector);
            final CCombo duplicateDetectorChooser = new CCombo(relatedBugsComposite, 0x800008);
            toolkit.adapt((Control)duplicateDetectorChooser, false, false);
            duplicateDetectorChooser.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            duplicateDetectorChooser.setFont(TEXT_FONT);
            duplicateDetectorChooser.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
            Collections.sort(allCollectors, new Comparator<AbstractDuplicateDetector>(){

                @Override
                public int compare(AbstractDuplicateDetector c1, AbstractDuplicateDetector c2) {
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            });
            for (AbstractDuplicateDetector detector : allCollectors) {
                duplicateDetectorChooser.add(detector.getName());
            }
            duplicateDetectorChooser.select(0);
            duplicateDetectorChooser.setEnabled(true);
            duplicateDetectorChooser.setData(allCollectors);
            if (allCollectors.size() > 0) {
                Button searchForDuplicates = toolkit.createButton(relatedBugsComposite, Messages.TaskEditorDescriptionPart_Search, 0);
                GridData searchDuplicatesButtonData = new GridData(32);
                searchForDuplicates.setLayoutData((Object)searchDuplicatesButtonData);
                searchForDuplicates.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        String selectedDetector = duplicateDetectorChooser.getItem(duplicateDetectorChooser.getSelectionIndex());
                        TaskEditorDescriptionPart.this.searchForDuplicates(selectedDetector);
                    }
                });
            }
            toolkit.paintBordersFor(relatedBugsComposite);
        }
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.getAttribute() == null) {
            return;
        }
        super.createControl(parent, toolkit);
        if (SearchUtil.supportsTaskSearch()) {
            this.addDuplicateDetection(this.getComposite(), toolkit);
        }
        this.getEditor().enableAutoTogglePreview();
        if (!this.getTaskData().isNew()) {
            this.getEditor().showPreview();
        }
    }

    @Override
    protected void fillToolBar(ToolBarManager toolBar) {
        if (!this.getTaskData().isNew()) {
            AbstractReplyToCommentAction replyAction = new AbstractReplyToCommentAction(this.getTaskEditorPage(), null){

                protected String getReplyText() {
                    return TaskEditorDescriptionPart.this.getEditor().getValue();
                }
            };
            replyAction.setImageDescriptor(TasksUiImages.COMMENT_REPLY_SMALL);
            toolBar.add((IAction)replyAction);
        }
        super.fillToolBar(toolBar);
    }

    protected IRepositoryQuery getDuplicateQuery(String name) throws CoreException {
        String duplicateDetectorName = name.equals("default") ? "Stack Trace" : name;
        for (AbstractDuplicateDetector detector : this.getDuplicateSearchCollectorsList()) {
            if (!detector.getName().equals(duplicateDetectorName)) continue;
            return detector.getDuplicatesQuery(this.getTaskEditorPage().getTaskRepository(), this.getTaskData());
        }
        return null;
    }

    protected Set<AbstractDuplicateDetector> getDuplicateSearchCollectorsList() {
        HashSet<AbstractDuplicateDetector> duplicateDetectors = new HashSet<AbstractDuplicateDetector>();
        for (AbstractDuplicateDetector detector : TasksUiPlugin.getDefault().getDuplicateSearchCollectorsList()) {
            if (!this.isValidDuplicateDetector(detector)) continue;
            duplicateDetectors.add(detector);
        }
        return duplicateDetectors;
    }

    @Override
    public void initialize(AbstractTaskEditorPage taskEditorPage) {
        super.initialize(taskEditorPage);
        this.setAttribute(this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.description"));
    }

    private boolean isValidDuplicateDetector(AbstractDuplicateDetector detector) {
        return (detector.getConnectorKind() == null || detector.getConnectorKind().equals(this.getTaskEditorPage().getConnectorKind())) && detector.canQuery(this.getTaskData());
    }

    public void searchForDuplicates(String duplicateDetectorName) {
        try {
            IRepositoryQuery duplicatesQuery = this.getDuplicateQuery(duplicateDetectorName);
            if (duplicatesQuery != null) {
                SearchUtil.runSearchQuery(TasksUiInternal.getTaskList(), this.getTaskEditorPage().getTaskRepository(), duplicatesQuery);
            } else {
                TasksUiInternal.displayStatus(Messages.TaskEditorDescriptionPart_Duplicate_Detection_Failed, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.TaskEditorDescriptionPart_The_duplicate_detector_did_not_return_a_valid_query));
            }
        }
        catch (CoreException e) {
            TasksUiInternal.displayStatus(Messages.TaskEditorDescriptionPart_Duplicate_Detection_Failed, e.getStatus());
        }
    }
}

