/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.impl;

import com.aelitis.azureus.core.clientmessageservice.impl.ClientConnection;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessageHandler;
import java.util.Map;

public class ClientMessage {
    private final String message_id;
    private final ClientConnection client;
    private final Map payload;
    private ClientMessageHandler handler;
    private boolean outcome_reported;

    public ClientMessage(String string, ClientConnection clientConnection, Map map, ClientMessageHandler clientMessageHandler) {
        this.message_id = string;
        this.client = clientConnection;
        this.payload = map;
        this.handler = clientMessageHandler;
    }

    public String getMessageID() {
        return this.message_id;
    }

    public ClientConnection getClient() {
        return this.client;
    }

    public Map getPayload() {
        return this.payload;
    }

    public ClientMessageHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ClientMessageHandler clientMessageHandler) {
        this.handler = clientMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportComplete() {
        ClientMessage clientMessage = this;
        synchronized (clientMessage) {
            if (this.outcome_reported) {
                return;
            }
            this.outcome_reported = true;
        }
        this.handler.sendAttemptCompleted(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportFailed(Throwable throwable) {
        ClientMessage clientMessage = this;
        synchronized (clientMessage) {
            if (this.outcome_reported) {
                return;
            }
            this.outcome_reported = true;
        }
        this.handler.sendAttemptFailed(this, throwable);
    }
}

