/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.secure.impl;

import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClient;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClientAdapter;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClientListener;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClientMessage;
import com.aelitis.azureus.core.clientmessageservice.secure.impl.SecureMessageServiceClientHelper;
import com.aelitis.azureus.core.clientmessageservice.secure.impl.SecureMessageServiceClientMessageImpl;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SystemTime;

public class SecureMessageServiceClientImpl
implements SecureMessageServiceClient {
    public static final int STATUS_OK = 0;
    public static final int STATUS_LOGON_FAIL = 1;
    public static final int STATUS_INVALID_SEQUENCE = 2;
    public static final int STATUS_FAILED = 3;
    public static final int STATUS_ABORT = 4;
    public static final String SERVICE_NAME = "SecureMsgServ";
    private static final long MIN_RETRY_PERIOD = 300000L;
    private static final long MAX_RETRY_PERIOD = 0x6DDD00L;
    private String host;
    private int port;
    private int timeout_secs;
    private RSAPublicKey public_key;
    private SecureMessageServiceClientAdapter adapter;
    private long retry_millis = 300000L;
    private int connect_failure_count = 0;
    private AEMonitor message_mon;
    private AESemaphore message_sem;
    private String last_failed_user_pw = "";
    private long last_failed_user_pw_time;
    private List messages = new ArrayList();
    private List listeners = new ArrayList();

    public SecureMessageServiceClientImpl(String string, int n, int n2, RSAPublicKey rSAPublicKey, SecureMessageServiceClientAdapter secureMessageServiceClientAdapter) {
        this.host = string;
        this.port = n;
        this.timeout_secs = n2;
        this.public_key = rSAPublicKey;
        this.adapter = secureMessageServiceClientAdapter;
        this.message_mon = new AEMonitor("SecureService:messages");
        this.message_sem = new AESemaphore("SecureService:messages");
        new AEThread("SecureService::messageSender", true){

            public void runSupport() {
                while (true) {
                    long l = SecureMessageServiceClientImpl.this.retry_millis;
                    if (SecureMessageServiceClientImpl.this.connect_failure_count > 0) {
                        for (int i = 0; i < SecureMessageServiceClientImpl.this.connect_failure_count; ++i) {
                            if ((l += l) <= 0x6DDD00L) continue;
                            l = 0x6DDD00L;
                            break;
                        }
                    }
                    SecureMessageServiceClientImpl.this.message_sem.reserve(l);
                    try {
                        SecureMessageServiceClientImpl.this.sendMessagesSupport();
                        continue;
                    }
                    catch (Throwable throwable) {
                        SecureMessageServiceClientImpl.this.adapter.log("Request processing failed", throwable);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public void sendMessages() {
        this.message_sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void sendMessagesSupport() {
        block50: {
            Object v0;
            Iterator iterator;
            ArrayList arrayList;
            long l;
            String string = this.adapter.getUser();
            byte[] byArray = this.adapter.getPassword();
            String string2 = string + "/" + new String(byArray);
            if (string.length() == 0) {
                this.adapter.authenticationFailed();
                return;
            }
            if (string2.equals(this.last_failed_user_pw) && (l = SystemTime.getCurrentTime()) > this.last_failed_user_pw_time && l - this.last_failed_user_pw_time < 60000L) {
                this.adapter.authenticationFailed();
                return;
            }
            try {
                this.message_mon.enter();
                arrayList = new ArrayList(this.messages);
                iterator = null;
                this.message_mon.exit();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.message_mon.exit();
                throw throwable;
            }
            if (arrayList.size() == 0) {
                return;
            }
            ArrayList<SecureMessageServiceClientMessageImpl> arrayList2 = new ArrayList<SecureMessageServiceClientMessageImpl>();
            boolean bl = false;
            iterator = arrayList.iterator();
            while (iterator.hasNext() && !bl) {
                SecureMessageServiceClientMessageImpl secureMessageServiceClientMessageImpl = (SecureMessageServiceClientMessageImpl)iterator.next();
                boolean bl2 = true;
                int n = 0;
                while (bl2 && !bl) {
                    Throwable throwable4222;
                    Object var23_28;
                    boolean bl3;
                    ClientMessageService clientMessageService;
                    block47: {
                        block46: {
                            Iterator iterator2;
                            bl2 = false;
                            clientMessageService = null;
                            bl3 = false;
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            long l2 = this.adapter.getMessageSequence();
                            hashMap.put("user", string);
                            hashMap.put("password", byArray);
                            hashMap.put("seq", new Long(l2));
                            hashMap.put("request", secureMessageServiceClientMessageImpl.getRequest());
                            this.last_failed_user_pw = "";
                            clientMessageService = SecureMessageServiceClientHelper.getServerService(this.host, this.port, this.timeout_secs, SERVICE_NAME, this.public_key);
                            clientMessageService.sendMessage(hashMap);
                            Map map = clientMessageService.receiveMessage();
                            bl3 = true;
                            long l3 = (Long)map.get("status");
                            Long l4 = (Long)map.get("retry");
                            if (l4 != null) {
                                this.retry_millis = l4;
                                if (this.retry_millis < 300000L) {
                                    this.retry_millis = 300000L;
                                }
                                this.adapter.log("Server requested retry period of " + this.retry_millis / 1000L + " seconds");
                            } else {
                                this.retry_millis = 300000L;
                            }
                            if (l3 == 0L) {
                                secureMessageServiceClientMessageImpl.setReply((Map)map.get("reply"));
                                this.adapter.log("Request successfully sent: " + secureMessageServiceClientMessageImpl.getRequest() + "->" + secureMessageServiceClientMessageImpl.getReply());
                                this.adapter.setMessageSequence(l2 + 1L);
                                this.adapter.serverOK();
                                iterator2 = this.listeners.iterator();
                                while (iterator2.hasNext()) {
                                    try {
                                        ((SecureMessageServiceClientListener)iterator2.next()).complete(secureMessageServiceClientMessageImpl);
                                    }
                                    catch (Throwable throwable2) {
                                        throwable2.printStackTrace();
                                    }
                                }
                                arrayList2.add(secureMessageServiceClientMessageImpl);
                                break block46;
                            }
                            if (l3 == 1L) {
                                this.last_failed_user_pw = string2;
                                this.last_failed_user_pw_time = SystemTime.getCurrentTime();
                                this.adapter.serverOK();
                                this.adapter.authenticationFailed();
                                bl = true;
                                break block46;
                            }
                            if (l3 == 2L) {
                                if (n == 1) {
                                    this.adapter.serverFailed(new Exception("Sequence resynchronisation failed"));
                                    bl = true;
                                } else {
                                    ++n;
                                    bl2 = true;
                                    long l5 = (Long)map.get("seq");
                                    this.adapter.log("Sequence resynchronise: local = " + l2 + ", remote = " + l5);
                                    this.adapter.setMessageSequence(l5);
                                }
                                break block46;
                            }
                            if (l3 == 3L) {
                                this.adapter.serverFailed(new Exception(new String((byte[])map.get("error"))));
                                bl = true;
                                break block46;
                            }
                            this.adapter.serverFailed(new Exception("Server requested abort"));
                            iterator2 = this.listeners.iterator();
                            while (iterator2.hasNext()) {
                                try {
                                    ((SecureMessageServiceClientListener)iterator2.next()).aborted(secureMessageServiceClientMessageImpl, new String((byte[])map.get("error")));
                                }
                                catch (Throwable throwable3) {
                                    throwable3.printStackTrace();
                                }
                            }
                            arrayList2.add(secureMessageServiceClientMessageImpl);
                        }
                        var23_28 = null;
                        if (bl3) {
                            this.connect_failure_count = 0;
                            break block47;
                        }
                        ++this.connect_failure_count;
                        if (this.connect_failure_count <= 1) break block47;
                        try {
                            this.adapter.log("Failed to contact server " + this.connect_failure_count + " times in a row");
                        }
                        catch (Throwable throwable4222) {
                            throwable4222.printStackTrace();
                        }
                    }
                    if (clientMessageService == null) continue;
                    clientMessageService.close();
                    {
                        continue;
                        catch (Throwable throwable5) {
                            this.adapter.serverFailed(throwable5);
                            bl = true;
                            var23_28 = null;
                            if (bl3) {
                                this.connect_failure_count = 0;
                            } else {
                                ++this.connect_failure_count;
                                if (this.connect_failure_count > 1) {
                                    try {
                                        this.adapter.log("Failed to contact server " + this.connect_failure_count + " times in a row");
                                    }
                                    catch (Throwable throwable4222) {
                                        throwable4222.printStackTrace();
                                    }
                                }
                            }
                            if (clientMessageService == null) continue;
                            clientMessageService.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable6) {
                        var23_28 = null;
                        if (bl3) {
                            this.connect_failure_count = 0;
                        } else {
                            ++this.connect_failure_count;
                            if (this.connect_failure_count > 1) {
                                try {
                                    this.adapter.log("Failed to contact server " + this.connect_failure_count + " times in a row");
                                }
                                catch (Throwable throwable4222) {
                                    throwable4222.printStackTrace();
                                }
                            }
                        }
                        if (clientMessageService != null) {
                            clientMessageService.close();
                        }
                        throw throwable6;
                    }
                }
            }
            Object var26_31 = null;
            try {
                this.message_mon.enter();
                this.messages.removeAll(arrayList2);
                v0 = null;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var28_37 = v0;
            this.message_mon.exit();
            {
                break block50;
                catch (Throwable throwable) {
                    Object v1;
                    this.adapter.serverFailed(throwable);
                    Object var26_32 = null;
                    try {
                        this.message_mon.enter();
                        this.messages.removeAll(arrayList2);
                        v1 = null;
                    }
                    catch (Throwable throwable7) {
                        v1 = null;
                    }
                    Object var28_38 = v1;
                    this.message_mon.exit();
                }
            }
            catch (Throwable throwable) {
                Object v2;
                Object var26_33 = null;
                try {
                    this.message_mon.enter();
                    this.messages.removeAll(arrayList2);
                    v2 = null;
                }
                catch (Throwable throwable8) {
                    v2 = null;
                }
                Object var28_39 = v2;
                this.message_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureMessageServiceClientMessage sendMessage(Map map, Object object, String string) {
        try {
            this.message_mon.enter();
            SecureMessageServiceClientMessageImpl secureMessageServiceClientMessageImpl = new SecureMessageServiceClientMessageImpl(this, map, object, string);
            this.messages.add(secureMessageServiceClientMessageImpl);
            this.message_sem.release();
            SecureMessageServiceClientMessageImpl secureMessageServiceClientMessageImpl2 = secureMessageServiceClientMessageImpl;
            Object var7_6 = null;
            this.message_mon.exit();
            return secureMessageServiceClientMessageImpl2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.message_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(SecureMessageServiceClientMessage secureMessageServiceClientMessage) {
        boolean bl = false;
        try {
            this.message_mon.enter();
            if (this.messages.remove(secureMessageServiceClientMessage)) {
                bl = true;
            }
            Object var4_3 = null;
            this.message_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.message_mon.exit();
            throw throwable;
        }
        if (bl) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((SecureMessageServiceClientListener)iterator.next()).cancelled(secureMessageServiceClientMessage);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureMessageServiceClientMessage[] getMessages() {
        try {
            this.message_mon.enter();
            SecureMessageServiceClientMessage[] secureMessageServiceClientMessageArray = this.messages.toArray(new SecureMessageServiceClientMessage[this.messages.size()]);
            Object var3_2 = null;
            this.message_mon.exit();
            return secureMessageServiceClientMessageArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.message_mon.exit();
            throw throwable;
        }
    }

    public void addListener(SecureMessageServiceClientListener secureMessageServiceClientListener) {
        this.listeners.add(secureMessageServiceClientListener);
    }

    public void removeListener(SecureMessageServiceClientListener secureMessageServiceClientListener) {
        this.listeners.remove(secureMessageServiceClientListener);
    }
}

