/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.cnetwork.impl;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkPropertyChangeListener;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkManagerImpl;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkVuzeGeneric;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.MapUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentNetworkImpl
implements ContentNetwork {
    protected static final long TYPE_VUZE_GENERIC = 1L;
    private static final String PP_STARTUP_NETWORK = "startup_network";
    private ContentNetworkManagerImpl manager;
    private long type;
    private long version;
    private long id;
    private String name;
    private Map<String, Object> pprop_defaults;
    private Map<Object, Object> transient_properties = Collections.synchronizedMap(new HashMap());
    private CopyOnWriteList persistent_listeners = new CopyOnWriteList();

    protected static ContentNetworkImpl importFromBEncodedMapStatic(ContentNetworkManagerImpl contentNetworkManagerImpl, Map map) throws IOException {
        long l = ImportExportUtils.importLong(map, "type");
        if (l == 1L) {
            return new ContentNetworkVuzeGeneric(contentNetworkManagerImpl, map);
        }
        throw new IOException("Unsupported network type: " + l);
    }

    protected ContentNetworkImpl(ContentNetworkManagerImpl contentNetworkManagerImpl, long l, long l2, long l3, String string, Map<String, Object> map) {
        this.manager = contentNetworkManagerImpl;
        this.type = l;
        this.version = l3;
        this.id = l2;
        this.name = string;
        this.pprop_defaults = map;
    }

    protected ContentNetworkImpl(ContentNetworkManagerImpl contentNetworkManagerImpl) {
        this.manager = contentNetworkManagerImpl;
    }

    protected void importFromBEncodedMap(Map<String, Object> map) throws IOException {
        this.type = ImportExportUtils.importLong(map, "type");
        this.id = ImportExportUtils.importLong(map, "id");
        this.version = ImportExportUtils.importLong(map, "version");
        this.name = ImportExportUtils.importString(map, "name");
        this.pprop_defaults = (Map)map.get("pprop_defaults");
    }

    protected void exportToBEncodedMap(Map<String, Object> map) throws IOException {
        ImportExportUtils.exportLong(map, "type", this.type);
        ImportExportUtils.exportLong(map, "id", this.id);
        ImportExportUtils.exportLong(map, "version", this.version);
        ImportExportUtils.exportString(map, "name", this.name);
        if (this.pprop_defaults != null) {
            map.put("pprop_defaults", this.pprop_defaults);
        }
    }

    protected void updateFrom(ContentNetworkImpl contentNetworkImpl) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        contentNetworkImpl.exportToBEncodedMap(hashMap);
        this.importFromBEncodedMap(hashMap);
    }

    @Override
    public long getID() {
        return this.id;
    }

    protected long getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected boolean isSameAs(ContentNetworkImpl contentNetworkImpl) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            this.exportToBEncodedMap(hashMap);
            contentNetworkImpl.exportToBEncodedMap(hashMap2);
            return BEncoder.mapsAreIdentical(hashMap, hashMap2);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return false;
        }
    }

    @Override
    public String getSearchService(String string) {
        return this.getServiceURL(1, new Object[]{string});
    }

    @Override
    public String getXSearchService(String string, boolean bl) {
        return this.getServiceURL(2, new Object[]{string, bl});
    }

    @Override
    public String getContentDetailsService(String string, String string2) {
        return this.getServiceURL(11, new Object[]{string, string2});
    }

    @Override
    public String getCommentService(String string) {
        return this.getServiceURL(12, new Object[]{string});
    }

    @Override
    public String getProfileService(String string, String string2) {
        return this.getServiceURL(13, new Object[]{string, string2});
    }

    @Override
    public String getTorrentDownloadService(String string, String string2) {
        return this.getServiceURL(14, new Object[]{string, string2});
    }

    @Override
    public String getFAQTopicService(String string) {
        return this.getServiceURL(18, new Object[]{string});
    }

    @Override
    public String getLoginService(String string) {
        return this.getServiceURL(22, new Object[]{string});
    }

    @Override
    public String getSiteRelativeURL(String string, boolean bl) {
        return this.getServiceURL(27, new Object[]{string, bl});
    }

    @Override
    public String getExternalSiteRelativeURL(String string, boolean bl) {
        return this.getServiceURL(37, new Object[]{string, bl});
    }

    @Override
    public String getAddFriendURL(String string) {
        return this.getServiceURL(28, new Object[]{string});
    }

    @Override
    public String getSubscriptionURL(String string) {
        return this.getServiceURL(29, new Object[]{string});
    }

    @Override
    public VuzeFile getVuzeFile() {
        VuzeFile vuzeFile = VuzeFileHandler.getSingleton().create();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            this.exportToBEncodedMap(hashMap);
            vuzeFile.addComponent(128, hashMap);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return vuzeFile;
    }

    @Override
    public boolean isStartupNetwork() {
        if (this.hasPersistentProperty(PP_STARTUP_NETWORK)) {
            return (Boolean)this.getPersistentProperty(PP_STARTUP_NETWORK);
        }
        return (Boolean)this.getPersistentProperty("is_cust");
    }

    @Override
    public void setStartupNetwork(boolean bl) {
        this.setPersistentProperty(PP_STARTUP_NETWORK, new Boolean(bl));
    }

    @Override
    public void setTransientProperty(Object object, Object object2) {
        this.transient_properties.put(object, object2);
    }

    @Override
    public Object getTransientProperty(Object object) {
        return this.transient_properties.get(object);
    }

    protected String getPropertiesKey() {
        return "cnetwork.net." + this.id + ".props";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPersistentProperty(String string, Object object) {
        Object object2 = this;
        synchronized (object2) {
            HashMap<String, Object> hashMap;
            Object v;
            String string2 = this.getPropertiesKey();
            if (object instanceof Boolean) {
                object = new Long((Boolean)object != false ? 1L : 0L);
            }
            if (BEncoder.objectsAreIdentical(v = (hashMap = new HashMap<String, Object>(COConfigurationManager.getMapParameter(string2, new HashMap()))).get(string2), object)) {
                return;
            }
            hashMap.put(string, object);
            COConfigurationManager.setParameter(string2, hashMap);
        }
        object2 = this.persistent_listeners.iterator();
        while (object2.hasNext()) {
            try {
                ((ContentNetworkPropertyChangeListener)object2.next()).propertyChanged(string);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPersistentProperty(String string) {
        ContentNetworkImpl contentNetworkImpl = this;
        synchronized (contentNetworkImpl) {
            String string2 = this.getPropertiesKey();
            Map map = COConfigurationManager.getMapParameter(string2, new HashMap());
            if (string == "source_ref") {
                return MapUtils.getMapString(map, string, MapUtils.getMapString(this.pprop_defaults, string, null));
            }
            Object object = map.get(string);
            if (string == "auth_shown" || string == "is_cust" || string == "active" || string == "in_menu" || string == PP_STARTUP_NETWORK) {
                if (object == null && this.pprop_defaults != null) {
                    object = this.pprop_defaults.get(string);
                }
                if (object == null) {
                    return false;
                }
                return (Long)object == 1L;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPersistentProperty(String string) {
        ContentNetworkImpl contentNetworkImpl = this;
        synchronized (contentNetworkImpl) {
            String string2 = this.getPropertiesKey();
            Map map = COConfigurationManager.getMapParameter(string2, new HashMap());
            return map.containsKey(string);
        }
    }

    protected Map<String, Object> getPersistentPropertyDefaults() {
        return this.pprop_defaults;
    }

    @Override
    public void addPersistentPropertyChangeListener(ContentNetworkPropertyChangeListener contentNetworkPropertyChangeListener) {
        this.persistent_listeners.add(contentNetworkPropertyChangeListener);
    }

    @Override
    public void removePersistentPropertyChangeListener(ContentNetworkPropertyChangeListener contentNetworkPropertyChangeListener) {
        this.persistent_listeners.remove(contentNetworkPropertyChangeListener);
    }

    protected void destroy() {
        String string = this.getPropertiesKey();
        COConfigurationManager.setParameter(string, new HashMap());
    }

    @Override
    public void remove() {
        this.manager.removeNetwork(this);
    }

    protected void debug(String string) {
        Debug.out(this.getString() + ": " + string);
    }

    protected String getString() {
        return this.getID() + " - " + this.getName() + ": version=" + this.getVersion() + ", site=" + this.getProperty(1);
    }
}

