/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.cnetwork.impl;

import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkImpl;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkManagerImpl;
import com.aelitis.azureus.core.crypto.VuzeCryptoManager;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNetworkVuzeGeneric
extends ContentNetworkImpl {
    private static String URL_SUFFIX;
    private Map<Integer, String> service_map = new HashMap<Integer, String>();
    private Set<Integer> service_exclusions;
    private String SITE_HOST;
    private String URL_PREFIX;
    private String URL_EXT_PREFIX;
    private String URL_ICON;
    private String URL_RELAY_RPC;
    private String URL_AUTHORIZED_RPC;
    private String URL_FAQ;
    private String URL_BLOG;
    private String URL_FORUMS;
    private String URL_WIKI;

    public ContentNetworkVuzeGeneric(ContentNetworkManagerImpl contentNetworkManagerImpl, long l, long l2, String string, Map<String, Object> map, Set<Integer> set, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        this(contentNetworkManagerImpl, l, l2, string, map, set, string2, string3, string4, string5, string6, string7, string8, string9, string10, null);
    }

    public ContentNetworkVuzeGeneric(ContentNetworkManagerImpl contentNetworkManagerImpl, long l, long l2, String string, Map<String, Object> map, Set<Integer> set, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        super(contentNetworkManagerImpl, 1L, l, l2, string, map);
        this.SITE_HOST = string2;
        this.URL_PREFIX = string3;
        this.URL_ICON = string4;
        this.URL_RELAY_RPC = string5;
        this.URL_AUTHORIZED_RPC = string6;
        this.URL_FAQ = string7;
        this.URL_BLOG = string8;
        this.URL_FORUMS = string9;
        this.URL_WIKI = string10;
        this.URL_EXT_PREFIX = string11;
        this.service_exclusions = set;
        this.init();
    }

    protected ContentNetworkVuzeGeneric(ContentNetworkManagerImpl contentNetworkManagerImpl, Map<String, Object> map) throws IOException {
        super(contentNetworkManagerImpl);
        this.importFromBEncodedMap(map);
    }

    @Override
    protected void importFromBEncodedMap(Map<String, Object> map) throws IOException {
        super.importFromBEncodedMap(map);
        this.SITE_HOST = ImportExportUtils.importString(map, "vg_site");
        this.URL_PREFIX = ImportExportUtils.importString(map, "vg_prefix");
        this.URL_EXT_PREFIX = ImportExportUtils.importString(map, "vg_ext_prefix");
        if (this.URL_EXT_PREFIX == null) {
            this.URL_EXT_PREFIX = this.URL_PREFIX;
        }
        this.URL_ICON = ImportExportUtils.importString(map, "vg_icon");
        this.URL_RELAY_RPC = ImportExportUtils.importString(map, "vg_relay_rpc");
        this.URL_AUTHORIZED_RPC = ImportExportUtils.importString(map, "vg_auth_rpc");
        this.URL_FAQ = ImportExportUtils.importString(map, "vg_faq");
        this.URL_BLOG = ImportExportUtils.importString(map, "vg_blog");
        this.URL_FORUMS = ImportExportUtils.importString(map, "vg_forums");
        this.URL_WIKI = ImportExportUtils.importString(map, "vg_wiki");
        List list = (List)map.get("vg_sex");
        if (list != null) {
            this.service_exclusions = new HashSet<Integer>();
            for (Long l : list) {
                this.service_exclusions.add(l.intValue());
            }
        }
        this.init();
    }

    protected void exportToBEncodedMap(Map map) throws IOException {
        super.exportToBEncodedMap(map);
        ImportExportUtils.exportString(map, "vg_site", this.SITE_HOST);
        ImportExportUtils.exportString(map, "vg_prefix", this.URL_PREFIX);
        ImportExportUtils.exportString(map, "vg_ext_prefix", this.URL_EXT_PREFIX);
        ImportExportUtils.exportString(map, "vg_icon", this.URL_ICON);
        ImportExportUtils.exportString(map, "vg_relay_rpc", this.URL_RELAY_RPC);
        ImportExportUtils.exportString(map, "vg_auth_rpc", this.URL_AUTHORIZED_RPC);
        ImportExportUtils.exportString(map, "vg_faq", this.URL_FAQ);
        ImportExportUtils.exportString(map, "vg_blog", this.URL_BLOG);
        ImportExportUtils.exportString(map, "vg_forums", this.URL_FORUMS);
        ImportExportUtils.exportString(map, "vg_wiki", this.URL_WIKI);
        if (this.service_exclusions != null) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (Integer n : this.service_exclusions) {
                arrayList.add(n.longValue());
            }
            map.put("vg_sex", arrayList);
        }
    }

    protected void init() {
        this.service_map.clear();
        this.addService(1, this.URL_PREFIX + "search?q=");
        this.addService(2, this.URL_PREFIX + "xsearch/index.php?q=");
        this.addService(3, "http://vrpc.vuze.com/vzrpc/rpc.php");
        this.addService(6, this.URL_PREFIX + "browse.start?");
        this.addService(7, this.URL_PREFIX + "publish.start?");
        this.addService(8, this.URL_PREFIX + "welcome.start?");
        this.addService(35, this.URL_PREFIX + "about.start?");
        this.addService(9, this.URL_PREFIX + "publishnew.start?");
        this.addService(10, this.URL_PREFIX + "publishinfo.start");
        this.addService(11, this.URL_PREFIX + "details/");
        this.addService(12, this.URL_PREFIX + "comment/");
        this.addService(13, this.URL_PREFIX + "profile/");
        this.addService(14, this.URL_PREFIX + "download/");
        this.addService(15, this.URL_PREFIX);
        this.addService(16, this.URL_EXT_PREFIX + "support/");
        this.addService(22, this.URL_PREFIX + "login.start?");
        this.addService(23, this.URL_PREFIX + "logout.start?");
        this.addService(24, this.URL_PREFIX + "register.start?");
        this.addService(25, this.URL_PREFIX + "profile.start?");
        this.addService(26, this.URL_PREFIX + "account.start?");
        this.addService(27, this.URL_PREFIX);
        this.addService(37, this.URL_EXT_PREFIX);
        this.addService(28, this.URL_PREFIX + "user/AddFriend.html?");
        this.addService(29, this.URL_PREFIX + "xsearch/index.php?");
        this.addService(31, this.URL_PREFIX + "ip.start?");
        this.addService(30, this.URL_ICON);
        this.addService(32, this.URL_PREFIX + "emp/load/");
        this.addService(33, this.URL_PREFIX + "emp/recommend/");
        this.addService(34, this.URL_PREFIX + "sidebar.close");
        this.addService(36, "http://pixel.quantserve.com/pixel/p-64Ix1G_SXwOa-.gif");
        if (this.URL_RELAY_RPC != null) {
            this.addService(4, this.URL_RELAY_RPC);
        }
        if (this.URL_AUTHORIZED_RPC != null) {
            this.addService(5, this.URL_AUTHORIZED_RPC);
        }
        if (this.URL_FAQ != null) {
            this.addService(17, this.URL_FAQ);
            this.addService(18, this.URL_FAQ + "?View=entry&EntryID=");
        }
        if (this.URL_BLOG != null) {
            this.addService(19, this.URL_BLOG);
        }
        if (this.URL_FORUMS != null) {
            this.addService(20, this.URL_FORUMS);
        }
        if (this.URL_WIKI != null) {
            this.addService(21, this.URL_WIKI);
        }
    }

    protected void addService(int n, String string) {
        this.service_map.put(n, string);
    }

    protected Set<Integer> getServiceExclusions() {
        return this.service_exclusions;
    }

    @Override
    public Object getProperty(int n) {
        if (n == 1) {
            return this.SITE_HOST;
        }
        if (n == 2) {
            return this.getID() != 1L;
        }
        if (n == 3) {
            return String.valueOf(this.getID());
        }
        this.debug("Unknown property");
        return null;
    }

    @Override
    public boolean isServiceSupported(int n) {
        if (this.service_exclusions != null && this.service_exclusions.contains(n)) {
            return false;
        }
        return this.service_map.get(n) != null;
    }

    @Override
    public String getServiceURL(int n) {
        return this.getServiceURL(n, new Object[0]);
    }

    @Override
    public String getServiceURL(int n, Object[] objectArray) {
        if (this.service_exclusions != null && this.service_exclusions.contains(n)) {
            this.debug("Service type '" + n + "' is excluded");
            return null;
        }
        String string = this.service_map.get(n);
        if (string == null) {
            this.debug("Unknown service type '" + n + "'");
            return null;
        }
        switch (n) {
            case 1: {
                String string2 = (String)objectArray[0];
                return string + UrlUtils.encode(string2) + "&" + URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
            }
            case 2: {
                String string3;
                String string4 = (String)objectArray[0];
                boolean bl = (Boolean)objectArray[1];
                String string5 = string + UrlUtils.encode(string4) + "&" + URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
                if (bl) {
                    string5 = string5 + "&createSubscription=1";
                }
                if ((string3 = this.getExtensionKey()) != null) {
                    string5 = string5 + "&extension_key=" + UrlUtils.encode(string3);
                }
                return string5;
            }
            case 11: {
                String string6 = (String)objectArray[0];
                String string7 = (String)objectArray[1];
                String string8 = string + string6 + ".html?" + URL_SUFFIX;
                if (string7 != null) {
                    string8 = string8 + "&client_ref=" + UrlUtils.encode(string7);
                }
                return string8;
            }
            case 32: 
            case 33: {
                String string9 = (String)objectArray[0];
                String string10 = string + string9 + "?" + URL_SUFFIX;
                return string10;
            }
            case 12: {
                String string11 = (String)objectArray[0];
                return string + string11 + ".html?" + URL_SUFFIX + "&rnd=" + Math.random();
            }
            case 13: {
                String string12 = (String)objectArray[0];
                String string13 = (String)objectArray[1];
                return string + UrlUtils.encode(string12) + "?" + URL_SUFFIX + "&client_ref=" + UrlUtils.encode(string13);
            }
            case 14: {
                String string14 = (String)objectArray[0];
                String string15 = (String)objectArray[1];
                String string16 = string + string14 + ".torrent";
                if (string15 != null) {
                    string16 = string16 + "?referal=" + UrlUtils.encode(string15);
                }
                string16 = this.appendURLSuffix(string16, false, true);
                return string16;
            }
            case 18: {
                String string17 = (String)objectArray[0];
                return string + string17;
            }
            case 22: {
                String string18 = (String)objectArray[0];
                if (string18 == null || string18.length() == 0) {
                    string = string + URL_SUFFIX;
                } else {
                    string = string + "msg=" + UrlUtils.encode(string18);
                    string = string + "&" + URL_SUFFIX;
                }
                return string;
            }
            case 25: 
            case 26: {
                string = string + URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
                return string;
            }
            case 27: {
                String string19 = (String)objectArray[0];
                boolean bl = (Boolean)objectArray[1];
                string = string + (string19.startsWith("/") ? string19.substring(1) : string19);
                if (bl) {
                    string = this.appendURLSuffix(string, false, true);
                }
                return string;
            }
            case 37: {
                String string20 = (String)objectArray[0];
                boolean bl = (Boolean)objectArray[1];
                string = string + (string20.startsWith("/") ? string20.substring(1) : string20);
                if (bl) {
                    string = this.appendURLSuffix(string, false, true);
                }
                string = string.replaceAll("&vzemb=1", "");
                return string;
            }
            case 28: {
                String string21 = (String)objectArray[0];
                string = string + "ts=" + Math.random() + "&bg_color=" + string21 + "&" + URL_SUFFIX;
                return string;
            }
            case 29: {
                String string22 = (String)objectArray[0];
                string = string + "subscription=" + string22 + "&" + URL_SUFFIX;
                return string;
            }
            case 31: {
                String string23;
                String string24 = string23 = objectArray.length > 0 ? (String)objectArray[0] : null;
                if (string23 != null) {
                    string = string + "sourceref=" + UrlUtils.encode(string23) + "&" + URL_SUFFIX;
                }
                return string;
            }
            case 8: {
                String string25 = COConfigurationManager.getStringParameter("install.id", "null");
                if (string25.length() == 0) {
                    string25 = "blank";
                }
                string = string + "iid=" + UrlUtils.encode(string25) + "&" + URL_SUFFIX;
                return string;
            }
            case 6: 
            case 7: 
            case 23: 
            case 24: {
                return string + URL_SUFFIX;
            }
            case 35: {
                return string + "azv=" + "4.5.0.4" + "&locale=" + MessageText.getCurrentLocale().toString();
            }
        }
        return this.appendURLSuffix(string, false, true);
    }

    @Override
    public String appendURLSuffix(String string, boolean bl, boolean bl2) {
        if (string.indexOf("vzemb=") != -1) {
            return string;
        }
        String string2 = URL_SUFFIX;
        if (!bl2) {
            string2 = string2.replaceAll("azid=.*?&", "");
        }
        if (bl) {
            if (string.length() == 0) {
                return string2;
            }
            return string + "&" + string2;
        }
        if (string.indexOf("?") >= 0) {
            return string + "&" + string2;
        }
        return string + "?" + string2;
    }

    private String getExtensionKey() {
        FeatureManager.FeatureDetails[] featureDetailsArray;
        FeatureManager featureManager = PluginInitializer.getDefaultInterface().getUtilities().getFeatureManager();
        for (FeatureManager.FeatureDetails featureDetails : featureDetailsArray = featureManager.getFeatureDetails("core")) {
            String string;
            if (featureDetails.hasExpired() || (string = (String)featureDetails.getProperty("Fingerprint")) == null) continue;
            return featureDetails.getLicence().getShortID() + "-" + string;
        }
        return null;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Send Version Info", "locale"}, new ParameterListener(){

            public void parameterChanged(String string) {
                boolean bl = COConfigurationManager.getBooleanParameter("Send Version Info");
                URL_SUFFIX = "azid=" + (bl ? Base32.encode(VuzeCryptoManager.getSingleton().getPlatformAZID()) : "anonymous") + "&azv=" + "4.5.0.4" + "&locale=" + MessageText.getCurrentLocale().toString() + "&os.name=" + UrlUtils.encode(System.getProperty("os.name")) + "&vzemb=1";
                String string2 = System.getProperty("url.suffix", null);
                if (string2 != null) {
                    URL_SUFFIX = URL_SUFFIX + ("&" + string2);
                }
            }
        });
    }
}

