/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceiTunes;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;

public class DeviceiTunesManager {
    private DeviceManagerImpl device_manager;
    private DeviceiTunes itunes_device;

    protected DeviceiTunesManager(DeviceManagerImpl deviceManagerImpl) {
        this.device_manager = deviceManagerImpl;
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore azureusCore) {
                DeviceiTunesManager.this.init(azureusCore);
            }
        });
    }

    private void init(AzureusCore azureusCore) {
        final PluginManager pluginManager = azureusCore.getPluginManager();
        final PluginInterface pluginInterface = pluginManager.getDefaultPluginInterface();
        pluginInterface.addListener(new PluginListener(){

            public void initializationComplete() {
                PluginInterface[] pluginInterfaceArray;
                pluginInterface.addEventListener(new PluginEventListener(){

                    public void handleEvent(PluginEvent pluginEvent) {
                        int n = pluginEvent.getType();
                        if (n == 8) {
                            DeviceiTunesManager.this.pluginAdded((PluginInterface)pluginEvent.getValue());
                        }
                        if (n == 9) {
                            DeviceiTunesManager.this.pluginRemoved((PluginInterface)pluginEvent.getValue());
                        }
                    }
                });
                for (PluginInterface pluginInterface2 : pluginInterfaceArray = pluginManager.getPlugins()) {
                    if (!pluginInterface2.getPluginState().isOperational()) continue;
                    DeviceiTunesManager.this.pluginAdded(pluginInterface2);
                }
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginAdded(PluginInterface pluginInterface) {
        if (pluginInterface.getPluginState().isBuiltIn()) {
            return;
        }
        String string = pluginInterface.getPluginID();
        if (string.equals("azitunes")) {
            DeviceiTunes deviceiTunes;
            DeviceiTunesManager deviceiTunesManager = this;
            synchronized (deviceiTunesManager) {
                if (this.itunes_device != null) {
                    return;
                }
                this.itunes_device = deviceiTunes = new DeviceiTunes(this.device_manager, pluginInterface);
            }
            this.device_manager.addDevice(deviceiTunes, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pluginRemoved(PluginInterface pluginInterface) {
        String string = pluginInterface.getPluginID();
        if (string.equals("azitunes")) {
            DeviceiTunes deviceiTunes;
            DeviceiTunesManager deviceiTunesManager = this;
            synchronized (deviceiTunesManager) {
                if (this.itunes_device == null) {
                    return;
                }
                deviceiTunes = this.itunes_device;
                this.itunes_device = null;
            }
            deviceiTunes.remove();
        }
    }
}

