/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.impl.TranscodePipe;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.HashMap;
import java.util.StringTokenizer;

public class TranscodePipeFileSource
extends TranscodePipe {
    private static final String NL = "\r\n";
    private File source_file;
    private RandomAccessFile raf;
    private int raf_count;

    protected TranscodePipeFileSource(File file, TranscodePipe.errorListener errorListener2) throws IOException {
        super(errorListener2);
        this.source_file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSocket(Socket socket) {
        Object object = this;
        synchronized (object) {
            if (this.destroyed) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            this.sockets.add(socket);
        }
        try {
            Object object2;
            object = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            while (true) {
                String string = "";
                while (!string.endsWith(NL)) {
                    byte[] byArray = new byte[1];
                    inputStream.read(byArray);
                    string = string + new String(byArray);
                }
                if ((string = string.trim()).length() == 0) break;
                if (object == null) {
                    object = string;
                    continue;
                }
                int n = string.indexOf(58);
                if (n == -1) {
                    return;
                }
                String string2 = string.substring(0, n).trim().toLowerCase();
                object2 = string.substring(n + 1).trim();
                hashMap.put(string2, (String)object2);
            }
            boolean bl = false;
            if (!((String)object).startsWith("GET ")) {
                if (((String)object).startsWith("HEAD ")) {
                    bl = true;
                } else {
                    throw new IOException("unsupported method '" + (String)object + "'");
                }
            }
            long l = this.source_file.length();
            if (bl) {
                this.write(outputStream, "HTTP/1.1 200 OK\r\n");
                this.write(outputStream, "Server: Azureus Media Server 1.0\r\n");
                this.write(outputStream, "Accept-Ranges: bytes\r\n");
                this.write(outputStream, "Content-Length: " + l + NL);
                this.write(outputStream, "Content-Range: 0-" + (l - 1L) + "/" + l + NL);
                outputStream.flush();
            } else {
                object2 = (String)hashMap.get("range");
                long l2 = 0L;
                long l3 = 0L;
                boolean bl2 = false;
                if (object2 == null) {
                    this.write(outputStream, "HTTP/1.1 200 OK\r\n");
                    this.write(outputStream, "Server: Azureus Media Server 1.0\r\n");
                    this.write(outputStream, "Connection: close\r\n");
                    this.write(outputStream, "Accept-Ranges: bytes\r\n");
                    this.write(outputStream, "Content-Range: 0-" + (l - 1L) + "/" + l + NL);
                    this.write(outputStream, "Content-Length: " + l + NL + NL);
                    l3 = l;
                    bl2 = true;
                } else {
                    long l4;
                    if (!((String)(object2 = ((String)object2).toLowerCase())).startsWith("bytes=")) {
                        throw new IOException("invalid range: " + (String)object2);
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer((String)(object2 = ((String)object2).substring(6)), ",");
                    if (stringTokenizer.countTokens() != 1) {
                        throw new IOException("invalid range - only single supported: " + (String)object2);
                    }
                    String string = stringTokenizer.nextToken();
                    int n = string.indexOf(45);
                    long l5 = n < string.length() - 1 ? Long.parseLong(string.substring(n + 1)) : l - 1L;
                    if (n > 0) {
                        l4 = Long.parseLong(string.substring(0, n));
                    } else {
                        l4 = l - l5;
                        l5 = l - 1L;
                    }
                    l3 = l5 - l4 + 1L;
                    if (l3 < 0L) {
                        this.write(outputStream, "HTTP/1.1 416 Requested Range Not Satisfiable\r\n\r\n");
                    } else {
                        l2 = l4;
                        this.write(outputStream, "HTTP/1.1 206 Partial content\r\n");
                        this.write(outputStream, "Server: Azureus Media Server 1.0\r\n");
                        this.write(outputStream, "Connection: close\r\n");
                        this.write(outputStream, "Content-Range: bytes " + l4 + "-" + l5 + "/" + l + NL);
                        this.write(outputStream, "Content-Length: " + l3 + NL + NL);
                        bl2 = true;
                    }
                }
                outputStream.flush();
                if (bl2) {
                    this.handleRAF(outputStream, l2, l3);
                }
            }
            object2 = this;
            synchronized (object2) {
                if (this.destroyed) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.sockets.remove(socket);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                socket.close();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            TranscodePipeFileSource transcodePipeFileSource = this;
            synchronized (transcodePipeFileSource) {
                this.sockets.remove(socket);
            }
        }
    }

    protected void write(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RandomAccessFile reserveRAF() throws IOException {
        TranscodePipeFileSource transcodePipeFileSource = this;
        synchronized (transcodePipeFileSource) {
            if (this.destroyed) {
                throw new IOException("destroyed");
            }
            if (this.raf == null) {
                this.raf = new RandomAccessFile(this.source_file, "r");
            }
            ++this.raf_count;
            return this.raf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseRAF(RandomAccessFile randomAccessFile) {
        TranscodePipeFileSource transcodePipeFileSource = this;
        synchronized (transcodePipeFileSource) {
            --this.raf_count;
            if (this.raf_count == 0) {
                try {
                    this.raf.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.raf = null;
            }
        }
    }

    protected boolean destroy() {
        if (super.destroy()) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.raf = null;
            }
            return true;
        }
        return false;
    }
}

