/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.db.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.DHTStorageBlock;
import com.aelitis.azureus.core.dht.DHTStorageKey;
import com.aelitis.azureus.core.dht.DHTStorageKeyStats;
import com.aelitis.azureus.core.dht.control.DHTControl;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.db.DHTDBLookupResult;
import com.aelitis.azureus.core.dht.db.DHTDBStats;
import com.aelitis.azureus.core.dht.db.DHTDBValue;
import com.aelitis.azureus.core.dht.db.impl.DHTDBMapping;
import com.aelitis.azureus.core.dht.db.impl.DHTDBValueImpl;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportQueryStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTDBImpl
implements DHTDB,
DHTDBStats {
    private static final int MAX_VALUE_LIFETIME = 259200000;
    private int original_republish_interval;
    public static int ORIGINAL_REPUBLISH_INTERVAL_GRACE = 3600000;
    private static final boolean ENABLE_PRECIOUS_STUFF = false;
    private static final int PRECIOUS_CHECK_INTERVAL = 0x6DDD00;
    private int cache_republish_interval;
    private long MIN_CACHE_EXPIRY_CHECK_INTERVAL = 60000L;
    private long last_cache_expiry_check;
    private static final long IP_BLOOM_FILTER_REBUILD_PERIOD = 900000L;
    private static final int IP_COUNT_BLOOM_SIZE_INCREASE_CHUNK = 1000;
    private BloomFilter ip_count_bloom_filter = BloomFilterFactory.createAddRemove8Bit(1000);
    private static final int VALUE_VERSION_CHUNK = 128;
    private int next_value_version;
    private int next_value_version_left;
    protected static final int QUERY_STORE_REQUEST_ENTRY_SIZE = 6;
    protected static final int QUERY_STORE_REPLY_ENTRY_SIZE = 2;
    private Map<HashWrapper, DHTDBMapping> stored_values = new HashMap<HashWrapper, DHTDBMapping>();
    private Map<DHTDBMapping.ShortHash, DHTDBMapping> stored_values_prefix_map = new HashMap<DHTDBMapping.ShortHash, DHTDBMapping>();
    private DHTControl control;
    private DHTStorageAdapter adapter;
    private DHTRouter router;
    private DHTTransportContact local_contact;
    private DHTLogger logger;
    private static final long MAX_TOTAL_SIZE = 0x400000L;
    private int total_size;
    private int total_values;
    private int total_keys;
    private int total_local_keys;
    private boolean force_original_republish;
    private IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private AEMonitor this_mon = new AEMonitor("DHTDB");
    private static final boolean DEBUG_SURVEY = false;
    private static final boolean SURVEY_ONLY_RF_KEYS = true;
    private static final int SURVEY_PERIOD = 900000;
    private static final int SURVEY_STATE_INACT_TIMEOUT = 3600000;
    private static final int SURVEY_STATE_MAX_LIFE_TIMEOUT = 12600000;
    private static final int SURVEY_STATE_MAX_LIFE_RAND = 3600000;
    private static final int MAX_SURVEY_SIZE = 100;
    private static final int MAX_SURVEY_STATE_SIZE = 150;
    private final boolean survey_enabled;
    private volatile boolean survey_in_progress;
    private Map<HashWrapper, Long> survey_mapping_times = new HashMap<HashWrapper, Long>();
    private Map<HashWrapper, SurveyContactState> survey_state = new LinkedHashMap<HashWrapper, SurveyContactState>(150, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<HashWrapper, SurveyContactState> entry) {
            return this.size() > 150;
        }
    };

    public DHTDBImpl(DHTStorageAdapter dHTStorageAdapter, int n, int n2, byte by, DHTLogger dHTLogger) {
        this.adapter = dHTStorageAdapter == null ? null : new adapterFacade(dHTStorageAdapter);
        this.original_republish_interval = n;
        this.cache_republish_interval = n2;
        this.logger = dHTLogger;
        this.survey_enabled = by >= 26 && (this.adapter == null || this.adapter.getNetwork() == 1 || FeatureAvailability.isDHTRepV2Enabled());
        SimpleTimer.addPeriodicEvent("DHTDB:op", this.original_republish_interval, true, new TimerEventPerformer(){

            public void perform(TimerEvent timerEvent2) {
                DHTDBImpl.this.logger.log("Republish of original mappings starts");
                long l = SystemTime.getCurrentTime();
                int n = DHTDBImpl.this.republishOriginalMappings();
                long l2 = SystemTime.getCurrentTime();
                DHTDBImpl.this.logger.log("Republish of original mappings completed in " + (l2 - l) + ": " + "values = " + n);
            }
        });
        SimpleTimer.addPeriodicEvent("DHTDB:cp", this.cache_republish_interval + 10000 - (int)(Math.random() * 20000.0), true, new TimerEventPerformer(){

            public void perform(TimerEvent timerEvent2) {
                DHTDBImpl.this.logger.log("Republish of cached mappings starts");
                long l = SystemTime.getCurrentTime();
                int[] nArray = DHTDBImpl.this.republishCachedMappings();
                long l2 = SystemTime.getCurrentTime();
                DHTDBImpl.this.logger.log("Republish of cached mappings completed in " + (l2 - l) + ": " + "values = " + nArray[0] + ", keys = " + nArray[1] + ", ops = " + nArray[2]);
                if (DHTDBImpl.this.force_original_republish) {
                    DHTDBImpl.this.force_original_republish = false;
                    DHTDBImpl.this.logger.log("Force republish of original mappings due to router change starts");
                    l = SystemTime.getCurrentTime();
                    int n = DHTDBImpl.this.republishOriginalMappings();
                    l2 = SystemTime.getCurrentTime();
                    DHTDBImpl.this.logger.log("Force republish of original mappings due to router change completed in " + (l2 - l) + ": " + "values = " + n);
                }
            }
        });
        SimpleTimer.addPeriodicEvent("DHTDB:bloom", 900000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent timerEvent2) {
                try {
                    DHTDBImpl.this.this_mon.enter();
                    DHTDBImpl.this.rebuildIPBloomFilter(false);
                    Object var3_2 = null;
                    DHTDBImpl.this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    DHTDBImpl.this.this_mon.exit();
                    throw throwable;
                }
            }
        });
        if (this.survey_enabled) {
            SimpleTimer.addPeriodicEvent("DHTDB:survey", 900000L, true, new TimerEventPerformer(){

                public void perform(TimerEvent timerEvent2) {
                    DHTDBImpl.this.survey();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setControl(DHTControl dHTControl) {
        this.control = dHTControl;
        this.force_original_republish = this.router != null;
        this.router = this.control.getRouter();
        this.local_contact = this.control.getTransport().getLocalContact();
        try {
            this.this_mon.enter();
            this.survey_state.clear();
            for (DHTDBMapping dHTDBMapping : this.stored_values.values()) {
                dHTDBMapping.updateLocalContact(this.local_contact);
            }
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTDBValue store(HashWrapper hashWrapper, byte[] byArray, byte by, byte by2, byte by3) {
        if ((by & 0x40) == 0) {
            if ((by & 0xFFFFFF80) != 0) {
                Debug.out("Obfuscated puts without 'put-and-forget' are not supported as original-republishing of them is not implemented");
            }
            if (by2 > 0 && by2 * 60 * 60 * 1000 < this.original_republish_interval) {
                Debug.out("Don't put persistent values with a lifetime less than republish period - lifetime over-ridden");
                by2 = 0;
            }
            try {
                this.this_mon.enter();
                ++this.total_local_keys;
                DHTDBMapping dHTDBMapping = this.stored_values.get(hashWrapper);
                if (dHTDBMapping == null) {
                    dHTDBMapping = new DHTDBMapping(this, hashWrapper, true);
                    this.stored_values.put(hashWrapper, dHTDBMapping);
                    this.addToPrefixMap(dHTDBMapping);
                }
                DHTDBValueImpl dHTDBValueImpl = new DHTDBValueImpl(SystemTime.getCurrentTime(), byArray, this.getNextValueVersion(), this.local_contact, this.local_contact, true, by, by2, by3);
                dHTDBMapping.add(dHTDBValueImpl);
                DHTDBValueImpl dHTDBValueImpl2 = dHTDBValueImpl;
                Object var10_10 = null;
                this.this_mon.exit();
                return dHTDBValueImpl2;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        DHTDBValueImpl dHTDBValueImpl = new DHTDBValueImpl(SystemTime.getCurrentTime(), byArray, this.getNextValueVersion(), this.local_contact, this.local_contact, true, by, by2, by3);
        return dHTDBValueImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte store(DHTTransportContact dHTTransportContact, HashWrapper hashWrapper, DHTTransportValue[] dHTTransportValueArray) {
        if ((long)(this.total_size + this.total_values * 4) > 0x400000L) {
            DHTLog.log("Not storing " + DHTLog.getString2(hashWrapper.getHash()) + " as maximum storage limit exceeded");
            return 3;
        }
        try {
            int n;
            this.this_mon.enter();
            this.checkCacheExpiration(false);
            DHTDBMapping dHTDBMapping = this.stored_values.get(hashWrapper);
            if (dHTDBMapping == null) {
                dHTDBMapping = new DHTDBMapping(this, hashWrapper, false);
                this.stored_values.put(hashWrapper, dHTDBMapping);
                this.addToPrefixMap(dHTDBMapping);
            }
            for (n = 0; n < dHTTransportValueArray.length; ++n) {
                DHTTransportValue dHTTransportValue = dHTTransportValueArray[n];
                DHTDBValueImpl dHTDBValueImpl = new DHTDBValueImpl(dHTTransportContact, dHTTransportValue, false);
                dHTDBMapping.add(dHTDBValueImpl);
            }
            n = dHTDBMapping.getDiversificationType();
            Object var9_8 = null;
            this.this_mon.exit();
            return (byte)n;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTDBLookupResult get(DHTTransportContact dHTTransportContact, HashWrapper hashWrapper, int n, byte by, boolean bl) {
        DHTDBMapping dHTDBMapping;
        block4: {
            try {
                this.this_mon.enter();
                this.checkCacheExpiration(false);
                dHTDBMapping = this.stored_values.get(hashWrapper);
                if (dHTDBMapping != null) break block4;
                DHTDBLookupResult dHTDBLookupResult = null;
                Object var10_9 = null;
                this.this_mon.exit();
                return dHTDBLookupResult;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        if (bl) {
            dHTDBMapping.addHit();
        }
        final DHTDBValue[] dHTDBValueArray = dHTDBMapping.get(dHTTransportContact, n, by);
        DHTDBLookupResult dHTDBLookupResult = new DHTDBLookupResult(){

            public DHTDBValue[] getValues() {
                return dHTDBValueArray;
            }

            public byte getDiversificationType() {
                return dHTDBMapping.getDiversificationType();
            }
        };
        Object var10_10 = null;
        this.this_mon.exit();
        return dHTDBLookupResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTDBValue get(HashWrapper hashWrapper) {
        block3: {
            try {
                this.this_mon.enter();
                DHTDBMapping dHTDBMapping = this.stored_values.get(hashWrapper);
                if (dHTDBMapping == null) break block3;
                DHTDBValueImpl dHTDBValueImpl = dHTDBMapping.get(this.local_contact);
                Object var5_5 = null;
                this.this_mon.exit();
                return dHTDBValueImpl;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        DHTDBValue dHTDBValue = null;
        Object var5_6 = null;
        this.this_mon.exit();
        return dHTDBValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(HashWrapper hashWrapper) {
        try {
            this.this_mon.enter();
            boolean bl = this.stored_values.containsKey(hashWrapper);
            Object var4_3 = null;
            this.this_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTDBValue remove(DHTTransportContact dHTTransportContact, HashWrapper hashWrapper) {
        block4: {
            block5: {
                try {
                    this.this_mon.enter();
                    DHTDBMapping dHTDBMapping = this.stored_values.get(hashWrapper);
                    if (dHTDBMapping == null) break block4;
                    DHTDBValueImpl dHTDBValueImpl = dHTDBMapping.remove(dHTTransportContact);
                    if (dHTDBValueImpl == null) break block5;
                    --this.total_local_keys;
                    DHTDBValue dHTDBValue = dHTDBValueImpl.getValueForDeletion(this.getNextValueVersion());
                    Object var7_8 = null;
                    this.this_mon.exit();
                    return dHTDBValue;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            DHTDBValue dHTDBValue = null;
            Object var7_9 = null;
            this.this_mon.exit();
            return dHTDBValue;
        }
        DHTDBValue dHTDBValue = null;
        Object var7_10 = null;
        this.this_mon.exit();
        return dHTDBValue;
    }

    @Override
    public DHTStorageBlock keyBlockRequest(DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2) {
        if (this.adapter == null) {
            return null;
        }
        if (dHTTransportContact != null) {
            byte[] byArray3 = this.adapter.getKeyForKeyBlock(byArray);
            List<DHTTransportContact> list = this.control.getClosestKContactsList(byArray3, true);
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.router.isID(list.get(i).getID())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                DHTLog.log("Not processing key block for  " + DHTLog.getString2(byArray3) + " as key too far away");
                return null;
            }
            if (!this.control.verifyContact(dHTTransportContact, true)) {
                DHTLog.log("Not processing key block for  " + DHTLog.getString2(byArray3) + " as verification failed");
                return null;
            }
        }
        return this.adapter.keyBlockRequest(dHTTransportContact, byArray, byArray2);
    }

    @Override
    public DHTStorageBlock getKeyBlockDetails(byte[] byArray) {
        if (this.adapter == null) {
            return null;
        }
        return this.adapter.getKeyBlockDetails(byArray);
    }

    @Override
    public boolean isKeyBlocked(byte[] byArray) {
        return this.getKeyBlockDetails(byArray) != null;
    }

    @Override
    public DHTStorageBlock[] getDirectKeyBlocks() {
        if (this.adapter == null) {
            return new DHTStorageBlock[0];
        }
        return this.adapter.getDirectKeyBlocks();
    }

    @Override
    public boolean isEmpty() {
        return this.total_keys == 0;
    }

    @Override
    public int getKeyCount() {
        return this.total_keys;
    }

    @Override
    public int getLocalKeyCount() {
        return this.total_local_keys;
    }

    @Override
    public int getValueCount() {
        return this.total_values;
    }

    @Override
    public int getSize() {
        return this.total_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getValueDetails() {
        try {
            this.this_mon.enter();
            int[] nArray = new int[6];
            for (DHTDBMapping object2 : this.stored_values.values()) {
                nArray[0] = nArray[0] + object2.getValueCount();
                nArray[1] = nArray[1] + object2.getLocalSize();
                nArray[2] = nArray[2] + object2.getDirectSize();
                nArray[3] = nArray[3] + object2.getIndirectSize();
                byte by = object2.getDiversificationType();
                if (by == 2) {
                    nArray[4] = nArray[4] + 1;
                    continue;
                }
                if (by != 3) continue;
                nArray[5] = nArray[5] + 1;
            }
            int[] nArray2 = nArray;
            Object var6_6 = null;
            this.this_mon.exit();
            return nArray2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    @Override
    public int getKeyBlockCount() {
        if (this.adapter == null) {
            return 0;
        }
        return this.adapter.getDirectKeyBlocks().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<HashWrapper> getKeys() {
        try {
            this.this_mon.enter();
            Iterator<HashWrapper> iterator = new ArrayList<HashWrapper>(this.stored_values.keySet()).iterator();
            Object var3_2 = null;
            this.this_mon.exit();
            return iterator;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int republishOriginalMappings() {
        Object object;
        HashWrapper hashWrapper;
        int n = 0;
        HashMap hashMap = new HashMap();
        try {
            this.this_mon.enter();
            for (Map.Entry<HashWrapper, DHTDBMapping> entry : this.stored_values.entrySet()) {
                hashWrapper = entry.getKey();
                object = entry.getValue();
                Iterator<DHTDBValueImpl> iterator = ((DHTDBMapping)object).getValues();
                ArrayList<DHTDBValueImpl> arrayList = new ArrayList<DHTDBValueImpl>();
                while (iterator.hasNext()) {
                    DHTDBValueImpl dHTDBValueImpl = iterator.next();
                    if (dHTDBValueImpl == null || !dHTDBValueImpl.isLocal()) continue;
                    dHTDBValueImpl.setCreationTime();
                    arrayList.add(dHTDBValueImpl);
                }
                if (arrayList.size() <= 0) continue;
                hashMap.put(hashWrapper, arrayList);
            }
            Object var11_13 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (Map.Entry<HashWrapper, DHTDBMapping> entry : hashMap.entrySet()) {
            hashWrapper = entry.getKey();
            object = (List)((Object)entry.getValue());
            for (int i = 0; i < object.size(); ++i) {
                ++n;
                this.control.putEncodedKey(hashWrapper.getHash(), "Republish", (DHTTransportValue)object.get(i), 0L, true);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected int[] republishCachedMappings() {
        int n;
        Object object;
        Runnable runnable;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.router.refreshIdleLeaves(this.cache_republish_interval);
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList();
        long l = System.currentTimeMillis();
        try {
            this.this_mon.enter();
            this.checkCacheExpiration(true);
            for (Map.Entry<HashWrapper, DHTDBMapping> object7 : this.stored_values.entrySet()) {
                HashWrapper hashWrapper = object7.getKey();
                object5 = object7.getValue();
                if (((DHTDBMapping)object5).getDiversificationType() != 1) continue;
                object4 = ((DHTDBMapping)object5).getValues();
                boolean bl = object4.hasNext();
                ArrayList<DHTDBValueImpl> arrayList2 = new ArrayList<DHTDBValueImpl>();
                while (object4.hasNext()) {
                    DHTDBValueImpl dHTDBValueImpl = object4.next();
                    if (dHTDBValueImpl.isLocal()) {
                        bl = false;
                        continue;
                    }
                    if (dHTDBValueImpl.getReplicationFactor() == -1) {
                        bl = false;
                    }
                    if (l < dHTDBValueImpl.getStoreTime()) {
                        dHTDBValueImpl.setStoreTime(l);
                        continue;
                    }
                    if (l - dHTDBValueImpl.getStoreTime() <= (long)this.cache_republish_interval) continue;
                    arrayList2.add(dHTDBValueImpl);
                }
                if (bl) {
                    arrayList2.clear();
                    arrayList.add(object5);
                }
                if (arrayList2.size() <= 0) continue;
                hashMap.put(hashWrapper, arrayList2);
            }
            object3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var14_33 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (arrayList.size() > 0) {
            object2 = new ArrayList();
            for (DHTDBMapping dHTDBMapping : arrayList) {
                object5 = dHTDBMapping.getKey();
                object4 = ((HashWrapper)object5).getHash();
                List<DHTTransportContact> list = this.control.getClosestKContactsList((byte[])object4, false);
                boolean bl = false;
                for (int i = 0; i < list.size(); ++i) {
                    if (!this.router.isID(list.get(i).getID())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                DHTLog.log("Dropping cache entry for " + DHTLog.getString((byte[])object4) + " as now too far away");
                object2.add(object5);
            }
            if (object2.size() > 0) {
                try {
                    void var6_8;
                    this.this_mon.enter();
                    boolean nArray = false;
                    while (var6_8 < object2.size()) {
                        DHTDBMapping dHTDBMapping = this.stored_values.remove(object2.get((int)var6_8));
                        if (dHTDBMapping != null) {
                            this.removeFromPrefixMap(dHTDBMapping);
                            dHTDBMapping.destroy();
                        }
                        ++var6_8;
                    }
                    runnable = null;
                    this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var16_39 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
        }
        object2 = new int[]{0};
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        object5 = new HashSet();
        if (hashMap.size() > 0) {
            object4 = hashMap.entrySet().iterator();
            ArrayList<Object[]> arrayList3 = new ArrayList<Object[]>();
            HashMap<HashWrapper, Object[]> hashMap2 = new HashMap<HashWrapper, Object[]>();
            while (object4.hasNext()) {
                int n2;
                Map.Entry entry = (Map.Entry)object4.next();
                Object[] objectArray = (Object[])entry.getKey();
                object3 = objectArray.getHash();
                object = this.control.getClosestKContactsList((byte[])object3, false);
                boolean bl = false;
                for (n2 = 0; n2 < object.size(); ++n2) {
                    if (!this.router.isID(((DHTTransportContact)object.get(n2)).getID())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    DHTLog.log("Dropping cache entry for " + DHTLog.getString((byte[])object3) + " as now too far away");
                    arrayList3.add(objectArray);
                }
                for (n2 = 0; n2 < object.size(); ++n2) {
                    DHTTransportContact dHTTransportContact = (DHTTransportContact)object.get(n2);
                    if (this.router.isID(dHTTransportContact.getID())) continue;
                    Object[] objectArray2 = (Object[])hashMap2.get(new HashWrapper(dHTTransportContact.getID()));
                    if (objectArray2 == null) {
                        objectArray2 = new Object[]{dHTTransportContact, new ArrayList()};
                        hashMap2.put(new HashWrapper(dHTTransportContact.getID()), objectArray2);
                    }
                    ((List)objectArray2[1]).add(objectArray);
                }
            }
            for (Object[] objectArray : hashMap2.values()) {
                object3 = (DHTTransportContact)objectArray[0];
                object = new AESemaphore("DHTDB:cacheForward");
                object3.sendFindNode(new DHTTransportReplyHandlerAdapter((HashSet)object5, objectArray, nArray, hashMap, (int[])object2, (DHTTransportContact)object3, nArray2, (AESemaphore)object){
                    final /* synthetic */ HashSet val$anti_spoof_done;
                    final /* synthetic */ Object[] val$data;
                    final /* synthetic */ int[] val$keys_published;
                    final /* synthetic */ Map val$republish;
                    final /* synthetic */ int[] val$values_published;
                    final /* synthetic */ DHTTransportContact val$contact;
                    final /* synthetic */ int[] val$republish_ops;
                    final /* synthetic */ AESemaphore val$sem;
                    {
                        this.val$anti_spoof_done = hashSet;
                        this.val$data = objectArray;
                        this.val$keys_published = nArray;
                        this.val$republish = map;
                        this.val$values_published = nArray2;
                        this.val$contact = dHTTransportContact;
                        this.val$republish_ops = nArray3;
                        this.val$sem = aESemaphore;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void findNodeReply(DHTTransportContact dHTTransportContact, DHTTransportContact[] dHTTransportContactArray) {
                        this.val$anti_spoof_done.add(dHTTransportContact);
                        try {
                            List list = (List)this.val$data[1];
                            byte[][] byArrayArray = new byte[list.size()][];
                            DHTTransportValue[][] dHTTransportValueArray = new DHTTransportValue[byArrayArray.length][];
                            this.val$keys_published[0] = this.val$keys_published[0] + byArrayArray.length;
                            for (int i = 0; i < byArrayArray.length; ++i) {
                                HashWrapper hashWrapper = (HashWrapper)list.get(i);
                                byArrayArray[i] = hashWrapper.getHash();
                                List list2 = (List)this.val$republish.get(hashWrapper);
                                dHTTransportValueArray[i] = new DHTTransportValue[list2.size()];
                                this.val$values_published[0] = this.val$values_published[0] + dHTTransportValueArray[i].length;
                                for (int j = 0; j < list2.size(); ++j) {
                                    DHTDBValueImpl dHTDBValueImpl = (DHTDBValueImpl)list2.get(j);
                                    dHTTransportValueArray[i][j] = dHTDBValueImpl.getValueForRelay(DHTDBImpl.this.local_contact);
                                }
                            }
                            ArrayList<DHTTransportContact> arrayList = new ArrayList<DHTTransportContact>();
                            arrayList.add(this.val$contact);
                            this.val$republish_ops[0] = this.val$republish_ops[0] + 1;
                            DHTDBImpl.this.control.putDirectEncodedKeys(byArrayArray, "Republish cache", dHTTransportValueArray, arrayList);
                            Object var12_12 = null;
                            this.val$sem.release();
                        }
                        catch (Throwable throwable) {
                            Object var12_13 = null;
                            this.val$sem.release();
                            throw throwable;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                        try {
                            DHTLog.log("cacheForward: pre-store findNode failed " + DHTLog.getString(dHTTransportContact) + " -> failed: " + throwable.getMessage());
                            DHTDBImpl.this.router.contactDead(dHTTransportContact.getID(), false);
                            Object var4_3 = null;
                            this.val$sem.release();
                        }
                        catch (Throwable throwable2) {
                            Object var4_4 = null;
                            this.val$sem.release();
                            throw throwable2;
                        }
                    }
                }, object3.getProtocolVersion() >= 8 ? new byte[]{} : new byte[20]);
                ((AESemaphore)object).reserve();
            }
            try {
                this.this_mon.enter();
                for (n = 0; n < arrayList3.size(); ++n) {
                    object3 = this.stored_values.remove(arrayList3.get(n));
                    if (object3 == null) continue;
                    this.removeFromPrefixMap((DHTDBMapping)object3);
                    ((DHTDBMapping)object3).destroy();
                }
                Object var21_46 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var21_47 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        if (((DHTStorageBlock[])(object4 = this.getDirectKeyBlocks())).length > 0) {
            for (int i = 0; i < ((DHTStorageBlock[])object4).length; ++i) {
                int n3;
                Object object6 = object4[i];
                List<DHTTransportContact> list = this.control.getClosestKContactsList(object6.getKey(), false);
                n = 0;
                for (n3 = 0; n3 < list.size(); ++n3) {
                    object = list.get(n3);
                    if (!this.router.isID(object.getID())) continue;
                    n = 1;
                    break;
                }
                for (n3 = 0; n != 0 && n3 < list.size(); ++n3) {
                    object = list.get(n3);
                    if (object6.hasBeenSentTo((DHTTransportContact)object) || this.router.isID(object.getID()) || object.getProtocolVersion() < 14) continue;
                    runnable = new Runnable((DHTTransportContact)object, (DHTStorageBlock)object6){
                        final /* synthetic */ DHTTransportContact val$contact;
                        final /* synthetic */ DHTStorageBlock val$key_block;
                        {
                            this.val$contact = dHTTransportContact;
                            this.val$key_block = dHTStorageBlock;
                        }

                        public void run() {
                            this.val$contact.sendKeyBlock(new DHTTransportReplyHandlerAdapter(){

                                public void keyBlockReply(DHTTransportContact dHTTransportContact) {
                                    DHTLog.log("key block forward ok " + DHTLog.getString(dHTTransportContact));
                                    val$key_block.sentTo(dHTTransportContact);
                                }

                                public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                                    DHTLog.log("key block forward failed " + DHTLog.getString(dHTTransportContact) + " -> failed: " + throwable.getMessage());
                                }
                            }, this.val$key_block.getRequest(), this.val$key_block.getCertificate());
                        }
                    };
                    if (((HashSet)object5).contains(object)) {
                        runnable.run();
                        continue;
                    }
                    object.sendFindNode(new DHTTransportReplyHandlerAdapter(){

                        public void findNodeReply(DHTTransportContact dHTTransportContact, DHTTransportContact[] dHTTransportContactArray) {
                            runnable.run();
                        }

                        public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                            DHTLog.log("pre-kb findNode failed " + DHTLog.getString(dHTTransportContact) + " -> failed: " + throwable.getMessage());
                            DHTDBImpl.this.router.contactDead(dHTTransportContact.getID(), false);
                        }
                    }, object.getProtocolVersion() >= 8 ? new byte[]{} : new byte[20]);
                }
            }
        }
        return new int[]{(int)object2[0], nArray[0], nArray2[0]};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCacheExpiration(boolean bl) {
        long l;
        long l2 = SystemTime.getCurrentTime();
        if (!bl && (l = l2 - this.last_cache_expiry_check) > 0L && l < this.MIN_CACHE_EXPIRY_CHECK_INTERVAL) {
            return;
        }
        try {
            this.this_mon.enter();
            this.last_cache_expiry_check = l2;
            Iterator<DHTDBMapping> iterator = this.stored_values.values().iterator();
            while (iterator.hasNext()) {
                DHTDBMapping dHTDBMapping = iterator.next();
                if (dHTDBMapping.getValueCount() == 0) {
                    iterator.remove();
                    this.removeFromPrefixMap(dHTDBMapping);
                    dHTDBMapping.destroy();
                    continue;
                }
                Iterator<DHTDBValueImpl> iterator2 = dHTDBMapping.getValues();
                while (iterator2.hasNext()) {
                    int n;
                    DHTDBValueImpl dHTDBValueImpl = iterator2.next();
                    if (dHTDBValueImpl.isLocal()) continue;
                    int n2 = dHTDBValueImpl.getLifeTimeHours();
                    if (n2 < 1) {
                        n = this.original_republish_interval;
                    } else {
                        n = n2 * 60 * 60 * 1000;
                        if (n > 259200000) {
                            n = 259200000;
                        }
                    }
                    int n3 = (dHTDBValueImpl.getFlags() & 0x40) != 0 ? 0 : Math.min(ORIGINAL_REPUBLISH_INTERVAL_GRACE, n / 4);
                    if (l2 <= dHTDBValueImpl.getCreationTime() + (long)n + (long)n3) continue;
                    DHTLog.log("removing cache entry (" + dHTDBValueImpl.getString() + ")");
                    iterator2.remove();
                }
            }
            Object var12_11 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void addToPrefixMap(DHTDBMapping dHTDBMapping) {
        byte[] byArray;
        byte[] byArray2;
        DHTDBMapping.ShortHash shortHash = dHTDBMapping.getShortKey();
        DHTDBMapping dHTDBMapping2 = this.stored_values_prefix_map.get(shortHash);
        if (dHTDBMapping2 != null && this.control.computeAndCompareDistances(byArray2 = dHTDBMapping2.getKey().getBytes(), byArray = dHTDBMapping.getKey().getBytes(), this.local_contact.getID()) < 0) {
            return;
        }
        this.stored_values_prefix_map.put(shortHash, dHTDBMapping);
        if (this.stored_values_prefix_map.size() > this.stored_values.size()) {
            Debug.out("inconsistent");
        }
    }

    protected void removeFromPrefixMap(DHTDBMapping dHTDBMapping) {
        DHTDBMapping.ShortHash shortHash = dHTDBMapping.getShortKey();
        DHTDBMapping dHTDBMapping2 = this.stored_values_prefix_map.get(shortHash);
        if (dHTDBMapping2 == dHTDBMapping) {
            this.stored_values_prefix_map.remove(shortHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPreciousStuff() {
        Object object;
        HashWrapper hashWrapper;
        long l = SystemTime.getCurrentTime();
        HashMap hashMap = new HashMap();
        try {
            this.this_mon.enter();
            for (Map.Entry<HashWrapper, DHTDBMapping> entry : this.stored_values.entrySet()) {
                hashWrapper = entry.getKey();
                object = entry.getValue();
                Iterator<DHTDBValueImpl> iterator = ((DHTDBMapping)object).getValues();
                ArrayList<DHTDBValueImpl> arrayList = new ArrayList<DHTDBValueImpl>();
                while (iterator.hasNext()) {
                    DHTDBValueImpl dHTDBValueImpl = iterator.next();
                    if (!dHTDBValueImpl.isLocal() || (dHTDBValueImpl.getFlags() | 0x20) == 0 || l - dHTDBValueImpl.getCreationTime() <= 0x6DDD00L) continue;
                    dHTDBValueImpl.setCreationTime();
                    arrayList.add(dHTDBValueImpl);
                }
                if (arrayList.size() <= 0) continue;
                hashMap.put(hashWrapper, arrayList);
            }
            Object var12_13 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (Map.Entry<HashWrapper, DHTDBMapping> entry : hashMap.entrySet()) {
            hashWrapper = entry.getKey();
            object = (List)((Object)entry.getValue());
            for (int i = 0; i < object.size(); ++i) {
                this.control.putEncodedKey(hashWrapper.getHash(), "Precious republish", (DHTTransportValue)object.get(i), 0L, true);
            }
        }
    }

    protected DHTTransportContact getLocalContact() {
        return this.local_contact;
    }

    protected DHTStorageAdapter getAdapter() {
        return this.adapter;
    }

    protected void log(String string) {
        this.logger.log(string);
    }

    @Override
    public DHTDBStats getStats() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void survey() {
        block11: {
            Object object;
            if (this.survey_in_progress) {
                return;
            }
            this.checkCacheExpiration(false);
            final byte[] byArray = this.router.getID();
            final ByteArrayHashMap<DHTTransportContact> byteArrayHashMap = new ByteArrayHashMap<DHTTransportContact>();
            List<DHTTransportContact> list = this.control.getClosestContactsList(byArray, this.router.getK() * 3, true);
            for (DHTTransportContact object22 : list) {
                byteArrayHashMap.put(object22.getID(), object22);
            }
            Object object3 = byArray;
            Object var5_6 = null;
            final ArrayList<HashWrapper> arrayList = new ArrayList<HashWrapper>();
            try {
                this.this_mon.enter();
                long l = SystemTime.getMonotonousTime();
                object = this.survey_state.values().iterator();
                while (object.hasNext()) {
                    if (!object.next().timeout(l)) continue;
                    object.remove();
                }
                Iterator<DHTDBMapping> iterator = this.stored_values.values().iterator();
                HashSet<HashWrapper> hashSet = new HashSet<HashWrapper>(this.survey_mapping_times.keySet());
                while (iterator.hasNext()) {
                    void var5_7;
                    DHTDBMapping dHTDBMapping = iterator.next();
                    HashWrapper hashWrapper = dHTDBMapping.getKey();
                    if (hashSet.size() > 0) {
                        hashSet.remove(hashWrapper);
                    }
                    if (!this.applyRF(dHTDBMapping)) continue;
                    arrayList.add(hashWrapper);
                    byte[] byArray2 = hashWrapper.getBytes();
                    byte[] byArray3 = this.control.computeDistance(byArray, byArray2);
                    if (var5_7 != null && this.control.compareDistances(byArray3, (byte[])var5_7) <= 0) continue;
                    byte[] byArray4 = byArray3;
                    object3 = byArray2;
                }
                for (HashWrapper hashWrapper : hashSet) {
                    this.survey_mapping_times.remove(hashWrapper);
                }
                this.logger.log("Survey starts: state size=" + this.survey_state.size() + ", all keys=" + this.stored_values.size() + ", applicable keys=" + arrayList.size());
                Object var17_20 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                this.this_mon.exit();
                throw throwable;
            }
            if (object3 == byArray) {
                this.logger.log("Survey complete - no applicable values");
                return;
            }
            byte[] byArray5 = this.control.getObfuscatedKey((byte[])object3);
            final int[] nArray = new int[]{0};
            object = new boolean[]{false};
            try {
                this.survey_in_progress = true;
                this.control.lookupEncoded(byArray5, "Neighbourhood survey: basic", 0L, true, new DHTOperationAdapter((boolean[])object){
                    private List<DHTTransportContact> contacts = new ArrayList<DHTTransportContact>();
                    private boolean survey_complete;
                    final /* synthetic */ boolean[] val$processing;
                    {
                        this.val$processing = blArray;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void found(DHTTransportContact dHTTransportContact, boolean bl) {
                        if (bl) {
                            List<DHTTransportContact> list = this.contacts;
                            synchronized (list) {
                                if (!this.survey_complete) {
                                    this.contacts.add(dHTTransportContact);
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void complete(boolean bl) {
                        block16: {
                            List<DHTTransportContact> list;
                            boolean bl2 = false;
                            try {
                                int n = 0;
                                int n2 = 0;
                                byte[] byArray5 = null;
                                byte[] byArray2 = null;
                                List<DHTTransportContact> list2 = this.contacts;
                                synchronized (list2) {
                                    for (DHTTransportContact dHTTransportContact : this.contacts) {
                                        byte[] byArray3 = dHTTransportContact.getID();
                                        if (byteArrayHashMap.containsKey(byArray3)) {
                                            ++n;
                                            continue;
                                        }
                                        ++n2;
                                        if (byteArrayHashMap.size() >= 100) {
                                            DHTDBImpl.this.log("Max survery size exceeded");
                                            break;
                                        }
                                        byteArrayHashMap.put(byArray3, dHTTransportContact);
                                        byte[] byArray4 = DHTDBImpl.this.control.computeDistance(byArray, byArray3);
                                        if (byArray5 != null && DHTDBImpl.this.control.compareDistances(byArray4, byArray5) >= 0) continue;
                                        byArray5 = byArray4;
                                        byArray2 = byArray3;
                                    }
                                    this.contacts.clear();
                                }
                                if (n2 > 0 && n2 * 100 / (n + n2) >= 25 && byteArrayHashMap.size() < 100) {
                                    int n3 = nArray[0];
                                    nArray[0] = n3 + 1;
                                    if (n3 < 5) {
                                        DHTDBImpl.this.control.lookupEncoded(byArray2, "Neighbourhood survey: level=" + nArray[0], 0L, true, this);
                                        bl2 = true;
                                    }
                                }
                                Object var14_13 = null;
                                if (bl2) break block16;
                                list = this.contacts;
                            }
                            catch (Throwable throwable) {
                                Object var14_14 = null;
                                if (!bl2) {
                                    List<DHTTransportContact> list3 = this.contacts;
                                    synchronized (list3) {
                                        this.survey_complete = true;
                                    }
                                    DHTDBImpl.this.processSurvey(byArray, arrayList, byteArrayHashMap);
                                    this.val$processing[0] = true;
                                }
                                throw throwable;
                            }
                            synchronized (list) {
                                this.survey_complete = true;
                            }
                            DHTDBImpl.this.processSurvey(byArray, arrayList, byteArrayHashMap);
                            this.val$processing[0] = true;
                            {
                            }
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                if (object[0] != false) break block11;
                this.logger.log("Survey complete - no applicable nodes");
                this.survey_in_progress = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSurvey(byte[] byArray, List<HashWrapper> list, ByteArrayHashMap<DHTTransportContact> byteArrayHashMap) {
        boolean bl = false;
        try {
            Object object;
            byte[][] byArrayArray = new byte[byteArrayHashMap.size()][];
            int n = 0;
            for (byte[] object22 : byteArrayHashMap.keys()) {
                byArrayArray[n++] = object22;
            }
            ByteArrayHashMap byteArrayHashMap2 = new ByteArrayHashMap();
            HashMap hashMap = new HashMap();
            HashMap<DHTDBMapping, List<DHTTransportContact>> hashMap2 = new HashMap<DHTDBMapping, List<DHTTransportContact>>();
            int n2 = Math.min(byArrayArray.length, this.router.getK());
            try {
                List<Object> list2;
                Object object2;
                this.this_mon.enter();
                object = list.iterator();
                int hashMap22 = 0;
                while (object.hasNext()) {
                    Object i = this.stored_values.get(object.next());
                    if (i == null) continue;
                    ++hashMap22;
                    final byte[] byArray2 = ((DHTDBMapping)i).getKey().getBytes();
                    Arrays.sort(byArrayArray, new Comparator<byte[]>(){

                        @Override
                        public int compare(byte[] byArray, byte[] byArray22) {
                            return DHTDBImpl.this.control.computeAndCompareDistances(byArray, byArray22, byArray2);
                        }
                    });
                    int n3 = 0;
                    for (int arrayList = 0; arrayList < n2; ++arrayList) {
                        byte[] i2 = byArrayArray[arrayList];
                        if (!Arrays.equals(byArray, i2)) continue;
                        n3 = 1;
                        break;
                    }
                    if (n3 == 0) continue;
                    ArrayList<DHTTransportContact> byArray4 = new ArrayList<DHTTransportContact>(n2);
                    hashMap2.put((DHTDBMapping)i, (List<DHTTransportContact>)byArray4);
                    for (int j = 0; j < n2; ++j) {
                        object2 = byArrayArray[j];
                        if (Arrays.equals(byArray, (byte[])object2)) continue;
                        list2 = (List)byteArrayHashMap2.get((byte[])object2);
                        if (list2 == null) {
                            list2 = new ArrayList<Object>();
                            byteArrayHashMap2.put((byte[])object2, list2);
                        }
                        list2.add(i);
                        byArray4.add(byteArrayHashMap.get((byte[])object2));
                    }
                }
                for (byte[] byArray3 : byArrayArray) {
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    object2 = (List)byteArrayHashMap2.remove(byArray3);
                    list2 = new ByteArrayHashMap<List>();
                    if (object2 == null) continue;
                    ((ByteArrayHashMap)((Object)list2)).put(new byte[0], object2);
                    for (int i = 0; i < 3; ++i) {
                        List<byte[]> list3 = ((ByteArrayHashMap)((Object)list2)).keys();
                        object6 = list3.iterator();
                        while (object6.hasNext()) {
                            ArrayList<Object> arrayList;
                            byte[] byArray4;
                            Object object7;
                            Object object8;
                            object5 = (byte[])object6.next();
                            if (((Object)object5).length != i || (object4 = (Object)((List)((ByteArrayHashMap)((Object)list2)).get((byte[])object5))).size() < 2) continue;
                            object3 = new ByteArrayHashMap();
                            Object object9 = object4.iterator();
                            while (object9.hasNext()) {
                                object8 = (DHTDBMapping)object9.next();
                                object7 = ((DHTDBMapping)object8).getKey().getBytes();
                                byArray4 = new byte[i + 1];
                                System.arraycopy(object7, 0, byArray4, 0, i + 1);
                                arrayList = (List)((ByteArrayHashMap)object3).get(byArray4);
                                if (arrayList == null) {
                                    arrayList = new ArrayList<Object>();
                                    ((ByteArrayHashMap)object3).put(byArray4, arrayList);
                                }
                                arrayList.add(object8);
                            }
                            object9 = new ArrayList(object4.size());
                            object8 = ((ByteArrayHashMap)object3).keys();
                            object7 = object8.iterator();
                            while (object7.hasNext()) {
                                int n4;
                                byArray4 = (byte[])object7.next();
                                arrayList = (ArrayList<Object>)((ByteArrayHashMap)object3).get(byArray4);
                                int n5 = arrayList.size();
                                int n6 = i + 4 + n5 * (6 - i - 1);
                                if (n6 < (n4 = n5 * (6 - i))) {
                                    ((ByteArrayHashMap)((Object)list2)).put(byArray4, arrayList);
                                    continue;
                                }
                                object9.addAll(arrayList);
                            }
                            if (object9.size() == 0) {
                                ((ByteArrayHashMap)((Object)list2)).remove((byte[])object5);
                                continue;
                            }
                            ((ByteArrayHashMap)((Object)list2)).put((byte[])object5, (Object)object9);
                        }
                    }
                    String i = "";
                    int list3 = 1;
                    object6 = ((ByteArrayHashMap)((Object)list2)).keys();
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        object4 = (byte[])object5.next();
                        list3 += 3 + ((byte[])object4).length;
                        object3 = (List)((ByteArrayHashMap)((Object)list2)).get((byte[])object4);
                        list3 += (6 - ((Object)object4).length) * object3.size();
                        i = i + (i.length() == 0 ? "" : ", ") + ByteFormatter.encodeString((byte[])object4) + "->" + object3.size();
                    }
                    if (object6.size() <= 0) continue;
                    hashMap.put(byteArrayHashMap.get(byArray3), list2);
                }
                Object var35_43 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var35_44 = null;
                this.this_mon.exit();
                throw throwable;
            }
            object = new LinkedList(hashMap.entrySet());
            HashMap<DHTTransportContact, Object[]> hashMap3 = new HashMap<DHTTransportContact, Object[]>();
            for (int i = 0; i < Math.min(3, ((LinkedList)object).size()); ++i) {
                bl = true;
                this.doQuery(byArray, hashMap.size(), hashMap2, (LinkedList<Map.Entry<DHTTransportContact, ByteArrayHashMap<List<DHTDBMapping>>>>)object, hashMap3, null, null, null);
            }
            Object var37_46 = null;
            if (!bl) {
                this.logger.log("Survey complete - no applicable queries");
                this.survey_in_progress = false;
            }
        }
        catch (Throwable throwable) {
            Object var37_47 = null;
            if (!bl) {
                this.logger.log("Survey complete - no applicable queries");
                this.survey_in_progress = false;
            }
            throw throwable;
        }
    }

    protected boolean applyRF(DHTDBMapping dHTDBMapping) {
        Object object;
        if (dHTDBMapping.getDiversificationType() != 1) {
            return false;
        }
        Iterator<DHTDBValueImpl> iterator = dHTDBMapping.getValues();
        if (!iterator.hasNext()) {
            return false;
        }
        int n = Integer.MAX_VALUE;
        long l = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            object = iterator.next();
            byte by = ((DHTDBValueImpl)object).getReplicationFactor();
            if (by == -1 || by == 0) {
                return false;
            }
            int n2 = ((DHTDBValueImpl)object).getReplicationFrequencyHours() & 0xFF;
            if (n2 < n) {
                n = n2;
            }
            l = Math.min(l, ((DHTDBValueImpl)object).getCreationTime());
        }
        if (n > 0) {
            long l2;
            object = dHTDBMapping.getKey();
            Long l3 = this.survey_mapping_times.get(object);
            long l4 = SystemTime.getMonotonousTime();
            if (l3 != null && l3 > l4) {
                return false;
            }
            long l5 = n * 60 * 60 * 1000;
            long l6 = (SystemTime.getCurrentTime() - l) % l5;
            long l7 = l4 - l6 + l5 + (l2 = (long)(RandomUtils.nextInt(1800000) - 900000));
            if (l7 < l4 + 1800000L) {
                l7 += l5;
            }
            this.survey_mapping_times.put((HashWrapper)object, l7);
            if (l3 == null) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doQuery(final byte[] byArray, final int n, final Map<DHTDBMapping, List<DHTTransportContact>> map, final LinkedList<Map.Entry<DHTTransportContact, ByteArrayHashMap<List<DHTDBMapping>>>> linkedList, final Map<DHTTransportContact, Object[]> map2, DHTTransportContact dHTTransportContact, List<DHTDBMapping> list, List<byte[]> list2) {
        block17: {
            List<byte[]> list3;
            ByteArrayHashMap<List<DHTDBMapping>> byteArrayHashMap;
            ArrayList<DHTDBMapping> arrayList;
            Map.Entry<DHTTransportContact, ByteArrayHashMap<List<DHTDBMapping>>> entry;
            Object object = linkedList;
            synchronized (object) {
                if (dHTTransportContact != null) {
                    map2.put(dHTTransportContact, new Object[]{list, list2});
                }
                if (linkedList.size() == 0) {
                    if (map2.size() == n) {
                        this.queriesComplete(byArray, map, map2);
                    }
                    return;
                }
                entry = linkedList.removeFirst();
            }
            object = entry.getKey();
            boolean bl = false;
            try {
                if (object.getProtocolVersion() >= 26) {
                    final ArrayList<DHTDBMapping> arrayList2 = new ArrayList<DHTDBMapping>();
                    ByteArrayHashMap<List<DHTDBMapping>> byteArrayHashMap2 = entry.getValue();
                    List<byte[]> list4 = byteArrayHashMap2.keys();
                    ArrayList<Object[]> arrayList3 = new ArrayList<Object[]>(list4.size());
                    try {
                        this.this_mon.enter();
                        SurveyContactState surveyContactState = this.survey_state.get(new HashWrapper(object.getID()));
                        for (byte[] byArray2 : list4) {
                            int n2 = byArray2.length;
                            int n3 = 6 - n2;
                            List<DHTDBMapping> list5 = byteArrayHashMap2.get(byArray2);
                            ArrayList<byte[]> arrayList4 = new ArrayList<byte[]>(list5.size());
                            arrayList3.add(new Object[]{byArray2, arrayList4});
                            for (DHTDBMapping dHTDBMapping : list5) {
                                if (surveyContactState != null && surveyContactState.testMapping(dHTDBMapping)) continue;
                                arrayList2.add(dHTDBMapping);
                                byte[] byArray3 = dHTDBMapping.getKey().getBytes();
                                byte[] byArray4 = new byte[n3];
                                System.arraycopy(byArray3, n2, byArray4, 0, n3);
                                arrayList4.add(byArray4);
                            }
                        }
                        if (object.getID().equals(byArray)) {
                            Debug.out("inconsistent - we shouldn't query ourselves!");
                        }
                        object.sendQueryStore(new DHTTransportReplyHandlerAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void queryStoreReply(DHTTransportContact dHTTransportContact, List<byte[]> list) {
                                try {
                                    Object var4_3 = null;
                                    DHTDBImpl.this.doQuery(byArray, n, map, linkedList, map2, dHTTransportContact, arrayList2, list);
                                }
                                catch (Throwable throwable) {
                                    Object var4_4 = null;
                                    DHTDBImpl.this.doQuery(byArray, n, map, linkedList, map2, dHTTransportContact, arrayList2, list);
                                    throw throwable;
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                                try {
                                    Object var4_3 = null;
                                    DHTDBImpl.this.doQuery(byArray, n, map, linkedList, map2, dHTTransportContact, arrayList2, null);
                                }
                                catch (Throwable throwable2) {
                                    Object var4_4 = null;
                                    DHTDBImpl.this.doQuery(byArray, n, map, linkedList, map2, dHTTransportContact, arrayList2, null);
                                    throw throwable2;
                                }
                            }
                        }, 6, arrayList3);
                        bl = true;
                        Object var28_28 = null;
                        this.this_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var28_29 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                }
                Object var30_31 = null;
                if (bl) break block17;
                arrayList = new ArrayList<DHTDBMapping>();
                byteArrayHashMap = entry.getValue();
                list3 = byteArrayHashMap.keys();
            }
            catch (Throwable throwable) {
                Object var30_32 = null;
                if (!bl) {
                    ArrayList<DHTDBMapping> arrayList5 = new ArrayList<DHTDBMapping>();
                    ByteArrayHashMap<List<DHTDBMapping>> byteArrayHashMap3 = entry.getValue();
                    List<byte[]> list6 = byteArrayHashMap3.keys();
                    for (byte[] byArray5 : list6) {
                        arrayList5.addAll((Collection)byteArrayHashMap3.get(byArray5));
                    }
                    this.doQuery(byArray, n, map, linkedList, map2, (DHTTransportContact)object, arrayList5, null);
                }
                throw throwable;
            }
            for (byte[] byArray6 : list3) {
                arrayList.addAll((Collection)byteArrayHashMap.get(byArray6));
            }
            this.doQuery(byArray, n, map, linkedList, map2, (DHTTransportContact)object, arrayList, null);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queriesComplete(byte[] byArray, Map<DHTDBMapping, List<DHTTransportContact>> map, Map<DHTTransportContact, Object[]> map2) {
        Iterator<DHTDBValueImpl> iterator;
        Object object;
        Object object2;
        Object object3;
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        try {
            int n;
            HashSet<HashWrapper> hashSet;
            ArrayList<byte[]> arrayList;
            this.this_mon.enter();
            if (!Arrays.equals(byArray, this.router.getID())) {
                this.logger.log("Survey abandoned - router changed");
                Object var25_5 = null;
                this.this_mon.exit();
                this.survey_in_progress = false;
                return;
            }
            HashMap hashMap2 = new HashMap();
            for (Map.Entry<DHTTransportContact, Object[]> entry : map2.entrySet()) {
                Object[] objectArray;
                object3 = entry.getKey();
                object2 = new HashWrapper(object3.getID());
                object = this.survey_state.get(object2);
                if (object != null) {
                    object.updateContactDetails((DHTTransportContact)object3);
                } else {
                    object = new SurveyContactState((DHTTransportContact)object3);
                    this.survey_state.put((HashWrapper)object2, (SurveyContactState)object);
                }
                object.updateUseTime();
                Object[] objectArray2 = entry.getValue();
                iterator = (List)objectArray2[0];
                List list = (List)objectArray2[1];
                if (list == null) {
                    object.contactFailed();
                    continue;
                }
                object.contactOK();
                if (iterator.size() != list.size()) {
                    Debug.out("Inconsistent: mappings=" + iterator.size() + ", reply=" + list.size());
                    continue;
                }
                Iterator iterator2 = iterator.iterator();
                Iterator iterator3 = list.iterator();
                while (iterator2.hasNext()) {
                    arrayList = (DHTDBMapping)iterator2.next();
                    hashSet = (HashSet<HashWrapper>)((byte[])iterator3.next());
                    if (hashSet == null) {
                        object.removeMapping((DHTDBMapping)((Object)arrayList));
                        continue;
                    }
                    DHTDBMapping dHTDBMapping = this.stored_values_prefix_map.get(((DHTDBMapping)((Object)arrayList)).getShortKey());
                    if (dHTDBMapping == null) continue;
                    objectArray = dHTDBMapping.getKey().getBytes();
                    n = ((HashSet<E>)hashSet).length;
                    if (n < 2 || n >= objectArray.length) {
                        Debug.out("Invalid rep_len: " + n);
                        continue;
                    }
                    boolean bl = true;
                    int n2 = objectArray.length - n;
                    for (int i = 0; i < n; ++i) {
                        if (hashSet[i] == objectArray[i + n2]) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        object.addMapping((DHTDBMapping)((Object)arrayList));
                        continue;
                    }
                    object.removeMapping((DHTDBMapping)((Object)arrayList));
                }
                arrayList = object.getMappings();
                for (DHTDBMapping dHTDBMapping : arrayList) {
                    objectArray = (int[])hashMap2.get(dHTDBMapping);
                    if (objectArray == null) {
                        objectArray = new int[]{2};
                        hashMap2.put(dHTDBMapping, objectArray);
                        continue;
                    }
                    objectArray[0] = objectArray[0] + 1;
                }
            }
            for (Map.Entry<DHTDBMapping, List<DHTTransportContact>> entry : map.entrySet()) {
                Object object4;
                object3 = entry.getKey();
                object2 = entry.getValue();
                object = (int[])hashMap2.get(object3);
                Object object5 = object == null ? true : object[0];
                iterator = ((DHTDBMapping)object3).getValues();
                if (!iterator.hasNext()) continue;
                int n3 = -1;
                while (iterator.hasNext()) {
                    DHTDBValueImpl dHTDBValueImpl = (DHTDBValueImpl)iterator.next();
                    byte by = dHTDBValueImpl.getReplicationFactor();
                    if (by <= n3) continue;
                    n3 = by;
                }
                if (n3 == 0) continue;
                if (n3 > this.router.getK()) {
                    n3 = this.router.getK();
                }
                if (object5 >= n3) continue;
                int n4 = n3 - object5;
                ArrayList<SurveyContactState> arrayList2 = new ArrayList<SurveyContactState>();
                arrayList = new ArrayList<byte[]>(object2.size());
                hashSet = object2.iterator();
                while (hashSet.hasNext()) {
                    DHTTransportContact dHTTransportContact = (DHTTransportContact)hashSet.next();
                    if (dHTTransportContact.getProtocolVersion() < 26) continue;
                    arrayList.add(dHTTransportContact.getAddress().getAddress().getAddress());
                    SurveyContactState surveyContactState = this.survey_state.get(new HashWrapper(dHTTransportContact.getID()));
                    if (surveyContactState == null || surveyContactState.testMapping((DHTDBMapping)object3)) continue;
                    arrayList2.add(surveyContactState);
                }
                hashSet = new HashSet<HashWrapper>();
                for (byte[] byArray2 : arrayList) {
                    Iterator iterator4 = arrayList.iterator();
                    while (iterator4.hasNext()) {
                        object4 = (byte[])iterator4.next();
                        if (byArray2 == object4 || byArray2.length != ((byte[])object4).length || byArray2.length != 4 || byArray2[0] != object4[0] || byArray2[1] != object4[1]) continue;
                        this.log("/16 match on " + ByteFormatter.encodeString(byArray2) + "/" + ByteFormatter.encodeString(object4));
                        hashSet.add(new HashWrapper(byArray2));
                        hashSet.add(new HashWrapper((byte[])object4));
                    }
                }
                final byte[] byArray3 = ((DHTDBMapping)object3).getKey().getBytes();
                Collections.sort(arrayList2, new Comparator<SurveyContactState>(){

                    @Override
                    public int compare(SurveyContactState surveyContactState, SurveyContactState surveyContactState2) {
                        boolean bl;
                        boolean bl2 = surveyContactState.getConsecFails() >= 2;
                        boolean bl3 = bl = surveyContactState2.getConsecFails() >= 2;
                        if (bl2 == bl) {
                            return DHTDBImpl.this.control.computeAndCompareDistances(surveyContactState.getContact().getID(), surveyContactState2.getContact().getID(), byArray3);
                        }
                        if (bl2) {
                            return 1;
                        }
                        return -1;
                    }
                });
                int n5 = Math.min(n4, arrayList2.size());
                for (n = 0; n < n5; ++n) {
                    object4 = (SurveyContactState)arrayList2.get(n);
                    if (hashSet.size() > 0 && hashSet.contains(new HashWrapper(object4.getContact().getAddress().getAddress().getAddress()))) {
                        object4.addMapping((DHTDBMapping)object3);
                        continue;
                    }
                    ArrayList<Object> arrayList3 = (ArrayList<Object>)hashMap.get(object4);
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<Object>();
                        hashMap.put(object4, arrayList3);
                    }
                    arrayList3.add(object3);
                }
            }
        }
        catch (Throwable throwable) {
            Object var25_7 = null;
            this.this_mon.exit();
            this.survey_in_progress = false;
            throw throwable;
        }
        Object var25_6 = null;
        this.this_mon.exit();
        this.survey_in_progress = false;
        this.logger.log("Survey complete - " + hashMap.size() + " store ops");
        for (Map.Entry entry : hashMap.entrySet()) {
            SurveyContactState surveyContactState = (SurveyContactState)entry.getKey();
            object3 = (List)entry.getValue();
            object2 = new byte[object3.size()][];
            object = new DHTTransportValue[((Object)object2).length][];
            for (int i = 0; i < ((Object)object2).length; ++i) {
                iterator = (DHTDBMapping)object3.get(i);
                object2[i] = ((DHTDBMapping)((Object)iterator)).getKey().getBytes();
                ArrayList<DHTDBValue> arrayList = new ArrayList<DHTDBValue>();
                Iterator<DHTDBValueImpl> iterator5 = ((DHTDBMapping)((Object)iterator)).getValues();
                while (iterator5.hasNext()) {
                    DHTDBValueImpl dHTDBValueImpl = iterator5.next();
                    if (dHTDBValueImpl.isLocal()) continue;
                    arrayList.add(dHTDBValueImpl.getValueForRelay(this.local_contact));
                }
                object[i] = arrayList.toArray(new DHTTransportValue[arrayList.size()]);
            }
            DHTTransportContact dHTTransportContact = surveyContactState.getContact();
            iterator = new Runnable((List)object3, dHTTransportContact, (byte[][])object2, (DHTTransportValue[][])object, surveyContactState){
                final /* synthetic */ List val$keys;
                final /* synthetic */ DHTTransportContact val$d_contact;
                final /* synthetic */ byte[][] val$store_keys;
                final /* synthetic */ DHTTransportValue[][] val$store_values;
                final /* synthetic */ SurveyContactState val$contact;
                {
                    this.val$keys = list;
                    this.val$d_contact = dHTTransportContact;
                    this.val$store_keys = byArray;
                    this.val$store_values = dHTTransportValueArray;
                    this.val$contact = surveyContactState;
                }

                public void run() {
                    DHTDBImpl.this.control.putDirectEncodedKeys(this.val$store_keys, "Replication forward", this.val$store_values, this.val$d_contact, new DHTOperationAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void complete(boolean bl) {
                            try {
                                DHTDBImpl.this.this_mon.enter();
                                if (bl) {
                                    val$contact.contactFailed();
                                } else {
                                    val$contact.contactOK();
                                    for (DHTDBMapping dHTDBMapping : val$keys) {
                                        val$contact.addMapping(dHTDBMapping);
                                    }
                                }
                                Object var5_4 = null;
                                DHTDBImpl.this.this_mon.exit();
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                DHTDBImpl.this.this_mon.exit();
                                throw throwable;
                            }
                        }
                    });
                }
            };
            if (dHTTransportContact.getRandomID() == 0) {
                dHTTransportContact.sendFindNode(new DHTTransportReplyHandlerAdapter((Runnable)((Object)iterator), surveyContactState){
                    final /* synthetic */ Runnable val$store_exec;
                    final /* synthetic */ SurveyContactState val$contact;
                    {
                        this.val$store_exec = runnable;
                        this.val$contact = surveyContactState;
                    }

                    public void findNodeReply(DHTTransportContact dHTTransportContact, DHTTransportContact[] dHTTransportContactArray) {
                        this.val$store_exec.run();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                        try {
                            DHTDBImpl.this.this_mon.enter();
                            this.val$contact.contactFailed();
                            Object var4_3 = null;
                            DHTDBImpl.this.this_mon.exit();
                        }
                        catch (Throwable throwable2) {
                            Object var4_4 = null;
                            DHTDBImpl.this.this_mon.exit();
                            throw throwable2;
                        }
                    }
                }, dHTTransportContact.getProtocolVersion() >= 8 ? new byte[]{} : new byte[20]);
                continue;
            }
            iterator.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTTransportQueryStoreReply queryStore(DHTTransportContact dHTTransportContact, int n, List<Object[]> list) {
        final ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        try {
            this.this_mon.enter();
            SurveyContactState surveyContactState = this.survey_state.get(new HashWrapper(dHTTransportContact.getID()));
            if (surveyContactState != null) {
                surveyContactState.updateContactDetails(dHTTransportContact);
            }
            for (Object[] objectArray : list) {
                byte[] byArray = (byte[])objectArray[0];
                List list2 = (List)objectArray[1];
                byte[] byArray2 = new byte[n];
                int n2 = byArray.length;
                int n3 = n - n2;
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                for (byte[] byArray3 : list2) {
                    System.arraycopy(byArray3, 0, byArray2, n2, n3);
                    DHTDBMapping dHTDBMapping = this.stored_values_prefix_map.get(new DHTDBMapping.ShortHash(byArray2));
                    if (dHTDBMapping == null) {
                        arrayList.add(null);
                        continue;
                    }
                    if (surveyContactState != null) {
                        surveyContactState.addMapping(dHTDBMapping);
                    }
                    byte[] byArray4 = dHTDBMapping.getKey().getBytes();
                    byte[] byArray5 = new byte[2];
                    System.arraycopy(byArray4, byArray4.length - 2, byArray5, 0, 2);
                    arrayList.add(byArray5);
                }
            }
            DHTTransportQueryStoreReply dHTTransportQueryStoreReply = new DHTTransportQueryStoreReply(){

                @Override
                public int getHeaderSize() {
                    return 2;
                }

                @Override
                public List<byte[]> getEntries() {
                    return arrayList;
                }
            };
            Object var19_18 = null;
            this.this_mon.exit();
            return dHTTransportQueryStoreReply;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(boolean bl) {
        TreeMap<Object, Object[]> treeMap = new TreeMap<Object, Object[]>();
        try {
            Object object;
            Object object2;
            Object object3;
            Iterator<Map.Entry<HashWrapper, DHTDBMapping>> iterator2;
            this.this_mon.enter();
            this.logger.log("Stored keys = " + this.stored_values.size() + ", values = " + this.getValueDetails()[0]);
            if (!bl) {
                Object var14_3 = null;
                this.this_mon.exit();
                return;
            }
            for (Map.Entry<HashWrapper, DHTDBMapping> object4 : this.stored_values.entrySet()) {
                iterator2 = object4.getKey();
                object3 = object4.getValue();
                DHTDBValueImpl[] n = object3.get(null, 0, (byte)0);
                for (int i = 0; i < n.length; ++i) {
                    object2 = n[i];
                    object = new Integer(object2.isLocal() ? 0 : 1);
                    Object[] objectArray = (Object[])treeMap.get(object);
                    if (objectArray == null) {
                        objectArray = new Object[]{new Integer(1), ""};
                        treeMap.put(object, objectArray);
                    } else {
                        objectArray[0] = new Integer((Integer)objectArray[0] + 1);
                    }
                    String string = (String)objectArray[1];
                    string = string + (string.length() == 0 ? "" : ", ") + "key=" + DHTLog.getString2(((HashWrapper)((Object)iterator2)).getHash()) + ",val=" + object2.getString();
                    objectArray[1] = string;
                }
            }
            for (Iterator<Map.Entry<HashWrapper, DHTDBMapping>> iterator2 : treeMap.keySet()) {
                object3 = (Object[])treeMap.get(iterator2);
                this.logger.log("    " + iterator2 + " -> " + object3[0] + " entries");
            }
            iterator2 = this.stored_values.entrySet().iterator();
            object3 = "    ";
            int n = 0;
            while (iterator2.hasNext()) {
                Map.Entry<HashWrapper, DHTDBMapping> entry = iterator2.next();
                object2 = entry.getKey();
                object = entry.getValue();
                if (n == 16) {
                    this.logger.log((String)object3);
                    object3 = "    ";
                    n = 0;
                }
                object3 = (String)object3 + (++n == 1 ? "" : ", ") + DHTLog.getString2(((HashWrapper)object2).getHash()) + " -> " + ((DHTDBMapping)object).getValueCount() + "/" + ((DHTDBMapping)object).getHits() + "[" + ((DHTDBMapping)object).getLocalSize() + "," + ((DHTDBMapping)object).getDirectSize() + "," + ((DHTDBMapping)object).getIndirectSize() + "]";
            }
            if (n > 0) {
                this.logger.log((String)object3);
            }
        }
        catch (Throwable throwable) {
            Object var14_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var14_4 = null;
        this.this_mon.exit();
    }

    protected void banContact(final DHTTransportContact dHTTransportContact, String string) {
        final boolean bl = this.control.getTransport().getNetwork() != 1;
        new AEThread2("DHTDBImpl:delayed flood delete", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DHTDBImpl.this.this_mon.enter();
                    Iterator iterator = DHTDBImpl.this.stored_values.values().iterator();
                    boolean bl3 = false;
                    HashWrapper hashWrapper = new HashWrapper(dHTTransportContact.getID());
                    while (iterator.hasNext()) {
                        DHTDBMapping dHTDBMapping = (DHTDBMapping)iterator.next();
                        boolean bl2 = false;
                        if (dHTDBMapping.removeDirectValue(hashWrapper) != null) {
                            bl2 = true;
                        }
                        if (dHTDBMapping.removeIndirectValue(hashWrapper) != null) {
                            bl2 = true;
                        }
                        if (!bl2 || bl) continue;
                        dHTDBMapping.rebuildIPBloomFilter(false);
                        bl3 = true;
                    }
                    if (bl3 && !bl) {
                        DHTDBImpl.this.rebuildIPBloomFilter(false);
                    }
                    Object var7_6 = null;
                    DHTDBImpl.this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    DHTDBImpl.this.this_mon.exit();
                    throw throwable;
                }
            }
        }.start();
        if (bl) {
            this.logger.log("Banning " + dHTTransportContact.getString() + " due to store flooding (" + string + ")");
            this.ip_filter.ban(dHTTransportContact.getAddress().getAddress().getHostAddress(), "DHT: Sender stored excessive entries at this node (" + string + ")", false);
        }
    }

    protected void incrementValueAdds(DHTTransportContact dHTTransportContact) {
        int n = this.ip_count_bloom_filter.add(dHTTransportContact.getAddress().getAddress().getAddress());
        if (this.ip_count_bloom_filter.getSize() / this.ip_count_bloom_filter.getEntryCount() < 10) {
            this.rebuildIPBloomFilter(true);
        }
        if (n > 64) {
            this.banContact(dHTTransportContact, "global flood");
        }
    }

    protected void decrementValueAdds(DHTTransportContact dHTTransportContact) {
        int n = this.ip_count_bloom_filter.remove(dHTTransportContact.getAddress().getAddress().getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildIPBloomFilter(boolean bl) {
        BloomFilter bloomFilter = bl ? BloomFilterFactory.createAddRemove8Bit(this.ip_count_bloom_filter.getSize() + 1000) : BloomFilterFactory.createAddRemove8Bit(this.ip_count_bloom_filter.getSize());
        try {
            Iterator<DHTDBMapping> iterator = this.stored_values.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                DHTDBMapping dHTDBMapping = iterator.next();
                dHTDBMapping.rebuildIPBloomFilter(false);
                Iterator<DHTDBValueImpl> iterator2 = dHTDBMapping.getDirectValues();
                while (iterator2.hasNext()) {
                    int n2;
                    DHTDBValueImpl dHTDBValueImpl = iterator2.next();
                    if (dHTDBValueImpl.isLocal() || (n2 = bloomFilter.add(dHTDBValueImpl.getOriginator().getAddress().getAddress().getAddress())) <= n) continue;
                    n = n2;
                }
            }
            this.logger.log("Rebuilt global IP bloom filter, size=" + bloomFilter.getSize() + ", entries=" + bloomFilter.getEntryCount() + ", max hits=" + n);
            Object var10_9 = null;
            this.ip_count_bloom_filter = bloomFilter;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.ip_count_bloom_filter = bloomFilter;
            throw throwable;
        }
    }

    protected void reportSizes(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextValueVersion() {
        try {
            int n;
            this.this_mon.enter();
            if (this.next_value_version_left == 0) {
                this.next_value_version_left = 128;
                if (this.adapter != null) {
                    this.next_value_version = this.adapter.getNextValueVersions(128);
                }
            }
            --this.next_value_version_left;
            int n2 = n = this.next_value_version++;
            Object var4_3 = null;
            this.this_mon.exit();
            return n2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SurveyContactState {
        private DHTTransportContact contact;
        private long creation_time = SystemTime.getMonotonousTime();
        private long timeout = this.creation_time + 12600000L + (long)RandomUtils.nextInt(3600000);
        private long last_used = this.creation_time;
        private Set<DHTDBMapping> mappings = new HashSet<DHTDBMapping>();
        private int consec_fails;

        protected SurveyContactState(DHTTransportContact dHTTransportContact) {
            this.contact = dHTTransportContact;
            this.log("new");
        }

        protected boolean timeout(long l) {
            return l - this.last_used > 3600000L || l > this.timeout;
        }

        protected DHTTransportContact getContact() {
            return this.contact;
        }

        protected long getCreationTime() {
            return this.creation_time;
        }

        protected void updateContactDetails(DHTTransportContact dHTTransportContact) {
            if (dHTTransportContact.getInstanceID() != this.contact.getInstanceID()) {
                this.log("instance id changed");
                this.mappings.clear();
            }
            this.contact = dHTTransportContact;
        }

        protected void updateUseTime() {
            this.last_used = SystemTime.getMonotonousTime();
        }

        protected long getLastUseTime() {
            return this.last_used;
        }

        protected void contactOK() {
            this.log("contact ok");
            this.consec_fails = 0;
        }

        protected void contactFailed() {
            ++this.consec_fails;
            this.log("failed, consec=" + this.consec_fails);
            if (this.consec_fails >= 2) {
                this.mappings.clear();
            }
        }

        protected int getConsecFails() {
            return this.consec_fails;
        }

        protected boolean testMapping(DHTDBMapping dHTDBMapping) {
            return this.mappings.contains(dHTDBMapping);
        }

        protected Set<DHTDBMapping> getMappings() {
            return this.mappings;
        }

        protected void addMapping(DHTDBMapping dHTDBMapping) {
            if (this.mappings.add(dHTDBMapping)) {
                this.log("add mapping");
            }
        }

        protected void removeMapping(DHTDBMapping dHTDBMapping) {
            if (this.mappings.remove(dHTDBMapping)) {
                this.log("remove mapping");
            }
        }

        protected void log(String string) {
        }
    }

    protected class adapterFacade
    implements DHTStorageAdapter {
        private DHTStorageAdapter delegate;

        protected adapterFacade(DHTStorageAdapter dHTStorageAdapter) {
            this.delegate = dHTStorageAdapter;
        }

        public int getNetwork() {
            return this.delegate.getNetwork();
        }

        public DHTStorageKey keyCreated(HashWrapper hashWrapper, boolean bl) {
            DHTDBImpl.this.reportSizes("keyAdded");
            DHTDBImpl.this.total_keys++;
            return this.delegate.keyCreated(hashWrapper, bl);
        }

        public void keyDeleted(DHTStorageKey dHTStorageKey) {
            DHTDBImpl.this.total_keys--;
            this.delegate.keyDeleted(dHTStorageKey);
            DHTDBImpl.this.reportSizes("keyDeleted");
        }

        public int getKeyCount() {
            return this.delegate.getKeyCount();
        }

        public void keyRead(DHTStorageKey dHTStorageKey, DHTTransportContact dHTTransportContact) {
            DHTDBImpl.this.reportSizes("keyRead");
            this.delegate.keyRead(dHTStorageKey, dHTTransportContact);
        }

        public DHTStorageKeyStats deserialiseStats(DataInputStream dataInputStream) throws IOException {
            return this.delegate.deserialiseStats(dataInputStream);
        }

        public void valueAdded(DHTStorageKey dHTStorageKey, DHTTransportValue dHTTransportValue) {
            DHTDBImpl.this.total_values++;
            DHTDBImpl.this.total_size += dHTTransportValue.getValue().length;
            DHTDBImpl.this.reportSizes("valueAdded");
            if (!dHTTransportValue.isLocal()) {
                DHTDBValueImpl dHTDBValueImpl = (DHTDBValueImpl)dHTTransportValue;
                boolean bl = Arrays.equals(dHTTransportValue.getOriginator().getID(), dHTDBValueImpl.getSender().getID());
                if (bl) {
                    DHTDBImpl.this.incrementValueAdds(dHTTransportValue.getOriginator());
                }
            }
            this.delegate.valueAdded(dHTStorageKey, dHTTransportValue);
        }

        public void valueUpdated(DHTStorageKey dHTStorageKey, DHTTransportValue dHTTransportValue, DHTTransportValue dHTTransportValue2) {
            DHTDBImpl.this.total_size += dHTTransportValue2.getValue().length - dHTTransportValue.getValue().length;
            DHTDBImpl.this.reportSizes("valueUpdated");
            this.delegate.valueUpdated(dHTStorageKey, dHTTransportValue, dHTTransportValue2);
        }

        public void valueDeleted(DHTStorageKey dHTStorageKey, DHTTransportValue dHTTransportValue) {
            DHTDBImpl.this.total_values--;
            DHTDBImpl.this.total_size -= dHTTransportValue.getValue().length;
            DHTDBImpl.this.reportSizes("valueDeleted");
            if (!dHTTransportValue.isLocal()) {
                DHTDBValueImpl dHTDBValueImpl = (DHTDBValueImpl)dHTTransportValue;
                boolean bl = Arrays.equals(dHTTransportValue.getOriginator().getID(), dHTDBValueImpl.getSender().getID());
                if (bl) {
                    DHTDBImpl.this.decrementValueAdds(dHTTransportValue.getOriginator());
                }
            }
            this.delegate.valueDeleted(dHTStorageKey, dHTTransportValue);
        }

        public boolean isDiversified(byte[] byArray) {
            return this.delegate.isDiversified(byArray);
        }

        public byte[][] getExistingDiversification(byte[] byArray, boolean bl, boolean bl2, int n) {
            return this.delegate.getExistingDiversification(byArray, bl, bl2, n);
        }

        public byte[][] createNewDiversification(String string, DHTTransportContact dHTTransportContact, byte[] byArray, boolean bl, byte by, boolean bl2, int n) {
            return this.delegate.createNewDiversification(string, dHTTransportContact, byArray, bl, by, bl2, n);
        }

        public int getNextValueVersions(int n) {
            return this.delegate.getNextValueVersions(n);
        }

        public DHTStorageBlock keyBlockRequest(DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2) {
            return this.delegate.keyBlockRequest(dHTTransportContact, byArray, byArray2);
        }

        public DHTStorageBlock getKeyBlockDetails(byte[] byArray) {
            return this.delegate.getKeyBlockDetails(byArray);
        }

        public DHTStorageBlock[] getDirectKeyBlocks() {
            return this.delegate.getDirectKeyBlocks();
        }

        public byte[] getKeyForKeyBlock(byte[] byArray) {
            return this.delegate.getKeyForKeyBlock(byArray);
        }

        public void setStorageForKey(String string, byte[] byArray) {
            this.delegate.setStorageForKey(string, byArray);
        }

        public byte[] getStorageForKey(String string) {
            return this.delegate.getStorageForKey(string);
        }

        public int getRemoteFreqDivCount() {
            return this.delegate.getRemoteFreqDivCount();
        }

        public int getRemoteSizeDivCount() {
            return this.delegate.getRemoteSizeDivCount();
        }
    }
}

