/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.helpers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TorrentFolderWatcher {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String PARAMID_FOLDER = "Watch Torrent Folder";
    private GlobalManager global_manager;
    private boolean running = false;
    private final ArrayList to_delete = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TorrentFolderWatcher");
    private FilenameFilter filename_filter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            String string2 = string.toLowerCase();
            return string2.endsWith(".torrent") || string2.endsWith(".tor");
        }
    };
    private ParameterListener param_listener = new ParameterListener(){

        public void parameterChanged(String string) {
            if (COConfigurationManager.getBooleanParameter(TorrentFolderWatcher.PARAMID_FOLDER)) {
                if (!TorrentFolderWatcher.this.running) {
                    TorrentFolderWatcher.this.running = true;
                    TorrentFolderWatcher.this.watch_thread.setDaemon(true);
                    TorrentFolderWatcher.this.watch_thread.setPriority(1);
                    TorrentFolderWatcher.this.watch_thread.start();
                }
            } else {
                TorrentFolderWatcher.this.running = false;
            }
        }
    };
    private final Thread watch_thread = new AEThread("FolderWatcher"){

        public void runSupport() {
            while (TorrentFolderWatcher.this.running) {
                int n = COConfigurationManager.getIntParameter("Watch Torrent Folder Interval");
                try {
                    Thread.sleep(n * 60000);
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                }
                TorrentFolderWatcher.this.importAddedFiles();
            }
        }
    };

    public TorrentFolderWatcher(GlobalManager globalManager) {
        this.global_manager = globalManager;
        if (COConfigurationManager.getBooleanParameter(PARAMID_FOLDER)) {
            this.running = true;
            this.watch_thread.setDaemon(true);
            this.watch_thread.setPriority(1);
            this.watch_thread.start();
        }
        COConfigurationManager.addParameterListener(PARAMID_FOLDER, this.param_listener);
    }

    public void destroy() {
        this.running = false;
        this.global_manager = null;
        COConfigurationManager.removeParameterListener(PARAMID_FOLDER, this.param_listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importAddedFiles() {
        block31: {
            block30: {
                block29: {
                    block28: {
                        try {
                            this.this_mon.enter();
                            if (!this.running) {
                                Object var15_1 = null;
                                this.this_mon.exit();
                                return;
                            }
                            boolean bl = COConfigurationManager.getBooleanParameter("Save Torrent Files");
                            String string = COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
                            int n = COConfigurationManager.getBooleanParameter("Start Watched Torrents Stopped") ? 70 : 75;
                            String string2 = COConfigurationManager.getStringParameter("Watch Torrent Folder Path");
                            String string3 = COConfigurationManager.getStringParameter("Default save path");
                            File file = null;
                            if (string2 != null && string2.length() > 0 && !(file = new File(string2)).isDirectory()) {
                                if (!file.exists()) {
                                    FileUtil.mkdirs(file);
                                }
                                if (!file.isDirectory()) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, 3, "[Watch Torrent Folder Path] does not exist or is not a dir"));
                                    }
                                    file = null;
                                }
                            }
                            if (file == null) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, 3, "[Watch Torrent Folder Path] not configured"));
                                }
                                break block28;
                            }
                            File file2 = null;
                            if (string3 != null && string3.length() > 0 && !(file2 = new File(string3)).isDirectory()) {
                                if (!file2.exists()) {
                                    FileUtil.mkdirs(file2);
                                }
                                if (!file2.isDirectory()) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, 3, "[Default save path] does not exist or is not a dir"));
                                    }
                                    Logger.log(new LogAlert(false, 3, "[Default save path] does not exist or is not a dir"));
                                    break block29;
                                }
                            }
                            if (file2 == null) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, 3, "[Default save path] needs to be set for auto-.torrent-import to work"));
                                }
                                Logger.log(new LogAlert(false, 3, "[Default save path] needs to be set for auto-.torrent-import to work"));
                            }
                            if (string.length() == 0 || string.equals(string2) || !new File(string).isDirectory()) {
                                bl = false;
                            }
                            for (int i = 0; i < this.to_delete.size(); ++i) {
                                TOTorrent tOTorrent = (TOTorrent)this.to_delete.get(i);
                                try {
                                    TorrentUtils.delete(tOTorrent);
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    Debug.printStackTrace(throwable);
                                }
                            }
                            this.to_delete.clear();
                            String[] stringArray = file.list(this.filename_filter);
                            if (stringArray == null) {
                                Logger.log(new LogEvent(LOGID, 3, "There was a problem trying to get a listing of torrents from " + file));
                                break block30;
                            }
                            for (int i = 0; i < stringArray.length; ++i) {
                                File file3 = new File(file, stringArray[i]);
                                try {
                                    TOTorrent tOTorrent = TorrentUtils.readFromFile(file3, false);
                                    if (this.global_manager.getDownloadManager(tOTorrent) != null) {
                                        if (!Logger.isEnabled()) continue;
                                        Logger.log(new LogEvent(LOGID, file3.getAbsolutePath() + " is already being downloaded"));
                                        continue;
                                    }
                                    byte[] byArray = null;
                                    try {
                                        byArray = tOTorrent.getHash();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (!bl) {
                                        File file4 = new File(file, file3.getName() + ".imported");
                                        TorrentUtils.move(file3, file4);
                                        this.global_manager.addDownloadManager(file4.getAbsolutePath(), byArray, string3, n, true);
                                    } else {
                                        this.global_manager.addDownloadManager(file3.getAbsolutePath(), byArray, string3, n, true);
                                        this.to_delete.add(tOTorrent);
                                    }
                                    if (!Logger.isEnabled()) continue;
                                    Logger.log(new LogEvent(LOGID, "Auto-imported " + file3.getAbsolutePath()));
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    Debug.out("Failed to auto-import torrent file '" + file3.getAbsolutePath() + "' - " + Debug.getNestedExceptionMessage(throwable));
                                    Debug.printStackTrace(throwable);
                                }
                            }
                            break block31;
                        }
                        catch (Throwable throwable) {
                            Object var15_6 = null;
                            this.this_mon.exit();
                            throw throwable;
                        }
                    }
                    Object var15_2 = null;
                    this.this_mon.exit();
                    return;
                }
                Object var15_3 = null;
                this.this_mon.exit();
                return;
            }
            Object var15_4 = null;
            this.this_mon.exit();
            return;
        }
        Object var15_5 = null;
        this.this_mon.exit();
    }
}

