/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;

public abstract class NetworkConnectionHelper
implements NetworkConnectionBase {
    private int upload_limit;
    private final LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        public String getName() {
            return "per_con_up: " + NetworkConnectionHelper.this.getString();
        }

        public int getRateLimitBytesPerSecond() {
            return NetworkConnectionHelper.this.upload_limit;
        }
    };
    private int download_limit;
    private final LimitedRateGroup download_limiter = new LimitedRateGroup(){

        public String getName() {
            return "per_con_down: " + NetworkConnectionHelper.this.getString();
        }

        public int getRateLimitBytesPerSecond() {
            return NetworkConnectionHelper.this.download_limit;
        }
    };
    private LimitedRateGroup[] upload_limiters = new LimitedRateGroup[]{this.upload_limiter};
    private LimitedRateGroup[] download_limiters = new LimitedRateGroup[]{this.download_limiter};

    public int getUploadLimit() {
        return this.upload_limit;
    }

    public int getDownloadLimit() {
        return this.download_limit;
    }

    public void setUploadLimit(int n) {
        this.upload_limit = n;
    }

    public void setDownloadLimit(int n) {
        this.download_limit = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        NetworkConnectionHelper networkConnectionHelper = this;
        synchronized (networkConnectionHelper) {
            if (bl) {
                for (int i = 0; i < this.upload_limiters.length; ++i) {
                    if (this.upload_limiters[i] != limitedRateGroup) continue;
                    return;
                }
                LimitedRateGroup[] limitedRateGroupArray = new LimitedRateGroup[this.upload_limiters.length + 1];
                System.arraycopy(this.upload_limiters, 0, limitedRateGroupArray, 0, this.upload_limiters.length);
                limitedRateGroupArray[this.upload_limiters.length] = limitedRateGroup;
                this.upload_limiters = limitedRateGroupArray;
            } else {
                for (int i = 0; i < this.download_limiters.length; ++i) {
                    if (this.download_limiters[i] != limitedRateGroup) continue;
                    return;
                }
                LimitedRateGroup[] limitedRateGroupArray = new LimitedRateGroup[this.download_limiters.length + 1];
                System.arraycopy(this.download_limiters, 0, limitedRateGroupArray, 0, this.download_limiters.length);
                limitedRateGroupArray[this.download_limiters.length] = limitedRateGroup;
                this.download_limiters = limitedRateGroupArray;
            }
        }
        NetworkManager.getSingleton().addRateLimiter(this, limitedRateGroup, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        NetworkConnectionHelper networkConnectionHelper = this;
        synchronized (networkConnectionHelper) {
            if (bl) {
                if (this.upload_limiters.length == 0) {
                    return;
                }
                int n = 0;
                LimitedRateGroup[] limitedRateGroupArray = new LimitedRateGroup[this.upload_limiters.length - 1];
                for (int i = 0; i < this.upload_limiters.length; ++i) {
                    if (this.upload_limiters[i] == limitedRateGroup) continue;
                    if (n == limitedRateGroupArray.length) {
                        return;
                    }
                    limitedRateGroupArray[n++] = this.upload_limiters[i];
                }
                this.upload_limiters = limitedRateGroupArray;
            } else {
                if (this.download_limiters.length == 0) {
                    return;
                }
                int n = 0;
                LimitedRateGroup[] limitedRateGroupArray = new LimitedRateGroup[this.download_limiters.length - 1];
                for (int i = 0; i < this.download_limiters.length; ++i) {
                    if (this.download_limiters[i] == limitedRateGroup) continue;
                    if (n == limitedRateGroupArray.length) {
                        return;
                    }
                    limitedRateGroupArray[n++] = this.download_limiters[i];
                }
                this.download_limiters = limitedRateGroupArray;
            }
        }
        NetworkManager.getSingleton().removeRateLimiter(this, limitedRateGroup, bl);
    }

    public LimitedRateGroup[] getRateLimiters(boolean bl) {
        if (bl) {
            return this.upload_limiters;
        }
        return this.download_limiters;
    }
}

