/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminASNImpl;
import com.aelitis.azureus.core.util.DNSUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class NetworkAdminASNLookupImpl {
    private static final String WHOIS_ADDRESS = "whois.cymru.com";
    private static final int WHOIS_PORT = 43;
    private static final int TIMEOUT = 30000;
    private InetAddress address;

    protected NetworkAdminASNLookupImpl(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    protected NetworkAdminASNImpl lookup() throws NetworkAdminException {
        return this.lookupDNS(this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NetworkAdminASNImpl lookupTCP(InetAddress inetAddress) throws NetworkAdminException {
        try {
            NetworkAdminASNImpl networkAdminASNImpl;
            Socket socket = new Socket();
            int n = 30000;
            long l = SystemTime.getCurrentTime();
            socket.connect(new InetSocketAddress(WHOIS_ADDRESS, 43), n);
            long l2 = SystemTime.getCurrentTime();
            n = (int)((long)n - (l2 - l));
            if (n <= 0) {
                throw new NetworkAdminException("Timeout on connect");
            }
            if (n > 30000) {
                n = 30000;
            }
            socket.setSoTimeout(n);
            try {
                OutputStream outputStream = socket.getOutputStream();
                String string = "-u -p " + inetAddress.getHostAddress() + "\r\n";
                outputStream.write(string.getBytes());
                outputStream.flush();
                InputStream inputStream = socket.getInputStream();
                byte[] byArray = new byte[1024];
                String string2 = "";
                while (true) {
                    int n2;
                    if ((n2 = inputStream.read(byArray)) <= 0) {
                        networkAdminASNImpl = this.processResult(string2);
                        Object var15_14 = null;
                        break;
                    }
                    string2 = string2 + new String(byArray, 0, n2);
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                socket.close();
                throw throwable;
            }
            socket.close();
            return networkAdminASNImpl;
        }
        catch (Throwable throwable) {
            throw new NetworkAdminException("whois connection failed", throwable);
        }
    }

    protected NetworkAdminASNImpl lookupDNS(InetAddress inetAddress) throws NetworkAdminException {
        byte[] byArray = inetAddress.getAddress();
        String string = "origin.asn.cymru.com";
        for (int i = 0; i < 4; ++i) {
            string = (byArray[i] & 0xFF) + "." + string;
        }
        String string2 = this.lookupDNS(string);
        NetworkAdminASNImpl networkAdminASNImpl = this.processResult("AS | BGP Prefix | CC | Reg | Date | AS Name\n" + string2 + " | n/a");
        String string3 = networkAdminASNImpl.getAS();
        if (string3.length() > 0) {
            String string4 = "AS" + string3 + ".asn.cymru.com";
            try {
                int n;
                String string5 = this.lookupDNS(string4);
                if (string5 != null && (n = string5.lastIndexOf(124)) != -1) {
                    String string6 = string5.substring(n + 1).trim();
                    networkAdminASNImpl.setASName(string6);
                }
            }
            catch (Throwable throwable) {
                Debug.outNoStack("ASN lookup for '" + string4 + "' failed: " + throwable.getMessage());
            }
        }
        return networkAdminASNImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String lookupDNS(String string) throws NetworkAdminException {
        DirContext dirContext = null;
        try {
            try {
                String string2;
                dirContext = DNSUtils.getInitialDirContext();
                Attributes attributes = dirContext.getAttributes(string, new String[]{"TXT"});
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                block7: while (true) {
                    if (!namingEnumeration.hasMoreElements()) throw new NetworkAdminException("DNS query returned no results");
                    Attribute attribute = namingEnumeration.next();
                    NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                    while (true) {
                        if (!namingEnumeration2.hasMoreElements()) continue block7;
                        string2 = (String)namingEnumeration2.nextElement();
                        if (string2 == null) continue;
                        if ((string2 = string2.trim()).startsWith("\"")) {
                            string2 = string2.substring(1);
                        }
                        if (string2.endsWith("\"")) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                        if (string2.length() > 0) break block7;
                    }
                    break;
                }
                String string3 = string2;
                Object var10_10 = null;
                if (dirContext == null) return string3;
                try {
                    dirContext.close();
                    return string3;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return string3;
            }
            catch (Throwable throwable) {
                throw new NetworkAdminException("DNS query failed", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (dirContext == null) throw throwable;
            try {}
            catch (Throwable throwable2) {
                throw throwable;
            }
            dirContext.close();
            throw throwable;
        }
    }

    protected NetworkAdminASNImpl processResult(String string) {
        Object object;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block0: while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (++n > 2) break;
            object = new StringTokenizer(string2, "|");
            int n2 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken().trim();
                if (n == 1) {
                    arrayList.add(string3.toLowerCase(MessageText.LOCALE_ENGLISH));
                } else {
                    if (n2 >= arrayList.size()) continue block0;
                    String string4 = (String)arrayList.get(n2);
                    hashMap.put(string4, string3);
                }
                ++n2;
            }
        }
        string2 = (String)hashMap.get("as");
        object = (String)hashMap.get("as name");
        String string5 = (String)hashMap.get("bgp prefix");
        if (string5 != null) {
            int n3 = string5.indexOf(32);
            if (n3 != -1) {
                string5 = string5.substring(n3 + 1).trim();
            }
            if (string5.indexOf(47) == -1) {
                string5 = null;
            }
        }
        return new NetworkAdminASNImpl(string2, (String)object, string5);
    }

    public static void main(String[] stringArray) {
        try {
            NetworkAdminASNLookupImpl networkAdminASNLookupImpl = new NetworkAdminASNLookupImpl(InetAddress.getByName("64.71.8.82"));
            System.out.println(networkAdminASNLookupImpl.lookup().getString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

