/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProgressListener;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolTester;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatChecker;

public class NetworkAdminTCPTester
implements NetworkAdminProtocolTester {
    private AzureusCore core;
    private NetworkAdminProgressListener listener;

    protected NetworkAdminTCPTester(AzureusCore azureusCore, NetworkAdminProgressListener networkAdminProgressListener) {
        this.core = azureusCore;
        this.listener = networkAdminProgressListener;
    }

    public InetAddress testOutbound(InetAddress inetAddress, int n) throws NetworkAdminException {
        try {
            return VersionCheckClient.getSingleton().getExternalIpAddressTCP(inetAddress, n, false);
        }
        catch (Throwable throwable) {
            try {
                Socket socket = new Socket();
                if (inetAddress != null) {
                    socket.bind(new InetSocketAddress(inetAddress, n));
                } else if (n != 0) {
                    socket.bind(new InetSocketAddress(n));
                }
                socket.setSoTimeout(10000);
                socket.connect(new InetSocketAddress("www.google.com", 80), 10000);
                socket.close();
                return null;
            }
            catch (Throwable throwable2) {
                throw new NetworkAdminException("Outbound test failed", throwable);
            }
        }
    }

    public InetAddress testInbound(InetAddress inetAddress, int n) throws NetworkAdminException {
        NatChecker natChecker = new NatChecker(this.core, inetAddress, n, false);
        if (natChecker.getResult() == 1) {
            return natChecker.getExternalAddress();
        }
        throw new NetworkAdminException("NAT test failed: " + natChecker.getAdditionalInfo());
    }
}

