/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderAdapter;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderPHE;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterTransparent;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class ProtocolDecoderInitial
extends ProtocolDecoder {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private ProtocolDecoderAdapter adapter;
    private TransportHelperFilter filter;
    private TransportHelper transport;
    private byte[][] shared_secrets;
    private ByteBuffer initial_data;
    private ByteBuffer decode_buffer;
    private int decode_read;
    private long start_time = SystemTime.getCurrentTime();
    private ProtocolDecoderPHE phe_decoder;
    private long last_read_time = 0L;
    private boolean processing_complete;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtocolDecoderInitial(TransportHelper transportHelper, byte[][] byArray, boolean bl, ByteBuffer byteBuffer, ProtocolDecoderAdapter protocolDecoderAdapter) throws IOException {
        super(true);
        this.transport = transportHelper;
        this.shared_secrets = byArray;
        this.initial_data = byteBuffer;
        this.adapter = protocolDecoderAdapter;
        final TransportHelperFilterTransparent transportHelperFilterTransparent = new TransportHelperFilterTransparent(this.transport, false);
        this.filter = transportHelperFilterTransparent;
        if (bl) {
            if (!ProtocolDecoderPHE.isCryptoOK()) throw new IOException("Crypto required but unavailable");
            this.decodePHE(null);
            return;
        } else {
            this.decode_buffer = ByteBuffer.allocate(this.adapter.getMaximumPlainHeaderLength());
            this.transport.registerForReadSelects(new TransportHelper.selectListener(){

                public boolean selectSuccess(TransportHelper transportHelper, Object object) {
                    try {
                        int n = transportHelper.read(ProtocolDecoderInitial.this.decode_buffer);
                        if (n < 0) {
                            ProtocolDecoderInitial.this.failed(new IOException("end of stream on socket read: in=" + ProtocolDecoderInitial.this.decode_buffer.position()));
                        } else if (n == 0) {
                            return false;
                        }
                        ProtocolDecoderInitial.this.last_read_time = SystemTime.getCurrentTime();
                        ProtocolDecoderInitial.this.decode_read += n;
                        int n2 = ProtocolDecoderInitial.this.adapter.matchPlainHeader(ProtocolDecoderInitial.this.decode_buffer);
                        if (n2 != 1) {
                            transportHelper.cancelReadSelects();
                            if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE && n2 == 2) {
                                if (NetworkManager.INCOMING_HANDSHAKE_FALLBACK_ALLOWED) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, "Incoming connection [" + ProtocolDecoderInitial.this.transport.getAddress() + "] is not encrypted but has been accepted as fallback is enabled"));
                                    }
                                } else if (AddressUtils.isLANLocalAddress(ProtocolDecoderInitial.this.transport.getAddress().getAddress().getHostAddress()) == 1) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, "Incoming connection [" + ProtocolDecoderInitial.this.transport.getAddress() + "] is not encrypted but has been accepted as lan-local"));
                                    }
                                } else {
                                    throw new IOException("Crypto required but incoming connection has none");
                                }
                            }
                            ProtocolDecoderInitial.this.decode_buffer.flip();
                            transportHelperFilterTransparent.insertRead(ProtocolDecoderInitial.this.decode_buffer);
                            ProtocolDecoderInitial.this.complete(ProtocolDecoderInitial.this.initial_data);
                        } else if (!ProtocolDecoderInitial.this.decode_buffer.hasRemaining()) {
                            transportHelper.cancelReadSelects();
                            if (NetworkManager.INCOMING_CRYPTO_ALLOWED) {
                                ProtocolDecoderInitial.this.decode_buffer.flip();
                                ProtocolDecoderInitial.this.decodePHE(ProtocolDecoderInitial.this.decode_buffer);
                            } else {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, "Incoming connection [" + ProtocolDecoderInitial.this.transport.getAddress() + "] encrypted but rejected as not permitted"));
                                }
                                throw new IOException("Incoming crypto connection not permitted");
                            }
                        }
                        return true;
                    }
                    catch (Throwable throwable) {
                        this.selectFailure(transportHelper, object, throwable);
                        return false;
                    }
                }

                public void selectFailure(TransportHelper transportHelper, Object object, Throwable throwable) {
                    transportHelper.cancelReadSelects();
                    ProtocolDecoderInitial.this.failed(throwable);
                }
            }, this);
        }
    }

    protected void decodePHE(ByteBuffer byteBuffer) throws IOException {
        ProtocolDecoderAdapter protocolDecoderAdapter = new ProtocolDecoderAdapter(){

            public void decodeComplete(ProtocolDecoder protocolDecoder, ByteBuffer byteBuffer) {
                ProtocolDecoderInitial.this.filter = protocolDecoder.getFilter();
                ProtocolDecoderInitial.this.complete(byteBuffer);
            }

            public void decodeFailed(ProtocolDecoder protocolDecoder, Throwable throwable) {
                ProtocolDecoderInitial.this.failed(throwable);
            }

            public void gotSecret(byte[] byArray) {
                ProtocolDecoderInitial.this.adapter.gotSecret(byArray);
            }

            public int getMaximumPlainHeaderLength() {
                throw new RuntimeException();
            }

            public int matchPlainHeader(ByteBuffer byteBuffer) {
                throw new RuntimeException();
            }
        };
        this.phe_decoder = new ProtocolDecoderPHE(this.transport, this.shared_secrets, byteBuffer, this.initial_data, protocolDecoderAdapter);
    }

    public boolean isComplete(long l) {
        if (!this.processing_complete) {
            long l2;
            long l3;
            if (this.start_time > l) {
                this.start_time = l;
            }
            if (this.last_read_time > l) {
                this.last_read_time = l;
            }
            if (this.phe_decoder != null) {
                this.last_read_time = this.phe_decoder.getLastReadTime();
            }
            if (this.last_read_time == 0L) {
                l3 = this.transport.getConnectTimeout();
                l2 = this.start_time;
            } else {
                l3 = this.transport.getReadTimeout();
                l2 = this.last_read_time;
            }
            if (l - l2 > l3) {
                try {
                    this.transport.cancelReadSelects();
                    this.transport.cancelWriteSelects();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String string = "";
                if (this.phe_decoder != null) {
                    string = ", crypto: " + this.phe_decoder.getString();
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Connection [" + this.transport.getAddress() + "] forcibly timed out after " + l3 / 1000L + "sec due to socket inactivity"));
                }
                this.failed(new Throwable("Protocol decode aborted: timed out after " + l3 / 1000L + "sec: " + this.decode_read + " bytes read" + string));
            }
        }
        return this.processing_complete;
    }

    public TransportHelperFilter getFilter() {
        return this.filter;
    }

    protected void complete(ByteBuffer byteBuffer) {
        if (!this.processing_complete) {
            this.processing_complete = true;
            this.adapter.decodeComplete(this, byteBuffer);
        }
    }

    protected void failed(Throwable throwable) {
        if (!this.processing_complete) {
            this.processing_complete = true;
            this.adapter.decodeFailed(this, throwable);
        }
    }
}

