/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class ReadController
implements AzureusCoreStatsProvider {
    private static int IDLE_SLEEP_TIME = 50;
    private static boolean AGGRESIVE_READ = false;
    private volatile ArrayList normal_priority_entities = new ArrayList();
    private volatile ArrayList high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("ReadController:EM");
    private int next_normal_position = 0;
    private int next_high_position = 0;
    private long loop_count;
    private long wait_count;
    private long non_progress_count;
    private long progress_count;
    private long entity_check_count;
    private long last_entity_check_count;
    private EventWaiter read_waiter = new EventWaiter();
    private int entity_count;

    public ReadController() {
        AEThread aEThread = new AEThread("ReadController:ReadProcessor"){

            public void runSupport() {
                ReadController.this.readProcessorLoop();
            }
        };
        aEThread.setDaemon(true);
        aEThread.setPriority(9);
        aEThread.start();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("net.read.control.loop.count");
        hashSet.add("net.read.control.np.count");
        hashSet.add("net.read.control.p.count");
        hashSet.add("net.read.control.wait.count");
        hashSet.add("net.read.control.entity.count");
        hashSet.add("net.read.control.con.count");
        hashSet.add("net.read.control.ready.con.count");
        AzureusCoreStats.registerProvider(hashSet, this);
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generate(IndentWriter indentWriter) {
                indentWriter.println("Read Controller");
                try {
                    RateControlledEntity rateControlledEntity;
                    int n;
                    indentWriter.indent();
                    ArrayList arrayList = ReadController.this.normal_priority_entities;
                    indentWriter.println("normal - " + arrayList.size());
                    for (n = 0; n < arrayList.size(); ++n) {
                        rateControlledEntity = (RateControlledEntity)arrayList.get(n);
                        indentWriter.println(rateControlledEntity.getString());
                    }
                    arrayList = ReadController.this.high_priority_entities;
                    indentWriter.println("priority - " + arrayList.size());
                    for (n = 0; n < arrayList.size(); ++n) {
                        rateControlledEntity = (RateControlledEntity)arrayList.get(n);
                        indentWriter.println(rateControlledEntity.getString());
                    }
                    Object var6_5 = null;
                    indentWriter.exdent();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    indentWriter.exdent();
                    throw throwable;
                }
            }
        });
    }

    public void updateStats(Set set, Map map) {
        if (set.contains("net.read.control.loop.count")) {
            map.put("net.read.control.loop.count", new Long(this.loop_count));
        }
        if (set.contains("net.read.control.np.count")) {
            map.put("net.read.control.np.count", new Long(this.non_progress_count));
        }
        if (set.contains("net.read.control.p.count")) {
            map.put("net.read.control.p.count", new Long(this.progress_count));
        }
        if (set.contains("net.read.control.wait.count")) {
            map.put("net.read.control.wait.count", new Long(this.wait_count));
        }
        if (set.contains("net.read.control.entity.count")) {
            map.put("net.read.control.entity.count", new Long(this.high_priority_entities.size() + this.normal_priority_entities.size()));
        }
        if (set.contains("net.read.control.con.count") || set.contains("net.read.control.ready.con.count")) {
            int n = 0;
            int n2 = 0;
            ArrayList[] arrayListArray = new ArrayList[]{this.normal_priority_entities, this.high_priority_entities};
            for (int i = 0; i < arrayListArray.length; ++i) {
                ArrayList arrayList = arrayListArray[i];
                for (int j = 0; j < arrayList.size(); ++j) {
                    RateControlledEntity rateControlledEntity = (RateControlledEntity)arrayList.get(j);
                    n2 += rateControlledEntity.getConnectionCount();
                    n += rateControlledEntity.getReadyConnectionCount(this.read_waiter);
                }
            }
            map.put("net.read.control.con.count", new Long(n2));
            map.put("net.read.control.ready.con.count", new Long(n));
        }
    }

    private void readProcessorLoop() {
        boolean bl = true;
        while (true) {
            ++this.loop_count;
            try {
                if (bl) {
                    bl = false;
                    if (this.doHighPriorityRead() || this.doNormalPriorityRead() || !this.read_waiter.waitForEvent(IDLE_SLEEP_TIME)) continue;
                    ++this.wait_count;
                    continue;
                }
                bl = true;
                if (this.doNormalPriorityRead() || this.doHighPriorityRead() || !this.read_waiter.waitForEvent(IDLE_SLEEP_TIME)) continue;
                ++this.wait_count;
                continue;
            }
            catch (Throwable throwable) {
                Debug.out("readProcessorLoop() EXCEPTION: ", throwable);
                continue;
            }
            break;
        }
    }

    private boolean doNormalPriorityRead() {
        return this.doRead(this.getNextReadyNormalPriorityEntity());
    }

    private boolean doHighPriorityRead() {
        return this.doRead(this.getNextReadyHighPriorityEntity());
    }

    private boolean doRead(RateControlledEntity rateControlledEntity) {
        if (rateControlledEntity != null) {
            if (AGGRESIVE_READ) {
                if (rateControlledEntity.doProcessing(this.read_waiter, 0) > 0) {
                    ++this.progress_count;
                    return true;
                }
                ++this.non_progress_count;
                if (this.entity_check_count - this.last_entity_check_count >= (long)(this.normal_priority_entities.size() + this.high_priority_entities.size())) {
                    this.last_entity_check_count = this.entity_check_count;
                    if (this.read_waiter.waitForEvent(IDLE_SLEEP_TIME)) {
                        ++this.wait_count;
                    }
                    return false;
                }
                return true;
            }
            return rateControlledEntity.doProcessing(this.read_waiter, 0) > 0;
        }
        return false;
    }

    private RateControlledEntity getNextReadyNormalPriorityEntity() {
        ArrayList arrayList = this.normal_priority_entities;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ++this.entity_check_count;
            this.next_normal_position = this.next_normal_position >= n ? 0 : this.next_normal_position;
            RateControlledEntity rateControlledEntity = (RateControlledEntity)arrayList.get(this.next_normal_position);
            ++this.next_normal_position;
            if (!rateControlledEntity.canProcess(this.read_waiter)) continue;
            return rateControlledEntity;
        }
        return null;
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList arrayList = this.high_priority_entities;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ++this.entity_check_count;
            this.next_high_position = this.next_high_position >= n ? 0 : this.next_high_position;
            RateControlledEntity rateControlledEntity = (RateControlledEntity)arrayList.get(this.next_high_position);
            ++this.next_high_position;
            if (!rateControlledEntity.canProcess(this.read_waiter)) continue;
            return rateControlledEntity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReadEntity(RateControlledEntity rateControlledEntity) {
        try {
            this.entities_mon.enter();
            if (rateControlledEntity.getPriority() == 1) {
                ArrayList<RateControlledEntity> arrayList = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                arrayList.addAll(this.high_priority_entities);
                arrayList.add(rateControlledEntity);
                this.high_priority_entities = arrayList;
            } else {
                ArrayList<RateControlledEntity> arrayList = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                arrayList.addAll(this.normal_priority_entities);
                arrayList.add(rateControlledEntity);
                this.normal_priority_entities = arrayList;
            }
            this.entity_count = this.normal_priority_entities.size() + this.high_priority_entities.size();
            Object var4_4 = null;
            this.entities_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.entities_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReadEntity(RateControlledEntity rateControlledEntity) {
        try {
            this.entities_mon.enter();
            if (rateControlledEntity.getPriority() == 1) {
                ArrayList arrayList = new ArrayList(this.high_priority_entities);
                arrayList.remove(rateControlledEntity);
                this.high_priority_entities = arrayList;
            } else {
                ArrayList arrayList = new ArrayList(this.normal_priority_entities);
                arrayList.remove(rateControlledEntity);
                this.normal_priority_entities = arrayList;
            }
            this.entity_count = this.normal_priority_entities.size() + this.high_priority_entities.size();
            Object var4_4 = null;
            this.entities_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.entities_mon.exit();
            throw throwable;
        }
    }

    public int getEntityCount() {
        return this.entity_count;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.control.read.idle.time", "network.control.read.aggressive"}, new ParameterListener(){

            public void parameterChanged(String string) {
                IDLE_SLEEP_TIME = COConfigurationManager.getIntParameter("network.control.read.idle.time");
                AGGRESIVE_READ = COConfigurationManager.getBooleanParameter("network.control.read.aggressive");
            }
        });
    }
}

