/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TransportHelperFilterTransparent
implements TransportHelperFilter {
    private TransportHelper transport;
    private boolean is_plain;
    private ByteBuffer read_insert;

    public TransportHelperFilterTransparent(TransportHelper transportHelper, boolean bl) {
        this.transport = transportHelper;
        this.is_plain = bl;
    }

    protected void insertRead(ByteBuffer byteBuffer) {
        this.read_insert = byteBuffer;
    }

    public boolean hasBufferedWrite() {
        return this.transport.hasDelayedWrite();
    }

    public boolean hasBufferedRead() {
        return this.read_insert != null && this.read_insert.remaining() > 0;
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.transport.write(byteBufferArray, n, n2);
    }

    public int write(ByteBuffer byteBuffer, boolean bl) throws IOException {
        return this.transport.write(byteBuffer, bl);
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.read_insert != null) {
            int n4 = this.read_insert.position();
            for (int i = n; i < n + n2; ++i) {
                ByteBuffer byteBuffer = byteBufferArray[i];
                int n5 = byteBuffer.remaining();
                if (n5 <= 0) continue;
                if (n5 < this.read_insert.remaining()) {
                    int n6 = this.read_insert.limit();
                    this.read_insert.limit(this.read_insert.position() + n5);
                    byteBuffer.put(this.read_insert);
                    this.read_insert.limit(n6);
                } else {
                    byteBuffer.put(this.read_insert);
                }
                if (!this.read_insert.hasRemaining()) break;
            }
            n3 = this.read_insert.position() - n4;
            if (this.read_insert.hasRemaining()) {
                return n3;
            }
            this.read_insert = null;
        }
        return (long)n3 + this.transport.read(byteBufferArray, n, n2);
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.read_insert != null) {
            return (int)this.read(new ByteBuffer[]{byteBuffer}, 0, 1);
        }
        return this.transport.read(byteBuffer);
    }

    public TransportHelper getHelper() {
        return this.transport;
    }

    public void setTrace(boolean bl) {
        this.transport.setTrace(bl);
    }

    public boolean isEncrypted() {
        return false;
    }

    public String getName(boolean bl) {
        String string = this.getHelper().getName(bl);
        if (string.length() > 0) {
            string = " (" + string + ")";
        }
        return (this.is_plain ? "Plain" : "None") + string;
    }
}

