/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.Debug;

public class HTTPNetworkConnectionWebSeed
extends HTTPNetworkConnection {
    private boolean switching;

    protected HTTPNetworkConnectionWebSeed(HTTPNetworkManager hTTPNetworkManager, NetworkConnection networkConnection, PEPeerTransport pEPeerTransport) {
        super(hTTPNetworkManager, networkConnection, pEPeerTransport);
    }

    protected void decodeHeader(HTTPMessageDecoder hTTPMessageDecoder, String string) throws IOException {
        if (this.switching) {
            Debug.out("new header received while paused");
            throw new IOException("Bork");
        }
        if (!this.isSeed()) {
            return;
        }
        PEPeerControl pEPeerControl = this.getPeerControl();
        try {
            Object object;
            Object object2;
            int n = string.indexOf("\r\n");
            String string2 = string.substring(4, n);
            n = string2.lastIndexOf(32);
            String string3 = string2.substring(0, n).trim();
            n = string3.indexOf(63);
            if (n != -1) {
                string3 = string3.substring(n + 1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "&");
            int n2 = -1;
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            while (stringTokenizer.hasMoreElements()) {
                Object object3;
                String string4 = stringTokenizer.nextToken();
                n = string4.indexOf(61);
                if (n == -1) continue;
                String string5 = string4.substring(0, n).toLowerCase(MessageText.LOCALE_ENGLISH);
                object2 = string4.substring(n + 1);
                if (string5.equals("info_hash")) {
                    object = pEPeerControl.getHash();
                    object3 = URLDecoder.decode((String)object2, "ISO-8859-1").getBytes("ISO-8859-1");
                    if (Arrays.equals(object3, (byte[])object)) continue;
                    this.switching = true;
                    hTTPMessageDecoder.pauseInternally();
                    this.flushRequests(new HTTPNetworkConnection.flushListener((byte[])object, (byte[])object3, string){
                        private boolean triggered;
                        final /* synthetic */ byte[] val$old_hash;
                        final /* synthetic */ byte[] val$new_hash;
                        final /* synthetic */ String val$header;
                        {
                            this.val$old_hash = byArray;
                            this.val$new_hash = byArray2;
                            this.val$header = string;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void flushed() {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                if (this.triggered) {
                                    return;
                                }
                                this.triggered = true;
                            }
                            HTTPNetworkConnectionWebSeed.this.getManager().reRoute(HTTPNetworkConnectionWebSeed.this, this.val$old_hash, this.val$new_hash, this.val$header);
                        }
                    });
                    return;
                }
                if (string5.equals("piece")) {
                    try {
                        n2 = Integer.parseInt((String)object2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw new IOException("Invalid piece number '" + (String)object2 + "'");
                    }
                }
                if (!string5.equals("ranges")) continue;
                object = new StringTokenizer((String)object2, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    object3 = ((StringTokenizer)object).nextToken();
                    int n3 = object3.indexOf(45);
                    if (n3 == -1) {
                        throw new IOException("Invalid range specification '" + (String)object2 + "'");
                    }
                    try {
                        arrayList.add(new int[]{Integer.parseInt(object3.substring(0, n3)), Integer.parseInt(object3.substring(n3 + 1))});
                    }
                    catch (Throwable throwable) {
                        throw new IOException("Invalid range specification '" + (String)object2 + "'");
                    }
                }
            }
            if (n2 == -1) {
                throw new IOException("Piece number not specified");
            }
            boolean bl = string.toLowerCase(MessageText.LOCALE_ENGLISH).indexOf("keep-alive") != -1;
            int n4 = pEPeerControl.getPieceLength(n2);
            if (arrayList.size() == 0) {
                arrayList.add(new int[]{0, n4 - 1});
            }
            object2 = new long[arrayList.size()];
            object = new long[arrayList.size()];
            long l = n2 * pEPeerControl.getPieceLength(0);
            for (int i = 0; i < arrayList.size(); ++i) {
                int[] nArray = (int[])arrayList.get(i);
                int n5 = nArray[0];
                int n6 = nArray[1];
                if (n5 < 0 || n5 >= n4 || n6 < 0 || n6 >= n4 || n5 > n6) {
                    throw new IOException("Invalid range specification '" + n5 + "-" + n6 + "'");
                }
                object2[i] = l + (long)n5;
                object[i] = (long)(n6 - n5 + 1);
            }
            this.addRequest(new HTTPNetworkConnection.httpRequest((long[])object2, (long[])object, 0L, false, bl));
        }
        catch (Throwable throwable) {
            Debug.outNoStack("Decode of '" + (string.length() > 128 ? string.substring(0, 128) + "..." : string) + "' - " + Debug.getNestedExceptionMessageAndStack(throwable));
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Decode failed: " + Debug.getNestedExceptionMessage(throwable));
        }
    }
}

