/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageEncoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnectionFile;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnectionWebSeed;
import com.aelitis.azureus.core.networkmanager.impl.tcp.IncomingSocketChannelManager;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRoutingListener;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.BEncoder;

public class HTTPNetworkManager {
    private static final String NL = "\r\n";
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final HTTPNetworkManager instance = new HTTPNetworkManager();
    private final IncomingSocketChannelManager http_incoming_manager;
    private long total_requests;
    private long total_webseed_requests;
    private long total_getright_requests;
    private long total_invalid_requests;
    private long total_ok_requests;
    private CopyOnWriteList<URLHandler> url_handlers = new CopyOnWriteList();

    public static HTTPNetworkManager getSingleton() {
        return instance;
    }

    private HTTPNetworkManager() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("net.http.inbound.request.count");
        hashSet.add("net.http.inbound.request.ok.count");
        hashSet.add("net.http.inbound.request.invalid.count");
        hashSet.add("net.http.inbound.request.webseed.count");
        hashSet.add("net.http.inbound.request.getright.count");
        AzureusCoreStats.registerProvider(hashSet, new AzureusCoreStatsProvider(){

            public void updateStats(Set set, Map map) {
                if (set.contains("net.http.inbound.request.count")) {
                    map.put("net.http.inbound.request.count", new Long(HTTPNetworkManager.this.total_requests));
                }
                if (set.contains("net.http.inbound.request.ok.count")) {
                    map.put("net.http.inbound.request.ok.count", new Long(HTTPNetworkManager.this.total_ok_requests));
                }
                if (set.contains("net.http.inbound.request.invalid.count")) {
                    map.put("net.http.inbound.request.invalid.count", new Long(HTTPNetworkManager.this.total_invalid_requests));
                }
                if (set.contains("net.http.inbound.request.webseed.count")) {
                    map.put("net.http.inbound.request.webseed.count", new Long(HTTPNetworkManager.this.total_webseed_requests));
                }
                if (set.contains("net.http.inbound.request.getright.count")) {
                    map.put("net.http.inbound.request.getright.count", new Long(HTTPNetworkManager.this.total_getright_requests));
                }
            }
        });
        this.http_incoming_manager = new IncomingSocketChannelManager("HTTP.Data.Listen.Port", "HTTP.Data.Listen.Port.Enable");
        NetworkManager.ByteMatcher byteMatcher = new NetworkManager.ByteMatcher(){

            public int matchThisSizeOrBigger() {
                return 16;
            }

            public int maxSize() {
                return 256;
            }

            public int minSize() {
                return 3;
            }

            /*
             * Exception decompiling
             */
            public Object matches(TransportHelper var1_1, ByteBuffer var2_2, int var3_3) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[TRYBLOCK]], but top level block is 27[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public Object minMatches(TransportHelper transportHelper, ByteBuffer byteBuffer, int n) {
                byte[] byArray = new byte[3];
                byteBuffer.get(byArray);
                if (byArray[0] != 71 || byArray[1] != 69 || byArray[2] != 84) {
                    return null;
                }
                return "";
            }

            public byte[][] getSharedSecrets() {
                return null;
            }

            public int getSpecificPort() {
                return HTTPNetworkManager.this.http_incoming_manager.getTCPListeningPortNumber();
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(byteMatcher, new NetworkManager.RoutingListener(){

            public void connectionRouted(final NetworkConnection networkConnection, Object object) {
                Object[] objectArray = (Object[])object;
                Object object2 = objectArray[0];
                if (object2 instanceof TransportHelper) {
                    HTTPNetworkManager.this.writeReply(networkConnection, (TransportHelper)objectArray[0], (String)objectArray[1]);
                    return;
                }
                if (object2 instanceof URLHandler) {
                    ((URLHandler)object2).handle((TransportHelper)objectArray[1], (String)objectArray[2]);
                    return;
                }
                final String string = (String)object2;
                PeerManagerRegistration peerManagerRegistration = (PeerManagerRegistration)objectArray[1];
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " routed successfully on '" + string + "'"));
                }
                PeerManager.getSingleton().manualRoute(peerManagerRegistration, networkConnection, new PeerManagerRoutingListener(){

                    public boolean routed(PEPeerTransport pEPeerTransport) {
                        if (string.indexOf("/webseed") != -1) {
                            HTTPNetworkManager.this.total_webseed_requests++;
                            new HTTPNetworkConnectionWebSeed(HTTPNetworkManager.this, networkConnection, pEPeerTransport);
                            return true;
                        }
                        if (string.indexOf("/files/") != -1) {
                            HTTPNetworkManager.this.total_getright_requests++;
                            new HTTPNetworkConnectionFile(HTTPNetworkManager.this, networkConnection, pEPeerTransport);
                            return true;
                        }
                        return false;
                    }
                });
            }

            public boolean autoCryptoFallback() {
                return false;
            }
        }, new MessageStreamFactory(){

            public MessageStreamEncoder createEncoder() {
                return new HTTPMessageEncoder();
            }

            public MessageStreamDecoder createDecoder() {
                return new HTTPMessageDecoder();
            }
        });
    }

    protected void reRoute(HTTPNetworkConnection hTTPNetworkConnection, byte[] byArray, byte[] byArray2, final String string) {
        NetworkConnection networkConnection = hTTPNetworkConnection.getConnection();
        PeerManagerRegistration peerManagerRegistration = PeerManager.getSingleton().manualMatchHash(networkConnection.getEndpoint().getNotionalAddress(), byArray2);
        if (peerManagerRegistration == null) {
            hTTPNetworkConnection.close("Re-routing failed - registration not found");
            return;
        }
        Transport transport = networkConnection.detachTransport();
        hTTPNetworkConnection.close("Switching torrents");
        final NetworkConnection networkConnection2 = NetworkManager.getSingleton().bindTransport(transport, new HTTPMessageEncoder(), new HTTPMessageDecoder(string));
        PeerManager.getSingleton().manualRoute(peerManagerRegistration, networkConnection2, new PeerManagerRoutingListener(){

            public boolean routed(PEPeerTransport pEPeerTransport) {
                HTTPNetworkConnection hTTPNetworkConnection;
                if (string.indexOf("/webseed") != -1) {
                    hTTPNetworkConnection = new HTTPNetworkConnectionWebSeed(HTTPNetworkManager.this, networkConnection2, pEPeerTransport);
                } else if (string.indexOf("/files/") != -1) {
                    hTTPNetworkConnection = new HTTPNetworkConnectionFile(HTTPNetworkManager.this, networkConnection2, pEPeerTransport);
                } else {
                    return false;
                }
                hTTPNetworkConnection.readWakeup();
                return true;
            }
        });
    }

    public boolean isHTTPListenerEnabled() {
        return this.http_incoming_manager.isEnabled();
    }

    public int getHTTPListeningPortNumber() {
        return this.http_incoming_manager.getTCPListeningPortNumber();
    }

    public void setExplicitBindAddress(InetAddress inetAddress) {
        this.http_incoming_manager.setExplicitBindAddress(inetAddress);
    }

    public void clearExplicitBindAddress() {
        this.http_incoming_manager.clearExplicitBindAddress();
    }

    public boolean isEffectiveBindAddress(InetAddress inetAddress) {
        return this.http_incoming_manager.isEffectiveBindAddress(inetAddress);
    }

    protected String getIndexPage() {
        return "HTTP/1.1 200 OK\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected String getPingPage(String string) {
        Object object;
        Object object2;
        int n = string.indexOf(32);
        if (n != -1) {
            string = string.substring(0, n);
        }
        n = string.indexOf(63);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        if (n != -1) {
            object2 = new StringTokenizer(string.substring(n + 1), "&");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                n = ((String)object).indexOf(61);
                if (n == -1) continue;
                String string2 = ((String)object).substring(0, n);
                String string3 = ((String)object).substring(n + 1);
                if (!string2.equals("check")) continue;
                hashMap.put("check", string3);
                bl = true;
            }
        }
        if (bl) {
            try {
                object2 = BEncoder.encode(hashMap);
                object = new byte[4];
                ByteBuffer.wrap((byte[])object).putInt(((Object)object2).length);
                return "HTTP/1.1 200 OK\r\nConnection: Close\r\nContent-Length: " + (((Object)object2).length + 4) + NL + NL + new String((byte[])object, "ISO-8859-1") + new String((byte[])object2, "ISO-8859-1");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.getNotFound();
    }

    protected String getTest503() {
        return "HTTP/1.1 503 Service Unavailable\r\nConnection: Close\r\nContent-Length: 4\r\n\r\n1234";
    }

    protected String getNotFound() {
        return "HTTP/1.1 404 Not Found\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected String getRangeNotSatisfiable() {
        return "HTTP/1.1 416 Not Satisfiable\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected void writeReply(final NetworkConnection networkConnection, TransportHelper transportHelper, final String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        final ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        try {
            transportHelper.write(byteBuffer, false);
            if (byteBuffer.remaining() > 0) {
                transportHelper.registerForWriteSelects(new TransportHelper.selectListener(){

                    public boolean selectSuccess(TransportHelper transportHelper, Object object) {
                        try {
                            int n = transportHelper.write(byteBuffer, false);
                            if (byteBuffer.remaining() > 0) {
                                transportHelper.registerForWriteSelects(this, null);
                            } else {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " closed"));
                                }
                                networkConnection.close();
                            }
                            return n > 0;
                        }
                        catch (Throwable throwable) {
                            transportHelper.cancelWriteSelects();
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " failed to write error '" + string + "'"));
                            }
                            networkConnection.close();
                            return false;
                        }
                    }

                    public void selectFailure(TransportHelper transportHelper, Object object, Throwable throwable) {
                        transportHelper.cancelWriteSelects();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " failed to write error '" + string + "'"));
                        }
                        networkConnection.close();
                    }
                }, null);
            } else {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " closed"));
                }
                networkConnection.close();
            }
        }
        catch (Throwable throwable) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "HTTP connection from " + networkConnection.getEndpoint().getNotionalAddress() + " failed to write error '" + string + "'"));
            }
            networkConnection.close();
        }
    }

    public void addURLHandler(URLHandler uRLHandler) {
        this.url_handlers.add(uRLHandler);
    }

    public void removeURLHandler(URLHandler uRLHandler) {
        this.url_handlers.remove(uRLHandler);
    }

    static /* synthetic */ long access$008(HTTPNetworkManager hTTPNetworkManager) {
        return hTTPNetworkManager.total_requests++;
    }

    static /* synthetic */ CopyOnWriteList access$500(HTTPNetworkManager hTTPNetworkManager) {
        return hTTPNetworkManager.url_handlers;
    }

    static /* synthetic */ long access$108(HTTPNetworkManager hTTPNetworkManager) {
        return hTTPNetworkManager.total_ok_requests++;
    }

    static /* synthetic */ long access$208(HTTPNetworkManager hTTPNetworkManager) {
        return hTTPNetworkManager.total_invalid_requests++;
    }

    public static interface URLHandler {
        public boolean matches(String var1);

        public void handle(TransportHelper var1, String var2);
    }
}

