/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.HashWrapper;

public class AZHandshake
implements AZMessage {
    public static final int HANDSHAKE_TYPE_PLAIN = 0;
    public static final int HANDSHAKE_TYPE_CRYPTO = 1;
    private static final byte bss = 11;
    private final byte version;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte[] identity;
    private final HashWrapper sessionID;
    private final HashWrapper reconnectID;
    private final String client;
    private final String client_version;
    private final String[] avail_ids;
    private final byte[] avail_versions;
    private int tcp_port;
    private int udp_port;
    private int udp_non_data_port;
    private final int handshake_type;
    private final boolean uploadOnly;
    private final InetAddress ipv6;

    public AZHandshake(byte[] byArray, HashWrapper hashWrapper, HashWrapper hashWrapper2, String string, String string2, int n, int n2, int n3, InetAddress inetAddress, String[] stringArray, byte[] byArray2, int n4, byte by, boolean bl) {
        this.identity = byArray;
        this.sessionID = hashWrapper;
        this.reconnectID = hashWrapper2;
        this.client = string;
        this.client_version = string2;
        this.avail_ids = stringArray;
        this.avail_versions = byArray2;
        this.tcp_port = n;
        this.udp_port = n2;
        this.udp_non_data_port = n3;
        this.handshake_type = n4;
        this.version = by;
        this.uploadOnly = bl;
        this.ipv6 = inetAddress;
        if (this.tcp_port < 0 || this.tcp_port > 65535) {
            Debug.out("given TCP listen port is invalid: " + this.tcp_port);
            this.tcp_port = 0;
        }
        if (this.udp_port < 0 || this.udp_port > 65535) {
            Debug.out("given UDP listen port is invalid: " + this.udp_port);
            this.udp_port = 0;
        }
        if (this.udp_non_data_port < 0 || this.udp_non_data_port > 65535) {
            Debug.out("given UDP non-data listen port is invalid: " + this.udp_non_data_port);
            this.udp_non_data_port = 0;
        }
    }

    public byte[] getIdentity() {
        return this.identity;
    }

    public HashWrapper getRemoteSessionID() {
        return this.sessionID;
    }

    public HashWrapper getReconnectSessionID() {
        return this.reconnectID;
    }

    public boolean isUploadOnly() {
        return this.uploadOnly;
    }

    public String getClient() {
        return this.client;
    }

    public String getClientVersion() {
        return this.client_version;
    }

    public String[] getMessageIDs() {
        return this.avail_ids;
    }

    public byte[] getMessageVersions() {
        return this.avail_versions;
    }

    public int getTCPListenPort() {
        return this.tcp_port;
    }

    public int getUDPListenPort() {
        return this.udp_port;
    }

    public int getUDPNonDataListenPort() {
        return this.udp_non_data_port;
    }

    public InetAddress getIPv6() {
        return this.ipv6;
    }

    public int getHandshakeType() {
        return this.handshake_type;
    }

    public String getID() {
        return "AZ_HANDSHAKE";
    }

    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_HANDSHAKE_BYTES;
    }

    public String getFeatureID() {
        return "AZ1";
    }

    public int getFeatureSubID() {
        return 0;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getDescription() {
        if (this.description == null) {
            String string = "";
            for (int i = 0; i < this.avail_ids.length; ++i) {
                String string2 = this.avail_ids[i];
                byte by = this.avail_versions[i];
                if (string2.equals(this.getID())) continue;
                string = string + "[" + string2 + ":" + by + "]";
            }
            this.description = this.getID() + " from [" + ByteFormatter.nicePrint(this.identity, true) + ", " + this.client + " " + this.client_version + ", TCP/UDP ports " + this.tcp_port + "/" + this.udp_port + "/" + this.udp_non_data_port + ", handshake " + (this.getHandshakeType() == 0 ? "plain" : "crypto") + ", upload_only = " + (this.isUploadOnly() ? "1" : "0") + (this.ipv6 != null ? ", ipv6 = " + this.ipv6.getHostAddress() : "") + (this.sessionID != null ? ", sessionID: " + this.sessionID.toBase32String() : "") + (this.reconnectID != null ? ", reconnect request: " + this.reconnectID.toBase32String() : "") + "] supports " + string;
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("identity", this.identity);
            if (this.sessionID != null) {
                hashMap.put("session", this.sessionID.getBytes());
            }
            if (this.reconnectID != null) {
                hashMap.put("reconn", this.reconnectID.getBytes());
            }
            hashMap.put("client", this.client);
            hashMap.put("version", this.client_version);
            hashMap.put("tcp_port", new Long(this.tcp_port));
            hashMap.put("udp_port", new Long(this.udp_port));
            hashMap.put("udp2_port", new Long(this.udp_non_data_port));
            hashMap.put("handshake_type", new Long(this.handshake_type));
            hashMap.put("upload_only", new Long(this.uploadOnly ? 1L : 0L));
            if (this.ipv6 != null) {
                hashMap.put("ipv6", this.ipv6.getAddress());
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.avail_ids.length; ++i) {
                String string = this.avail_ids[i];
                byte by = this.avail_versions[i];
                if (string.equals(this.getID())) continue;
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("id", string);
                hashMap2.put("ver", new byte[]{by});
                arrayList.add(hashMap2);
            }
            hashMap.put("messages", arrayList);
            if (this.handshake_type == 1) {
                hashMap.put("pad", new byte[(int)(Math.random() * 64.0)]);
            }
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(hashMap, (byte)13);
            if (this.buffer.remaining((byte)11) > 1200) {
                System.out.println("Generated AZHandshake size = " + this.buffer.remaining((byte)11) + " bytes");
            }
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        List list;
        Long l;
        Long l2;
        Long l3;
        Map map = MessagingUtil.convertBencodedByteStreamToPayload(directByteBuffer, 100, this.getID());
        byte[] byArray = (byte[])map.get("identity");
        if (byArray == null) {
            throw new MessageException("id == null");
        }
        if (byArray.length != 20) {
            throw new MessageException("id.length != 20: " + byArray.length);
        }
        byte[] byArray2 = (byte[])map.get("session");
        byte[] byArray3 = (byte[])map.get("reconn");
        byte[] byArray4 = (byte[])map.get("client");
        if (byArray4 == null) {
            throw new MessageException("raw_name == null");
        }
        String string = new String(byArray4);
        byte[] byArray5 = (byte[])map.get("version");
        if (byArray5 == null) {
            throw new MessageException("raw_ver == null");
        }
        String string2 = new String(byArray5);
        Long l4 = (Long)map.get("tcp_port");
        if (l4 == null) {
            l4 = new Long(0L);
        }
        if ((l3 = (Long)map.get("udp_port")) == null) {
            l3 = new Long(0L);
        }
        if ((l2 = (Long)map.get("udp2_port")) == null) {
            l2 = l3;
        }
        if ((l = (Long)map.get("handshake_type")) == null) {
            l = new Long(0L);
        }
        InetAddress inetAddress = null;
        if (map.get("ipv6") instanceof byte[]) {
            try {
                InetAddress.getByAddress((byte[])map.get("ipv6"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((list = (List)map.get("messages")) == null) {
            throw new MessageException("raw_msgs == null");
        }
        String[] stringArray = new String[list.size()];
        byte[] byArray6 = new byte[list.size()];
        int n = 0;
        for (Map map2 : list) {
            byte[] byArray7 = (byte[])map2.get("id");
            if (byArray7 == null) {
                throw new MessageException("mid == null");
            }
            stringArray[n] = new String(byArray7);
            byte[] byArray8 = (byte[])map2.get("ver");
            if (byArray8 == null) {
                throw new MessageException("ver == null");
            }
            if (byArray8.length != 1) {
                throw new MessageException("ver.length != 1");
            }
            byArray6[n] = byArray8[0];
            ++n;
        }
        Long l5 = (Long)map.get("upload_only");
        boolean bl = l5 != null && l5 > 0L;
        return new AZHandshake(byArray, byArray2 == null ? null : new HashWrapper(byArray2), byArray3 == null ? null : new HashWrapper(byArray3), string, string2, l4.intValue(), l3.intValue(), l2.intValue(), inetAddress, stringArray, byArray6, l.intValue(), by, bl);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

