/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;

public class OutgoingBTHaveMessageAggregator {
    private final ArrayList pending_haves = new ArrayList();
    private final AEMonitor pending_haves_mon = new AEMonitor("OutgoingBTHaveMessageAggregator:PH");
    private byte bt_have_version;
    private byte az_have_version;
    private boolean destroyed = false;
    private final OutgoingMessageQueue outgoing_message_q;
    private final OutgoingMessageQueue.MessageQueueListener added_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        public boolean messageAdded(Message message) {
            return true;
        }

        public void messageQueued(Message message) {
            String string = message.getID();
            if (!string.equals("BT_HAVE") && !string.equals("AZ_HAVE")) {
                OutgoingBTHaveMessageAggregator.this.sendPendingHaves();
            }
        }

        public void messageRemoved(Message message) {
        }

        public void messageSent(Message message) {
        }

        public void protocolBytesSent(int n) {
        }

        public void dataBytesSent(int n) {
        }

        public void flush() {
        }
    };

    public OutgoingBTHaveMessageAggregator(OutgoingMessageQueue outgoingMessageQueue, byte by, byte by2) {
        this.outgoing_message_q = outgoingMessageQueue;
        this.bt_have_version = by;
        this.az_have_version = by2;
        outgoingMessageQueue.registerQueueListener(this.added_message_listener);
    }

    public void setHaveVersion(byte by, byte by2) {
        this.bt_have_version = by;
        this.az_have_version = by2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueHaveMessage(int n, boolean bl) {
        if (this.destroyed) {
            return;
        }
        try {
            this.pending_haves_mon.enter();
            this.pending_haves.add(new Integer(n));
            if (bl) {
                this.sendPendingHaves();
            } else {
                int n2 = this.pending_haves.size() * 9;
                if (n2 >= this.outgoing_message_q.getMssSize()) {
                    this.sendPendingHaves();
                }
            }
            Object var5_4 = null;
            this.pending_haves_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.pending_haves_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.pending_haves_mon.enter();
            this.pending_haves.clear();
            this.destroyed = true;
            Object var2_1 = null;
            this.pending_haves_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.pending_haves_mon.exit();
            throw throwable;
        }
    }

    public void forceSendOfPending() {
        this.sendPendingHaves();
    }

    public boolean hasPending() {
        return !this.pending_haves.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingHaves() {
        if (this.destroyed) {
            return;
        }
        try {
            this.pending_haves_mon.enter();
            int n = this.pending_haves.size();
            if (n == 0) {
                Object var5_2 = null;
                this.pending_haves_mon.exit();
                return;
            }
            if (n == 1 || this.az_have_version < 2) {
                for (int i = 0; i < n; ++i) {
                    Integer n2 = (Integer)this.pending_haves.get(i);
                    this.outgoing_message_q.addMessage(new BTHave(n2, this.bt_have_version), true);
                }
            } else {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (Integer)this.pending_haves.get(i);
                }
                this.outgoing_message_q.addMessage(new AZHave(nArray, this.az_have_version), true);
            }
            this.outgoing_message_q.doListenerNotifications();
            this.pending_haves.clear();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.pending_haves_mon.exit();
            throw throwable;
        }
        Object var5_3 = null;
        this.pending_haves_mon.exit();
    }
}

