/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.vuzefile;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileImpl;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;

public class VuzeFileHandler {
    private static VuzeFileHandler singleton = new VuzeFileHandler();
    private CopyOnWriteList processors = new CopyOnWriteList();

    public static VuzeFileHandler getSingleton() {
        return singleton;
    }

    protected VuzeFileHandler() {
    }

    public VuzeFile loadVuzeFile(String string) {
        try {
            File file = new File(string);
            if (file.isFile()) {
                return this.getVuzeFile(new FileInputStream(file));
            }
            URL uRL = new URI(string).toURL();
            String string2 = uRL.getProtocol().toLowerCase();
            if (string2.equals("http") || string2.equals("https")) {
                ResourceDownloader resourceDownloader = StaticUtilities.getResourceDownloaderFactory().create(uRL);
                return this.getVuzeFile(resourceDownloader.download());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public VuzeFile loadVuzeFile(byte[] byArray) {
        return this.loadVuzeFile(new ByteArrayInputStream(byArray));
    }

    public VuzeFile loadVuzeFile(InputStream inputStream) {
        return this.getVuzeFile(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected VuzeFile getVuzeFile(InputStream inputStream) {
        try {
            VuzeFile vuzeFile;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            try {
                Map map = BDecoder.decode(bufferedInputStream);
                vuzeFile = this.loadVuzeFile(map);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return vuzeFile;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public VuzeFile loadVuzeFile(Map map) {
        if (map.containsKey("vuze") && !map.containsKey("info")) {
            return new VuzeFileImpl(this, (Map)map.get("vuze"));
        }
        return null;
    }

    public VuzeFile loadAndHandleVuzeFile(String string, int n) {
        VuzeFile vuzeFile = this.loadVuzeFile(string);
        if (vuzeFile == null) {
            return null;
        }
        this.handleFiles(new VuzeFile[]{vuzeFile}, n);
        return vuzeFile;
    }

    public void handleFiles(VuzeFile[] vuzeFileArray, int n) {
        for (VuzeFileProcessor vuzeFileProcessor : this.processors) {
            try {
                vuzeFileProcessor.process(vuzeFileArray, n);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        for (int i = 0; i < vuzeFileArray.length; ++i) {
            VuzeFile vuzeFile = vuzeFileArray[i];
            VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
            for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                if (vuzeFileComponent.isProcessed()) continue;
                Debug.out("Failed to handle Vuze file component " + vuzeFileComponent.getContent());
            }
        }
    }

    public VuzeFile create() {
        return new VuzeFileImpl(this);
    }

    public void addProcessor(VuzeFileProcessor vuzeFileProcessor) {
        this.processors.add(vuzeFileProcessor);
    }
}

