/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.netstatus;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusPlugin;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterBT;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusProtocolTesterListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;

public class NetStatusProtocolTester
implements DistributedDatabaseTransferHandler {
    private static final int REQUEST_HISTORY_MAX = 64;
    private static final int MAX_ACTIVE_TESTS = 3;
    private static final int MAX_TEST_TIME = 120000;
    private static final int TEST_TYPE_BT = 1;
    private static final int VERSION_INITIAL = 1;
    private static final int CURRENT_VERSION = 1;
    private static final int BT_MAX_SLAVES = 8;
    private NetStatusPlugin plugin;
    private PluginInterface plugin_interface;
    private DistributedDatabase ddb;
    private DHTPlugin dht_plugin;
    private testXferType transfer_type = new testXferType();
    private Map request_history = new LinkedHashMap(64, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 64;
        }
    };
    private List active_tests = new ArrayList();
    private TimerEventPeriodic timer_event = null;

    protected NetStatusProtocolTester(NetStatusPlugin netStatusPlugin, PluginInterface pluginInterface) {
        this.plugin = netStatusPlugin;
        this.plugin_interface = pluginInterface;
        try {
            PluginInterface pluginInterface2 = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (pluginInterface2 != null) {
                this.dht_plugin = (DHTPlugin)pluginInterface2.getPlugin();
            }
            this.ddb = this.plugin_interface.getDistributedDatabase();
            this.ddb.addTransferHandler(this.transfer_type, this);
            this.log("DDB transfer type registered");
        }
        catch (Throwable throwable) {
            this.log("DDB transfer type registration failed", throwable);
        }
    }

    public NetStatusProtocolTesterBT runTest(NetStatusProtocolTesterListener netStatusProtocolTesterListener) {
        return this.runTest("", netStatusProtocolTesterListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetStatusProtocolTesterBT runTest(String string, final NetStatusProtocolTesterListener netStatusProtocolTesterListener) {
        final NetStatusProtocolTesterBT netStatusProtocolTesterBT = new NetStatusProtocolTesterBT(this, true);
        netStatusProtocolTesterBT.addListener(netStatusProtocolTesterListener);
        netStatusProtocolTesterBT.start();
        this.addToActive(netStatusProtocolTesterBT);
        try {
            block11: {
                try {
                    if (string.length() == 0) {
                        DHT[] dHTArray = this.dht_plugin.getDHTs();
                        DHT dHT = null;
                        int n = Constants.isCVSVersion() ? 1 : 0;
                        for (int i = 0; i < dHTArray.length; ++i) {
                            if (dHTArray[i].getTransport().getNetwork() != n) continue;
                            dHT = dHTArray[i];
                            break;
                        }
                        if (dHT == null) {
                            netStatusProtocolTesterListener.logError("Distributed database unavailable");
                            break block11;
                        } else {
                            int n2;
                            DHTTransportContact[] dHTTransportContactArray = dHT.getTransport().getReachableContacts();
                            final ArrayList<DHTTransportContact> arrayList = new ArrayList<DHTTransportContact>(Arrays.asList(dHTTransportContactArray));
                            final int[] nArray = new int[]{0};
                            final int n3 = Math.min(8, dHTTransportContactArray.length);
                            netStatusProtocolTesterListener.log("Searching " + dHTTransportContactArray.length + " contacts for " + n3 + " test targets");
                            final AESemaphore aESemaphore = new AESemaphore("NetStatusProbe");
                            for (n2 = 0; n2 < n3; ++n2) {
                                new AEThread2("NetStatusProbe", true){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     * Enabled aggressive block sorting
                                     * Enabled unnecessary exception pruning
                                     * Enabled aggressive exception aggregation
                                     * Converted monitor instructions to comments
                                     * Lifted jumps to return sites
                                     */
                                    public void run() {
                                        try {
                                            while (!netStatusProtocolTesterBT.isDestroyed()) {
                                                DHTTransportContact dHTTransportContact = null;
                                                Object object = nArray;
                                                // MONITORENTER : nArray
                                                if (nArray[0] < n3 && arrayList.size() > 0) {
                                                    dHTTransportContact = (DHTTransportContact)arrayList.remove(0);
                                                }
                                                // MONITOREXIT : object
                                                if (dHTTransportContact == null) break;
                                                try {
                                                    object = NetStatusProtocolTester.this.ddb.importContact(dHTTransportContact.getAddress());
                                                    if (!NetStatusProtocolTester.this.tryTest(netStatusProtocolTesterBT, (DistributedDatabaseContact)object)) continue;
                                                    int[] nArray2 = nArray;
                                                    // MONITORENTER : nArray
                                                    nArray[0] = nArray[0] + 1;
                                                    // MONITOREXIT : nArray2
                                                }
                                                catch (Throwable throwable) {
                                                    netStatusProtocolTesterListener.logError("Contact import for " + dHTTransportContact.getName() + " failed", throwable);
                                                }
                                            }
                                            Object var6_5 = null;
                                            aESemaphore.release();
                                            return;
                                        }
                                        catch (Throwable throwable) {
                                            Object var6_6 = null;
                                            aESemaphore.release();
                                            throw throwable;
                                        }
                                    }
                                }.start();
                            }
                            for (n2 = 0; n2 < n3; ++n2) {
                                aESemaphore.reserve();
                            }
                            netStatusProtocolTesterListener.log("Searching complete, " + nArray[0] + " targets found");
                        }
                        break block11;
                    }
                    String[] stringArray = string.split(":");
                    if (stringArray.length != 2) {
                        this.log("Invalid address - use <host>:<port> ");
                        NetStatusProtocolTesterBT netStatusProtocolTesterBT2 = netStatusProtocolTesterBT;
                        Object var14_19 = null;
                        netStatusProtocolTesterBT.addListener(new NetStatusProtocolTesterListener(){

                            public void sessionAdded(NetStatusProtocolTesterBT.Session session) {
                            }

                            public void complete(NetStatusProtocolTesterBT netStatusProtocolTesterBT) {
                                NetStatusProtocolTester.this.removeFromActive(netStatusProtocolTesterBT);
                            }

                            public void log(String string) {
                            }

                            public void logError(String string) {
                            }

                            public void logError(String string, Throwable throwable) {
                            }
                        });
                        netStatusProtocolTesterBT.setOutboundConnectionsComplete();
                        new DelayedEvent("NetStatus:killer", 10000L, new AERunnable(netStatusProtocolTesterListener, netStatusProtocolTesterBT){
                            final /* synthetic */ NetStatusProtocolTesterListener val$listener;
                            final /* synthetic */ NetStatusProtocolTesterBT val$bt_tester;
                            {
                                this.val$listener = netStatusProtocolTesterListener;
                                this.val$bt_tester = netStatusProtocolTesterBT;
                            }

                            public void runSupport() {
                                this.val$listener.log("Destroying tester");
                                this.val$bt_tester.destroy();
                            }
                        });
                        return netStatusProtocolTesterBT2;
                    }
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(stringArray[0].trim(), Integer.parseInt(stringArray[1].trim()));
                    DistributedDatabaseContact distributedDatabaseContact = this.ddb.importContact(inetSocketAddress);
                    this.tryTest(netStatusProtocolTesterBT, distributedDatabaseContact);
                }
                catch (Throwable throwable) {
                    netStatusProtocolTesterListener.logError("Test failed", throwable);
                    Object var14_21 = null;
                    netStatusProtocolTesterBT.addListener(new /* invalid duplicate definition of identical inner class */);
                    netStatusProtocolTesterBT.setOutboundConnectionsComplete();
                    new DelayedEvent("NetStatus:killer", 10000L, new /* invalid duplicate definition of identical inner class */);
                    return netStatusProtocolTesterBT;
                }
            }
            Object var14_20 = null;
            netStatusProtocolTesterBT.addListener(new /* invalid duplicate definition of identical inner class */);
            netStatusProtocolTesterBT.setOutboundConnectionsComplete();
            new DelayedEvent("NetStatus:killer", 10000L, new /* invalid duplicate definition of identical inner class */);
            return netStatusProtocolTesterBT;
        }
        catch (Throwable throwable) {
            Object var14_22 = null;
            netStatusProtocolTesterBT.addListener(new /* invalid duplicate definition of identical inner class */);
            netStatusProtocolTesterBT.setOutboundConnectionsComplete();
            new DelayedEvent("NetStatus:killer", 10000L, new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    protected boolean tryTest(NetStatusProtocolTesterBT netStatusProtocolTesterBT, DistributedDatabaseContact distributedDatabaseContact) {
        byte[] byArray;
        boolean bl = NetworkManager.getCryptoRequired(0);
        this.log("Trying test to " + distributedDatabaseContact.getName());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("v", new Long(1L));
        hashMap.put("t", new Long(1L));
        hashMap.put("h", netStatusProtocolTesterBT.getServerHash());
        hashMap.put("c", new Long(bl ? 1L : 0L));
        Map map = this.sendRequest(distributedDatabaseContact, hashMap);
        byte[] byArray2 = byArray = map == null ? null : (byte[])map.get("h");
        if (byArray != null) {
            this.log("    " + distributedDatabaseContact.getName() + " accepted test");
            netStatusProtocolTesterBT.testOutbound(this.adjustLoopback(distributedDatabaseContact.getAddress()), byArray, bl);
            return true;
        }
        this.log("    " + distributedDatabaseContact.getName() + " declined test");
        return false;
    }

    protected InetSocketAddress adjustLoopback(InetSocketAddress inetSocketAddress) {
        InetSocketAddress inetSocketAddress2 = this.dht_plugin.getLocalAddress().getAddress();
        if (inetSocketAddress2.getAddress().getHostAddress().equals(inetSocketAddress.getAddress().getHostAddress())) {
            return new InetSocketAddress("127.0.0.1", inetSocketAddress.getPort());
        }
        return inetSocketAddress;
    }

    protected Map sendRequest(DistributedDatabaseContact distributedDatabaseContact, Map map) {
        try {
            this.log("Sending DDB request to " + distributedDatabaseContact.getName() + " - " + map);
            DistributedDatabaseKey distributedDatabaseKey = this.ddb.createKey(BEncoder.encode(map));
            DistributedDatabaseValue distributedDatabaseValue = distributedDatabaseContact.read(new DistributedDatabaseProgressListener(){

                public void reportSize(long l) {
                }

                public void reportActivity(String string) {
                }

                public void reportCompleteness(int n) {
                }
            }, this.transfer_type, distributedDatabaseKey, 10000L);
            if (distributedDatabaseValue == null) {
                return null;
            }
            Map map2 = BDecoder.decode((byte[])distributedDatabaseValue.getValue(byte[].class));
            this.log("    received reply - " + map2);
            return map2;
        }
        catch (Throwable throwable) {
            this.log("sendRequest failed", throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map receiveRequest(InetSocketAddress inetSocketAddress, Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Long l = (Long)map.get("t");
        hashMap.put("v", new Long(1L));
        if (l != null && l.intValue() == 1) {
            byte[] byArray;
            TCPNetworkManager tCPNetworkManager = TCPNetworkManager.getSingleton();
            InetSocketAddress inetSocketAddress2 = this.adjustLoopback(inetSocketAddress);
            boolean bl = inetSocketAddress2.getAddress().isLoopbackAddress();
            if ((bl || tCPNetworkManager.isTCPListenerEnabled() && tCPNetworkManager.getTCPListeningPortNumber() == this.ddb.getLocalContact().getAddress().getPort() && SystemTime.getCurrentTime() - tCPNetworkManager.getLastIncomingNonLocalConnectionTime() <= 86400000L) && (byArray = (byte[])map.get("h")) != null) {
                NetStatusProtocolTesterBT netStatusProtocolTesterBT;
                Object object = this.active_tests;
                synchronized (object) {
                    if (this.active_tests.size() > 3) {
                        this.log("Too many active tests");
                        return hashMap;
                    }
                    netStatusProtocolTesterBT = new NetStatusProtocolTesterBT(this, false);
                    netStatusProtocolTesterBT.start();
                    this.addToActive(netStatusProtocolTesterBT);
                }
                object = (Long)map.get("c");
                boolean bl2 = object != null && (Long)object == 1L;
                netStatusProtocolTesterBT.testOutbound(inetSocketAddress2, byArray, bl2);
                hashMap.put("h", netStatusProtocolTesterBT.getServerHash());
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToActive(NetStatusProtocolTesterBT netStatusProtocolTesterBT) {
        List list = this.active_tests;
        synchronized (list) {
            this.active_tests.add(netStatusProtocolTesterBT);
            if (this.timer_event == null) {
                this.timer_event = SimpleTimer.addPeriodicEvent("NetStatusProtocolTester:timer", 30000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent timerEvent2) {
                        long l = SystemTime.getCurrentTime();
                        ArrayList<NetStatusProtocolTesterBT> arrayList = new ArrayList<NetStatusProtocolTesterBT>();
                        List list = NetStatusProtocolTester.this.active_tests;
                        synchronized (list) {
                            for (int i = 0; i < NetStatusProtocolTester.this.active_tests.size(); ++i) {
                                NetStatusProtocolTesterBT netStatusProtocolTesterBT = (NetStatusProtocolTesterBT)NetStatusProtocolTester.this.active_tests.get(i);
                                long l2 = netStatusProtocolTesterBT.getStartTime(l);
                                if (l - l2 <= 120000L) continue;
                                arrayList.add(netStatusProtocolTesterBT);
                            }
                        }
                        for (int i = 0; i < arrayList.size(); ++i) {
                            NetStatusProtocolTester.this.removeFromActive((NetStatusProtocolTesterBT)arrayList.get(i));
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromActive(NetStatusProtocolTesterBT netStatusProtocolTesterBT) {
        netStatusProtocolTesterBT.destroy();
        List list = this.active_tests;
        synchronized (list) {
            this.active_tests.remove(netStatusProtocolTesterBT);
            if (this.active_tests.size() == 0 && this.timer_event != null) {
                this.timer_event.cancel();
                this.timer_event = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedDatabaseValue read(DistributedDatabaseContact distributedDatabaseContact, DistributedDatabaseTransferType distributedDatabaseTransferType, DistributedDatabaseKey distributedDatabaseKey) throws DistributedDatabaseException {
        Object object = distributedDatabaseKey.getKey();
        try {
            byte[] byArray = (byte[])object;
            HashWrapper hashWrapper = new HashWrapper(byArray);
            Map map = this.request_history;
            synchronized (map) {
                if (this.request_history.containsKey(hashWrapper)) {
                    return null;
                }
                this.request_history.put(hashWrapper, "");
            }
            map = BDecoder.decode((byte[])object);
            this.log("Received DDB request from " + distributedDatabaseContact.getName() + " - " + map);
            Map map2 = this.receiveRequest(distributedDatabaseContact.getAddress(), map);
            return this.ddb.createValue(BEncoder.encode(map2));
        }
        catch (Throwable throwable) {
            this.log("DDB read failed", throwable);
            return null;
        }
    }

    public void write(DistributedDatabaseContact distributedDatabaseContact, DistributedDatabaseTransferType distributedDatabaseTransferType, DistributedDatabaseKey distributedDatabaseKey, DistributedDatabaseValue distributedDatabaseValue) throws DistributedDatabaseException {
        throw new DistributedDatabaseException("not supported");
    }

    public void log(String string) {
        this.plugin.log(string);
    }

    public void log(String string, Throwable throwable) {
        this.plugin.log(string, throwable);
    }

    protected class testXferType
    implements DistributedDatabaseTransferType {
        protected testXferType() {
        }
    }
}

