/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.removerules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;

public class DownloadRemoveRulesPlugin
implements Plugin,
DownloadManagerListener {
    public static final int INITIAL_DELAY = 60000;
    public static final int DELAYED_REMOVAL_PERIOD = 60000;
    public static final int AELITIS_BIG_TORRENT_SEED_LIMIT = 10000;
    public static final int AELITIS_SMALL_TORRENT_SEED_LIMIT = 1000;
    public static final int MAX_SEED_TO_PEER_RATIO = 10;
    public static final String UPDATE_TRACKER = "tracker.update.vuze.com";
    protected PluginInterface plugin_interface;
    protected boolean closing;
    protected Map dm_listener_map = new HashMap(10);
    protected List monitored_downloads = new ArrayList();
    protected LoggerChannel log;
    protected BooleanParameter remove_unauthorised;
    protected BooleanParameter remove_unauthorised_seeding_only;
    protected BooleanParameter remove_unauthorised_data;
    protected BooleanParameter remove_update_torrents;

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", "Download Remove Rules");
    }

    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.log = this.plugin_interface.getLogger().getChannel("DLRemRules");
        BasicPluginConfigModel basicPluginConfigModel = this.plugin_interface.getUIManager().createBasicPluginConfigModel("torrents", "download.removerules.name");
        basicPluginConfigModel.addLabelParameter2("download.removerules.unauthorised.info");
        this.remove_unauthorised = basicPluginConfigModel.addBooleanParameter2("download.removerules.unauthorised", "download.removerules.unauthorised", false);
        this.remove_unauthorised_seeding_only = basicPluginConfigModel.addBooleanParameter2("download.removerules.unauthorised.seedingonly", "download.removerules.unauthorised.seedingonly", true);
        this.remove_unauthorised_data = basicPluginConfigModel.addBooleanParameter2("download.removerules.unauthorised.data", "download.removerules.unauthorised.data", false);
        this.remove_unauthorised.addEnabledOnSelection(this.remove_unauthorised_seeding_only);
        this.remove_unauthorised.addEnabledOnSelection(this.remove_unauthorised_data);
        this.remove_update_torrents = basicPluginConfigModel.addBooleanParameter2("download.removerules.updatetorrents", "download.removerules.updatetorrents", true);
        new DelayedEvent("DownloadRemovalRules", 60000L, new AERunnable(){

            public void runSupport() {
                DownloadRemoveRulesPlugin.this.plugin_interface.getDownloadManager().addListener(DownloadRemoveRulesPlugin.this);
            }
        });
    }

    public void downloadAdded(final Download download) {
        DiskManagerFileInfo diskManagerFileInfo;
        Object object;
        if (!download.isPersistent()) {
            return;
        }
        if (download.getFlag(16L) && ((DiskManagerFileInfo[])(object = download.getDiskManagerFileInfo())).length == 1 && (diskManagerFileInfo = object[0]).getDownloaded() == diskManagerFileInfo.getLength() && !diskManagerFileInfo.getFile().exists()) {
            this.log.log("Removing low-noise download '" + download.getName() + " as data missing");
            this.removeDownload(download, false);
        }
        object = new DownloadTrackerListener(){

            public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
                if (DownloadRemoveRulesPlugin.this.closing) {
                    return;
                }
                DownloadRemoveRulesPlugin.this.handleScrape(download, downloadScrapeResult);
            }

            public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
                if (DownloadRemoveRulesPlugin.this.closing) {
                    return;
                }
                DownloadRemoveRulesPlugin.this.handleAnnounce(download, downloadAnnounceResult);
            }
        };
        this.monitored_downloads.add(download);
        this.dm_listener_map.put(download, object);
        download.addTrackerListener((DownloadTrackerListener)object);
    }

    protected void handleScrape(Download download, DownloadScrapeResult downloadScrapeResult) {
        String string = downloadScrapeResult.getStatus();
        if (string == null) {
            string = "";
        }
        this.handleAnnounceScrapeStatus(download, string);
    }

    protected void handleAnnounce(Download download, DownloadAnnounceResult downloadAnnounceResult) {
        String string = "";
        if (downloadAnnounceResult.getResponseType() == 2 && (string = downloadAnnounceResult.getError()) == null) {
            string = "";
        }
        this.handleAnnounceScrapeStatus(download, string);
    }

    protected void handleAnnounceScrapeStatus(Download download, String string) {
        String string2;
        if (!this.monitored_downloads.contains(download)) {
            return;
        }
        string = string.toLowerCase();
        boolean bl = download.isComplete();
        if (!(string.indexOf("not authori") == -1 && string.toLowerCase().indexOf("unauthori") == -1 || !this.remove_unauthorised.getValue() || this.remove_unauthorised_seeding_only.getValue() && !bl)) {
            this.log.log((Object)download.getTorrent(), 1, "Download '" + download.getName() + "' is unauthorised and removal triggered");
            this.removeDownload(download, this.remove_unauthorised_data.getValue());
            return;
        }
        Torrent torrent = download.getTorrent();
        if (torrent != null && torrent.getAnnounceURL() != null && (string2 = torrent.getAnnounceURL().toString().toLowerCase()).indexOf(UPDATE_TRACKER) != -1) {
            if (bl && string.indexOf("too many seeds") != -1 || string.indexOf("too many peers") != -1) {
                this.log.log((Object)download.getTorrent(), 1, "Download '" + download.getName() + "' being removed on instruction from the tracker");
                this.removeDownloadDelayed(download, false);
            } else if (bl && this.remove_update_torrents.getValue()) {
                long l;
                long l2 = download.getLastScrapeResult().getSeedCount();
                if (l2 / ((l = (long)download.getLastScrapeResult().getNonSeedCount()) == 0L ? 1L : l) > 10L) {
                    this.log.log((Object)download.getTorrent(), 1, "Download '" + download.getName() + "' being removed to reduce swarm size");
                    this.removeDownloadDelayed(download, false);
                } else {
                    long l3 = download.getCreationTime();
                    long l4 = (SystemTime.getCurrentTime() - l3) / 60000L;
                    if (l4 > 15L) {
                        boolean bl2;
                        boolean bl3 = bl2 = torrent.getSize() > 0x100000L;
                        if (l2 > 10000L && bl2 || l2 > 1000L && !bl2) {
                            this.log.log("Download '" + download.getName() + "' being removed to reduce swarm size");
                            this.removeDownloadDelayed(download, false);
                        }
                    }
                }
            }
        }
    }

    protected void removeDownloadDelayed(final Download download, final boolean bl) {
        this.monitored_downloads.remove(download);
        this.plugin_interface.getUtilities().createThread("delayedRemoval", new AERunnable(){

            public void runSupport() {
                try {
                    Thread.sleep(60000L);
                    DownloadRemoveRulesPlugin.this.removeDownload(download, bl);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        });
    }

    protected void removeDownload(Download download, final boolean bl) {
        this.monitored_downloads.remove(download);
        if (download.getState() == 7) {
            try {
                download.remove(false, bl);
            }
            catch (Throwable throwable) {
                this.log.logAlert("Automatic removal of download '" + download.getName() + "' failed", throwable);
            }
        } else {
            download.addListener(new DownloadListener(){

                public void stateChanged(Download download, int n, int n2) {
                    DownloadRemoveRulesPlugin.this.log.log((Object)download.getTorrent(), 1, "download state changed to '" + n2 + "'");
                    if (n2 == 7) {
                        try {
                            download.remove(false, bl);
                            String string = DownloadRemoveRulesPlugin.this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("download.removerules.removed.ok", new String[]{download.getName()});
                            if (download.getFlag(16L)) {
                                DownloadRemoveRulesPlugin.this.log.log((Object)download.getTorrent(), 1, string);
                            } else {
                                DownloadRemoveRulesPlugin.this.log.logAlert(1, string);
                            }
                        }
                        catch (Throwable throwable) {
                            DownloadRemoveRulesPlugin.this.log.logAlert("Automatic removal of download '" + download.getName() + "' failed", throwable);
                        }
                    }
                }

                public void positionChanged(Download download, int n, int n2) {
                }
            });
            try {
                download.stop();
            }
            catch (DownloadException downloadException) {
                this.log.logAlert("Automatic removal of download '" + download.getName() + "' failed", downloadException);
            }
        }
    }

    public void downloadRemoved(Download download) {
        this.monitored_downloads.remove(download);
        DownloadTrackerListener downloadTrackerListener = (DownloadTrackerListener)this.dm_listener_map.remove(download);
        if (downloadTrackerListener != null) {
            download.removeTrackerListener(downloadTrackerListener);
        }
    }

    public void destroyInitiated() {
        this.closing = true;
    }

    public void destroyed() {
    }
}

