/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;

public class DiskManagerPieceImpl
implements DiskManagerPiece {
    private static final byte PIECE_STATUS_NEEDED = 1;
    private static final byte PIECE_STATUS_WRITTEN = 32;
    private static final byte PIECE_STATUS_CHECKING = 64;
    private static final byte PIECE_STATUS_MASK_DOWNLOADABLE = 97;
    private static final byte PIECE_STATUS_MASK_NEEDS_CHECK = 96;
    private final DiskManagerHelper diskManager;
    private final int pieceNumber;
    private final short nbBlocks;
    protected volatile boolean[] written;
    private byte statusFlags;
    private short read_count;
    private boolean done;

    public DiskManagerPieceImpl(DiskManagerHelper diskManagerHelper, int n, int n2) {
        this.diskManager = diskManagerHelper;
        this.pieceNumber = n;
        this.nbBlocks = (short)((n2 + 16384 - 1) / 16384);
        this.statusFlags = 1;
    }

    public DiskManager getManager() {
        return this.diskManager;
    }

    public int getPieceNumber() {
        return this.pieceNumber;
    }

    public int getLength() {
        return this.diskManager.getPieceLength(this.pieceNumber);
    }

    public int getNbBlocks() {
        return this.nbBlocks;
    }

    public short getReadCount() {
        return this.read_count;
    }

    public void setReadCount(short s) {
        this.read_count = s;
    }

    public int getBlockSize(int n) {
        int n2;
        if (n == this.nbBlocks - 1 && (n2 = this.getLength() % 16384) != 0) {
            return n2;
        }
        return 16384;
    }

    public boolean isSkipped() {
        DMPieceList dMPieceList = this.diskManager.getPieceList(this.pieceNumber);
        for (int i = 0; i < dMPieceList.size(); ++i) {
            if (dMPieceList.get(i).getFile().isSkipped()) continue;
            return false;
        }
        return true;
    }

    public boolean isNeeded() {
        return (this.statusFlags & 1) != 0;
    }

    public boolean calcNeeded() {
        boolean bl = false;
        DMPieceList dMPieceList = this.diskManager.getPieceList(this.pieceNumber);
        for (int i = 0; i < dMPieceList.size(); ++i) {
            DiskManagerFileInfoImpl diskManagerFileInfoImpl = dMPieceList.get(i).getFile();
            long l = diskManagerFileInfoImpl.getLength();
            bl |= l > 0L && diskManagerFileInfoImpl.getDownloaded() < l && !diskManagerFileInfoImpl.isSkipped();
        }
        if (bl) {
            this.statusFlags = (byte)(this.statusFlags | 1);
            return true;
        }
        this.statusFlags = (byte)(this.statusFlags & 0xFFFFFFFE);
        return false;
    }

    public void clearNeeded() {
        this.statusFlags = (byte)(this.statusFlags & 0xFFFFFFFE);
    }

    public void setNeeded() {
        this.statusFlags = (byte)(this.statusFlags | 1);
    }

    public void setNeeded(boolean bl) {
        this.statusFlags = bl ? (byte)(this.statusFlags | 1) : (byte)(this.statusFlags & 0xFFFFFFFE);
    }

    public boolean isWritten() {
        return (this.statusFlags & 0x20) != 0;
    }

    public boolean[] getWritten() {
        return this.written;
    }

    public boolean isWritten(int n) {
        if (this.done) {
            return true;
        }
        boolean[] blArray = this.written;
        if (blArray == null) {
            return false;
        }
        return blArray[n];
    }

    public int getNbWritten() {
        if (this.done) {
            return this.nbBlocks;
        }
        boolean[] blArray = this.written;
        if (blArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }

    public void setWritten(int n) {
        if (this.written == null) {
            this.written = new boolean[this.nbBlocks];
        }
        boolean[] blArray = this.written;
        blArray[n] = true;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (blArray[i]) continue;
            return;
        }
        this.statusFlags = (byte)(this.statusFlags | 0x20);
    }

    public boolean isChecking() {
        return (this.statusFlags & 0x40) != 0;
    }

    public void setChecking() {
        this.statusFlags = (byte)(this.statusFlags | 0x40);
    }

    public boolean isNeedsCheck() {
        return !this.done && (this.statusFlags & 0x60) == 32;
    }

    public boolean calcDone() {
        return this.done;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean bl) {
        if (bl != this.done) {
            this.diskManager.setPieceDone(this, bl);
        }
    }

    public void setDoneSupport(boolean bl) {
        this.done = bl;
        if (this.done) {
            this.written = null;
        }
    }

    public void setDownloadable() {
        this.setDone(false);
        this.statusFlags = (byte)(this.statusFlags & 0xFFFFFF9E);
        this.calcNeeded();
    }

    public boolean isDownloadable() {
        return !this.done && (this.statusFlags & 0x61) == 1;
    }

    public boolean isInteresting() {
        return !this.done && (this.statusFlags & 1) != 0;
    }

    public void reset() {
        this.setDownloadable();
        this.written = null;
    }

    public void reDownloadBlock(int n) {
        boolean[] blArray = this.written;
        if (blArray != null) {
            blArray[n] = false;
            this.setDownloadable();
        }
    }

    public String getString() {
        String string = "";
        string = string + (this.isNeeded() ? "needed," : "");
        string = string + (this.isDone() ? "done," : "");
        if (!this.isDone()) {
            string = string + (this.isDownloadable() ? "downable," : "");
            string = string + (this.isWritten() ? "written" : "written " + this.getNbWritten()) + ",";
            string = string + (this.isChecking() ? "checking" : "");
        }
        if (string.endsWith(",")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

