/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistrationAdapter;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.ForceRecheckListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.download.impl.DownloadManagerRateController;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerFactory;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.NonDaemonTask;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;

public class DownloadManagerController
extends LogRelation
implements PEPeerManagerAdapter,
PeerManagerRegistrationAdapter {
    private static long STATE_FLAG_HASDND = 1L;
    private static long STATE_FLAG_COMPLETE_NO_DND = 2L;
    private static long skeleton_builds;
    private static ExternalSeedPlugin ext_seed_plugin;
    private static boolean ext_seed_plugin_tried;
    private static final int LDT_DL_ADDED = 1;
    private static final int LDT_DL_REMOVED = 2;
    private static ListenerManager disk_listeners_agregator;
    private ListenerManager disk_listeners = ListenerManager.createManager("DMC:DiskListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object object, int n, Object object2) {
            disk_listeners_agregator.dispatch(object, n, object2);
        }
    });
    private AEMonitor disk_listeners_mon = new AEMonitor("DownloadManagerController:DL");
    private AEMonitor control_mon = new AEMonitor("DownloadManagerController");
    private AEMonitor state_mon = new AEMonitor("DownloadManagerController:State");
    private AEMonitor facade_mon = new AEMonitor("DownloadManagerController:Facade");
    private DownloadManagerImpl download_manager;
    private DownloadManagerStatsImpl stats;
    private volatile int state_set_by_method = -1;
    private volatile int substate;
    private volatile boolean force_start;
    private volatile DiskManager disk_manager_use_accessors;
    private DiskManagerListener disk_manager_listener_use_accessors;
    private FileInfoFacadeSet fileFacadeSet = new FileInfoFacadeSet();
    private boolean files_facade_destroyed;
    private boolean cached_complete_excluding_dnd;
    private boolean cached_has_dnd_files;
    private boolean cached_values_set;
    private PeerManagerRegistration peer_manager_registration;
    private PEPeerManager peer_manager;
    private List external_rate_limiters_cow;
    private String errorDetail;
    private GlobalManagerStats global_stats;
    private boolean bInitialized = false;
    private long data_send_rate_at_close;
    private static final int ACTIVATION_REBUILD_TIME = 600000;
    private static final int BLOOM_SIZE = 64;
    private volatile BloomFilter activation_bloom;
    private volatile long activation_bloom_create_time = SystemTime.getCurrentTime();
    private volatile int activation_count;
    private volatile long activation_count_time;
    private boolean piece_checking_enabled = true;
    private long priority_connection_count;
    private static final int HTTP_SEEDS_MAX = 64;
    private LinkedList<ExternalSeedPeer> http_seeds = new LinkedList();

    protected static ExternalSeedPlugin getExternalSeedPlugin() {
        if (!ext_seed_plugin_tried) {
            ext_seed_plugin_tried = true;
            try {
                PluginInterface pluginInterface = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(ExternalSeedPlugin.class);
                if (pluginInterface != null) {
                    ext_seed_plugin = (ExternalSeedPlugin)pluginInterface.getPlugin();
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return ext_seed_plugin;
    }

    protected DownloadManagerController(DownloadManagerImpl downloadManagerImpl) {
        this.download_manager = downloadManagerImpl;
        GlobalManager globalManager = this.download_manager.getGlobalManager();
        this.global_stats = globalManager.getStats();
        this.stats = (DownloadManagerStatsImpl)this.download_manager.getStats();
        this.cached_values_set = false;
    }

    protected void setInitialState(int n) {
        DownloadManagerState downloadManagerState;
        TOTorrent tOTorrent;
        this.bInitialized = true;
        if (this.getState() == -1) {
            this.setState(n, true);
        }
        if ((tOTorrent = this.download_manager.getTorrent()) != null) {
            try {
                this.peer_manager_registration = PeerManager.getSingleton().registerLegacyManager(tOTorrent.getHashWrapper(), this);
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
            }
        }
        if ((downloadManagerState = this.download_manager.getDownloadState()).parameterExists("dndflags")) {
            long l = downloadManagerState.getLongParameter("dndflags");
            this.cached_complete_excluding_dnd = (l & STATE_FLAG_COMPLETE_NO_DND) != 0L;
            this.cached_has_dnd_files = (l & STATE_FLAG_HASDND) != 0L;
            this.cached_values_set = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startDownload(TRTrackerAnnouncer tRTrackerAnnouncer) {
        Object[] objectArray;
        DiskManager diskManager;
        block13: {
            block12: {
                block11: {
                    try {
                        this.control_mon.enter();
                        if (this.getState() != 40) {
                            Debug.out("DownloadManagerController::startDownload state must be ready, " + this.getState());
                            this.setFailed("Inconsistent download state: startDownload, state = " + this.getState());
                            Object var4_2 = null;
                            this.control_mon.exit();
                            return;
                        }
                        if (tRTrackerAnnouncer == null) {
                            Debug.out("DownloadManagerController:startDownload: tracker_client is null");
                            this.stopIt(70, false, false);
                            break block11;
                        }
                        if (this.peer_manager != null) {
                            Debug.out("DownloadManagerController::startDownload: peer manager not null");
                            this.peer_manager.stopAll();
                            DownloadManagerRateController.removePeerManager(this.peer_manager);
                            this.peer_manager = null;
                        }
                        if ((diskManager = this.getDiskManager()) == null) {
                            Debug.out("DownloadManagerController::startDownload: disk manager is null");
                            break block12;
                        }
                        this.setState(50, false);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        this.control_mon.exit();
                        throw throwable;
                    }
                }
                Object var4_3 = null;
                this.control_mon.exit();
                return;
            }
            Object var4_4 = null;
            this.control_mon.exit();
            return;
        }
        List list = null;
        this.control_mon.exit();
        final PEPeerManager pEPeerManager = PEPeerManagerFactory.create(tRTrackerAnnouncer.getPeerId(), this, diskManager);
        this.download_manager.informWillBeStarted(pEPeerManager);
        pEPeerManager.start();
        tRTrackerAnnouncer.setAnnounceDataProvider(new TRTrackerAnnouncerDataProvider(){
            private long last_reported_total_received;
            private long last_reported_total_received_data;
            private long last_reported_total_received_discard;
            private long last_reported_total_received_failed;

            public String getName() {
                return DownloadManagerController.this.getDisplayName();
            }

            public long getTotalSent() {
                return pEPeerManager.getStats().getTotalDataBytesSentNoLan();
            }

            public long getTotalReceived() {
                long l = pEPeerManager.getStats().getTotalDataBytesReceivedNoLan();
                long l2 = pEPeerManager.getStats().getTotalDiscarded();
                long l3 = pEPeerManager.getStats().getTotalHashFailBytes();
                long l4 = l - (l2 + l3);
                if ((l4 -= pEPeerManager.getHiddenBytes()) < this.last_reported_total_received) {
                    l4 = this.last_reported_total_received;
                    if (this.last_reported_total_received_data != -1L) {
                        this.last_reported_total_received_data = -1L;
                    }
                } else {
                    this.last_reported_total_received = l4;
                    this.last_reported_total_received_data = l;
                    this.last_reported_total_received_discard = l2;
                    this.last_reported_total_received_failed = l3;
                }
                return l4 < 0L ? 0L : l4;
            }

            public long getRemaining() {
                return Math.max(pEPeerManager.getRemaining(), pEPeerManager.getHiddenBytes());
            }

            public long getFailedHashCheck() {
                return pEPeerManager.getStats().getTotalHashFailBytes();
            }

            public String getExtensions() {
                return DownloadManagerController.this.getTrackerClientExtensions();
            }

            public int getMaxNewConnectionsAllowed() {
                return pEPeerManager.getMaxNewConnectionsAllowed();
            }

            public int getPendingConnectionCount() {
                return pEPeerManager.getPendingPeerCount();
            }

            public int getConnectedConnectionCount() {
                return pEPeerManager.getNbPeers() + pEPeerManager.getNbSeeds();
            }

            public int getUploadSpeedKBSec(boolean bl) {
                long l = DownloadManagerController.this.stats.getDataSendRate();
                if (bl && (l = DownloadManagerController.this.data_send_rate_at_close) == 0L) {
                    int n;
                    int n2 = DownloadManagerController.this.global_stats.getDataSendRate();
                    if (n2 < (n = DownloadManagerController.this.global_stats.getDataSendRateAtClose())) {
                        n2 = n;
                    }
                    List list = DownloadManagerController.this.download_manager.getGlobalManager().getDownloadManagers();
                    int n3 = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        int n4;
                        DownloadManager downloadManager = (DownloadManager)list.get(i);
                        if (downloadManager.getStats().getDownloadCompleted(false) == 1000 || (n4 = downloadManager.getState()) == 100 || n4 == 65 || n4 == 70) continue;
                        ++n3;
                    }
                    l = n3 == 0 ? (long)n2 : (long)(n2 / n3);
                }
                return (int)((l + 1023L) / 1024L);
            }

            public int getCryptoLevel() {
                return DownloadManagerController.this.download_manager.getCryptoLevel();
            }

            public void setPeerSources(String[] stringArray) {
                Object object;
                DownloadManagerState downloadManagerState = DownloadManagerController.this.download_manager.getDownloadState();
                String[] stringArray2 = PEPeerSource.PS_SOURCES;
                for (int i = 0; i < stringArray2.length; ++i) {
                    object = stringArray2[i];
                    boolean bl = false;
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!((String)object).equals(stringArray[j])) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    downloadManagerState.setPeerSourcePermitted((String)object, false);
                }
                PEPeerManager pEPeerManager2 = DownloadManagerController.this.getPeerManager();
                if (pEPeerManager2 != null) {
                    object = new HashSet();
                    object.addAll(Arrays.asList(stringArray));
                    for (PEPeer pEPeer : pEPeerManager2.getPeers()) {
                        if (object.contains(pEPeer.getPeerSource())) continue;
                        pEPeerManager2.removePeer(pEPeer, "Peer source not permitted");
                    }
                }
            }

            public boolean isPeerSourceEnabled(String string) {
                return DownloadManagerController.this.isPeerSourceEnabled(string);
            }
        });
        try {
            this.control_mon.enter();
            this.peer_manager = pEPeerManager;
            DownloadManagerRateController.addPeerManager(this.peer_manager);
            list = this.external_rate_limiters_cow;
            objectArray = null;
            this.control_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.control_mon.exit();
            throw throwable;
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                objectArray = (Object[])list.get(i);
                pEPeerManager.addRateLimiter((LimitedRateGroup)objectArray[0], (Boolean)objectArray[1]);
            }
        }
        if (this.getState() == 50) {
            this.download_manager.informStateChanged();
        }
        this.download_manager.informStarted(pEPeerManager);
    }

    public void initializeDiskManager(final boolean bl) {
        this.initializeDiskManagerSupport(10, new DiskManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(int n, int n2) {
                DiskManager diskManager;
                try {
                    DownloadManagerController.this.control_mon.enter();
                    diskManager = DownloadManagerController.this.getDiskManager();
                    if (diskManager == null) {
                        Object var5_4 = null;
                        DownloadManagerController.this.control_mon.exit();
                        return;
                    }
                    Object var5_5 = null;
                    DownloadManagerController.this.control_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    DownloadManagerController.this.control_mon.exit();
                    throw throwable;
                }
                try {
                    if (n2 == 10) {
                        DownloadManagerController.this.setFailed(diskManager.getErrorMessage());
                    }
                    if (n == 3 && n2 != 3) {
                        DownloadManagerController.this.fileFacadeSet.makeSureFilesFacadeFilled(true);
                        DownloadManagerController.this.stats.setDownloadCompleted(DownloadManagerController.this.stats.getDownloadCompleted(true));
                        DownloadManagerController.this.download_manager.setAssumedComplete(DownloadManagerController.this.isDownloadComplete(false));
                    }
                    if (n2 == 4) {
                        int n3 = DownloadManagerController.this.stats.getDownloadCompleted(false);
                        if (DownloadManagerController.this.stats.getTotalDataBytesReceived() == 0L && DownloadManagerController.this.stats.getTotalDataBytesSent() == 0L && DownloadManagerController.this.stats.getSecondsDownloading() == 0L) {
                            if (n3 < 1000) {
                                if (bl) {
                                    DownloadManagerController.this.setFailed("File check failed");
                                    DownloadManagerController.this.download_manager.getDownloadState().clearResumeData();
                                } else {
                                    long l = (long)n3 * diskManager.getTotalLength() / 1000L;
                                    DownloadManagerController.this.stats.setSavedDownloadedUploaded(l, l);
                                }
                            } else {
                                int n4 = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                                if (n4 > 0) {
                                    DownloadManagerController.this.stats.setSavedDownloadedUploaded(DownloadManagerController.this.download_manager.getSize() * (long)n4, DownloadManagerController.this.stats.getTotalDataBytesSent());
                                }
                                DownloadManagerController.this.download_manager.getDownloadState().setFlag(1L, true);
                            }
                        }
                        if (n3 == 1000) {
                            DownloadManagerController.this.download_manager.getDownloadState().discardFluff();
                        }
                    }
                    Object var8_11 = null;
                    DownloadManagerController.this.download_manager.informStateChanged();
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    DownloadManagerController.this.download_manager.informStateChanged();
                    throw throwable;
                }
            }

            public void filePriorityChanged(DiskManagerFileInfo diskManagerFileInfo) {
                DownloadManagerController.this.download_manager.informPriorityChange(diskManagerFileInfo);
            }

            public void pieceDoneChanged(DiskManagerPiece diskManagerPiece) {
            }

            public void fileAccessModeChanged(DiskManagerFileInfo diskManagerFileInfo, int n, int n2) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDiskManagerSupport(int n, DiskManagerListener diskManagerListener) {
        try {
            this.control_mon.enter();
            int n2 = this.getState();
            if (n2 != 0 && n2 != 70 && n2 != 75 && n2 != 100) {
                Debug.out("DownloadManagerController::initializeDiskManager: Illegal initialize state, " + n2);
                this.setFailed("Inconsistent download state: initSupport, state = " + n2);
                Object var7_4 = null;
                this.control_mon.exit();
                this.download_manager.informStateChanged();
                return;
            }
            DiskManager diskManager = this.getDiskManager();
            if (diskManager != null) {
                Debug.out("DownloadManagerController::initializeDiskManager: disk manager is not null");
                diskManager.stop(false);
                this.setDiskManager(null, null);
            }
            this.errorDetail = "";
            this.setState(n, false);
            DiskManager diskManager2 = DiskManagerFactory.create(this.download_manager.getTorrent(), this.download_manager);
            this.setDiskManager(diskManager2, diskManagerListener);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.control_mon.exit();
            this.download_manager.informStateChanged();
            throw throwable;
        }
        Object var7_5 = null;
        this.control_mon.exit();
        this.download_manager.informStateChanged();
    }

    public boolean canForceRecheck() {
        int n = this.getState();
        return n == 70 || n == 75 || n == 100 && this.getDiskManager() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRecheck(ForceRecheckListener forceRecheckListener) {
        try {
            this.control_mon.enter();
            if (this.getDiskManager() != null || !this.canForceRecheck()) {
                Debug.out("DownloadManagerController::forceRecheck: illegal entry state");
                Object var5_2 = null;
                this.control_mon.exit();
                return;
            }
            int n = this.getState();
            this.download_manager.getDownloadState().clearResumeData();
            boolean bl = this.force_start;
            this.force_start = true;
            this.download_manager.setDataAlreadyAllocated(false);
            this.initializeDiskManagerSupport(30, new forceRecheckDiskManagerListener(bl, n, forceRecheckListener));
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.control_mon.exit();
            throw throwable;
        }
        Object var5_3 = null;
        this.control_mon.exit();
    }

    public void setPieceCheckingEnabled(boolean bl) {
        this.piece_checking_enabled = bl;
        DiskManager diskManager = this.getDiskManager();
        if (diskManager != null) {
            diskManager.setPieceCheckingEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopIt(int n, boolean bl, boolean bl2) {
        block34: {
            block33: {
                boolean bl3;
                long l = this.stats.getDataSendRate();
                if (l != 0L) {
                    this.data_send_rate_at_close = l;
                }
                boolean bl4 = bl3 = n == 71;
                if (bl3) {
                    n = 70;
                }
                int n2 = n;
                try {
                    try {
                        this.control_mon.enter();
                        int n3 = this.getState();
                        if (n3 == 70 || n3 == 100 && this.getDiskManager() == null) {
                            if (bl2) {
                                this.download_manager.deleteDataFiles();
                            }
                            if (bl) {
                                this.download_manager.deleteTorrentFile();
                            }
                            this.setState(n, false);
                            Object var21_9 = null;
                            this.control_mon.exit();
                            this.download_manager.informStateChanged();
                            return;
                        }
                        if (n3 == 65) {
                            break block33;
                        }
                        this.setSubState(n);
                        this.setState(65, false);
                        final AESemaphore aESemaphore = new AESemaphore("DM:DownloadManager.NDTR");
                        NonDaemonTaskRunner.runAsync(new NonDaemonTask(){

                            public Object run() {
                                aESemaphore.reserve();
                                return null;
                            }

                            public String getName() {
                                return "Stopping '" + DownloadManagerController.this.getDisplayName() + "'";
                            }
                        });
                        try {
                            LinkedList<ExternalSeedPeer> linkedList;
                            ArrayList<ExternalSeedPeer> arrayList;
                            try {
                                if (this.peer_manager != null) {
                                    this.peer_manager.stopAll();
                                    this.stats.saveSessionTotals();
                                    DownloadManagerRateController.removePeerManager(this.peer_manager);
                                }
                                this.download_manager.informStopped(this.peer_manager, n2 == 75);
                                this.peer_manager = null;
                                DiskManager diskManager = this.getDiskManager();
                                if (diskManager != null) {
                                    boolean bl5 = diskManager.stop(bl3);
                                    if (bl5) {
                                        int n4 = 0;
                                        while (!diskManager.isStopped()) {
                                            if (++n4 > 120) {
                                                Debug.out("Download stop took too long to complete");
                                                break;
                                            }
                                            if (n4 % 20 == 0) {
                                                Debug.out("Waiting for download to stop - elapsed=" + n4 + " sec");
                                            }
                                            Thread.sleep(1000L);
                                        }
                                    }
                                    this.stats.setCompleted(this.stats.getCompleted());
                                    this.stats.setDownloadCompleted(this.stats.getDownloadCompleted(true));
                                    if (!this.download_manager.getAssumedComplete()) {
                                        this.download_manager.getDownloadState().save();
                                    }
                                    this.setDiskManager(null, null);
                                }
                                Object var14_18 = null;
                                this.force_start = false;
                                if (bl2) {
                                    this.download_manager.deleteDataFiles();
                                }
                                if (bl) {
                                    this.download_manager.deleteTorrentFile();
                                }
                                arrayList = new ArrayList<ExternalSeedPeer>();
                                linkedList = this.http_seeds;
                            }
                            catch (Throwable throwable) {
                                Object var14_19 = null;
                                this.force_start = false;
                                if (bl2) {
                                    this.download_manager.deleteDataFiles();
                                }
                                if (bl) {
                                    this.download_manager.deleteTorrentFile();
                                }
                                ArrayList<ExternalSeedPeer> arrayList2 = new ArrayList<ExternalSeedPeer>();
                                Object object = this.http_seeds;
                                synchronized (object) {
                                    arrayList2.addAll(this.http_seeds);
                                    this.http_seeds.clear();
                                }
                                object = arrayList2.iterator();
                                while (true) {
                                    if (!object.hasNext()) {
                                        if (this.getState() != 65) throw throwable;
                                        this.setState(n2, true);
                                        throw throwable;
                                    }
                                    ExternalSeedPeer externalSeedPeer = (ExternalSeedPeer)object.next();
                                    externalSeedPeer.remove();
                                }
                            }
                            synchronized (linkedList) {
                                arrayList.addAll(this.http_seeds);
                                this.http_seeds.clear();
                            }
                            for (ExternalSeedPeer externalSeedPeer : arrayList) {
                                externalSeedPeer.remove();
                            }
                            if (this.getState() == 65) {
                                this.setState(n2, true);
                            }
                            Object var19_27 = null;
                            aESemaphore.release();
                            break block34;
                        }
                        catch (Throwable throwable) {
                            Object var19_28 = null;
                            aESemaphore.release();
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        Object var21_12 = null;
                        this.control_mon.exit();
                        this.download_manager.informStateChanged();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var21_13 = null;
                    this.control_mon.exit();
                    this.download_manager.informStateChanged();
                    throw throwable;
                }
            }
            Object var21_10 = null;
            this.control_mon.exit();
            this.download_manager.informStateChanged();
            return;
        }
        Object var21_11 = null;
        this.control_mon.exit();
        this.download_manager.informStateChanged();
    }

    protected void setStateWaiting() {
        this.setState(0, true);
    }

    public void setStateFinishing() {
        this.setState(55, true);
    }

    public void setStateDownloading() {
        if (this.getState() == 60) {
            this.setState(50, true);
        } else if (this.getState() != 50) {
            Logger.log(new LogEvent((Object)this, LogIDs.CORE, 1, "Trying to set state to downloading when state is not seeding"));
        }
    }

    public void setStateSeeding(boolean bl) {
        this.setStateFinishing();
        this.download_manager.downloadEnded(bl);
        this.setState(60, true);
    }

    public boolean isStateSeeding() {
        return this.getState() == 60;
    }

    protected void setStateQueued() {
        this.setState(75, true);
    }

    public int getState() {
        if (this.state_set_by_method != 10) {
            return this.state_set_by_method;
        }
        DiskManager diskManager = this.getDiskManager();
        if (diskManager == null) {
            return 10;
        }
        int n = diskManager.getState();
        if (n == 1) {
            return 10;
        }
        if (n == 2) {
            return 20;
        }
        if (n == 3) {
            return 30;
        }
        if (n == 4) {
            return 40;
        }
        if (n == 10) {
            return 100;
        }
        return 100;
    }

    protected int getSubState() {
        if (this.state_set_by_method == 65) {
            return this.substate;
        }
        return this.getState();
    }

    private void setSubState(int n) {
        this.substate = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int n, boolean bl) {
        boolean bl2 = false;
        try {
            this.state_mon.enter();
            int n2 = this.state_set_by_method;
            if (n2 != n) {
                File file;
                TOTorrent tOTorrent;
                this.state_set_by_method = n;
                if (this.state_set_by_method != 75) {
                    this.activation_bloom = null;
                    if (this.state_set_by_method == 70) {
                        this.activation_count = 0;
                    }
                }
                if (this.state_set_by_method != 75 && this.state_set_by_method == 100 && (tOTorrent = this.download_manager.getTorrent()) != null && !tOTorrent.isSimpleTorrent() && (file = this.download_manager.getAbsoluteSaveLocation()) != null && file.exists() && file.isDirectory()) {
                    TorrentUtils.recursiveEmptyDirDelete(file, false);
                }
            }
            Object var8_7 = null;
            this.state_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.state_mon.exit();
            throw throwable;
        }
        if (bl2) {
            this.filesExist(true);
        }
        if (bl) {
            this.download_manager.informStateChanged();
        }
    }

    public void restartDownload(boolean bl) {
        boolean bl2 = this.isForceStart();
        this.stopIt(70, false, false);
        if (bl) {
            this.download_manager.getDownloadState().clearResumeData();
        }
        this.download_manager.initialize();
        if (bl2) {
            this.setForceStart(true);
        }
    }

    protected void destroy() {
        if (this.peer_manager_registration != null) {
            this.peer_manager_registration.unregister();
            this.peer_manager_registration = null;
        }
        this.fileFacadeSet.destroyFileInfo();
    }

    public boolean isPeerSourceEnabled(String string) {
        return this.download_manager.getDownloadState().isPeerSourceEnabled(string);
    }

    public byte[][] getSecrets() {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        try {
            byte[] byArray = tOTorrent.getHash();
            try {
                byte[] byArray2 = this.getSecret2(tOTorrent);
                return new byte[][]{byArray, byArray2};
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                return new byte[][]{byArray};
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return new byte[0][];
        }
    }

    public byte[][] getSecrets(int n) {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        try {
            byte[] byArray = n == 1 ? tOTorrent.getHash() : this.getSecret2(tOTorrent);
            return new byte[][]{byArray};
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return new byte[0][];
        }
    }

    protected byte[] getSecret2(TOTorrent tOTorrent) throws TOTorrentException {
        AbstractMap abstractMap = this.download_manager.getDownloadState().getMapAttribute("secrets");
        abstractMap = abstractMap == null ? new HashMap() : new LightHashMap(abstractMap);
        if (abstractMap.size() == 0) {
            abstractMap.put("p1", tOTorrent.getPieces()[0]);
            this.download_manager.getDownloadState().setMapAttribute("secrets", abstractMap);
        }
        return (byte[])abstractMap.get("p1");
    }

    public boolean manualRoute(NetworkConnection networkConnection) {
        return false;
    }

    public long getRandomSeed() {
        return this.download_manager.getDownloadState().getLongParameter("rand");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        PEPeerManager pEPeerManager;
        try {
            this.control_mon.enter();
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(this.external_rate_limiters_cow == null ? 1 : this.external_rate_limiters_cow.size() + 1);
            if (this.external_rate_limiters_cow != null) {
                arrayList.addAll(this.external_rate_limiters_cow);
            }
            arrayList.add(new Object[]{limitedRateGroup, new Boolean(bl)});
            this.external_rate_limiters_cow = arrayList;
            pEPeerManager = this.peer_manager;
            Object var6_5 = null;
            this.control_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.control_mon.exit();
            throw throwable;
        }
        if (pEPeerManager != null) {
            pEPeerManager.addRateLimiter(limitedRateGroup, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        PEPeerManager pEPeerManager;
        try {
            this.control_mon.enter();
            if (this.external_rate_limiters_cow != null) {
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>(this.external_rate_limiters_cow.size() - 1);
                for (int i = 0; i < this.external_rate_limiters_cow.size(); ++i) {
                    Object[] objectArray = (Object[])this.external_rate_limiters_cow.get(i);
                    if (objectArray[0] == limitedRateGroup) continue;
                    arrayList.add(objectArray);
                }
                this.external_rate_limiters_cow = arrayList.size() == 0 ? null : arrayList;
            }
            pEPeerManager = this.peer_manager;
            Object var8_7 = null;
            this.control_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.control_mon.exit();
            throw throwable;
        }
        if (pEPeerManager != null) {
            pEPeerManager.removeRateLimiter(limitedRateGroup, bl);
        }
    }

    public void enqueueReadRequest(PEPeer pEPeer, DiskManagerReadRequest diskManagerReadRequest, DiskManagerReadRequestListener diskManagerReadRequestListener) {
        this.getDiskManager().enqueueReadRequest(diskManagerReadRequest, diskManagerReadRequestListener);
    }

    public boolean activateRequest(InetSocketAddress inetSocketAddress) {
        if (this.getState() == 75) {
            byte[] byArray;
            int n;
            BloomFilter bloomFilter = this.activation_bloom;
            if (bloomFilter == null) {
                this.activation_bloom = bloomFilter = BloomFilterFactory.createAddRemove4Bit(64);
            }
            if ((n = bloomFilter.add(byArray = inetSocketAddress.getAddress().getAddress())) > 5) {
                Logger.log(new LogEvent((Object)this, LogIDs.CORE, 1, "Activate request for " + this.getDisplayName() + " from " + inetSocketAddress + " denied as too many recently received"));
                return false;
            }
            Logger.log(new LogEvent(this, LogIDs.CORE, "Activate request for " + this.getDisplayName() + " from " + inetSocketAddress));
            long l = SystemTime.getCurrentTime();
            if (l < this.activation_bloom_create_time || l - this.activation_bloom_create_time > 600000L) {
                this.activation_bloom = BloomFilterFactory.createAddRemove4Bit(64);
                this.activation_bloom_create_time = l;
            }
            this.activation_count = bloomFilter.getEntryCount();
            this.activation_count_time = l;
            return this.download_manager.activateRequest(this.activation_count);
        }
        return false;
    }

    public void deactivateRequest(InetSocketAddress inetSocketAddress) {
        BloomFilter bloomFilter = this.activation_bloom;
        if (bloomFilter != null) {
            byte[] byArray = inetSocketAddress.getAddress().getAddress();
            int n = bloomFilter.count(byArray);
            for (int i = 0; i < n; ++i) {
                bloomFilter.remove(byArray);
            }
            this.activation_count = bloomFilter.getEntryCount();
        }
    }

    public int getActivationCount() {
        long l = SystemTime.getCurrentTime();
        if (l < this.activation_count_time) {
            this.activation_count_time = l;
        } else if (l - this.activation_count_time > 600000L) {
            this.activation_count = 0;
        }
        return this.activation_count;
    }

    public PeerManagerRegistration getPeerManagerRegistration() {
        return this.peer_manager_registration;
    }

    public boolean isForceStart() {
        return this.force_start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForceStart(boolean bl) {
        try {
            this.state_mon.enter();
            if (this.force_start != bl) {
                this.force_start = bl;
                int n = this.getState();
                if (this.force_start && (n == 70 || n == 75)) {
                    this.setState(0, false);
                }
            }
            Object var4_3 = null;
            this.state_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.state_mon.exit();
            throw throwable;
        }
        this.download_manager.informStateChanged();
    }

    protected void setFailed(String string) {
        if (string != null) {
            this.errorDetail = string;
        }
        this.stopIt(100, false, false);
    }

    public boolean filesExist(boolean bl) {
        if (!bl && !this.download_manager.isDataAlreadyAllocated()) {
            return false;
        }
        DiskManager diskManager = this.getDiskManager();
        if (diskManager != null) {
            return diskManager.filesExist();
        }
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        DiskManagerFileInfo[] diskManagerFileInfoArray = this.fileFacadeSet.getFiles();
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[i];
            if (diskManagerFileInfo.isSkipped()) continue;
            File file = diskManagerFileInfo.getFile(true);
            try {
                if (!file.exists()) {
                    File file2;
                    if (!this.download_manager.getTorrent().isSimpleTorrent() && FileUtil.isAncestorOf(file2 = this.download_manager.getAbsoluteSaveLocation(), file) && !file2.exists()) {
                        file = file2;
                    }
                    this.setFailed(MessageText.getString("DownloadManager.error.datamissing") + " " + file);
                    return false;
                }
                if (diskManagerFileInfo.getLength() >= file.length() || COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) continue;
                this.setFailed(MessageText.getString("DownloadManager.error.badsize") + " " + file + "(" + diskManagerFileInfo.getLength() + "/" + file.length() + ")");
                return false;
            }
            catch (Exception exception) {
                this.setFailed(exception.getMessage());
                return false;
            }
        }
        return true;
    }

    public DiskManagerFileInfoSet getDiskManagerFileInfoSet() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        return this.fileFacadeSet;
    }

    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        return this.fileFacadeSet.getFiles();
    }

    protected void fileInfoChanged() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(true);
    }

    protected void filePrioritiesChanged(List list) {
        if (!this.cached_values_set) {
            this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        }
        if (!this.cached_has_dnd_files && list.size() == 1 && !((DiskManagerFileInfo)list.get(0)).isSkipped()) {
            return;
        }
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        this.calculateCompleteness(this.fileFacadeSet.facadeFiles);
    }

    protected void calculateCompleteness(DiskManagerFileInfo[] diskManagerFileInfoArray) {
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[i];
            if (diskManagerFileInfo.isSkipped()) {
                bl2 = true;
            } else if (diskManagerFileInfo.getDownloaded() != diskManagerFileInfo.getLength()) {
                bl = false;
            }
            if (bl2 && !bl) break;
        }
        this.cached_complete_excluding_dnd = bl;
        this.cached_has_dnd_files = bl2;
        this.cached_values_set = true;
        DownloadManagerState downloadManagerState = this.download_manager.getDownloadState();
        long l = (this.cached_complete_excluding_dnd ? STATE_FLAG_COMPLETE_NO_DND : 0L) | (this.cached_has_dnd_files ? STATE_FLAG_HASDND : 0L);
        downloadManagerState.setLongParameter("dndflags", l);
    }

    protected boolean isDownloadComplete(boolean bl) {
        int n;
        if (!this.cached_values_set) {
            this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        }
        if (!this.cached_has_dnd_files) {
            return this.stats.getDownloadCompleted(false) == 1000;
        }
        DiskManager diskManager = this.getDiskManager();
        if (diskManager != null && (n = diskManager.getState()) == 4) {
            long l = bl ? diskManager.getRemaining() : diskManager.getRemainingExcludingDND();
            return l == 0L;
        }
        if (bl) {
            return false;
        }
        return this.cached_complete_excluding_dnd;
    }

    protected PEPeerManager getPeerManager() {
        return this.peer_manager;
    }

    protected DiskManager getDiskManager() {
        return this.disk_manager_use_accessors;
    }

    protected String getErrorDetail() {
        return this.errorDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDiskManager(DiskManager diskManager, DiskManagerListener diskManagerListener) {
        if (diskManager != null) {
            diskManager.setPieceCheckingEnabled(this.piece_checking_enabled);
        }
        try {
            this.disk_listeners_mon.enter();
            DiskManager diskManager2 = this.disk_manager_use_accessors;
            if (diskManager2 != null && this.disk_manager_listener_use_accessors != null) {
                diskManager2.removeListener(this.disk_manager_listener_use_accessors);
            }
            this.disk_manager_use_accessors = diskManager;
            this.disk_manager_listener_use_accessors = diskManagerListener;
            if (diskManager != null) {
                diskManager.addListener(diskManagerListener);
            }
            this.fileInfoChanged();
            if (diskManager == null && diskManager2 != null) {
                this.disk_listeners.dispatch(2, diskManager2);
            } else if (diskManager != null && diskManager2 == null) {
                this.disk_listeners.dispatch(1, diskManager);
            } else {
                Debug.out("inconsistent DiskManager state - " + diskManager + "/" + diskManager2);
            }
            Object var5_4 = null;
            this.disk_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.disk_listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiskListener(DownloadManagerDiskListener downloadManagerDiskListener) {
        try {
            this.disk_listeners_mon.enter();
            this.disk_listeners.addListener(downloadManagerDiskListener);
            DiskManager diskManager = this.getDiskManager();
            if (diskManager != null) {
                this.disk_listeners.dispatch(downloadManagerDiskListener, 1, diskManager);
            }
            Object var4_3 = null;
            this.disk_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.disk_listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiskListener(DownloadManagerDiskListener downloadManagerDiskListener) {
        try {
            this.disk_listeners_mon.enter();
            this.disk_listeners.removeListener(downloadManagerDiskListener);
            Object var3_2 = null;
            this.disk_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.disk_listeners_mon.exit();
            throw throwable;
        }
    }

    public long getDiskListenerCount() {
        return this.disk_listeners.size();
    }

    public String getDisplayName() {
        return this.download_manager.getDisplayName();
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.download_manager.getEffectiveUploadRateLimitBytesPerSecond();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.stats.getDownloadRateLimitBytesPerSecond();
    }

    public int getPermittedBytesToReceive() {
        return NetworkManager.getSingleton().getRateHandler(false, false).getCurrentNumBytesAllowed();
    }

    public void permittedReceiveBytesUsed(int n) {
        NetworkManager.getSingleton().getRateHandler(false, false).bytesProcessed(n);
    }

    public int getPermittedBytesToSend() {
        return NetworkManager.getSingleton().getRateHandler(true, false).getCurrentNumBytesAllowed();
    }

    public void permittedSendBytesUsed(int n) {
        NetworkManager.getSingleton().getRateHandler(true, false).bytesProcessed(n);
    }

    public int getMaxUploads() {
        return this.download_manager.getEffectiveMaxUploads();
    }

    public int getMaxConnections() {
        int n = this.download_manager.isMaxConnectionsWhenSeedingEnabled() && this.isStateSeeding() ? this.download_manager.getMaxConnectionsWhenSeeding() : this.download_manager.getMaxConnections();
        return n;
    }

    public int getMaxSeedConnections() {
        return this.download_manager.getMaxSeedConnections();
    }

    public boolean isExtendedMessagingEnabled() {
        return this.download_manager.isExtendedMessagingEnabled();
    }

    public boolean isPeerExchangeEnabled() {
        return this.download_manager.getDownloadState().isPeerSourceEnabled("PeerExchange");
    }

    public int getCryptoLevel() {
        return this.download_manager.getCryptoLevel();
    }

    public boolean isPeriodicRescanEnabled() {
        return this.download_manager.getDownloadState().getFlag(2L);
    }

    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        return this.download_manager.getTrackerScrapeResponse();
    }

    public String getTrackerClientExtensions() {
        return this.download_manager.getDownloadState().getTrackerClientExtensions();
    }

    public void setTrackerRefreshDelayOverrides(int n) {
        this.download_manager.setTrackerRefreshDelayOverrides(n);
    }

    public boolean isNATHealthy() {
        return this.download_manager.getNATStatus() == 1;
    }

    public void addPeer(PEPeer pEPeer) {
        this.download_manager.addPeer(pEPeer);
    }

    public void removePeer(PEPeer pEPeer) {
        this.download_manager.removePeer(pEPeer);
    }

    public void addPiece(PEPiece pEPiece) {
        this.download_manager.addPiece(pEPiece);
    }

    public void removePiece(PEPiece pEPiece) {
        this.download_manager.removePiece(pEPiece);
    }

    public void discarded(PEPeer pEPeer, int n) {
        if (this.global_stats != null) {
            this.global_stats.discarded(n);
        }
    }

    public void protocolBytesReceived(PEPeer pEPeer, int n) {
        if (this.global_stats != null) {
            this.global_stats.protocolBytesReceived(n, pEPeer.isLANLocal());
        }
    }

    public void dataBytesReceived(PEPeer pEPeer, int n) {
        if (this.global_stats != null) {
            this.global_stats.dataBytesReceived(n, pEPeer.isLANLocal());
        }
    }

    public void protocolBytesSent(PEPeer pEPeer, int n) {
        if (this.global_stats != null) {
            this.global_stats.protocolBytesSent(n, pEPeer.isLANLocal());
        }
    }

    public void dataBytesSent(PEPeer pEPeer, int n) {
        if (this.global_stats != null) {
            this.global_stats.dataBytesSent(n, pEPeer.isLANLocal());
        }
    }

    public int getPosition() {
        return this.download_manager.getPosition();
    }

    public void statsRequest(PEPeer pEPeer, Map map, Map map2) {
        GlobalManager globalManager = this.download_manager.getGlobalManager();
        globalManager.statsRequest(map, map2);
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        map2.put("dl", hashMap);
        try {
            hashMap.put("u_lim", new Long(this.getUploadRateLimitBytesPerSecond()));
            hashMap.put("d_lim", new Long(this.getDownloadRateLimitBytesPerSecond()));
            hashMap.put("u_rate", new Long(this.stats.getProtocolSendRate() + this.stats.getDataSendRate()));
            hashMap.put("d_rate", new Long(this.stats.getProtocolReceiveRate() + this.stats.getDataReceiveRate()));
            hashMap.put("u_slot", new Long(this.getMaxUploads()));
            hashMap.put("c_max", new Long(this.getMaxConnections()));
            hashMap.put("c_leech", new Long(this.download_manager.getNbPeers()));
            hashMap.put("c_seed", new Long(this.download_manager.getNbSeeds()));
            PEPeerManager pEPeerManager = this.peer_manager;
            if (pEPeerManager != null) {
                hashMap.put("c_rem", Integer.valueOf(pEPeerManager.getNbRemoteTCPConnections()));
                List<PEPeer> list = pEPeerManager.getPeers();
                ArrayList<Long> arrayList = new ArrayList<Long>();
                hashMap.put("slot_up", arrayList);
                for (PEPeer pEPeer2 : list) {
                    if (pEPeer2.isChokedByMe()) continue;
                    long l = pEPeer2.getStats().getDataSendRate() + pEPeer2.getStats().getProtocolSendRate();
                    arrayList.add(l);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHTTPSeed(String string, int n) {
        block7: {
            ExternalSeedPlugin externalSeedPlugin = DownloadManagerController.getExternalSeedPlugin();
            try {
                if (externalSeedPlugin == null) break block7;
                HashMap<String, Cloneable> hashMap = new HashMap<String, Cloneable>();
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                String string2 = "http://" + UrlUtils.convertIPV6Host(string) + ":" + n + "/webseed";
                arrayList.add(string2.getBytes());
                hashMap.put("httpseeds", arrayList);
                HashMap<String, Long> hashMap2 = new HashMap<String, Long>();
                hashMap2.put("supports_503", new Long(0L));
                hashMap2.put("transient", new Long(1L));
                hashMap.put("httpseeds-params", hashMap2);
                List<ExternalSeedPeer> list = externalSeedPlugin.addSeed(org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl.getDownloadStatic(this.download_manager), hashMap);
                if (list.size() <= 0) break block7;
                ArrayList<ExternalSeedPeer> arrayList2 = new ArrayList<ExternalSeedPeer>();
                LinkedList<ExternalSeedPeer> linkedList = this.http_seeds;
                synchronized (linkedList) {
                    this.http_seeds.addAll(list);
                    while (this.http_seeds.size() > 64) {
                        ExternalSeedPeer externalSeedPeer = this.http_seeds.removeFirst();
                        arrayList2.add(externalSeedPeer);
                    }
                }
                for (ExternalSeedPeer externalSeedPeer : arrayList2) {
                    externalSeedPeer.remove();
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void priorityConnectionChanged(boolean bl) {
        DownloadManagerController downloadManagerController = this;
        synchronized (downloadManagerController) {
            this.priority_connection_count = bl ? ++this.priority_connection_count : --this.priority_connection_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPriorityConnection() {
        DownloadManagerController downloadManagerController = this;
        synchronized (downloadManagerController) {
            return this.priority_connection_count > 0L;
        }
    }

    public String getDescription() {
        return this.download_manager.getDisplayName();
    }

    public LogRelation getLogRelation() {
        return this;
    }

    public String getRelationText() {
        return this.download_manager.getRelationText();
    }

    public Object[] getQueryableInterfaces() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.download_manager.getQueryableInterfaces();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        arrayList.add(this.download_manager);
        DiskManager diskManager = this.getDiskManager();
        if (diskManager != null) {
            arrayList.add(diskManager);
        }
        return arrayList.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("DownloadManager Controller:");
        indentWriter.indent();
        try {
            indentWriter.println("cached info: complete w/o DND=" + this.cached_complete_excluding_dnd + "; hasDND? " + this.cached_has_dnd_files);
            indentWriter.println("Complete w/DND? " + this.isDownloadComplete(true) + "; w/o DND? " + this.isDownloadComplete(false));
            indentWriter.println("filesFacade length: " + this.fileFacadeSet.nbFiles());
            if (this.force_start) {
                indentWriter.println("Force Start");
            }
            indentWriter.println("FilesExist? " + this.filesExist(this.download_manager.isDataAlreadyAllocated()));
            Object var3_2 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    static {
        disk_listeners_agregator = ListenerManager.createAsyncManager("DMC:DiskListenAgregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object object, int n, Object object2) {
                DownloadManagerDiskListener downloadManagerDiskListener = (DownloadManagerDiskListener)object;
                if (n == 1) {
                    downloadManagerDiskListener.diskManagerAdded((DiskManager)object2);
                } else if (n == 2) {
                    downloadManagerDiskListener.diskManagerRemoved((DiskManager)object2);
                }
            }
        });
    }

    public class forceRecheckDiskManagerListener
    implements DiskManagerListener {
        private final boolean wasForceStarted;
        private final int start_state;
        private final ForceRecheckListener l;

        public forceRecheckDiskManagerListener(boolean bl, int n, ForceRecheckListener forceRecheckListener) {
            this.wasForceStarted = bl;
            this.start_state = n;
            this.l = forceRecheckListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(int n, int n2) {
            try {
                DownloadManagerController.this.control_mon.enter();
                if (DownloadManagerController.this.getDiskManager() == null) {
                    DownloadManagerController.this.download_manager.setAssumedComplete(false);
                    if (this.l != null) {
                        this.l.forceRecheckComplete(DownloadManagerController.this.download_manager);
                    }
                    Object var4_3 = null;
                    DownloadManagerController.this.control_mon.exit();
                    return;
                }
                Object var4_4 = null;
                DownloadManagerController.this.control_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                DownloadManagerController.this.control_mon.exit();
                throw throwable;
            }
            if (n2 == 3) {
                DownloadManagerController.this.fileFacadeSet.makeSureFilesFacadeFilled(true);
            }
            if (n2 == 4 || n2 == 10) {
                DownloadManagerController.this.force_start = this.wasForceStarted;
                DownloadManagerController.this.stats.setDownloadCompleted(DownloadManagerController.this.stats.getDownloadCompleted(true));
                if (n2 == 4) {
                    try {
                        boolean bl = false;
                        boolean bl2 = false;
                        try {
                            DownloadManagerController.this.control_mon.enter();
                            DiskManager diskManager = DownloadManagerController.this.getDiskManager();
                            if (diskManager != null) {
                                diskManager.stop(false);
                                bl = diskManager.getRemainingExcludingDND() == 0L;
                                bl2 = true;
                                DownloadManagerController.this.setDiskManager(null, null);
                                if (this.start_state == 100) {
                                    DownloadManagerController.this.setState(70, false);
                                } else {
                                    DownloadManagerController.this.setState(this.start_state, false);
                                }
                            }
                            Object var7_12 = null;
                            DownloadManagerController.this.control_mon.exit();
                            DownloadManagerController.this.download_manager.informStateChanged();
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            DownloadManagerController.this.control_mon.exit();
                            DownloadManagerController.this.download_manager.informStateChanged();
                            throw throwable;
                        }
                        if (bl2) {
                            DownloadManagerController.this.download_manager.setAssumedComplete(bl);
                        }
                    }
                    catch (Exception exception) {
                        DownloadManagerController.this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(exception));
                    }
                } else {
                    try {
                        DownloadManagerController.this.control_mon.enter();
                        DiskManager diskManager = DownloadManagerController.this.getDiskManager();
                        if (diskManager != null) {
                            diskManager.stop(false);
                            DownloadManagerController.this.setDiskManager(null, null);
                            DownloadManagerController.this.setFailed(diskManager.getErrorMessage());
                        }
                        Object var9_15 = null;
                        DownloadManagerController.this.control_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        DownloadManagerController.this.control_mon.exit();
                        throw throwable;
                    }
                    DownloadManagerController.this.download_manager.setAssumedComplete(false);
                }
                if (this.l != null) {
                    this.l.forceRecheckComplete(DownloadManagerController.this.download_manager);
                }
            }
        }

        public void filePriorityChanged(DiskManagerFileInfo diskManagerFileInfo) {
            DownloadManagerController.this.download_manager.informPriorityChange(diskManagerFileInfo);
        }

        public void pieceDoneChanged(DiskManagerPiece diskManagerPiece) {
        }

        public void fileAccessModeChanged(DiskManagerFileInfo diskManagerFileInfo, int n, int n2) {
        }
    }

    protected class fileInfoFacade
    implements DiskManagerFileInfo {
        private DiskManagerFileInfo delegate;
        private List listeners;

        protected fileInfoFacade() {
        }

        protected void setDelegate(DiskManagerFileInfo diskManagerFileInfo) {
            if (diskManagerFileInfo == this.delegate) {
                return;
            }
            if (this.delegate != null) {
                this.delegate.close();
            }
            this.delegate = diskManagerFileInfo;
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.delegate.addListener((DiskManagerFileInfoListener)this.listeners.get(i));
                }
            }
        }

        public void setPriority(int n) {
            this.delegate.setPriority(n);
        }

        public void setSkipped(boolean bl) {
            this.delegate.setSkipped(bl);
        }

        public boolean setLink(File file) {
            return this.delegate.setLink(file);
        }

        public boolean setLinkAtomic(File file) {
            return this.delegate.setLinkAtomic(file);
        }

        public File getLink() {
            return this.delegate.getLink();
        }

        public boolean setStorageType(int n) {
            return this.delegate.setStorageType(n);
        }

        public int getStorageType() {
            return this.delegate.getStorageType();
        }

        public int getAccessMode() {
            return this.delegate.getAccessMode();
        }

        public long getDownloaded() {
            return this.delegate.getDownloaded();
        }

        public String getExtension() {
            return this.delegate.getExtension();
        }

        public int getFirstPieceNumber() {
            return this.delegate.getFirstPieceNumber();
        }

        public int getLastPieceNumber() {
            return this.delegate.getLastPieceNumber();
        }

        public long getLength() {
            return this.delegate.getLength();
        }

        public int getNbPieces() {
            return this.delegate.getNbPieces();
        }

        public int getPriority() {
            return this.delegate.getPriority();
        }

        public boolean isSkipped() {
            return this.delegate.isSkipped();
        }

        public int getIndex() {
            return this.delegate.getIndex();
        }

        public DiskManager getDiskManager() {
            return this.delegate.getDiskManager();
        }

        public DownloadManager getDownloadManager() {
            return DownloadManagerController.this.download_manager;
        }

        public File getFile(boolean bl) {
            return this.delegate.getFile(bl);
        }

        public TOTorrentFile getTorrentFile() {
            return this.delegate.getTorrentFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCache() throws Exception {
            try {
                DownloadManagerController.this.facade_mon.enter();
                this.delegate.flushCache();
                Object var2_1 = null;
                DownloadManagerController.this.facade_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DownloadManagerController.this.facade_mon.exit();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DirectByteBuffer read(long l, int n) throws IOException {
            try {
                DownloadManagerController.this.facade_mon.enter();
                DirectByteBuffer directByteBuffer = this.delegate.read(l, n);
                Object var6_4 = null;
                DownloadManagerController.this.facade_mon.exit();
                return directByteBuffer;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                DownloadManagerController.this.facade_mon.exit();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                DownloadManagerController.this.facade_mon.enter();
                this.delegate.close();
                Object var2_1 = null;
                DownloadManagerController.this.facade_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DownloadManagerController.this.facade_mon.exit();
                throw throwable;
            }
        }

        public void addListener(DiskManagerFileInfoListener diskManagerFileInfoListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(diskManagerFileInfoListener);
            this.delegate.addListener(diskManagerFileInfoListener);
        }

        public void removeListener(DiskManagerFileInfoListener diskManagerFileInfoListener) {
            this.listeners.remove(diskManagerFileInfoListener);
            this.delegate.removeListener(diskManagerFileInfoListener);
        }
    }

    protected class FileInfoFacadeSet
    implements DiskManagerFileInfoSet {
        DiskManagerFileInfoSet delegate;
        fileInfoFacade[] facadeFiles = new fileInfoFacade[0];

        protected FileInfoFacadeSet() {
        }

        public DiskManagerFileInfo[] getFiles() {
            return this.facadeFiles;
        }

        public int nbFiles() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.nbFiles();
        }

        public void setPriority(int[] nArray) {
            this.delegate.setPriority(nArray);
        }

        public void setSkipped(boolean[] blArray, boolean bl) {
            this.delegate.setSkipped(blArray, bl);
        }

        public boolean[] setStorageTypes(boolean[] blArray, int n) {
            return this.delegate.setStorageTypes(blArray, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fixupFileInfo(fileInfoFacade[] fileInfoFacadeArray) {
            if (fileInfoFacadeArray.length == 0) {
                return;
            }
            final ArrayList arrayList = new ArrayList(0);
            try {
                int n;
                DownloadManagerController.this.facade_mon.enter();
                if (DownloadManagerController.this.files_facade_destroyed) {
                    Object var9_3 = null;
                    DownloadManagerController.this.facade_mon.exit();
                    return;
                }
                DiskManager diskManager = DownloadManagerController.this.getDiskManager();
                DiskManagerFileInfoSet diskManagerFileInfoSet = null;
                if (diskManager != null && ((n = diskManager.getState()) == 3 || n == 4)) {
                    diskManagerFileInfoSet = diskManager.getFileSet();
                }
                if (diskManagerFileInfoSet == null) {
                    final boolean[] blArray = new boolean[]{true};
                    try {
                        skeleton_builds++;
                        if (skeleton_builds % 1000L == 0L) {
                            Debug.outNoStack("Skeleton builds: " + skeleton_builds);
                        }
                        diskManagerFileInfoSet = DiskManagerFactory.getFileInfoSkeleton(DownloadManagerController.this.download_manager, new DiskManagerListener(){

                            public void stateChanged(int n, int n2) {
                            }

                            public void filePriorityChanged(DiskManagerFileInfo diskManagerFileInfo) {
                                if (blArray[0]) {
                                    arrayList.add(diskManagerFileInfo);
                                } else {
                                    DownloadManagerController.this.download_manager.informPriorityChange(diskManagerFileInfo);
                                }
                            }

                            public void pieceDoneChanged(DiskManagerPiece diskManagerPiece) {
                            }

                            public void fileAccessModeChanged(DiskManagerFileInfo diskManagerFileInfo, int n, int n2) {
                            }
                        });
                        Object var7_11 = null;
                        blArray[0] = false;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        blArray[0] = false;
                        throw throwable;
                    }
                    DownloadManagerController.this.calculateCompleteness(diskManagerFileInfoSet.getFiles());
                }
                DiskManagerFileInfo[] diskManagerFileInfoArray = diskManagerFileInfoSet.getFiles();
                for (int i = 0; i < fileInfoFacadeArray.length; ++i) {
                    fileInfoFacadeArray[i].setDelegate(diskManagerFileInfoArray[i]);
                }
                this.delegate = diskManagerFileInfoSet;
            }
            catch (Throwable throwable) {
                Object var9_5 = null;
                DownloadManagerController.this.facade_mon.exit();
                throw throwable;
            }
            Object var9_4 = null;
            DownloadManagerController.this.facade_mon.exit();
            ((DownloadManagerController)DownloadManagerController.this).fileFacadeSet.facadeFiles = fileInfoFacadeArray;
            DownloadManagerController.this.download_manager.informPrioritiesChange(arrayList);
            arrayList.clear();
        }

        private void makeSureFilesFacadeFilled(boolean bl) {
            if (!DownloadManagerController.this.bInitialized) {
                return;
            }
            if (this.facadeFiles.length == 0) {
                fileInfoFacade[] fileInfoFacadeArray = new fileInfoFacade[DownloadManagerController.this.download_manager.getTorrent() == null ? 0 : DownloadManagerController.this.download_manager.getTorrent().getFiles().length];
                for (int i = 0; i < fileInfoFacadeArray.length; ++i) {
                    fileInfoFacadeArray[i] = new fileInfoFacade();
                }
                DownloadManagerController.this.fileFacadeSet.fixupFileInfo(fileInfoFacadeArray);
            } else if (bl) {
                this.fixupFileInfo(this.facadeFiles);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroyFileInfo() {
            try {
                block6: {
                    block5: {
                        DownloadManagerController.this.facade_mon.enter();
                        if (DownloadManagerController.this.fileFacadeSet == null) break block5;
                        if (!DownloadManagerController.this.files_facade_destroyed) break block6;
                    }
                    Object var3_1 = null;
                    DownloadManagerController.this.facade_mon.exit();
                    return;
                }
                DownloadManagerController.this.files_facade_destroyed = true;
                for (int i = 0; i < this.facadeFiles.length; ++i) {
                    this.facadeFiles[i].close();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                DownloadManagerController.this.facade_mon.exit();
                throw throwable;
            }
            Object var3_2 = null;
            DownloadManagerController.this.facade_mon.exit();
        }
    }
}

