/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.CopyOnWriteMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.DownloadManagerStateEvent;
import org.gudy.azureus2.core3.download.DownloadManagerStateListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerDefaultPaths;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.TOTorrentListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class DownloadManagerStateImpl
implements DownloadManagerState,
ParameterListener {
    private static final int VER_INCOMING_PEER_SOURCE = 1;
    private static final int VER_CURRENT = 1;
    private static final LogIDs LOGID;
    private static final String RESUME_KEY = "resume";
    private static final String TRACKER_CACHE_KEY = "tracker_cache";
    private static final String ATTRIBUTE_KEY = "attributes";
    private static final String AZUREUS_PROPERTIES_KEY = "azureus_properties";
    private static final File ACTIVE_DIR;
    public static boolean SUPPRESS_FIXUP_ERRORS;
    private static Random random;
    private static final Map default_parameters;
    private static final Map default_attributes;
    private static AEMonitor class_mon;
    private static Map state_map;
    private static Map global_state_cache;
    private static ArrayList global_state_cache_wrappers;
    private DownloadManagerImpl download_manager;
    private final TorrentUtils.ExtendedTorrent torrent;
    private boolean write_required;
    private Category category;
    private CopyOnWriteList listeners_cow = new CopyOnWriteList();
    private CopyOnWriteMap listeners_read_map_cow = new CopyOnWriteMap();
    private CopyOnWriteMap listeners_write_map_cow = new CopyOnWriteMap();
    private Map parameters;
    private Map attributes;
    private AEMonitor this_mon = new AEMonitor("DownloadManagerState");
    private boolean firstPrimaryFileRead = true;
    private int supressWrites = 0;
    private static ThreadLocal tls_wbr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DownloadManagerState getDownloadState(DownloadManagerImpl downloadManagerImpl, TOTorrent tOTorrent, TorrentUtils.ExtendedTorrent extendedTorrent) throws TOTorrentException {
        byte[] byArray = extendedTorrent.getHash();
        DownloadManagerStateImpl downloadManagerStateImpl = null;
        try {
            class_mon.enter();
            HashWrapper hashWrapper = new HashWrapper(byArray);
            downloadManagerStateImpl = (DownloadManagerStateImpl)state_map.get(hashWrapper);
            if (downloadManagerStateImpl == null) {
                downloadManagerStateImpl = new DownloadManagerStateImpl(downloadManagerImpl, extendedTorrent);
                state_map.put(hashWrapper, downloadManagerStateImpl);
            } else {
                if (downloadManagerStateImpl.getDownloadManager() == null && downloadManagerImpl != null) {
                    downloadManagerStateImpl.setDownloadManager(downloadManagerImpl);
                }
                if (tOTorrent != null) {
                    downloadManagerStateImpl.mergeTorrentDetails(tOTorrent);
                }
            }
            Object var7_6 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            class_mon.exit();
            throw throwable;
        }
        return downloadManagerStateImpl;
    }

    public static DownloadManagerState getDownloadState(TOTorrent tOTorrent) throws TOTorrentException {
        byte[] byArray = tOTorrent.getHash();
        TorrentUtils.ExtendedTorrent extendedTorrent = null;
        File file = DownloadManagerStateImpl.getStateFile(byArray);
        if (file.exists()) {
            try {
                extendedTorrent = TorrentUtils.readDelegateFromFile(file, false);
            }
            catch (Throwable throwable) {
                Debug.out("Failed to load download state for " + file, throwable);
            }
        }
        if (extendedTorrent == null) {
            TorrentUtils.copyToFile(tOTorrent, file);
            extendedTorrent = TorrentUtils.readDelegateFromFile(file, false);
        }
        return DownloadManagerStateImpl.getDownloadState(null, tOTorrent, extendedTorrent);
    }

    protected static DownloadManagerState getDownloadState(DownloadManagerImpl downloadManagerImpl, String string, byte[] byArray, boolean bl) throws TOTorrentException {
        Object object;
        boolean bl2 = state_map.size() > 32;
        TorrentUtils.ExtendedTorrent extendedTorrent = null;
        TorrentUtils.ExtendedTorrent extendedTorrent2 = null;
        if (byArray != null && ((File)(object = DownloadManagerStateImpl.getStateFile(byArray))).exists()) {
            try {
                Map map = (Map)global_state_cache.remove(new HashWrapper(byArray));
                if (map != null) {
                    CachedStateWrapper cachedStateWrapper = new CachedStateWrapper(downloadManagerImpl, string, byArray, map, bl);
                    global_state_cache_wrappers.add(cachedStateWrapper);
                    extendedTorrent2 = cachedStateWrapper;
                } else {
                    extendedTorrent2 = TorrentUtils.readDelegateFromFile((File)object, bl2);
                }
            }
            catch (Throwable throwable) {
                Debug.out("Failed to load download state for " + object);
            }
        }
        if (extendedTorrent2 == null) {
            extendedTorrent = TorrentUtils.readDelegateFromFile(new File(string), bl2);
            byArray = extendedTorrent.getHash();
            object = DownloadManagerStateImpl.getStateFile(byArray);
            if (((File)object).exists()) {
                try {
                    extendedTorrent2 = TorrentUtils.readDelegateFromFile((File)object, bl2);
                }
                catch (Throwable throwable) {
                    Debug.out("Failed to load download state for " + object);
                }
            }
            if (extendedTorrent2 == null) {
                TorrentUtils.copyToFile(extendedTorrent, (File)object);
                extendedTorrent2 = TorrentUtils.readDelegateFromFile((File)object, bl2);
            }
        }
        object = DownloadManagerStateImpl.getDownloadState(downloadManagerImpl, extendedTorrent, extendedTorrent2);
        if (bl) {
            object.setActive(false);
        }
        return object;
    }

    protected static File getStateFile(byte[] byArray) {
        return new File(ACTIVE_DIR, ByteFormatter.encodeString(byArray) + ".dat");
    }

    protected static File getGlobalStateFile() {
        return new File(ACTIVE_DIR, "cache.dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void loadGlobalStateCache() {
        block13: {
            File file = DownloadManagerStateImpl.getGlobalStateFile();
            if (!file.canRead()) {
                return;
            }
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));
                Map map = BDecoder.decode(bufferedInputStream);
                List list = (List)map.get("state");
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        Map map2 = (Map)list.get(i);
                        byte[] byArray = (byte[])map2.get("hash");
                        if (byArray == null) continue;
                        global_state_cache.put(new HashWrapper(byArray), map2);
                    }
                }
                bufferedInputStream.close();
                Object var8_9 = null;
                try {
                    bufferedInputStream.close();
                }
                catch (Throwable throwable) {}
                break block13;
                {
                    catch (IOException iOException) {
                        Debug.printStackTrace(iOException);
                        Object var8_10 = null;
                        try {
                            bufferedInputStream.close();
                        }
                        catch (Throwable throwable) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveGlobalStateCache() {
        try {
            try {
                Object object2;
                class_mon.enter();
                HashMap hashMap = new HashMap();
                ArrayList<Map> arrayList = new ArrayList<Map>();
                hashMap.put("state", arrayList);
                for (Object object2 : state_map.values()) {
                    DownloadManager downloadManager = object2.getDownloadManager();
                    if (downloadManager == null || !downloadManager.isPersistent()) continue;
                    try {
                        Map map = CachedStateWrapper.export((DownloadManagerState)object2);
                        arrayList.add(map);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                object2 = new GZIPOutputStream(new FileOutputStream(DownloadManagerStateImpl.getGlobalStateFile()));
                try {
                    ((FilterOutputStream)object2).write(BEncoder.encode(hashMap));
                    ((DeflaterOutputStream)object2).close();
                }
                catch (IOException iOException) {
                    Debug.printStackTrace(iOException);
                    try {
                        ((DeflaterOutputStream)object2).close();
                    }
                    catch (IOException iOException2) {
                    }
                }
                Object var7_10 = null;
                class_mon.exit();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var7_11 = null;
                class_mon.exit();
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public static void discardGlobalStateCache() {
        DownloadManagerStateImpl.getGlobalStateFile().delete();
        for (int i = 0; i < global_state_cache_wrappers.size(); ++i) {
            ((CachedStateWrapper)global_state_cache_wrappers.get(i)).clearCache();
        }
        global_state_cache_wrappers.clear();
        global_state_cache_wrappers.trimToSize();
    }

    protected DownloadManagerStateImpl(DownloadManagerImpl downloadManagerImpl, TorrentUtils.ExtendedTorrent extendedTorrent) {
        int n;
        Category category;
        String string;
        this.download_manager = downloadManagerImpl;
        this.torrent = extendedTorrent;
        this.attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if ((string = this.getStringAttribute("category")) != null && (category = CategoryManager.getCategory(string)) != null) {
            this.setCategory(category);
        }
        this.parameters = this.getMapAttribute("parameters");
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        if ((n = this.getIntAttribute("version")) < 1) {
            if (this.getPeerSources().length > 0) {
                if (PEPeerSource.isPeerSourceEnabledByDefault("Incoming")) {
                    this.setPeerSourceEnabled("Incoming", true);
                }
            } else {
                this.setPeerSources(PEPeerSource.getDefaultEnabledPeerSources());
            }
        }
        if (n < 1) {
            this.setIntAttribute("version", 1);
        }
        this.addListeners();
    }

    public void parameterChanged(String string) {
        this.informWritten("parameters");
    }

    protected void addListeners() {
        COConfigurationManager.addParameterListener("Max.Peer.Connections.Per.Torrent.When.Seeding", (ParameterListener)this);
        COConfigurationManager.addParameterListener("Max.Peer.Connections.Per.Torrent.When.Seeding.Enable", (ParameterListener)this);
        COConfigurationManager.addParameterListener("Max.Peer.Connections.Per.Torrent", (ParameterListener)this);
        COConfigurationManager.addParameterListener("Max Uploads", (ParameterListener)this);
        COConfigurationManager.addParameterListener("Max Uploads Seeding", (ParameterListener)this);
        COConfigurationManager.addParameterListener("Max Seeds Per Torrent", (ParameterListener)this);
        COConfigurationManager.addParameterListener("enable.seedingonly.maxuploads", (ParameterListener)this);
    }

    protected void removeListeners() {
        COConfigurationManager.removeParameterListener("Max.Peer.Connections.Per.Torrent.When.Seeding", this);
        COConfigurationManager.removeParameterListener("Max.Peer.Connections.Per.Torrent.When.Seeding.Enable", this);
        COConfigurationManager.removeParameterListener("Max.Peer.Connections.Per.Torrent", this);
        COConfigurationManager.removeParameterListener("Max Uploads", this);
        COConfigurationManager.removeParameterListener("Max Uploads Seeding", this);
        COConfigurationManager.removeParameterListener("Max Seeds Per Torrent", this);
        COConfigurationManager.removeParameterListener("enable.seedingonly.maxuploads", this);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    protected void setDownloadManager(DownloadManagerImpl downloadManagerImpl) {
        this.download_manager = downloadManagerImpl;
    }

    public File getStateFile() {
        try {
            File file = new File(ACTIVE_DIR, ByteFormatter.encodeString(this.torrent.getHash()) + File.separatorChar);
            return StringInterner.internFile(file);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    public void clearTrackerResponseCache() {
        this.setTrackerResponseCache(new HashMap());
    }

    public Map getTrackerResponseCache() {
        HashMap hashMap = null;
        hashMap = this.torrent.getAdditionalMapProperty(TRACKER_CACHE_KEY);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackerResponseCache(Map map) {
        try {
            boolean bl;
            this.this_mon.enter();
            boolean bl2 = bl = !BEncoder.mapsAreIdentical(map, this.getTrackerResponseCache());
            if (bl) {
                this.write_required = true;
                this.torrent.setAdditionalMapProperty(TRACKER_CACHE_KEY, map);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getResumeData() {
        try {
            this.this_mon.enter();
            Map map = this.torrent.getAdditionalMapProperty(RESUME_KEY);
            Object var3_2 = null;
            this.this_mon.exit();
            return map;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void clearResumeData() {
        this.setResumeData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResumeData(Map map) {
        try {
            this.this_mon.enter();
            if (map == null) {
                this.setLongAttribute("resumecomplete", 1L);
                this.torrent.removeAdditionalProperty(RESUME_KEY);
            } else {
                this.torrent.setAdditionalMapProperty(RESUME_KEY, map);
                boolean bl = DiskManagerFactory.isTorrentResumeDataComplete(this);
                this.setLongAttribute("resumecomplete", bl ? 2L : 1L);
            }
            this.write_required = true;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.save();
    }

    public boolean isResumeDataComplete() {
        long l = this.getLongAttribute("resumecomplete");
        if (l == 0L) {
            boolean bl = DiskManagerFactory.isTorrentResumeDataComplete(this);
            this.setLongAttribute("resumecomplete", bl ? 2L : 1L);
            return bl;
        }
        return l == 2L;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void setActive(boolean bl) {
        this.torrent.setDiscardFluff(!bl);
    }

    public void discardFluff() {
        this.torrent.setDiscardFluff(true);
    }

    public void suppressStateSave(boolean bl) {
        if (bl) {
            ++this.supressWrites;
        } else if (this.supressWrites > 0) {
            --this.supressWrites;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        boolean bl;
        if (this.supressWrites > 0) {
            return;
        }
        try {
            this.this_mon.enter();
            bl = this.write_required;
            if (this.write_required) {
                this.write_required = false;
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (bl) {
            try {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Saving state for download '" + TorrentUtils.getLocalisedName(this.torrent) + "'"));
                }
                this.torrent.setAdditionalMapProperty(ATTRIBUTE_KEY, this.attributes);
                TorrentUtils.writeToFile((TOTorrent)this.torrent, true);
            }
            catch (Throwable throwable) {
                Logger.log(new LogEvent((Object)this.torrent, LOGID, "Saving state", throwable));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        try {
            try {
                class_mon.enter();
                HashWrapper hashWrapper = this.torrent.getHashWrapper();
                state_map.remove(hashWrapper);
                TorrentUtils.delete(this.torrent);
                File file = new File(ACTIVE_DIR, ByteFormatter.encodeString(hashWrapper.getBytes()));
                if (file.exists() && file.isDirectory()) {
                    FileUtil.recursiveDelete(file);
                }
                this.removeListeners();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var4_5 = null;
                class_mon.exit();
            }
            Object var4_4 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected void mergeTorrentDetails(TOTorrent tOTorrent) {
        try {
            boolean bl = TorrentUtils.mergeAnnounceURLs(tOTorrent, this.torrent);
            if (bl) {
                TRTrackerAnnouncer tRTrackerAnnouncer;
                this.save();
                if (this.download_manager != null && (tRTrackerAnnouncer = this.download_manager.getTrackerClient()) != null) {
                    tRTrackerAnnouncer.resetTrackerUrl(false);
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public void setFlag(long l, boolean bl) {
        long l2;
        long l3 = this.getLongAttribute("flags");
        if (l3 != (l2 = bl ? l3 | l : l3 & (l ^ 0xFFFFFFFFFFFFFFFFL))) {
            this.setLongAttribute("flags", l2);
        }
    }

    public boolean getFlag(long l) {
        long l2 = this.getLongAttribute("flags");
        return (l2 & l) != 0L;
    }

    public long getFlags() {
        return this.getLongAttribute("flags");
    }

    public boolean parameterExists(String string) {
        return this.parameters.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterDefault(String string) {
        try {
            this.this_mon.enter();
            Object v = this.parameters.get(string);
            if (v == null) {
                Object var4_3 = null;
                this.this_mon.exit();
                return;
            }
            this.parameters = new LightHashMap(this.parameters);
            this.parameters.remove(string);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var4_4 = null;
        this.this_mon.exit();
        this.setMapAttribute("parameters", this.parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLongParameter(String string) {
        long l;
        block27: {
            long l2;
            block26: {
                long l3;
                block25: {
                    long l4;
                    block24: {
                        try {
                            void var2_12;
                            this.this_mon.enter();
                            Object v = this.parameters.get(string);
                            if (v == null) {
                                Object v2 = default_parameters.get(string);
                                if (v2 == null) {
                                    Debug.out("Unknown parameter '" + string + "' - must be defined in DownloadManagerState");
                                    long l5 = 0L;
                                    Object var6_23 = null;
                                    this.this_mon.exit();
                                    return l5;
                                }
                                if (string == "max.uploads.when.seeding.enabled") {
                                    if (COConfigurationManager.getBooleanParameter("enable.seedingonly.maxuploads")) {
                                        Boolean bl = new Boolean(true);
                                    }
                                } else if (string == "max.uploads.when.seeding") {
                                    int n = COConfigurationManager.getIntParameter("Max Uploads Seeding");
                                    Integer n2 = new Integer(n);
                                } else if (string == "max.uploads") {
                                    int n = COConfigurationManager.getIntParameter("Max Uploads");
                                    Integer n3 = new Integer(n);
                                } else if (string == "max.peers") {
                                    int n = COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent");
                                    Integer n4 = new Integer(n);
                                } else if (string == "max.peers.when.seeding.enabled") {
                                    if (COConfigurationManager.getBooleanParameter("Max.Peer.Connections.Per.Torrent.When.Seeding.Enable")) {
                                        Boolean bl = new Boolean(true);
                                    }
                                } else if (string == "max.peers.when.seeding") {
                                    int n = COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent.When.Seeding");
                                    Integer n5 = new Integer(n);
                                } else if (string == "max.seeds") {
                                    Integer n = new Integer(COConfigurationManager.getIntParameter("Max Seeds Per Torrent"));
                                } else if (string == "rand") {
                                    long l6 = random.nextLong();
                                    this.setLongParameter(string, l6);
                                    Long l7 = new Long(l6);
                                }
                            }
                            if (var2_12 instanceof Boolean) {
                                l4 = (Boolean)var2_12 != false ? 1 : 0;
                                break block24;
                            }
                            if (var2_12 instanceof Integer) {
                                l3 = ((Integer)var2_12).longValue();
                                break block25;
                            }
                            if (var2_12 instanceof Long) {
                                l2 = (Long)var2_12;
                                break block26;
                            }
                            Debug.out("Invalid parameter value for '" + string + "' - " + var2_12);
                            l = 0L;
                            break block27;
                        }
                        catch (Throwable throwable) {
                            Object var6_28 = null;
                            this.this_mon.exit();
                            throw throwable;
                        }
                    }
                    Object var6_24 = null;
                    this.this_mon.exit();
                    return l4;
                }
                Object var6_25 = null;
                this.this_mon.exit();
                return l3;
            }
            Object var6_26 = null;
            this.this_mon.exit();
            return l2;
        }
        Object var6_27 = null;
        this.this_mon.exit();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLongParameter(String string, long l) {
        Object v = default_parameters.get(string);
        if (v == null) {
            Debug.out("Unknown parameter '" + string + "' - must be defined in DownloadManagerState");
        }
        try {
            this.this_mon.enter();
            this.parameters = new LightHashMap(this.parameters);
            this.parameters.put(string, new Long(l));
            this.setMapAttribute("parameters", this.parameters);
            Object var6_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public int getIntParameter(String string) {
        return (int)this.getLongParameter(string);
    }

    public void setIntParameter(String string, int n) {
        this.setLongParameter(string, n);
    }

    public boolean getBooleanParameter(String string) {
        return this.getLongParameter(string) != 0L;
    }

    public void setBooleanParameter(String string, boolean bl) {
        this.setLongParameter(string, bl ? 1L : 0L);
    }

    public void setAttribute(String string, String string2) {
        if (string.equals("category")) {
            if (string2 == null) {
                this.setCategory(null);
            } else {
                Category category = CategoryManager.getCategory(string2);
                if (category == null) {
                    category = CategoryManager.createCategory(string2);
                }
                this.setCategory(category);
            }
            return;
        }
        if (string.equals("relativepath") && string2.length() > 0) {
            File file = new File(string2);
            string2 = (file = DownloadManagerDefaultPaths.normaliseRelativePath(file)) == null ? "" : file.getPath();
        }
        this.setStringAttribute(string, string2);
    }

    public String getAttribute(String string) {
        if (string.equals("category")) {
            Category category = this.getCategory();
            if (category == null) {
                return null;
            }
            if (category == CategoryManager.getCategory(2)) {
                return null;
            }
            return category.getName();
        }
        return this.getStringAttribute(string);
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        if (category == CategoryManager.getCategory(2)) {
            category = null;
        }
        if (category == this.category) {
            return;
        }
        if (category != null && category.getType() != 0) {
            category = null;
        }
        Category category2 = this.category == null ? CategoryManager.getCategory(2) : this.category;
        this.category = category;
        if (category2 != null) {
            category2.removeManager(this);
        }
        if (this.category != null) {
            this.category.addManager(this);
        }
        if (this.category != null && this.category.getType() == 0) {
            this.setStringAttribute("category", this.category.getName());
        } else {
            this.setStringAttribute("category", null);
        }
    }

    public String getTrackerClientExtensions() {
        return this.getStringAttribute("trackerclientextensions");
    }

    public void setTrackerClientExtensions(String string) {
        this.setStringAttribute("trackerclientextensions", string);
    }

    public String getDisplayName() {
        return this.getStringAttribute("displayname");
    }

    public void setDisplayName(String string) {
        this.setStringAttribute("displayname", string);
    }

    public String getUserComment() {
        return this.getStringAttribute("comment");
    }

    public void setUserComment(String string) {
        this.setStringAttribute("comment", string);
    }

    public String getRelativeSavePath() {
        return this.getStringAttribute("relativepath");
    }

    public String getPrimaryFile() {
        DiskManagerFileInfo[] diskManagerFileInfoArray;
        String string = this.getStringAttribute("primaryfile");
        if ((string == null || string.length() == 0 || this.firstPrimaryFileRead && !new File(string).exists() && this.download_manager.getStats().getDownloadCompleted(true) != 0) && (diskManagerFileInfoArray = this.download_manager.getDiskManagerFileInfo()).length > 0) {
            int n = -1;
            long l = -1L;
            int n2 = 0;
            for (int i = 0; i < diskManagerFileInfoArray.length && n2 < 10; ++i) {
                if (diskManagerFileInfoArray[i].isSkipped()) continue;
                ++n2;
                if (diskManagerFileInfoArray[i].getLength() <= l) continue;
                l = diskManagerFileInfoArray[i].getLength();
                n = i;
            }
            if (n >= 0) {
                string = diskManagerFileInfoArray[n].getFile(true).getPath();
            }
        }
        if (string == null) {
            string = "";
        }
        if (this.firstPrimaryFileRead) {
            this.firstPrimaryFileRead = false;
        }
        this.setPrimaryFile(string);
        return string;
    }

    public void setPrimaryFile(String string) {
        this.setStringAttribute("primaryfile", string);
    }

    public String[] getNetworks() {
        List list = this.getListAttributeSupport("networks");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            for (int j = 0; j < AENetworkClassifier.AT_NETWORKS.length; ++j) {
                String string2 = AENetworkClassifier.AT_NETWORKS[j];
                if (!string2.equals(string)) continue;
                arrayList.add(string2);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public boolean isNetworkEnabled(String string) {
        List list = this.getListAttributeSupport("networks");
        return list.contains(string);
    }

    public void setNetworks(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.setListAttribute("networks", arrayList);
    }

    public void setNetworkEnabled(String string, boolean bl) {
        int n;
        List list = this.getListAttributeSupport("networks");
        boolean bl2 = list.contains(string);
        ArrayList arrayList = new ArrayList();
        if (bl && !bl2) {
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            arrayList.add(string);
            this.setListAttribute("networks", arrayList);
        }
        if (!bl && bl2) {
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            arrayList.remove(string);
            this.setListAttribute("networks", arrayList);
        }
    }

    public String[] getPeerSources() {
        List list = this.getListAttributeSupport("peersources");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            for (int j = 0; j < PEPeerSource.PS_SOURCES.length; ++j) {
                String string2 = PEPeerSource.PS_SOURCES[j];
                if (!string2.equals(string)) continue;
                arrayList.add(string2);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public boolean isPeerSourceEnabled(String string) {
        List list = this.getListAttributeSupport("peersources");
        return list.contains(string);
    }

    public boolean isPeerSourcePermitted(String string) {
        if (string.equals("DHT") && (TorrentUtils.getPrivate(this.torrent) || !TorrentUtils.getDHTBackupEnabled(this.torrent))) {
            return false;
        }
        if (string.equals("PeerExchange") && TorrentUtils.getPrivate(this.torrent)) {
            return false;
        }
        List list = this.getListAttributeSupport("peersourcesdenied");
        return list == null || !list.contains(string);
    }

    public void setPeerSourcePermitted(String string, boolean bl) {
        ArrayList<String> arrayList;
        if (!this.getFlag(32L)) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Attempt to modify permitted peer sources denied as disabled '" + TorrentUtils.getLocalisedName(this.torrent) + "'"));
            return;
        }
        if (!bl) {
            this.setPeerSourceEnabled(string, false);
        }
        if ((arrayList = this.getListAttributeSupport("peersourcesdenied")) == null) {
            if (!bl) {
                arrayList = new ArrayList<String>();
                arrayList.add(string);
                this.setListAttribute("peersourcesdenied", arrayList);
            }
        } else {
            if (bl) {
                arrayList.remove(string);
            } else if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
            this.setListAttribute("peersourcesdenied", arrayList);
        }
    }

    public void setPeerSources(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!this.isPeerSourcePermitted(string)) continue;
            arrayList.add(stringArray[i]);
        }
        this.setListAttribute("peersources", arrayList);
    }

    public void setPeerSourceEnabled(String string, boolean bl) {
        int n;
        if (bl && !this.isPeerSourcePermitted(string)) {
            return;
        }
        List list = this.getListAttributeSupport("peersources");
        boolean bl2 = list.contains(string);
        ArrayList arrayList = new ArrayList();
        if (bl && !bl2) {
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            arrayList.add(string);
            this.setListAttribute("peersources", arrayList);
        }
        if (!bl && bl2) {
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(list.get(n));
            }
            arrayList.remove(string);
            this.setListAttribute("peersources", arrayList);
        }
    }

    public void setFileLink(File file, File file2) {
        CaseSensitiveFileMap caseSensitiveFileMap = this.getFileLinks();
        File file3 = caseSensitiveFileMap.get(file);
        if (file2 == null ? file3 == null : file3 != null && file3.equals(file2)) {
            return;
        }
        caseSensitiveFileMap.put(file, file2);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = caseSensitiveFileMap.keySetIterator();
        while (iterator.hasNext()) {
            File file4 = (File)iterator.next();
            File file5 = caseSensitiveFileMap.get(file4);
            String string = file4 + "\n" + (file5 == null ? "" : file5.toString());
            arrayList.add(string);
        }
        this.setListAttribute("filelinks", arrayList);
    }

    public void clearFileLinks() {
        CaseSensitiveFileMap caseSensitiveFileMap = this.getFileLinks();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = caseSensitiveFileMap.keySetIterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            File file2 = caseSensitiveFileMap.get(file);
            if (file2 != null) {
                bl = true;
            }
            String string = file + "\n";
            arrayList.add(string);
        }
        if (bl) {
            this.setListAttribute("filelinks", arrayList);
        }
    }

    public File getFileLink(File file) {
        return this.getFileLinks().get(file);
    }

    public CaseSensitiveFileMap getFileLinks() {
        List list = this.getListAttributeSupport("filelinks");
        CaseSensitiveFileMap caseSensitiveFileMap = new CaseSensitiveFileMap();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            int n = string.indexOf("\n");
            if (n == -1) continue;
            File file = n == string.length() - 1 ? null : new File(string.substring(n + 1));
            caseSensitiveFileMap.put(new File(string.substring(0, n)), file);
        }
        return caseSensitiveFileMap;
    }

    public boolean isOurContent() {
        Map map = this.getMapAttribute("Plugin.azdirector.ContentMap");
        return map != null && map.containsKey("DIRECTOR PUBLISH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getStringAttribute(String string) {
        Throwable throwable2;
        String string2;
        byte[] byArray;
        block8: {
            block7: {
                this.informWillRead(string);
                this.this_mon.enter();
                if (this.attributes.get(string) instanceof byte[]) break block7;
                String string3 = null;
                Object var6_4 = null;
                this.this_mon.exit();
                return string3;
            }
            byArray = (byte[])this.attributes.get(string);
            if (byArray != null) break block8;
            String string4 = null;
            Object var6_5 = null;
            this.this_mon.exit();
            return string4;
        }
        try {
            string2 = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                Debug.printStackTrace(unsupportedEncodingException);
                String string5 = null;
                Object var6_7 = null;
                this.this_mon.exit();
                return string5;
            }
            catch (Throwable throwable2) {
                Object var6_8 = null;
                this.this_mon.exit();
            }
        }
        Object var6_6 = null;
        this.this_mon.exit();
        return string2;
        throw throwable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStringAttribute(String string, String string2) {
        boolean bl = false;
        try {
            this.this_mon.enter();
            if (string2 == null) {
                if (this.attributes.containsKey(string)) {
                    this.attributes.remove(string);
                    bl = true;
                }
            } else {
                try {
                    byte[] byArray = (byte[])this.attributes.get(string);
                    byte[] byArray2 = string2.getBytes("UTF8");
                    if (byArray == null || !Arrays.equals(byArray, byArray2)) {
                        this.attributes.put(string, byArray2);
                        bl = true;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Debug.printStackTrace(unsupportedEncodingException);
                }
            }
            Object var7_7 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (bl) {
            this.write_required = true;
            this.informWritten(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLongAttribute(String string) {
        long l;
        block8: {
            long l2;
            block7: {
                long l3;
                block6: {
                    this.informWillRead(string);
                    try {
                        this.this_mon.enter();
                        Long l4 = (Long)this.attributes.get(string);
                        if (l4 == null) {
                            Object v = default_attributes.get(string);
                            if (v != null) {
                                if (v instanceof Long) {
                                    long l5 = (Long)v;
                                    Object var7_8 = null;
                                    this.this_mon.exit();
                                    return l5;
                                }
                                if (v instanceof Integer) {
                                    l3 = ((Integer)v).longValue();
                                    break block6;
                                }
                                Debug.out("unknown default type " + v);
                            }
                            l2 = 0L;
                            break block7;
                        }
                        l = l4;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                }
                Object var7_9 = null;
                this.this_mon.exit();
                return l3;
            }
            Object var7_10 = null;
            this.this_mon.exit();
            return l2;
        }
        Object var7_11 = null;
        this.this_mon.exit();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLongAttribute(String string, long l) {
        boolean bl = false;
        try {
            this.this_mon.enter();
            Long l2 = (Long)this.attributes.get(string);
            if (l2 == null || l2 != l) {
                this.attributes.put(string, new Long(l));
                bl = true;
            }
            Object var7_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (bl) {
            this.write_required = true;
            this.informWritten(string);
        }
    }

    public void setListAttribute(String string, String[] stringArray) {
        List<Object> list = stringArray == null ? null : Arrays.asList((Object[])stringArray.clone());
        this.setListAttribute(string, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getListAttribute(String string, int n) {
        block11: {
            Object e;
            block10: {
                List list;
                block9: {
                    if (string.equals("networks") || string.equals("peersources")) {
                        throw new UnsupportedOperationException("not supported right now, implement it yourself :P");
                    }
                    this.informWillRead(string);
                    try {
                        this.this_mon.enter();
                        list = (List)this.attributes.get(string);
                        if (list != null && n < list.size() && n >= 0) break block9;
                        String string2 = null;
                        Object var9_6 = null;
                        this.this_mon.exit();
                        return string2;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                }
                e = list.get(n);
                if (!(e instanceof byte[])) break block10;
                byte[] byArray = (byte[])e;
                String string3 = null;
                try {
                    string3 = StringInterner.intern(new String(byArray, "UTF8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Debug.printStackTrace(unsupportedEncodingException);
                }
                if (string3 != null) {
                    list.set(n, string3);
                }
                String string4 = string3;
                Object var9_7 = null;
                this.this_mon.exit();
                return string4;
            }
            if (!(e instanceof String)) break block11;
            String string5 = (String)e;
            Object var9_8 = null;
            this.this_mon.exit();
            return string5;
        }
        Object var9_9 = null;
        this.this_mon.exit();
        return null;
    }

    public String[] getListAttribute(String string) {
        if (string == "networks") {
            return this.getNetworks();
        }
        if (string == "peersources") {
            return this.getPeerSources();
        }
        List list = this.getListAttributeSupport(string);
        if (list == null) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        try {
            stringArray = list.toArray(stringArray);
        }
        catch (ArrayStoreException arrayStoreException) {
            Debug.out("getListAttribute( " + string + ") - object isnt String - " + arrayStoreException);
            return null;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getListAttributeSupport(String string) {
        this.informWillRead(string);
        try {
            this.this_mon.enter();
            List list = (List)this.attributes.get(string);
            ArrayList<String> arrayList = new ArrayList<String>(list != null ? list.size() : 0);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (e instanceof byte[]) {
                        byte[] byArray = (byte[])e;
                        String string2 = null;
                        try {
                            string2 = StringInterner.intern(new String(byArray, "UTF8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Debug.printStackTrace(unsupportedEncodingException);
                        }
                        if (string2 == null) continue;
                        arrayList.add(string2);
                        list.set(i, string2);
                        continue;
                    }
                    if (!(e instanceof String)) continue;
                    arrayList.add((String)e);
                }
            }
            ArrayList<String> arrayList2 = arrayList;
            Object var10_10 = null;
            this.this_mon.exit();
            return arrayList2;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setListAttribute(String string, List list) {
        boolean bl = false;
        try {
            this.this_mon.enter();
            if (list == null) {
                if (this.attributes.containsKey(string)) {
                    this.attributes.remove(string);
                    bl = true;
                }
            } else {
                List list2 = this.getListAttributeSupport(string);
                if (list2 == null || list2.size() != list.size()) {
                    this.attributes.put(string, list);
                    bl = true;
                } else {
                    if (list2 == list) {
                        Debug.out("setListAttribute: should clone?");
                    }
                    boolean bl2 = bl = !BEncoder.listsAreIdentical(list2, list);
                    if (bl) {
                        this.attributes.put(string, list);
                    }
                }
            }
            Object var6_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (bl) {
            this.write_required = true;
            this.informWritten(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMapAttribute(String string) {
        this.informWillRead(string);
        try {
            Map map;
            this.this_mon.enter();
            Map map2 = map = (Map)this.attributes.get(string);
            Object var5_4 = null;
            this.this_mon.exit();
            return map2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void setMapAttribute(String string, Map map) {
        this.setMapAttribute(string, map, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMapAttribute(String string, Map map, boolean bl) {
        boolean bl2 = false;
        try {
            this.this_mon.enter();
            if (map == null) {
                if (this.attributes.containsKey(string)) {
                    this.attributes.remove(string);
                    bl2 = true;
                }
            } else {
                Map map2 = this.getMapAttribute(string);
                if (map2 == null || map2.size() != map.size()) {
                    this.attributes.put(string, map);
                    bl2 = true;
                } else {
                    if (map2 == map) {
                        Debug.out("setMapAttribute: should clone?");
                    }
                    boolean bl3 = bl2 = !BEncoder.mapsAreIdentical(map2, map);
                    if (bl2) {
                        this.attributes.put(string, map);
                    }
                }
            }
            Object var7_6 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (bl2 && !bl) {
            this.write_required = true;
            this.informWritten(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute(String string) {
        block3: {
            try {
                this.this_mon.enter();
                if (this.attributes != null) break block3;
                boolean bl = false;
                Object var4_4 = null;
                this.this_mon.exit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        boolean bl = this.attributes.containsKey(string);
        Object var4_5 = null;
        this.this_mon.exit();
        return bl;
    }

    public void setIntAttribute(String string, int n) {
        this.setLongAttribute(string, n);
    }

    public int getIntAttribute(String string) {
        return (int)this.getLongAttribute(string);
    }

    public void setBooleanAttribute(String string, boolean bl) {
        this.setLongAttribute(string, bl ? 1 : 0);
    }

    public boolean getBooleanAttribute(String string) {
        return this.getLongAttribute(string) != 0L;
    }

    public static DownloadManagerState getDownloadState(DownloadManager downloadManager) {
        return new nullState(downloadManager);
    }

    protected void informWritten(final String string) {
        List list = this.listeners_cow.getList();
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((DownloadManagerStateListener)list.get(i)).stateChanged(this, new DownloadManagerStateEvent(){

                    public int getType() {
                        return 1;
                    }

                    public Object getData() {
                        return string;
                    }
                });
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        list = null;
        CopyOnWriteList copyOnWriteList = (CopyOnWriteList)this.listeners_write_map_cow.get(string);
        if (copyOnWriteList != null) {
            list = copyOnWriteList.getList();
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    ((DownloadManagerStateAttributeListener)list.get(i)).attributeEventOccurred(this.download_manager, string, 1);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informWillRead(final String string) {
        List list = (List)tls_wbr.get();
        if (!list.contains(string)) {
            list.add(string);
            try {
                List list2 = this.listeners_cow.getList();
                for (int i = 0; i < list2.size(); ++i) {
                    try {
                        ((DownloadManagerStateListener)list2.get(i)).stateChanged(this, new DownloadManagerStateEvent(){

                            public int getType() {
                                return 2;
                            }

                            public Object getData() {
                                return string;
                            }
                        });
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                list2 = null;
                CopyOnWriteList copyOnWriteList = null;
                copyOnWriteList = (CopyOnWriteList)this.listeners_read_map_cow.get(string);
                if (copyOnWriteList != null) {
                    list2 = copyOnWriteList.getList();
                }
                if (list2 != null) {
                    for (int i = 0; i < list2.size(); ++i) {
                        try {
                            ((DownloadManagerStateAttributeListener)list2.get(i)).attributeEventOccurred(this.download_manager, string, 2);
                            continue;
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
                Object var8_9 = null;
                list.remove(string);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                list.remove(string);
                throw throwable;
            }
            {
            }
        }
    }

    public void addListener(DownloadManagerStateListener downloadManagerStateListener) {
        this.listeners_cow.add(downloadManagerStateListener);
    }

    public void removeListener(DownloadManagerStateListener downloadManagerStateListener) {
        this.listeners_cow.remove(downloadManagerStateListener);
    }

    public void addListener(DownloadManagerStateAttributeListener downloadManagerStateAttributeListener, String string, int n) {
        CopyOnWriteMap copyOnWriteMap = n == 2 ? this.listeners_read_map_cow : this.listeners_write_map_cow;
        CopyOnWriteList<DownloadManagerStateAttributeListener> copyOnWriteList = (CopyOnWriteList<DownloadManagerStateAttributeListener>)copyOnWriteMap.get(string);
        if (copyOnWriteList == null) {
            copyOnWriteList = new CopyOnWriteList<DownloadManagerStateAttributeListener>();
            copyOnWriteMap.put(string, copyOnWriteList);
        }
        copyOnWriteList.add(downloadManagerStateAttributeListener);
    }

    public void removeListener(DownloadManagerStateAttributeListener downloadManagerStateAttributeListener, String string, int n) {
        CopyOnWriteMap copyOnWriteMap = n == 2 ? this.listeners_read_map_cow : this.listeners_write_map_cow;
        CopyOnWriteList copyOnWriteList = (CopyOnWriteList)copyOnWriteMap.get(string);
        if (copyOnWriteList != null) {
            copyOnWriteList.remove(downloadManagerStateAttributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("DownloadManagerState");
        try {
            indentWriter.indent();
            indentWriter.println("parameters=" + this.parameters);
            indentWriter.println("primary file=" + Debug.secretFileName(this.getPrimaryFile()));
            Object var3_2 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    static {
        int n;
        LOGID = LogIDs.DISK;
        SUPPRESS_FIXUP_ERRORS = false;
        ACTIVE_DIR = FileUtil.getUserFile("active");
        if (!ACTIVE_DIR.exists()) {
            FileUtil.mkdirs(ACTIVE_DIR);
        }
        random = RandomUtils.SECURE_RANDOM;
        default_parameters = new HashMap();
        for (n = 0; n < PARAMETERS.length; ++n) {
            default_parameters.put(PARAMETERS[n][0], PARAMETERS[n][1]);
        }
        default_attributes = new HashMap();
        for (n = 0; n < ATTRIBUTE_DEFAULTS.length; ++n) {
            default_attributes.put(ATTRIBUTE_DEFAULTS[n][0], ATTRIBUTE_DEFAULTS[n][1]);
        }
        TorrentUtils.registerMapFluff(new String[]{TRACKER_CACHE_KEY, RESUME_KEY});
        class_mon = new AEMonitor("DownloadManagerState:class");
        state_map = new HashMap();
        global_state_cache = new HashMap();
        global_state_cache_wrappers = new ArrayList();
        tls_wbr = new ThreadLocal(){

            public Object initialValue() {
                return new ArrayList(1);
            }
        };
    }

    protected static class CachedStateWrapper
    extends LogRelation
    implements TorrentUtils.ExtendedTorrent {
        private DownloadManagerImpl download_manager;
        private String torrent_file;
        private HashWrapper torrent_hash_wrapper;
        private Map cache;
        private Map cache_attributes;
        private Map cache_azp;
        private volatile TorrentUtils.ExtendedTorrent delegate;
        private TOTorrentException fixup_failure;
        private boolean discard_pieces;
        private boolean logged_failure;
        private Boolean simple_torrent;
        private long size;
        private URL announce_url;
        private cacheGroup announce_group;
        private volatile boolean discard_fluff;

        protected CachedStateWrapper(DownloadManagerImpl downloadManagerImpl, String string, byte[] byArray, Map map, boolean bl) {
            List list;
            byte[] byArray2;
            Long l;
            Long l2;
            this.download_manager = downloadManagerImpl;
            this.torrent_file = string;
            this.torrent_hash_wrapper = new HashWrapper(byArray);
            this.cache = map;
            this.cache_attributes = (Map)this.cache.get(DownloadManagerStateImpl.ATTRIBUTE_KEY);
            this.cache_azp = (Map)this.cache.get("azp");
            if (bl) {
                this.discard_pieces = true;
            } else {
                l2 = (Long)this.cache.get("dp");
                if (l2 != null) {
                    this.discard_pieces = l2 == 1L;
                }
            }
            l2 = (Long)this.cache.get("simple");
            if (l2 != null) {
                this.simple_torrent = new Boolean(l2 == 1L);
            }
            if ((l = (Long)this.cache.get("size")) != null) {
                this.size = l;
            }
            if ((byArray2 = (byte[])this.cache.get("au")) != null) {
                try {
                    this.announce_url = StringInterner.internURL(new URL(new String(byArray2, "UTF-8")));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((list = (List)this.cache.get("ag")) != null) {
                try {
                    this.announce_group = this.importGroup(list);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        protected static Map export(DownloadManagerState downloadManagerState) throws TOTorrentException {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            TOTorrent tOTorrent = downloadManagerState.getTorrent();
            hashMap.put("hash", tOTorrent.getHash());
            hashMap.put("name", tOTorrent.getName());
            hashMap.put("utf8name", tOTorrent.getUTF8Name() == null ? "" : tOTorrent.getUTF8Name());
            hashMap.put("comment", tOTorrent.getComment());
            hashMap.put("createdby", tOTorrent.getCreatedBy());
            hashMap.put("size", new Long(tOTorrent.getSize()));
            hashMap.put("encoding", tOTorrent.getAdditionalStringProperty("encoding"));
            hashMap.put("torrent filename", tOTorrent.getAdditionalStringProperty("torrent filename"));
            hashMap.put(DownloadManagerStateImpl.ATTRIBUTE_KEY, tOTorrent.getAdditionalMapProperty(DownloadManagerStateImpl.ATTRIBUTE_KEY));
            hashMap.put("azp", tOTorrent.getAdditionalMapProperty(DownloadManagerStateImpl.AZUREUS_PROPERTIES_KEY));
            try {
                hashMap.put("au", tOTorrent.getAnnounceURL().toExternalForm());
                hashMap.put("ag", CachedStateWrapper.exportGroup(tOTorrent.getAnnounceURLGroup()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            boolean bl = downloadManagerState.isResumeDataComplete();
            TOTorrent tOTorrent2 = downloadManagerState.getTorrent();
            if (tOTorrent2 instanceof CachedStateWrapper) {
                Boolean bl2;
                CachedStateWrapper cachedStateWrapper = (CachedStateWrapper)tOTorrent2;
                if (!bl) {
                    boolean bl3 = bl = cachedStateWrapper.peekPieces() == null;
                }
                if ((bl2 = cachedStateWrapper.simple_torrent) != null) {
                    hashMap.put("simple", new Long(bl2 != false ? 1L : 0L));
                }
            }
            hashMap.put("dp", new Long(bl ? 1L : 0L));
            return hashMap;
        }

        protected static List exportGroup(TOTorrentAnnounceURLGroup tOTorrentAnnounceURLGroup) {
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrentAnnounceURLGroup.getAnnounceURLSets();
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
                TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = tOTorrentAnnounceURLSetArray[i];
                URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
                if (uRLArray.length <= 0) continue;
                ArrayList<String> arrayList2 = new ArrayList<String>(uRLArray.length);
                for (int j = 0; j < uRLArray.length; ++j) {
                    arrayList2.add(uRLArray[j].toExternalForm());
                }
                arrayList.add(arrayList2);
            }
            return arrayList;
        }

        protected cacheGroup importGroup(List list) throws Exception {
            return new cacheGroup(list);
        }

        protected void clearCache() {
            this.cache = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean fixup() {
            try {
                if (this.delegate == null) {
                    CachedStateWrapper cachedStateWrapper = this;
                    synchronized (cachedStateWrapper) {
                        if (this.delegate == null) {
                            if (this.fixup_failure != null) {
                                throw this.fixup_failure;
                            }
                            this.delegate = this.loadRealState();
                            if (this.discard_fluff) {
                                this.delegate.setDiscardFluff(this.discard_fluff);
                            }
                            if (this.cache != null) {
                                Debug.out("Cache miss forced fixup");
                            }
                            this.cache = null;
                            if (this.cache_attributes != null) {
                                this.delegate.setAdditionalMapProperty(DownloadManagerStateImpl.ATTRIBUTE_KEY, this.cache_attributes);
                                this.cache_attributes = null;
                            }
                            if (this.cache_azp != null) {
                                this.delegate.setAdditionalMapProperty(DownloadManagerStateImpl.AZUREUS_PROPERTIES_KEY, this.cache_azp);
                                this.cache_azp = null;
                            }
                            this.announce_url = null;
                            if (this.announce_group != null) {
                                this.announce_group.fixGroup();
                                this.announce_group = null;
                            }
                        }
                    }
                }
                return true;
            }
            catch (TOTorrentException tOTorrentException) {
                this.fixup_failure = tOTorrentException;
                if (this.download_manager != null) {
                    this.download_manager.setTorrentInvalid(Debug.getNestedExceptionMessage(tOTorrentException));
                } else if (!this.logged_failure) {
                    this.logged_failure = true;
                    Debug.out("Torrent can't be loaded: " + Debug.getNestedExceptionMessage(tOTorrentException));
                }
                return false;
            }
        }

        protected TorrentUtils.ExtendedTorrent loadRealState() throws TOTorrentException {
            File file;
            if (!SUPPRESS_FIXUP_ERRORS && Constants.isCVSVersion() && !Thread.currentThread().isDaemon()) {
                Debug.out("Premature fixup?");
            }
            if ((file = DownloadManagerStateImpl.getStateFile(this.torrent_hash_wrapper.getBytes())).exists()) {
                try {
                    return TorrentUtils.readDelegateFromFile(file, this.discard_pieces);
                }
                catch (Throwable throwable) {
                    Debug.out("Failed to load download state for " + file);
                }
            }
            TOTorrent tOTorrent = TorrentUtils.readFromFile(new File(this.torrent_file), true);
            this.torrent_hash_wrapper = tOTorrent.getHashWrapper();
            file = DownloadManagerStateImpl.getStateFile(this.torrent_hash_wrapper.getBytes());
            if (file.exists()) {
                try {
                    return TorrentUtils.readDelegateFromFile(file, this.discard_pieces);
                }
                catch (Throwable throwable) {
                    Debug.out("Failed to load download state for " + file);
                }
            }
            TorrentUtils.copyToFile(tOTorrent, file);
            return TorrentUtils.readDelegateFromFile(file, this.discard_pieces);
        }

        public byte[] getName() {
            byte[] byArray;
            Map map = this.cache;
            if (map != null && (byArray = (byte[])map.get("name")) != null) {
                return byArray;
            }
            if (this.fixup()) {
                return this.delegate.getName();
            }
            return ("Error - " + Debug.getNestedExceptionMessage(this.fixup_failure)).getBytes();
        }

        public String getUTF8Name() {
            byte[] byArray;
            Map map = this.cache;
            if (map != null && (byArray = (byte[])map.get("utf8name")) != null) {
                String string;
                try {
                    string = new String(byArray, "utf8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
                if (string.length() == 0) {
                    return null;
                }
                return string;
            }
            if (this.fixup()) {
                return this.delegate.getUTF8Name();
            }
            return null;
        }

        public boolean isSimpleTorrent() {
            if (this.simple_torrent != null) {
                return this.simple_torrent;
            }
            if (this.fixup()) {
                boolean bl = this.delegate.isSimpleTorrent();
                this.simple_torrent = new Boolean(bl);
                return bl;
            }
            return false;
        }

        public byte[] getComment() {
            Map map = this.cache;
            if (map != null) {
                return (byte[])map.get("comment");
            }
            if (this.fixup()) {
                return this.delegate.getComment();
            }
            return null;
        }

        public void setComment(String string) {
            if (this.fixup()) {
                this.delegate.setComment(string);
            }
        }

        public long getCreationDate() {
            if (this.fixup()) {
                return this.delegate.getCreationDate();
            }
            return 0L;
        }

        public void setCreationDate(long l) {
            if (this.fixup()) {
                this.delegate.setCreationDate(l);
            }
        }

        public byte[] getCreatedBy() {
            Map map = this.cache;
            if (map != null) {
                return (byte[])map.get("createdby");
            }
            if (this.fixup()) {
                return this.delegate.getCreatedBy();
            }
            return null;
        }

        public void setCreatedBy(byte[] byArray) {
            if (this.fixup()) {
                this.delegate.setCreatedBy(byArray);
            }
        }

        public boolean isCreated() {
            if (this.fixup()) {
                return this.delegate.isCreated();
            }
            return false;
        }

        public URL getAnnounceURL() {
            if (this.announce_url != null) {
                return this.announce_url;
            }
            if (this.fixup()) {
                return this.delegate.getAnnounceURL();
            }
            return null;
        }

        public boolean setAnnounceURL(URL uRL) {
            if (this.fixup()) {
                return this.delegate.setAnnounceURL(uRL);
            }
            this.announce_url = uRL;
            return false;
        }

        public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
            if (this.announce_group != null) {
                return this.announce_group;
            }
            if (this.fixup()) {
                return this.delegate.getAnnounceURLGroup();
            }
            return null;
        }

        public byte[][] getPieces() throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.getPieces();
            }
            throw this.fixup_failure;
        }

        public void setPieces(byte[][] byArray) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.setPieces(byArray);
                return;
            }
            throw this.fixup_failure;
        }

        public byte[][] peekPieces() throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.peekPieces();
            }
            throw this.fixup_failure;
        }

        public void setDiscardFluff(boolean bl) {
            this.discard_fluff = bl;
            if (this.delegate != null) {
                this.delegate.setDiscardFluff(this.discard_fluff);
            }
        }

        public long getPieceLength() {
            if (this.fixup()) {
                return this.delegate.getPieceLength();
            }
            return 0L;
        }

        public int getNumberOfPieces() {
            if (this.fixup()) {
                return this.delegate.getNumberOfPieces();
            }
            return 0;
        }

        public long getSize() {
            if (this.size > 0L) {
                return this.size;
            }
            if (this.fixup()) {
                this.size = this.delegate.getSize();
                return this.size;
            }
            return 0L;
        }

        public TOTorrentFile[] getFiles() {
            if (this.fixup()) {
                return this.delegate.getFiles();
            }
            return new TOTorrentFile[0];
        }

        public byte[] getHash() throws TOTorrentException {
            return this.torrent_hash_wrapper.getBytes();
        }

        public HashWrapper getHashWrapper() throws TOTorrentException {
            return this.torrent_hash_wrapper;
        }

        public void setHashOverride(byte[] byArray) throws TOTorrentException {
            throw new TOTorrentException("Not supported", 8);
        }

        public boolean hasSameHashAs(TOTorrent tOTorrent) {
            try {
                byte[] byArray = tOTorrent.getHash();
                return Arrays.equals(this.getHash(), byArray);
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
                return false;
            }
        }

        public boolean getPrivate() {
            if (this.fixup()) {
                return this.delegate.getPrivate();
            }
            return false;
        }

        public void setPrivate(boolean bl) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.setPrivate(bl);
            }
        }

        public void setAdditionalStringProperty(String string, String string2) {
            if (this.fixup()) {
                this.delegate.setAdditionalStringProperty(string, string2);
            }
        }

        public String getAdditionalStringProperty(String string) {
            Map map = this.cache;
            if (map != null && (string.equals("encoding") || string.equals("torrent filename"))) {
                byte[] byArray = (byte[])map.get(string);
                if (byArray == null) {
                    return null;
                }
                try {
                    return new String(byArray, "UTF8");
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    return null;
                }
            }
            if (this.fixup()) {
                return this.delegate.getAdditionalStringProperty(string);
            }
            return null;
        }

        public void setAdditionalByteArrayProperty(String string, byte[] byArray) {
            if (this.fixup()) {
                this.delegate.setAdditionalByteArrayProperty(string, byArray);
            }
        }

        public byte[] getAdditionalByteArrayProperty(String string) {
            if (this.fixup()) {
                return this.delegate.getAdditionalByteArrayProperty(string);
            }
            return null;
        }

        public void setAdditionalLongProperty(String string, Long l) {
            if (this.fixup()) {
                this.delegate.setAdditionalLongProperty(string, l);
            }
        }

        public Long getAdditionalLongProperty(String string) {
            if (this.fixup()) {
                return this.delegate.getAdditionalLongProperty(string);
            }
            return null;
        }

        public void setAdditionalListProperty(String string, List list) {
            if (this.fixup()) {
                this.delegate.setAdditionalListProperty(string, list);
            }
        }

        public List getAdditionalListProperty(String string) {
            if (this.fixup()) {
                return this.delegate.getAdditionalListProperty(string);
            }
            return null;
        }

        public void setAdditionalMapProperty(String string, Map map) {
            if (this.fixup()) {
                this.delegate.setAdditionalMapProperty(string, map);
            }
        }

        public Map getAdditionalMapProperty(String string) {
            Map map = this.cache_attributes;
            if (map != null && string.equals(DownloadManagerStateImpl.ATTRIBUTE_KEY)) {
                return map;
            }
            map = this.cache_azp;
            if (map != null && string.equals(DownloadManagerStateImpl.AZUREUS_PROPERTIES_KEY)) {
                return map;
            }
            if (this.fixup()) {
                return this.delegate.getAdditionalMapProperty(string);
            }
            return null;
        }

        public Object getAdditionalProperty(String string) {
            if (this.fixup()) {
                return this.delegate.getAdditionalProperty(string);
            }
            return null;
        }

        public void setAdditionalProperty(String string, Object object) {
            if (this.fixup()) {
                this.delegate.setAdditionalProperty(string, object);
            }
        }

        public void removeAdditionalProperty(String string) {
            if (this.fixup()) {
                this.delegate.removeAdditionalProperty(string);
            }
        }

        public void removeAdditionalProperties() {
            if (this.fixup()) {
                this.delegate.removeAdditionalProperties();
            }
        }

        public void serialiseToBEncodedFile(File file) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.serialiseToBEncodedFile(file);
                return;
            }
            throw this.fixup_failure;
        }

        public Map serialiseToMap() throws TOTorrentException {
            if (this.fixup()) {
                return this.delegate.serialiseToMap();
            }
            throw this.fixup_failure;
        }

        public void serialiseToXMLFile(File file) throws TOTorrentException {
            if (this.fixup()) {
                this.delegate.serialiseToXMLFile(file);
                return;
            }
            throw this.fixup_failure;
        }

        public void addListener(TOTorrentListener tOTorrentListener) {
            if (this.fixup()) {
                this.delegate.addListener(tOTorrentListener);
            }
        }

        public void removeListener(TOTorrentListener tOTorrentListener) {
            if (this.fixup()) {
                this.delegate.removeListener(tOTorrentListener);
            }
        }

        public AEMonitor getMonitor() {
            if (this.fixup()) {
                return this.delegate.getMonitor();
            }
            return null;
        }

        public void print() {
            if (this.fixup()) {
                this.delegate.print();
            }
        }

        public String getRelationText() {
            return "Torrent: '" + new String(this.getName()) + "'";
        }

        public Object[] getQueryableInterfaces() {
            try {
                return new Object[]{AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManager(this)};
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected class cacheGroup
        implements TOTorrentAnnounceURLGroup {
            private TOTorrentAnnounceURLSet[] sets;

            protected cacheGroup(List list) throws Exception {
                this.sets = new TOTorrentAnnounceURLSet[list.size()];
                for (int i = 0; i < this.sets.length; ++i) {
                    List list2 = (List)list.get(i);
                    URL[] uRLArray = new URL[list2.size()];
                    for (int j = 0; j < uRLArray.length; ++j) {
                        uRLArray[j] = StringInterner.internURL(new URL(new String((byte[])list2.get(j), "UTF-8")));
                    }
                    this.sets[i] = new cacheSet(uRLArray);
                }
            }

            public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
                if (CachedStateWrapper.this.announce_group == null && CachedStateWrapper.this.fixup()) {
                    return CachedStateWrapper.this.delegate.getAnnounceURLGroup().getAnnounceURLSets();
                }
                return this.sets;
            }

            void fixGroup() {
                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = CachedStateWrapper.this.delegate.getAnnounceURLGroup().getAnnounceURLSets();
                if (tOTorrentAnnounceURLSetArray.length != this.sets.length) {
                    Debug.out("Cached announce group state does not match real state");
                } else {
                    for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
                        if (!(this.sets[i] instanceof cacheSet)) continue;
                        ((cacheSet)this.sets[i]).delegateSet = tOTorrentAnnounceURLSetArray[i];
                    }
                    this.sets = null;
                }
            }

            public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray) {
                if (CachedStateWrapper.this.fixup()) {
                    TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray2 = new TOTorrentAnnounceURLSet[tOTorrentAnnounceURLSetArray.length];
                    for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
                        TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = tOTorrentAnnounceURLSetArray[i];
                        if (tOTorrentAnnounceURLSet instanceof cacheSet) {
                            tOTorrentAnnounceURLSetArray2[i] = ((cacheSet)tOTorrentAnnounceURLSet).delegateSet;
                        }
                        if (tOTorrentAnnounceURLSetArray2[i] != null) continue;
                        tOTorrentAnnounceURLSetArray2[i] = tOTorrentAnnounceURLSet;
                    }
                    CachedStateWrapper.this.delegate.getAnnounceURLGroup().setAnnounceURLSets(tOTorrentAnnounceURLSetArray2);
                }
            }

            public TOTorrentAnnounceURLSet createAnnounceURLSet(URL[] uRLArray) {
                if (CachedStateWrapper.this.fixup()) {
                    return CachedStateWrapper.this.delegate.getAnnounceURLGroup().createAnnounceURLSet(uRLArray);
                }
                return null;
            }

            protected class cacheSet
            implements TOTorrentAnnounceURLSet {
                private URL[] urls;
                private TOTorrentAnnounceURLSet delegateSet;

                public cacheSet(URL[] uRLArray) {
                    this.urls = uRLArray;
                }

                public URL[] getAnnounceURLs() {
                    if (CachedStateWrapper.this.announce_group == null && CachedStateWrapper.this.fixup() && this.delegateSet != null) {
                        return this.delegateSet.getAnnounceURLs();
                    }
                    return this.urls;
                }

                public void setAnnounceURLs(URL[] uRLArray) {
                    if (CachedStateWrapper.this.fixup() && this.delegateSet != null) {
                        this.delegateSet.setAnnounceURLs(uRLArray);
                    } else {
                        this.urls = uRLArray;
                    }
                }
            }
        }
    }

    protected static class nullState
    implements DownloadManagerState {
        protected DownloadManager download_manager;

        protected nullState(DownloadManager downloadManager) {
            this.download_manager = downloadManager;
        }

        public TOTorrent getTorrent() {
            return null;
        }

        public File getStateFile() {
            return null;
        }

        public DownloadManager getDownloadManager() {
            return this.download_manager;
        }

        public void clearResumeData() {
        }

        public Map getResumeData() {
            return new HashMap();
        }

        public void setResumeData(Map map) {
        }

        public boolean isResumeDataComplete() {
            return false;
        }

        public void clearTrackerResponseCache() {
        }

        public Map getTrackerResponseCache() {
            return new HashMap();
        }

        public void setTrackerResponseCache(Map map) {
        }

        public void setFlag(long l, boolean bl) {
        }

        public boolean getFlag(long l) {
            return false;
        }

        public long getFlags() {
            return 0L;
        }

        public void setParameterDefault(String string) {
        }

        public long getLongParameter(String string) {
            return 0L;
        }

        public void setLongParameter(String string, long l) {
        }

        public int getIntParameter(String string) {
            return 0;
        }

        public void setIntParameter(String string, int n) {
        }

        public boolean getBooleanParameter(String string) {
            return false;
        }

        public void setBooleanParameter(String string, boolean bl) {
        }

        public void setAttribute(String string, String string2) {
        }

        public String getAttribute(String string) {
            return null;
        }

        public String getTrackerClientExtensions() {
            return null;
        }

        public void setTrackerClientExtensions(String string) {
        }

        public void setListAttribute(String string, String[] stringArray) {
        }

        public String getListAttribute(String string, int n) {
            return null;
        }

        public String[] getListAttribute(String string) {
            return null;
        }

        public void setMapAttribute(String string, Map map) {
        }

        public Map getMapAttribute(String string) {
            return null;
        }

        public boolean hasAttribute(String string) {
            return false;
        }

        public int getIntAttribute(String string) {
            return 0;
        }

        public long getLongAttribute(String string) {
            return 0L;
        }

        public boolean getBooleanAttribute(String string) {
            return false;
        }

        public void setIntAttribute(String string, int n) {
        }

        public void setLongAttribute(String string, long l) {
        }

        public void setBooleanAttribute(String string, boolean bl) {
        }

        public Category getCategory() {
            return null;
        }

        public void setCategory(Category category) {
        }

        public String[] getNetworks() {
            return new String[0];
        }

        public boolean isNetworkEnabled(String string) {
            return false;
        }

        public void setNetworks(String[] stringArray) {
        }

        public void setNetworkEnabled(String string, boolean bl) {
        }

        public String[] getPeerSources() {
            return new String[0];
        }

        public boolean isPeerSourcePermitted(String string) {
            return false;
        }

        public void setPeerSourcePermitted(String string, boolean bl) {
        }

        public boolean isPeerSourceEnabled(String string) {
            return false;
        }

        public void suppressStateSave(boolean bl) {
        }

        public void setPeerSources(String[] stringArray) {
        }

        public void setPeerSourceEnabled(String string, boolean bl) {
        }

        public void setFileLink(File file, File file2) {
        }

        public void clearFileLinks() {
        }

        public File getFileLink(File file) {
            return null;
        }

        public CaseSensitiveFileMap getFileLinks() {
            return new CaseSensitiveFileMap();
        }

        public void setActive(boolean bl) {
        }

        public void discardFluff() {
        }

        public void save() {
        }

        public void delete() {
        }

        public void addListener(DownloadManagerStateListener downloadManagerStateListener) {
        }

        public void removeListener(DownloadManagerStateListener downloadManagerStateListener) {
        }

        public void addListener(DownloadManagerStateAttributeListener downloadManagerStateAttributeListener, String string, int n) {
        }

        public void removeListener(DownloadManagerStateAttributeListener downloadManagerStateAttributeListener, String string, int n) {
        }

        public void setDisplayName(String string) {
        }

        public String getDisplayName() {
            return null;
        }

        public void setUserComment(String string) {
        }

        public String getUserComment() {
            return null;
        }

        public void setRelativeSavePath(String string) {
        }

        public String getRelativeSavePath() {
            return null;
        }

        public boolean parameterExists(String string) {
            return false;
        }

        public void generateEvidence(IndentWriter indentWriter) {
            indentWriter.println("DownloadManagerState: broken torrent");
        }

        public boolean isOurContent() {
            return false;
        }

        public String getPrimaryFile() {
            return null;
        }

        public void setPrimaryFile(String string) {
        }
    }
}

