/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentFinder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

class GlobalManagerHostSupport
implements TRHostTorrentFinder {
    protected GlobalManager gm;
    protected TRHost host;

    protected GlobalManagerHostSupport(GlobalManager globalManager) {
        this.gm = globalManager;
        this.host = TRHostFactory.getSingleton();
        this.host.initialise(this);
    }

    public TOTorrent lookupTorrent(byte[] byArray) {
        List list = this.gm.getDownloadManagers();
        for (int i = 0; i < list.size(); ++i) {
            DownloadManager downloadManager = (DownloadManager)list.get(i);
            TOTorrent tOTorrent = downloadManager.getTorrent();
            if (tOTorrent == null) continue;
            try {
                if (!Arrays.equals(byArray, tOTorrent.getHash())) continue;
                return tOTorrent;
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
            }
        }
        return null;
    }

    protected void torrentRemoved(String string, TOTorrent tOTorrent) {
        File file;
        TRHostTorrent tRHostTorrent = this.host.getHostTorrent(tOTorrent);
        if (tRHostTorrent != null && (file = new File(string)).exists()) {
            try {
                TorrentUtils.writeToFile(tRHostTorrent.getTorrent(), file, false);
                tRHostTorrent.setPassive(true);
            }
            catch (Throwable throwable) {
                Debug.out("Failed to make torrent '" + string + "' passive: " + Debug.getNestedExceptionMessage(throwable));
            }
        }
    }

    protected void destroy() {
        this.host.close();
    }
}

