/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.helpers.TorrentFolderWatcher;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.control.PeerControlSchedulerFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.GlobalMangerProgressListener;
import org.gudy.azureus2.core3.global.impl.GlobalManagerHostSupport;
import org.gudy.azureus2.core3.global.impl.GlobalManagerStatsImpl;
import org.gudy.azureus2.core3.global.impl.GlobalManagerStatsWriter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtilsListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcherWithException;
import org.gudy.azureus2.core3.util.NonDaemonTask;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalManagerImpl
extends DownloadManagerAdapter
implements GlobalManager,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final int LDT_MANAGER_ADDED = 1;
    private static final int LDT_MANAGER_REMOVED = 2;
    private static final int LDT_DESTROY_INITIATED = 3;
    private static final int LDT_DESTROYED = 4;
    private static final int LDT_SEEDING_ONLY = 5;
    private ListenerManager listeners = ListenerManager.createAsyncManager("GM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object object, int n, Object object2) {
            GlobalManagerListener globalManagerListener = (GlobalManagerListener)object;
            if (n == 1) {
                globalManagerListener.downloadManagerAdded((DownloadManager)object2);
            } else if (n == 2) {
                globalManagerListener.downloadManagerRemoved((DownloadManager)object2);
            } else if (n == 3) {
                globalManagerListener.destroyInitiated();
            } else if (n == 4) {
                globalManagerListener.destroyed();
            } else if (n == 5) {
                boolean[] blArray = (boolean[])object2;
                globalManagerListener.seedingStatusChanged(blArray[0], blArray[1]);
            }
        }
    });
    private static final int LDT_MANAGER_WBR = 1;
    private ListenerManager removal_listeners = ListenerManager.createManager("GM:DLWBRMListenDispatcher", new ListenerManagerDispatcherWithException(){

        public void dispatchWithException(Object object, int n, Object object2) throws GlobalManagerDownloadRemovalVetoException {
            GlobalManagerDownloadWillBeRemovedListener globalManagerDownloadWillBeRemovedListener = (GlobalManagerDownloadWillBeRemovedListener)object;
            DownloadManager downloadManager = (DownloadManager)((Object[])object2)[0];
            boolean bl = (Boolean)((Object[])object2)[1];
            boolean bl2 = (Boolean)((Object[])object2)[2];
            globalManagerDownloadWillBeRemovedListener.downloadWillBeRemoved(downloadManager, bl, bl2);
        }
    });
    private List<DownloadManager> managers_cow = new ArrayList<DownloadManager>();
    private AEMonitor managers_mon = new AEMonitor("GM:Managers");
    private Map manager_map = new HashMap();
    private GlobalMangerProgressListener progress_listener;
    private Checker checker;
    private GlobalManagerStatsImpl stats;
    private long last_swarm_stats_calc_time = 0L;
    private long last_swarm_stats = 0L;
    private boolean cripple_downloads_config;
    private TRTrackerScraper trackerScraper;
    private GlobalManagerStatsWriter stats_writer;
    private GlobalManagerHostSupport host_support;
    private Map saved_download_manager_state = new HashMap();
    private int next_seed_piece_recheck_index;
    private TorrentFolderWatcher torrent_folder_watcher;
    private ArrayList paused_list = new ArrayList();
    private final AEMonitor paused_list_mon = new AEMonitor("GlobalManager:PL");
    private volatile boolean isStopping;
    private volatile boolean destroyed;
    private volatile boolean needsSaving = false;
    private boolean seeding_only_mode = false;
    private boolean potentially_seeding_only_mode = false;
    private FrequencyLimitedDispatcher check_seeding_only_state_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            GlobalManagerImpl.this.checkSeedingOnlyStateSupport();
        }
    }, 5000);
    private boolean force_start_non_seed_exists;
    private int nat_status = 0;
    private boolean nat_status_probably_ok;
    private CopyOnWriteList dm_adapters = new CopyOnWriteList();
    DelayedEvent loadTorrentsDelay = null;
    boolean loadingComplete = false;
    AESemaphore loadingSem = new AESemaphore("Loading Torrents");
    AEMonitor addingDM_monitor = new AEMonitor("addingDM");
    List addingDMs = new ArrayList();
    private MainlineDHTProvider provider = null;

    public GlobalManagerImpl(AzureusCore azureusCore, GlobalMangerProgressListener globalMangerProgressListener, long l) {
        this.progress_listener = globalMangerProgressListener;
        this.cripple_downloads_config = "1".equals(System.getProperty("azureus.disabledownloads"));
        AEDiagnostics.addEvidenceGenerator(this);
        this.stats = new GlobalManagerStatsImpl(this);
        try {
            this.stats_writer = new GlobalManagerStatsWriter(azureusCore);
        }
        catch (Throwable throwable) {
            Logger.log(new LogEvent(LOGID, "Stats unavailable", throwable));
        }
        if (l > 0L) {
            this.loadTorrentsDelay = new DelayedEvent("GM:tld", l, new AERunnable(){

                public void runSupport() {
                    GlobalManagerImpl.this.loadExistingTorrentsNow(false);
                }
            });
        } else {
            this.loadDownloads();
        }
        if (this.progress_listener != null) {
            this.progress_listener.reportCurrentTask(MessageText.getString("splash.initializeGM"));
        }
        this.trackerScraper = TRTrackerScraperFactory.getSingleton();
        this.trackerScraper.setClientResolver(new TRTrackerScraperClientResolver(){

            public int getStatus(HashWrapper hashWrapper) {
                DownloadManager downloadManager = GlobalManagerImpl.this.getDownloadManager(hashWrapper);
                if (downloadManager == null) {
                    return 1;
                }
                int n = downloadManager.getState();
                if (n == 75) {
                    return 3;
                }
                if (n == 50 || n == 60) {
                    return 2;
                }
                return 4;
            }

            public boolean isNetworkEnabled(HashWrapper hashWrapper, URL uRL) {
                DownloadManager downloadManager = GlobalManagerImpl.this.getDownloadManager(hashWrapper);
                if (downloadManager == null) {
                    return false;
                }
                String string = AENetworkClassifier.categoriseAddress(uRL.getHost());
                String[] stringArray = downloadManager.getDownloadState().getNetworks();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] != string) continue;
                    return true;
                }
                return false;
            }

            public int[] getCachedScrape(HashWrapper hashWrapper) {
                DownloadManager downloadManager = GlobalManagerImpl.this.getDownloadManager(hashWrapper);
                if (downloadManager == null) {
                    return null;
                }
                long l = downloadManager.getDownloadState().getLongAttribute("scrapecache");
                if (l == -1L) {
                    return null;
                }
                int n = (int)(l >> 32 & 0xFFFFFFL);
                int n2 = (int)(l & 0xFFFFFFL);
                return new int[]{n, n2};
            }

            public Object[] getExtensions(HashWrapper hashWrapper) {
                Character c;
                String string;
                DownloadManager downloadManager = GlobalManagerImpl.this.getDownloadManager(hashWrapper);
                if (downloadManager == null) {
                    string = "";
                    c = TRTrackerScraperClientResolver.FL_NONE;
                } else {
                    string = downloadManager.getDownloadState().getTrackerClientExtensions();
                    if (string == null) {
                        string = "";
                    }
                    boolean bl = downloadManager.isDownloadComplete(false);
                    int n = downloadManager.getState();
                    c = n == 100 || n == 70 || n == 65 && downloadManager.getSubState() != 75 ? (bl ? TRTrackerScraperClientResolver.FL_COMPLETE_STOPPED : TRTrackerScraperClientResolver.FL_INCOMPLETE_STOPPED) : (n == 50 || n == 60 ? (bl ? TRTrackerScraperClientResolver.FL_COMPLETE_RUNNING : TRTrackerScraperClientResolver.FL_INCOMPLETE_RUNNING) : (bl ? TRTrackerScraperClientResolver.FL_COMPLETE_QUEUED : TRTrackerScraperClientResolver.FL_INCOMPLETE_QUEUED));
                }
                return new Object[]{string, c};
            }

            public boolean redirectTrackerUrl(HashWrapper hashWrapper, URL uRL, URL uRL2) {
                DownloadManager downloadManager = GlobalManagerImpl.this.getDownloadManager(hashWrapper);
                if (downloadManager == null || downloadManager.getTorrent() == null) {
                    return false;
                }
                return TorrentUtils.replaceAnnounceURL(downloadManager.getTorrent(), uRL, uRL2);
            }
        });
        this.trackerScraper.addListener(new TRTrackerScraperListener(){

            public void scrapeReceived(TRTrackerScraperResponse tRTrackerScraperResponse) {
                HashWrapper hashWrapper = tRTrackerScraperResponse.getHash();
                DownloadManager downloadManager = (DownloadManager)GlobalManagerImpl.this.manager_map.get(hashWrapper);
                if (downloadManager != null) {
                    downloadManager.setTrackerScrapeResponse(tRTrackerScraperResponse);
                }
            }
        });
        try {
            this.host_support = new GlobalManagerHostSupport(this);
        }
        catch (Throwable throwable) {
            Logger.log(new LogEvent(LOGID, "Hosting unavailable", throwable));
        }
        this.checker = new Checker();
        this.checker.start();
        this.torrent_folder_watcher = new TorrentFolderWatcher(this);
        TRTrackerUtils.addListener(new TRTrackerUtilsListener(){

            public void announceDetailsChanged() {
                Logger.log(new LogEvent(LOGID, "Announce details have changed, updating trackers"));
                List list = GlobalManagerImpl.this.managers_cow;
                for (int i = 0; i < list.size(); ++i) {
                    DownloadManager downloadManager = (DownloadManager)list.get(i);
                    downloadManager.requestTrackerAnnounce(true);
                }
            }
        });
    }

    @Override
    public void loadExistingTorrentsNow(boolean bl) {
        if (this.loadTorrentsDelay == null) {
            return;
        }
        this.loadTorrentsDelay = null;
        if (bl) {
            AEThread aEThread = new AEThread("load torrents", true){

                public void runSupport() {
                    GlobalManagerImpl.this.loadDownloads();
                }
            };
            aEThread.setPriority(3);
            aEThread.start();
        } else {
            this.loadDownloads();
        }
    }

    @Override
    public DownloadManager addDownloadManager(String string, String string2) {
        return this.addDownloadManager(string, null, string2, 0, true);
    }

    @Override
    public DownloadManager addDownloadManager(String string, byte[] byArray, String string2, int n, boolean bl) {
        return this.addDownloadManager(string, byArray, string2, n, bl, false, null);
    }

    @Override
    public DownloadManager addDownloadManager(String string, byte[] byArray, String string2, int n, boolean bl, boolean bl2, DownloadManagerInitialisationAdapter downloadManagerInitialisationAdapter) {
        return this.addDownloadManager(string, byArray, string2, null, n, bl, bl2, downloadManagerInitialisationAdapter);
    }

    /*
     * Exception decompiling
     */
    @Override
    public DownloadManager addDownloadManager(String var1_1, byte[] var2_2, String var3_3, String var4_4, int var5_5, boolean var6_6, boolean var7_7, DownloadManagerInitialisationAdapter var8_8) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadManager addDownloadManager(DownloadManager downloadManager, boolean bl, boolean bl2) {
        if (!this.isStopping) {
            block37: {
                this.loadExistingTorrentsNow(false);
                this.managers_mon.enter();
                int n = this.managers_cow.indexOf(downloadManager);
                if (n == -1) break block37;
                DownloadManager downloadManager2 = this.managers_cow.get(n);
                downloadManager.destroy(true);
                DownloadManager downloadManager3 = downloadManager2;
                Object var38_9 = null;
                this.managers_mon.exit();
                return downloadManager3;
            }
            try {
                Long l;
                Object object;
                Object object2;
                int n;
                int n2;
                DownloadManagerStats downloadManagerStats = downloadManager.getStats();
                HashWrapper hashWrapper = null;
                try {
                    hashWrapper = downloadManager.getTorrent().getHashWrapper();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Map map = (Map)this.saved_download_manager_state.get(hashWrapper);
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                long l7 = 0L;
                if (map != null) {
                    long l8;
                    Long l9;
                    Long l10;
                    Long l11;
                    Long l12;
                    Category category;
                    TOTorrent tOTorrent;
                    int n3;
                    this.saved_download_manager_state.remove(hashWrapper);
                    n2 = map.get("maxdl") == null ? 0 : ((Long)map.get("maxdl")).intValue();
                    n = map.get("maxul") == null ? 0 : ((Long)map.get("maxul")).intValue();
                    object2 = (Long)map.get("downloaded");
                    object = (Long)map.get("uploaded");
                    l = (Long)map.get("completed");
                    Long l13 = (Long)map.get("discarded");
                    Long l14 = (Long)map.get("hashfails");
                    Long l15 = (Long)map.get("hashfailbytes");
                    Long l16 = (Long)map.get("uploads");
                    if (l16 != null && (n3 = l16.intValue()) != 4 && downloadManager.getMaxUploads() == 4) {
                        downloadManager.setMaxUploads(n3);
                    }
                    downloadManagerStats.setDownloadRateLimitBytesPerSecond(n2);
                    downloadManagerStats.setUploadRateLimitBytesPerSecond(n);
                    if (l != null) {
                        downloadManagerStats.setDownloadCompleted(l.intValue());
                    }
                    if (l13 != null) {
                        l4 = l13;
                    }
                    if (l15 != null) {
                        l5 = l15;
                    } else if (l14 != null && (tOTorrent = downloadManager.getTorrent()) != null) {
                        l5 = l14 * tOTorrent.getPieceLength();
                    }
                    Long l17 = (Long)map.get("position");
                    String string = null;
                    if (map.containsKey("category")) {
                        try {
                            string = new String((byte[])map.get("category"), "UTF8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Debug.printStackTrace(unsupportedEncodingException);
                        }
                    }
                    if (string != null && (category = CategoryManager.getCategory(string)) != null) {
                        downloadManager.getDownloadState().setCategory(category);
                    }
                    downloadManager.requestAssumedCompleteMode();
                    if (object2 != null && object != null) {
                        boolean bl3 = downloadManager.isDownloadComplete(false);
                        long l18 = (Long)object;
                        long l19 = (Long)object2;
                        if (bl3 && l19 == 0L) {
                            int n4 = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                            l19 = downloadManager.getSize() * (long)n4;
                            downloadManager.getDownloadState().setFlag(1L, true);
                        }
                        l2 = l19;
                        l3 = l18;
                    }
                    if (l17 != null) {
                        downloadManager.setPosition(l17.intValue());
                    }
                    if ((l12 = (Long)map.get("secondsDownloading")) != null) {
                        l6 = l12;
                    }
                    if ((l11 = (Long)map.get("secondsOnlySeeding")) != null) {
                        l7 = l11;
                    }
                    if ((l10 = (Long)map.get("allocated")) != null && l10.intValue() == 1) {
                        downloadManager.setDataAlreadyAllocated(true);
                    }
                    if ((l9 = (Long)map.get("creationTime")) != null && (l8 = l9.longValue()) < SystemTime.getCurrentTime()) {
                        downloadManager.setCreationTime(l8);
                    }
                } else if (downloadManagerStats.getDownloadCompleted(false) == 1000) {
                    n2 = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                    l2 = downloadManager.getSize() * (long)n2;
                }
                downloadManagerStats.restoreSessionTotals(l2, l3, l4, l5, l6, l7);
                n2 = downloadManager.isDownloadComplete(false) ? 1 : 0;
                if (downloadManager.getPosition() == -1) {
                    n = 0;
                    for (int i = 0; i < this.managers_cow.size(); ++i) {
                        object = this.managers_cow.get(i);
                        int n5 = object.isDownloadComplete(false);
                        if (n5 != n2) continue;
                        ++n;
                    }
                    downloadManager.setPosition(n + 1);
                }
                downloadManager.requestAssumedCompleteMode();
                ArrayList<DownloadManager> arrayList = new ArrayList<DownloadManager>(this.managers_cow);
                arrayList.add(downloadManager);
                this.managers_cow = arrayList;
                object2 = downloadManager.getTorrent();
                if (object2 != null) {
                    try {
                        this.manager_map.put(new HashWrapper(object2.getHash()), downloadManager);
                    }
                    catch (TOTorrentException tOTorrentException) {
                        Debug.printStackTrace(tOTorrentException);
                    }
                }
                if (COConfigurationManager.getBooleanParameter("Set Completion Flag For Completed Downloads On Start") && downloadManager.isDownloadComplete(true)) {
                    downloadManager.getDownloadState().setFlag(8L, true);
                }
                if (bl2) {
                    this.listeners.dispatch(1, downloadManager);
                }
                downloadManager.addListener(this);
                if (map != null) {
                    object = (Long)map.get("forceStart");
                    if (object == null && (l = (Long)map.get("startStopLocked")) != null) {
                        object = l;
                    }
                    if (object != null && ((Long)object).intValue() == 1) {
                        downloadManager.setForceStart(true);
                    }
                }
                Object var38_10 = null;
                this.managers_mon.exit();
            }
            catch (Throwable throwable) {
                Object var38_11 = null;
                this.managers_mon.exit();
                throw throwable;
            }
            if (bl) {
                this.saveDownloads(false);
            }
            return downloadManager;
        }
        Logger.log(new LogEvent(LOGID, 3, "Tried to add a DownloadManager after shutdown of GlobalManager."));
        return null;
    }

    @Override
    public List getDownloadManagers() {
        return this.managers_cow;
    }

    @Override
    public DownloadManager getDownloadManager(TOTorrent tOTorrent) {
        if (tOTorrent == null) {
            return null;
        }
        try {
            return this.getDownloadManager(tOTorrent.getHashWrapper());
        }
        catch (TOTorrentException tOTorrentException) {
            return null;
        }
    }

    @Override
    public DownloadManager getDownloadManager(HashWrapper hashWrapper) {
        return (DownloadManager)this.manager_map.get(hashWrapper);
    }

    @Override
    public void canDownloadManagerBeRemoved(DownloadManager downloadManager, boolean bl, boolean bl2) throws GlobalManagerDownloadRemovalVetoException {
        try {
            this.removal_listeners.dispatchWithException(1, new Object[]{downloadManager, new Boolean(bl), new Boolean(bl2)});
        }
        catch (Throwable throwable) {
            if (throwable instanceof GlobalManagerDownloadRemovalVetoException) {
                throw (GlobalManagerDownloadRemovalVetoException)throwable;
            }
            GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException = new GlobalManagerDownloadRemovalVetoException("Error running veto check");
            globalManagerDownloadRemovalVetoException.initCause(throwable);
            Debug.out(throwable);
            throw globalManagerDownloadRemovalVetoException;
        }
    }

    @Override
    public void removeDownloadManager(DownloadManager downloadManager) throws GlobalManagerDownloadRemovalVetoException {
        this.removeDownloadManager(downloadManager, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDownloadManager(DownloadManager downloadManager, boolean bl, boolean bl2) throws GlobalManagerDownloadRemovalVetoException {
        Object object;
        Object object2;
        if (!this.managers_cow.contains(downloadManager)) {
            return;
        }
        this.canDownloadManagerBeRemoved(downloadManager, bl, bl2);
        downloadManager.stopIt(70, bl, bl2);
        try {
            this.managers_mon.enter();
            object2 = new ArrayList<DownloadManager>(this.managers_cow);
            object2.remove(downloadManager);
            this.managers_cow = object2;
            object = downloadManager.getTorrent();
            if (object != null) {
                try {
                    this.manager_map.remove(new HashWrapper(object.getHash()));
                }
                catch (TOTorrentException tOTorrentException) {
                    Debug.printStackTrace(tOTorrentException);
                }
            }
            Object var8_7 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.managers_mon.exit();
            throw throwable;
        }
        object2 = downloadManager.getTorrent();
        if (object2 != null) {
            TorrentUtils.removeCreatedTorrent((TOTorrent)object2);
        }
        downloadManager.destroy(false);
        this.fixUpDownloadManagerPositions();
        this.listeners.dispatch(2, downloadManager);
        downloadManager.removeListener(this);
        this.saveDownloads(false);
        object = downloadManager.getDownloadState();
        if (object.getCategory() != null) {
            object.setCategory(null);
        }
        if (downloadManager.getTorrent() != null) {
            this.trackerScraper.remove(downloadManager.getTorrent());
        }
        if (this.host_support != null) {
            this.host_support.torrentRemoved(downloadManager.getTorrentFileName(), downloadManager.getTorrent());
        }
        object.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGlobalManager() {
        try {
            this.managers_mon.enter();
            if (this.isStopping) {
                Object var2_1 = null;
                this.managers_mon.exit();
                return;
            }
            this.isStopping = true;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.managers_mon.exit();
            throw throwable;
        }
        Object var2_2 = null;
        this.managers_mon.exit();
        this.stats.save();
        this.informDestroyInitiated();
        if (this.host_support != null) {
            this.host_support.destroy();
        }
        this.torrent_folder_watcher.destroy();
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                public Object run() {
                    return null;
                }

                public String getName() {
                    return "Stopping global manager";
                }
            });
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        this.checker.stopIt();
        if (COConfigurationManager.getBooleanParameter("Pause Downloads On Exit")) {
            this.pauseDownloads(true);
            this.stopAllDownloads(true);
            this.saveDownloads(true);
        } else {
            this.saveDownloads(true);
            this.stopAllDownloads(true);
        }
        if (this.stats_writer != null) {
            this.stats_writer.destroy();
        }
        DownloadManagerStateFactory.saveGlobalStateCache();
        this.managers_cow = new ArrayList<DownloadManager>();
        this.manager_map.clear();
        this.informDestroyed();
    }

    @Override
    public void stopAllDownloads() {
        this.stopAllDownloads(false);
    }

    protected void stopAllDownloads(boolean bl) {
        if (bl && this.progress_listener != null) {
            this.progress_listener.reportCurrentTask(MessageText.getString("splash.unloadingTorrents"));
        }
        long l = 0L;
        List<DownloadManager> list = this.sortForStop();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            DownloadManager downloadManager = list.get(i);
            long l2 = SystemTime.getCurrentTime();
            if (this.progress_listener != null && l2 - l > 100L) {
                l = l2;
                n2 = i + 1;
                this.progress_listener.reportPercent(100 * n2 / n);
                this.progress_listener.reportCurrentTask(MessageText.getString("splash.unloadingTorrent") + " " + n2 + " " + MessageText.getString("splash.of") + " " + n + " : " + downloadManager.getTorrentFileName());
            }
            if ((n2 = downloadManager.getState()) == 70 || n2 == 65) continue;
            downloadManager.stopIt(bl ? 71 : 70, false, false);
        }
    }

    @Override
    public void startAllDownloads() {
        for (DownloadManager downloadManager : this.managers_cow) {
            if (downloadManager.getState() != 70) continue;
            downloadManager.stopIt(75, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pauseDownload(DownloadManager downloadManager) {
        if (downloadManager.getTorrent() == null) {
            return false;
        }
        int n = downloadManager.getState();
        if (n != 70 && n != 100 && n != 65) {
            try {
                HashWrapper hashWrapper = downloadManager.getTorrent().getHashWrapper();
                boolean bl = downloadManager.isForceStart();
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.add(new Object[]{hashWrapper, new Boolean(bl)});
                    Object var6_6 = null;
                    this.paused_list_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.paused_list_mon.exit();
                    throw throwable;
                }
                downloadManager.stopIt(70, false, false);
                return true;
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
            }
        }
        return false;
    }

    @Override
    public void pauseDownloads() {
        this.pauseDownloads(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pauseDownloads(boolean bl) {
        List<DownloadManager> list = this.sortForStop();
        for (DownloadManager downloadManager : list) {
            int n;
            if (downloadManager.getTorrent() == null || (n = downloadManager.getState()) == 70 || n == 100 || n == 65) continue;
            try {
                Object var8_8;
                boolean bl2 = downloadManager.isForceStart();
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.add(new Object[]{downloadManager.getTorrent().getHashWrapper(), new Boolean(bl2)});
                    var8_8 = null;
                    this.paused_list_mon.exit();
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    this.paused_list_mon.exit();
                    throw throwable;
                }
                if (bl) continue;
                downloadManager.stopIt(70, false, false);
            }
            catch (TOTorrentException tOTorrentException) {
                Debug.printStackTrace(tOTorrentException);
            }
        }
    }

    public boolean canPauseDownload(DownloadManager downloadManager) {
        if (downloadManager.getTorrent() == null) {
            return false;
        }
        int n = downloadManager.getState();
        return n != 70 && n != 100 && n != 65;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isPaused(DownloadManager downloadManager) {
        int n;
        if (this.paused_list.size() == 0) {
            return false;
        }
        try {
            this.paused_list_mon.enter();
            for (n = 0; n < this.paused_list.size(); ++n) {
                Object[] objectArray = (Object[])this.paused_list.get(n);
                HashWrapper hashWrapper = (HashWrapper)objectArray[0];
                DownloadManager downloadManager2 = this.getDownloadManager(hashWrapper);
                if (downloadManager2 != downloadManager) continue;
                boolean bl = true;
                Object var8_7 = null;
                this.paused_list_mon.exit();
                return bl;
            }
            n = 0;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.paused_list_mon.exit();
            throw throwable;
        }
        Object var8_8 = null;
        this.paused_list_mon.exit();
        return n != 0;
    }

    @Override
    public boolean canPauseDownloads() {
        for (DownloadManager downloadManager : this.managers_cow) {
            if (!this.canPauseDownload(downloadManager)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeDownload(DownloadManager downloadManager) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] objectArray = (Object[])this.paused_list.get(i);
                HashWrapper hashWrapper = (HashWrapper)objectArray[0];
                bl2 = (Boolean)objectArray[1];
                DownloadManager downloadManager2 = this.getDownloadManager(hashWrapper);
                if (downloadManager2 != downloadManager) continue;
                bl = true;
                this.paused_list.remove(i);
                break;
            }
            Object var9_8 = null;
            this.paused_list_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.paused_list_mon.exit();
            throw throwable;
        }
        if (bl && downloadManager.getState() == 70) {
            if (bl2) {
                downloadManager.setForceStart(true);
            } else {
                downloadManager.stopIt(75, false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeDownloads() {
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] objectArray = (Object[])this.paused_list.get(i);
                HashWrapper hashWrapper = (HashWrapper)objectArray[0];
                boolean bl = (Boolean)objectArray[1];
                DownloadManager downloadManager = this.getDownloadManager(hashWrapper);
                if (downloadManager == null || downloadManager.getState() != 70) continue;
                if (bl) {
                    downloadManager.setForceStart(true);
                    continue;
                }
                downloadManager.stopIt(75, false, false);
            }
            this.paused_list.clear();
            Object var7_6 = null;
            this.paused_list_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.paused_list_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canResumeDownloads() {
        try {
            this.paused_list_mon.enter();
            int n = 0;
            while (true) {
                if (n >= this.paused_list.size()) {
                    Object var7_7 = null;
                    this.paused_list_mon.exit();
                    return false;
                }
                Object[] objectArray = (Object[])this.paused_list.get(n);
                HashWrapper hashWrapper = (HashWrapper)objectArray[0];
                DownloadManager downloadManager = this.getDownloadManager(hashWrapper);
                if (downloadManager != null && downloadManager.getState() == 70) {
                    boolean bl = true;
                    Object var7_6 = null;
                    this.paused_list_mon.exit();
                    return bl;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.paused_list_mon.exit();
            throw throwable;
        }
    }

    private List<DownloadManager> sortForStop() {
        ArrayList<DownloadManager> arrayList = new ArrayList<DownloadManager>(this.managers_cow);
        Collections.sort(arrayList, new Comparator<DownloadManager>(){

            @Override
            public int compare(DownloadManager downloadManager, DownloadManager downloadManager2) {
                int n = downloadManager.getState();
                int n2 = downloadManager2.getState();
                if (n2 == 75) {
                    return 1;
                }
                if (n == 75) {
                    return -1;
                }
                return 0;
            }
        });
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDownloads() {
        if (this.cripple_downloads_config) {
            this.loadingComplete = true;
            this.loadingSem.releaseForever();
            return;
        }
        try {
            DownloadManagerStateFactory.loadGlobalStateCache();
            int n = 2;
            ArrayList<DownloadManager> arrayList = new ArrayList<DownloadManager>();
            long l = 0L;
            try {
                try {
                    Object object;
                    Long l2;
                    Object object2;
                    int n2;
                    if (this.progress_listener != null) {
                        this.progress_listener.reportCurrentTask(MessageText.getString("splash.loadingTorrents"));
                    }
                    Map map = FileUtil.readResilientConfigFile("downloads.config");
                    boolean bl = Boolean.getBoolean("debug");
                    Iterator<Object> iterator = null;
                    List list = (List)map.get("downloads");
                    if (list == null) {
                        iterator = map.values().iterator();
                        n2 = map.size();
                    } else {
                        iterator = list.iterator();
                        n2 = list.size();
                    }
                    int n3 = 0;
                    while (iterator.hasNext()) {
                        ++n3;
                        object2 = (Map)iterator.next();
                        try {
                            List list2;
                            DownloadManager downloadManager;
                            boolean bl2;
                            byte[] byArray;
                            byte[] byArray2;
                            Object object3;
                            byte[] byArray3 = (byte[])object2.get("torrent_hash");
                            l2 = (Long)object2.get("persistent");
                            boolean bl3 = l2 == null || l2 == 1L;
                            String string = new String((byte[])object2.get("torrent"), "UTF8");
                            if (this.progress_listener != null && SystemTime.getCurrentTime() - l > 100L) {
                                l = SystemTime.getCurrentTime();
                                object = string;
                                try {
                                    object3 = new File(string);
                                    object = ((File)object3).getName();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.progress_listener.reportPercent(100 * n3 / n2);
                                this.progress_listener.reportCurrentTask(MessageText.getString("splash.loadingTorrent") + " " + n3 + " " + MessageText.getString("splash.of") + " " + n2 + " : " + (String)object);
                            }
                            if ((byArray2 = (byte[])object2.get("save_dir")) != null) {
                                byArray = (byte[])object2.get("save_file");
                                object = new String(byArray2, "UTF8");
                                object3 = byArray != null ? new String(byArray, "UTF8") : null;
                            } else {
                                byArray = (byte[])object2.get("path");
                                object = new String(byArray, "UTF8");
                                object3 = null;
                            }
                            int n4 = 0;
                            if (bl) {
                                n4 = 70;
                            } else if (object2.containsKey("state")) {
                                n4 = ((Long)object2.get("state")).intValue();
                                if (n4 != 70 && n4 != 75 && n4 != 0) {
                                    n4 = 75;
                                }
                            } else {
                                int n5 = ((Long)object2.get("stopped")).intValue();
                                if (n5 == 1) {
                                    n4 = 70;
                                }
                            }
                            Long l3 = (Long)object2.get("secondsDownloading");
                            boolean bl4 = bl2 = l3 != null && l3 > 0L;
                            if (byArray3 != null) {
                                this.saved_download_manager_state.put(new HashWrapper(byArray3), object2);
                            }
                            if (!bl3 || this.addDownloadManager(downloadManager = DownloadManagerFactory.create((GlobalManager)this, byArray3, string, (String)object, (String)object3, n4, true, true, bl2, list2 = (List)object2.get("file_priorities")), false, false) != downloadManager) continue;
                            arrayList.add(downloadManager);
                            if (arrayList.size() < n) continue;
                            n *= 2;
                            this.triggerAddListener(arrayList);
                            arrayList.clear();
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                        }
                        catch (Throwable throwable) {
                            Logger.log(new LogEvent(LOGID, "Error while loading downloads.  One download may not have been added to the list.", throwable));
                        }
                    }
                    COConfigurationManager.setParameter("Set Completion Flag For Completed Downloads On Start", false);
                    object2 = (ArrayList)map.get("pause_data");
                    if (object2 != null) {
                        try {
                            this.paused_list_mon.enter();
                            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                                boolean bl5;
                                byte[] byArray;
                                l2 = ((ArrayList)object2).get(i);
                                if (l2 instanceof byte[]) {
                                    byArray = (byte[])((ArrayList)object2).get(i);
                                    bl5 = false;
                                } else {
                                    object = (Map)((Object)l2);
                                    byArray = (byte[])object.get("hash");
                                    bl5 = ((Long)object.get("force")).intValue() == 1;
                                }
                                this.paused_list.add(new Object[]{new HashWrapper(byArray), new Boolean(bl5)});
                            }
                            Object var25_32 = null;
                            this.paused_list_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var25_33 = null;
                            this.paused_list_mon.exit();
                            throw throwable;
                        }
                    }
                    this.fixUpDownloadManagerPositions();
                    Logger.log(new LogEvent(LOGID, "Loaded " + this.managers_cow.size() + " torrents"));
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    Object var27_36 = null;
                    this.loadingComplete = true;
                    this.triggerAddListener(arrayList);
                    this.loadingSem.releaseForever();
                }
                Object var27_35 = null;
                this.loadingComplete = true;
                this.triggerAddListener(arrayList);
                this.loadingSem.releaseForever();
            }
            catch (Throwable throwable) {
                Object var27_37 = null;
                this.loadingComplete = true;
                this.triggerAddListener(arrayList);
                this.loadingSem.releaseForever();
                throw throwable;
            }
            Object var29_39 = null;
        }
        catch (Throwable throwable) {
            Object var29_40 = null;
            DownloadManagerStateFactory.discardGlobalStateCache();
            throw throwable;
        }
        DownloadManagerStateFactory.discardGlobalStateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerAddListener(List list) {
        try {
            this.managers_mon.enter();
            List list2 = this.listeners.getListenersCopy();
            for (int i = 0; i < list2.size(); ++i) {
                GlobalManagerListener globalManagerListener = (GlobalManagerListener)list2.get(i);
                for (int j = 0; j < list.size(); ++j) {
                    DownloadManager downloadManager = (DownloadManager)list.get(j);
                    globalManagerListener.downloadManagerAdded(downloadManager);
                }
            }
            Object var8_7 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDownloads(boolean bl) {
        if (!bl) {
            this.needsSaving = true;
            return;
        }
        if (!this.loadingComplete) {
            this.needsSaving = true;
            return;
        }
        this.needsSaving = false;
        if (this.cripple_downloads_config) {
            return;
        }
        try {
            Serializable serializable;
            Object object;
            Object object2;
            Object[] objectArray;
            this.managers_mon.enter();
            Collections.sort(this.managers_cow, new Comparator(){

                public final int compare(Object object, Object object2) {
                    return ((DownloadManager)object).getPosition() - ((DownloadManager)object2).getPosition();
                }
            });
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Saving Download List (" + this.managers_cow.size() + " items)"));
            }
            HashMap hashMap = new HashMap();
            ArrayList<Object> arrayList = new ArrayList<Object>(this.managers_cow.size());
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                DownloadManager downloadManager = this.managers_cow.get(i);
                objectArray = downloadManager.getStats();
                object2 = new HashMap<String, Object>();
                object = downloadManager.getTorrent();
                if (object != null) {
                    try {
                        object2.put("torrent_hash", object.getHash());
                    }
                    catch (TOTorrentException tOTorrentException) {
                        Debug.printStackTrace(tOTorrentException);
                    }
                }
                serializable = downloadManager.getAbsoluteSaveLocation();
                object2.put("persistent", new Long(downloadManager.isPersistent() ? 1L : 0L));
                object2.put("torrent", downloadManager.getTorrentFileName());
                object2.put("save_dir", ((File)serializable).getParent());
                object2.put("save_file", ((File)serializable).getName());
                object2.put("maxdl", new Long(objectArray.getDownloadRateLimitBytesPerSecond()));
                object2.put("maxul", new Long(objectArray.getUploadRateLimitBytesPerSecond()));
                int n = downloadManager.getState();
                if (n == 100) {
                    n = 70;
                } else if (downloadManager.getAssumedComplete() && !downloadManager.isForceStart() && n != 70) {
                    n = 75;
                } else if (n != 70 && n != 75 && n != 0) {
                    n = 0;
                }
                object2.put("state", new Long(n));
                object2.put("position", new Long(downloadManager.getPosition()));
                object2.put("downloaded", new Long(objectArray.getTotalDataBytesReceived()));
                object2.put("uploaded", new Long(objectArray.getTotalDataBytesSent()));
                object2.put("completed", new Long(objectArray.getDownloadCompleted(true)));
                object2.put("discarded", new Long(objectArray.getDiscarded()));
                object2.put("hashfailbytes", new Long(objectArray.getHashFailBytes()));
                object2.put("forceStart", new Long(downloadManager.isForceStart() && downloadManager.getState() != 30 ? 1L : 0L));
                object2.put("secondsDownloading", new Long(objectArray.getSecondsDownloading()));
                object2.put("secondsOnlySeeding", new Long(objectArray.getSecondsOnlySeeding()));
                object2.put("uploads", new Long(downloadManager.getMaxUploads()));
                object2.put("creationTime", new Long(downloadManager.getCreationTime()));
                downloadManager.saveDownload();
                List list = (List)downloadManager.getData("file_priorities");
                if (list != null) {
                    object2.put("file_priorities", list);
                }
                object2.put("allocated", new Long(downloadManager.isDataAlreadyAllocated() ? 1L : 0L));
                arrayList.add(object2);
            }
            hashMap.put("downloads", arrayList);
            try {
                this.paused_list_mon.enter();
                if (!this.paused_list.isEmpty()) {
                    ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
                    for (int i = 0; i < this.paused_list.size(); ++i) {
                        objectArray = (Object[])this.paused_list.get(i);
                        object2 = (HashWrapper)objectArray[0];
                        object = (Boolean)objectArray[1];
                        serializable = new HashMap();
                        serializable.put("hash", ((HashWrapper)object2).getHash());
                        serializable.put("force", new Long(((Boolean)object).booleanValue() ? 1L : 0L));
                        arrayList2.add(serializable);
                    }
                    hashMap.put("pause_data", arrayList2);
                }
                Object var13_15 = null;
                this.paused_list_mon.exit();
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                this.paused_list_mon.exit();
                throw throwable;
            }
            FileUtil.writeResilientConfigFile("downloads.config", hashMap);
            Object var15_18 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    @Override
    public TRTrackerScraper getTrackerScraper() {
        return this.trackerScraper;
    }

    @Override
    public GlobalManagerStats getStats() {
        return this.stats;
    }

    @Override
    public boolean contains(DownloadManager downloadManager) {
        if (this.managers_cow != null && downloadManager != null) {
            return this.managers_cow.contains(downloadManager);
        }
        return false;
    }

    @Override
    public int getIndexOf(DownloadManager downloadManager) {
        if (this.managers_cow != null && downloadManager != null) {
            return this.managers_cow.indexOf(downloadManager);
        }
        return -1;
    }

    @Override
    public boolean isMoveableUp(DownloadManager downloadManager) {
        if (downloadManager.isDownloadComplete(false) && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return downloadManager.getPosition() > 1;
    }

    @Override
    public int downloadManagerCount(boolean bl) {
        int n = 0;
        for (DownloadManager downloadManager : this.managers_cow) {
            if (downloadManager.isDownloadComplete(false) != bl) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean isMoveableDown(DownloadManager downloadManager) {
        boolean bl = downloadManager.isDownloadComplete(false);
        if (bl && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return downloadManager.getPosition() < this.downloadManagerCount(bl);
    }

    @Override
    public void moveUp(DownloadManager downloadManager) {
        this.moveTo(downloadManager, downloadManager.getPosition() - 1);
    }

    @Override
    public void moveDown(DownloadManager downloadManager) {
        this.moveTo(downloadManager, downloadManager.getPosition() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTop(DownloadManager[] downloadManagerArray) {
        try {
            this.managers_mon.enter();
            int n = 1;
            for (int i = 0; i < downloadManagerArray.length; ++i) {
                this.moveTo(downloadManagerArray[i], n++);
            }
            Object var5_4 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveEnd(DownloadManager[] downloadManagerArray) {
        try {
            int n;
            this.managers_mon.enter();
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < this.managers_cow.size(); ++n) {
                DownloadManager downloadManager = this.managers_cow.get(n);
                if (downloadManager.isDownloadComplete(false)) {
                    ++n2;
                    continue;
                }
                ++n3;
            }
            for (n = downloadManagerArray.length - 1; n >= 0; --n) {
                if (downloadManagerArray[n].isDownloadComplete(false) && n2 > 0) {
                    this.moveTo(downloadManagerArray[n], n2--);
                    continue;
                }
                if (n3 <= 0) continue;
                this.moveTo(downloadManagerArray[n], n3--);
            }
            Object var7_6 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTo(DownloadManager downloadManager, int n) {
        boolean bl = downloadManager.isDownloadComplete(false);
        if (n < 1 || n > this.downloadManagerCount(bl)) {
            return;
        }
        try {
            this.managers_mon.enter();
            int n2 = downloadManager.getPosition();
            if (n > n2) {
                int n3 = n - n2;
                for (int i = 0; i < this.managers_cow.size(); ++i) {
                    int n4;
                    DownloadManager downloadManager2 = this.managers_cow.get(i);
                    boolean bl2 = downloadManager2.isDownloadComplete(false);
                    if (bl2 != bl || (n4 = downloadManager2.getPosition()) <= n2 || n4 > n) continue;
                    downloadManager2.setPosition(n4 - 1);
                    if (--n3 <= 0) break;
                }
                downloadManager.setPosition(n);
            } else if (n < n2 && n2 > 1) {
                int n5 = n2 - n;
                for (int i = 0; i < this.managers_cow.size(); ++i) {
                    DownloadManager downloadManager3 = this.managers_cow.get(i);
                    boolean bl3 = downloadManager3.isDownloadComplete(false);
                    int n6 = downloadManager3.getPosition();
                    if (bl3 != bl || n6 < n || n6 >= n2) continue;
                    downloadManager3.setPosition(n6 + 1);
                    if (--n5 <= 0) break;
                }
                downloadManager.setPosition(n);
            }
            Object var11_15 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fixUpDownloadManagerPositions() {
        try {
            this.managers_mon.enter();
            int n = 1;
            int n2 = 1;
            Collections.sort(this.managers_cow, new Comparator(){

                public final int compare(Object object, Object object2) {
                    int n = ((DownloadManager)object).getPosition() - ((DownloadManager)object2).getPosition();
                    if (n != 0) {
                        return n;
                    }
                    if (((DownloadManager)object).isPersistent()) {
                        return 1;
                    }
                    if (((DownloadManager)object2).isPersistent()) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                DownloadManager downloadManager = this.managers_cow.get(i);
                if (downloadManager.isDownloadComplete(false)) {
                    downloadManager.setPosition(n++);
                    continue;
                }
                downloadManager.setPosition(n2++);
            }
            Object var6_5 = null;
            this.managers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.managers_mon.exit();
            throw throwable;
        }
    }

    protected void informDestroyed() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.listeners.dispatch(4, null, true);
    }

    public void informDestroyInitiated() {
        this.listeners.dispatch(3, null, true);
    }

    @Override
    public void addListener(GlobalManagerListener globalManagerListener) {
        this.addListener(globalManagerListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(GlobalManagerListener globalManagerListener, boolean bl) {
        if (this.isStopping) {
            globalManagerListener.destroyed();
        } else {
            this.listeners.addListener(globalManagerListener);
            if (!bl) {
                return;
            }
            try {
                this.managers_mon.enter();
                List<DownloadManager> list = this.managers_cow;
                for (int i = 0; i < list.size(); ++i) {
                    globalManagerListener.downloadManagerAdded(list.get(i));
                }
                Object var6_5 = null;
                this.managers_mon.exit();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.managers_mon.exit();
                throw throwable;
            }
        }
    }

    @Override
    public void removeListener(GlobalManagerListener globalManagerListener) {
        this.listeners.removeListener(globalManagerListener);
    }

    @Override
    public void addDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener globalManagerDownloadWillBeRemovedListener) {
        this.removal_listeners.addListener(globalManagerDownloadWillBeRemovedListener);
    }

    @Override
    public void removeDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener globalManagerDownloadWillBeRemovedListener) {
        this.removal_listeners.removeListener(globalManagerDownloadWillBeRemovedListener);
    }

    @Override
    public void stateChanged(DownloadManager downloadManager, int n) {
        this.needsSaving = true;
        PEPeerManager pEPeerManager = downloadManager.getPeerManager();
        if (n == 50 && pEPeerManager != null && pEPeerManager.hasDownloadablePiece()) {
            this.setSeedingOnlyState(false, false);
        } else {
            this.checkSeedingOnlyState();
        }
        this.checkForceStart(downloadManager.isForceStart() && n == 50);
    }

    protected void checkForceStart(boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = true;
        } else {
            bl2 = false;
            if (this.force_start_non_seed_exists) {
                List<DownloadManager> list = this.managers_cow;
                for (int i = 0; i < list.size(); ++i) {
                    DownloadManager downloadManager = list.get(i);
                    if (!downloadManager.isForceStart() || downloadManager.getState() != 50) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2 != this.force_start_non_seed_exists) {
            this.force_start_non_seed_exists = bl2;
            Logger.log(new LogEvent(LOGID, "Force start download " + (this.force_start_non_seed_exists ? "exists" : "doesn't exist") + ", modifying download weighting"));
            PeerControlSchedulerFactory.overrideWeightedPriorities(this.force_start_non_seed_exists);
        }
    }

    protected void checkSeedingOnlyState() {
        this.check_seeding_only_state_dispatcher.dispatch();
    }

    protected void checkSeedingOnlyStateSupport() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        List<DownloadManager> list = this.managers_cow;
        for (int i = 0; i < list.size(); ++i) {
            DownloadManager downloadManager = list.get(i);
            PEPeerManager pEPeerManager = downloadManager.getPeerManager();
            int n = downloadManager.getState();
            if (downloadManager.getDiskManager() == null || pEPeerManager == null) {
                if (n != 75) continue;
                if (downloadManager.isDownloadComplete(false)) {
                    bl3 = true;
                    continue;
                }
                bl = false;
                bl2 = true;
                continue;
            }
            if (n == 50) {
                if (!pEPeerManager.hasDownloadablePiece()) {
                    if (bl2) continue;
                    bl = true;
                    continue;
                }
                bl = false;
                bl3 = false;
                break;
            }
            if (n != 60 || bl2) continue;
            bl = true;
        }
        if (bl) {
            bl3 = true;
        }
        this.setSeedingOnlyState(bl, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSeedingOnlyState(boolean bl, boolean bl2) {
        GlobalManagerImpl globalManagerImpl = this;
        synchronized (globalManagerImpl) {
            if (bl != this.seeding_only_mode || bl2 != this.potentially_seeding_only_mode) {
                this.seeding_only_mode = bl;
                this.potentially_seeding_only_mode = bl2;
                this.listeners.dispatch(5, new boolean[]{this.seeding_only_mode, this.potentially_seeding_only_mode});
            }
        }
    }

    @Override
    public boolean isSeedingOnly() {
        return this.seeding_only_mode;
    }

    @Override
    public boolean isPotentiallySeedingOnly() {
        return this.potentially_seeding_only_mode;
    }

    public long getTotalSwarmsPeerRate(boolean bl, boolean bl2) {
        long l = SystemTime.getCurrentTime();
        if (l < this.last_swarm_stats_calc_time || l - this.last_swarm_stats_calc_time >= 1000L) {
            long l2 = 0L;
            List<DownloadManager> list = this.managers_cow;
            for (int i = 0; i < list.size(); ++i) {
                boolean bl3;
                DownloadManager downloadManager = list.get(i);
                boolean bl4 = bl3 = downloadManager.getState() == 60;
                if ((!bl || bl3) && (!bl2 || !bl3)) continue;
                l2 += downloadManager.getStats().getTotalAveragePerPeer();
            }
            this.last_swarm_stats = l2;
            this.last_swarm_stats_calc_time = l;
        }
        return this.last_swarm_stats;
    }

    protected void computeNATStatus() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (DownloadManager downloadManager : this.managers_cow) {
            int n4 = downloadManager.getNATStatus();
            if (n4 == 1) {
                ++n;
                continue;
            }
            if (n4 == 2) {
                ++n2;
                continue;
            }
            if (n4 != 3) continue;
            ++n3;
        }
        if (n > 0) {
            this.nat_status = 1;
        } else if (n2 > 0 || this.nat_status_probably_ok) {
            this.nat_status = 2;
            this.nat_status_probably_ok = true;
        } else {
            this.nat_status = n3 > 0 ? 3 : 0;
        }
    }

    @Override
    public int getNATStatus() {
        return this.nat_status;
    }

    protected void seedPieceRecheck() {
        DownloadManager downloadManager;
        int n;
        List<DownloadManager> list = this.managers_cow;
        if (this.next_seed_piece_recheck_index >= list.size()) {
            this.next_seed_piece_recheck_index = 0;
        }
        for (n = this.next_seed_piece_recheck_index; n < list.size(); ++n) {
            downloadManager = list.get(n);
            if (!this.seedPieceRecheck(downloadManager)) continue;
            this.next_seed_piece_recheck_index = n + 1;
            if (this.next_seed_piece_recheck_index >= list.size()) {
                this.next_seed_piece_recheck_index = 0;
            }
            return;
        }
        for (n = 0; n < this.next_seed_piece_recheck_index; ++n) {
            downloadManager = list.get(n);
            if (!this.seedPieceRecheck(downloadManager)) continue;
            this.next_seed_piece_recheck_index = n + 1;
            if (this.next_seed_piece_recheck_index >= list.size()) {
                this.next_seed_piece_recheck_index = 0;
            }
            return;
        }
    }

    protected boolean seedPieceRecheck(DownloadManager downloadManager) {
        if (downloadManager.getState() != 60) {
            return false;
        }
        return downloadManager.seedPieceRecheck();
    }

    protected DownloadManagerInitialisationAdapter getDMAdapter(DownloadManagerInitialisationAdapter downloadManagerInitialisationAdapter) {
        List list = this.dm_adapters.getList();
        if (list.size() == 0) {
            return downloadManagerInitialisationAdapter;
        }
        if (downloadManagerInitialisationAdapter != null) {
            list = new ArrayList(list);
            list.add(downloadManagerInitialisationAdapter);
        }
        if (list.size() == 1) {
            return (DownloadManagerInitialisationAdapter)list.get(0);
        }
        final List list2 = list;
        return new DownloadManagerInitialisationAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void initialised(DownloadManager downloadManager) {
                for (int i = 0; i < list2.size(); ++i) {
                    try {
                        ((DownloadManagerInitialisationAdapter)list2.get(i)).initialised(downloadManager);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                if (Constants.isOSX) {
                    GlobalManagerImpl.this.fixLongFileName(downloadManager);
                }
                if (COConfigurationManager.getBooleanParameter("Rename Incomplete Files")) {
                    String string = COConfigurationManager.getStringParameter("Rename Incomplete Files Extension").trim();
                    DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
                    String string2 = downloadManagerState.getAttribute("incompfilesuffix");
                    if (string.length() > 0 && string2 == null) {
                        string = FileUtil.convertOSSpecificChars(string, false);
                        DiskManagerFileInfo[] diskManagerFileInfoArray = downloadManager.getDiskManagerFileInfo();
                        try {
                            downloadManagerState.suppressStateSave(true);
                            for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
                                DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[i];
                                File file = diskManagerFileInfo.getFile(false);
                                File file2 = downloadManagerState.getFileLink(file);
                                if (file2 == null && file.exists() || file2 != null && file2.exists()) continue;
                                File file3 = file2 == null ? new File(file.getParentFile(), file.getName() + string) : new File(file2.getParentFile(), file2.getName() + string);
                                downloadManagerState.setFileLink(file, file3);
                            }
                            Object var12_13 = null;
                            downloadManagerState.setAttribute("incompfilesuffix", string);
                            downloadManagerState.suppressStateSave(false);
                        }
                        catch (Throwable throwable) {
                            Object var12_14 = null;
                            downloadManagerState.setAttribute("incompfilesuffix", string);
                            downloadManagerState.suppressStateSave(false);
                            throw throwable;
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixLongFileName(DownloadManager downloadManager) {
        DiskManagerFileInfo[] diskManagerFileInfoArray = downloadManager.getDiskManagerFileInfo();
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        try {
            downloadManagerState.suppressStateSave(true);
            block5: for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
                DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[i];
                File file = diskManagerFileInfo.getFile(false);
                File file2 = downloadManagerState.getFileLink(file);
                if (file2 != null || file.exists()) continue;
                String string = file.getName();
                String string2 = FileUtil.getExtension(string);
                int n = string2.length();
                int n2 = (string = string.substring(0, string.length() - n)).length();
                if (n2 <= 50) continue;
                File file3 = file.getParentFile();
                file3.mkdirs();
                File file4 = null;
                boolean bl = true;
                while (string.length() > 50) {
                    try {
                        boolean bl2;
                        file4 = new File(file3, string + string2);
                        file4.getCanonicalPath();
                        if (bl) continue block5;
                        int n3 = 255;
                        block7: do {
                            bl2 = false;
                            for (int j = 0; j < i; ++j) {
                                DiskManagerFileInfo diskManagerFileInfo2 = diskManagerFileInfoArray[j];
                                if (!file4.equals(diskManagerFileInfo2.getFile(true))) continue;
                                while (++n3 < 4095 && (file4 = new File(file3, (string = string.substring(0, string.length() - 3) + Integer.toHexString(n3)) + string2)).equals(diskManagerFileInfo2.getFile(true))) {
                                }
                                bl2 = n3 <= 4095;
                                continue block7;
                            }
                        } while (bl2);
                        if (n3 > 4095) continue block5;
                        downloadManagerState.setFileLink(file, file4);
                        continue block5;
                    }
                    catch (IOException iOException) {
                        bl = false;
                        string = string.substring(0, string.length() - 1);
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                }
            }
            Object var20_21 = null;
            downloadManagerState.suppressStateSave(false);
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            downloadManagerState.suppressStateSave(false);
            throw throwable;
        }
    }

    @Override
    public void addDownloadManagerInitialisationAdapter(DownloadManagerInitialisationAdapter downloadManagerInitialisationAdapter) {
        this.dm_adapters.add(downloadManagerInitialisationAdapter);
    }

    @Override
    public void removeDownloadManagerInitialisationAdapter(DownloadManagerInitialisationAdapter downloadManagerInitialisationAdapter) {
        this.dm_adapters.remove(downloadManagerInitialisationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("Global Manager");
        try {
            indentWriter.indent();
            this.managers_mon.enter();
            indentWriter.println("  managers: " + this.managers_cow.size());
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                Object var5_4;
                DownloadManager downloadManager = this.managers_cow.get(i);
                try {
                    indentWriter.indent();
                    downloadManager.generateEvidence(indentWriter);
                    var5_4 = null;
                    indentWriter.exdent();
                    continue;
                }
                catch (Throwable throwable) {
                    var5_4 = null;
                    indentWriter.exdent();
                    throw throwable;
                }
            }
            Object var7_6 = null;
            this.managers_mon.exit();
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.managers_mon.exit();
            indentWriter.exdent();
            throw throwable;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            stringArray = new String[]{"C:\\temp\\downloads.config", "C:\\temp\\downloads-9-3-05.config", "C:\\temp\\merged.config"};
        } else if (stringArray.length != 3) {
            System.out.println("Usage: newer_config_file older_config_file save_config_file");
            return;
        }
        try {
            Object object2;
            Map map = FileUtil.readResilientFile(new File(stringArray[0]));
            Map map2 = FileUtil.readResilientFile(new File(stringArray[1]));
            List list = (List)map.get("downloads");
            List list2 = (List)map2.get("downloads");
            HashSet<HashWrapper> hashSet = new HashSet<HashWrapper>();
            for (Object object2 : list) {
                Object object3 = (byte[])object2.get("torrent_hash");
                System.out.println("1:" + ByteFormatter.nicePrint((byte[])object3));
                hashSet.add(new HashWrapper((byte[])object3));
            }
            object2 = new ArrayList();
            for (Map map3 : list2) {
                byte[] byArray = (byte[])map3.get("torrent_hash");
                HashWrapper hashWrapper = new HashWrapper(byArray);
                if (hashSet.contains(hashWrapper)) {
                    System.out.println("-:" + ByteFormatter.nicePrint(byArray));
                    continue;
                }
                System.out.println("2:" + ByteFormatter.nicePrint(byArray));
                object2.add(map3);
            }
            list.addAll(object2);
            System.out.println(object2.size() + " copied from " + stringArray[1] + " to " + stringArray[2]);
            FileUtil.writeResilientFile(new File(stringArray[2]), map);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void setMainlineDHTProvider(MainlineDHTProvider mainlineDHTProvider) {
        this.provider = mainlineDHTProvider;
    }

    @Override
    public MainlineDHTProvider getMainlineDHTProvider() {
        return this.provider;
    }

    @Override
    public void statsRequest(Map map, Map map2) {
        AzureusCore azureusCore = AzureusCoreFactory.getSingleton();
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        map2.put("gm", hashMap);
        try {
            boolean bl;
            hashMap.put("u_rate", new Long(this.stats.getDataAndProtocolSendRate()));
            hashMap.put("d_rate", new Long(this.stats.getDataAndProtocolReceiveRate()));
            hashMap.put("d_lim", new Long(TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond()));
            boolean bl2 = TransferSpeedValidator.isAutoSpeedActive(this) && TransferSpeedValidator.isAutoUploadAvailable(azureusCore);
            hashMap.put("auto_up", new Long(bl2 ? COConfigurationManager.getLongParameter("Auto Upload Speed Version") : 0L));
            long l = NetworkManager.getMaxUploadRateBPSNormal();
            boolean bl3 = NetworkManager.isSeedingOnlyUploadRate();
            hashMap.put("so", new Long(bl3 ? 1L : 0L));
            if (bl3) {
                l = NetworkManager.getMaxUploadRateBPSSeedingOnly();
            }
            hashMap.put("u_lim", new Long(l));
            SpeedManager speedManager = azureusCore.getSpeedManager();
            if (speedManager != null) {
                hashMap.put("u_cap", new Long(speedManager.getEstimatedUploadCapacityBytesPerSec().getBytesPerSec()));
                hashMap.put("d_cap", new Long(speedManager.getEstimatedDownloadCapacityBytesPerSec().getBytesPerSec()));
            }
            List list = this.getDownloadManagers();
            int n = 0;
            int n2 = 0;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            for (DownloadManager downloadManager : list) {
                int n3 = downloadManager.getState();
                if (n3 != 60 && n3 != 50) continue;
                DownloadManagerStats downloadManagerStats = downloadManager.getStats();
                if (downloadManager.isDownloadComplete(false)) {
                    ++n;
                    l2 += downloadManagerStats.getProtocolSendRate() + downloadManagerStats.getDataSendRate();
                    continue;
                }
                ++n2;
                l3 += downloadManagerStats.getProtocolSendRate() + downloadManagerStats.getDataSendRate();
                l4 += downloadManagerStats.getProtocolReceiveRate() + downloadManagerStats.getDataReceiveRate();
            }
            hashMap.put("dm_i", new Long(n2));
            hashMap.put("dm_c", new Long(n));
            hashMap.put("dm_i_u", new Long(l3));
            hashMap.put("dm_i_d", new Long(l4));
            hashMap.put("dm_c_u", new Long(l2));
            hashMap.put("nat", new Long(this.nat_status));
            boolean bl4 = COConfigurationManager.getBooleanParameter("Use Request Limiting");
            hashMap.put("req_lim", new Long(bl4 ? 1L : 0L));
            if (bl4) {
                hashMap.put("req_focus", new Long(COConfigurationManager.getBooleanParameter("Use Request Limiting Priorities") ? 1L : 0L));
            }
            hashMap.put("bias_up", new Long((bl = COConfigurationManager.getBooleanParameter("Bias Upload Enable")) ? 1L : 0L));
            if (bl) {
                hashMap.put("bias_slack", new Long(COConfigurationManager.getLongParameter("Bias Upload Slack KBs")));
                hashMap.put("bias_ulim", new Long(COConfigurationManager.getBooleanParameter("Bias Upload Handle No Limit") ? 1L : 0L));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class Checker
    extends AEThread {
        int loopFactor;
        private static final int waitTime = 10000;
        private int saveResumeLoopCount;
        private int initSaveResumeLoopCount;
        private int natCheckLoopCount;
        private int seedPieceCheckCount;
        private AESemaphore run_sem;

        public Checker() {
            super("Global Status Checker");
            this.saveResumeLoopCount = 30;
            this.initSaveResumeLoopCount = 6;
            this.natCheckLoopCount = 3;
            this.seedPieceCheckCount = 3;
            this.run_sem = new AESemaphore("GM:Checker:run");
            this.loopFactor = 0;
            this.setPriority(1);
        }

        private void determineSaveResumeDataInterval() {
            int n = COConfigurationManager.getIntParameter("Save Resume Interval", 5);
            if (n >= 1 && n <= 90) {
                this.saveResumeLoopCount = n * 60000 / 10000;
            }
        }

        public void runSupport() {
            while (true) {
                try {
                    ++this.loopFactor;
                    this.determineSaveResumeDataInterval();
                    if (this.loopFactor % this.saveResumeLoopCount == 0 || GlobalManagerImpl.this.needsSaving && GlobalManagerImpl.this.loadingComplete && this.loopFactor > this.initSaveResumeLoopCount) {
                        GlobalManagerImpl.this.saveDownloads(true);
                    }
                    if (this.loopFactor % this.natCheckLoopCount == 0) {
                        GlobalManagerImpl.this.computeNATStatus();
                        GlobalManagerImpl.this.checkSeedingOnlyState();
                        GlobalManagerImpl.this.checkForceStart(false);
                    }
                    if (this.loopFactor % this.seedPieceCheckCount == 0) {
                        GlobalManagerImpl.this.seedPieceRecheck();
                    }
                    for (DownloadManager downloadManager : GlobalManagerImpl.this.managers_cow) {
                        if (this.loopFactor % this.saveResumeLoopCount != 0) continue;
                        downloadManager.saveResumeData();
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
                try {
                    this.run_sem.reserve(10000L);
                    if (!this.run_sem.isReleasedForever()) continue;
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                    continue;
                }
                break;
            }
        }

        public void stopIt() {
            this.run_sem.releaseForever();
        }
    }
}

