/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderCandidate;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderFallback;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderReal;
import org.gudy.azureus2.core3.util.Debug;

public class LocaleUtil {
    private static final String systemEncoding = System.getProperty("file.encoding");
    private static final String[] manual_charset = new String[]{systemEncoding, "Big5", "EUC-JP", "EUC-KR", "GB18030", "GB2312", "GBK", "ISO-2022-JP", "ISO-2022-KR", "Shift_JIS", "KOI8-R", "TIS-620", "UTF8", "windows-1251", "ISO-8859-1"};
    protected static final String[] generalCharsets = new String[]{"ISO-8859-1", "UTF8", systemEncoding};
    private static LocaleUtil singleton = new LocaleUtil();
    private LocaleUtilDecoder[] all_decoders;
    private LocaleUtilDecoder[] general_decoders;
    private LocaleUtilDecoder system_decoder;
    private LocaleUtilDecoder fallback_decoder;

    public static LocaleUtil getSingleton() {
        return singleton;
    }

    private LocaleUtil() {
        int n;
        ArrayList<LocaleUtilDecoder> arrayList = new ArrayList<LocaleUtilDecoder>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < manual_charset.length; ++n) {
            try {
                String string = manual_charset[n];
                CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
                if (charsetDecoder != null) {
                    Object object = new LocaleUtilDecoderReal(arrayList.size(), charsetDecoder);
                    arrayList2.add(object.getName());
                    if (n == 0) {
                        this.system_decoder = object;
                    }
                    arrayList.add((LocaleUtilDecoder)object);
                    continue;
                }
                if (n != 0) continue;
                Debug.out("System decoder failed to be found!!!!");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.general_decoders = new LocaleUtilDecoder[generalCharsets.length];
        for (n = 0; n < this.general_decoders.length; ++n) {
            int n2 = arrayList2.indexOf(generalCharsets[n]);
            if (n2 == -1) continue;
            this.general_decoders[n] = (LocaleUtilDecoder)arrayList.get(n2);
        }
        n = COConfigurationManager.getBooleanParameter("File.Decoder.ShowAll") ? 1 : 0;
        if (n != 0) {
            SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
            for (Object object : sortedMap.keySet()) {
                if (arrayList2.contains(object)) continue;
                try {
                    CharsetDecoder charsetDecoder = Charset.forName((String)object).newDecoder();
                    if (charsetDecoder == null) continue;
                    LocaleUtilDecoderReal localeUtilDecoderReal = new LocaleUtilDecoderReal(arrayList.size(), charsetDecoder);
                    arrayList.add(localeUtilDecoderReal);
                    arrayList2.add(localeUtilDecoderReal.getName());
                }
                catch (Exception exception) {}
            }
        }
        this.fallback_decoder = new LocaleUtilDecoderFallback(arrayList.size());
        arrayList.add(this.fallback_decoder);
        this.all_decoders = new LocaleUtilDecoder[arrayList.size()];
        arrayList.toArray(this.all_decoders);
    }

    public String getSystemEncoding() {
        return systemEncoding;
    }

    public LocaleUtilDecoder[] getDecoders() {
        return this.all_decoders;
    }

    public LocaleUtilDecoder[] getGeneralDecoders() {
        return this.general_decoders;
    }

    public LocaleUtilDecoder getFallBackDecoder() {
        return this.fallback_decoder;
    }

    public LocaleUtilDecoder getSystemDecoder() {
        return this.system_decoder;
    }

    protected LocaleUtilDecoderCandidate[] getCandidates(byte[] byArray) {
        LocaleUtilDecoderCandidate[] localeUtilDecoderCandidateArray = new LocaleUtilDecoderCandidate[this.all_decoders.length];
        boolean bl = COConfigurationManager.getBooleanParameter("File.Decoder.ShowLax");
        for (int i = 0; i < this.all_decoders.length; ++i) {
            localeUtilDecoderCandidateArray[i] = new LocaleUtilDecoderCandidate(i);
            try {
                LocaleUtilDecoder localeUtilDecoder = this.all_decoders[i];
                String string = localeUtilDecoder.tryDecode(byArray, bl);
                if (string == null) continue;
                localeUtilDecoderCandidateArray[i].setDetails(localeUtilDecoder, string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return localeUtilDecoderCandidateArray;
    }

    protected List getCandidateDecoders(byte[] byArray) {
        LocaleUtilDecoderCandidate[] localeUtilDecoderCandidateArray = this.getCandidates(byArray);
        ArrayList<LocaleUtilDecoder> arrayList = new ArrayList<LocaleUtilDecoder>();
        for (int i = 0; i < localeUtilDecoderCandidateArray.length; ++i) {
            LocaleUtilDecoder localeUtilDecoder = localeUtilDecoderCandidateArray[i].getDecoder();
            if (localeUtilDecoder == null) continue;
            arrayList.add(localeUtilDecoder);
        }
        return arrayList;
    }

    protected List getCandidatesAsList(byte[] byArray) {
        LocaleUtilDecoderCandidate[] localeUtilDecoderCandidateArray = this.getCandidates(byArray);
        ArrayList<LocaleUtilDecoderCandidate> arrayList = new ArrayList<LocaleUtilDecoderCandidate>();
        for (int i = 0; i < localeUtilDecoderCandidateArray.length; ++i) {
            if (localeUtilDecoderCandidateArray[i].getDecoder() == null) continue;
            arrayList.add(localeUtilDecoderCandidateArray[i]);
        }
        return arrayList;
    }
}

