/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipchecker.extipchecker.impl;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Vector;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerService;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerServiceListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public abstract class ExternalIPCheckerServiceImpl
implements ExternalIPCheckerService,
Cloneable {
    private static final int MAX_PAGE_SIZE = 4096;
    private static final String MSG_KEY_ROOT = "IPChecker.external";
    private String name;
    private String description;
    private String url;
    private boolean completed;
    private Vector listeners = new Vector();
    private AEMonitor this_mon = new AEMonitor("ExtIPCheckServ");
    private AESemaphore timeout_sem = new AESemaphore("ExtIPCheckServ");

    protected ExternalIPCheckerServiceImpl(String string) {
        this.name = MessageText.getString(string + ".name");
        this.description = MessageText.getString(string + ".description");
        this.url = MessageText.getString(string + ".url");
    }

    public void initiateCheck(long l) {
        this._clone().initiateCheckSupport(l);
    }

    protected ExternalIPCheckerServiceImpl _clone() {
        try {
            return (ExternalIPCheckerServiceImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Debug.printStackTrace(cloneNotSupportedException);
            return null;
        }
    }

    protected void initiateCheckSupport(final long l) {
        AEThread aEThread = new AEThread("IPChecker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    ExternalIPCheckerServiceImpl.this.initiateCheckSupport();
                    Object var2_1 = null;
                    ExternalIPCheckerServiceImpl.this.setComplete();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    ExternalIPCheckerServiceImpl.this.setComplete();
                    throw throwable;
                }
            }
        };
        aEThread.setDaemon(true);
        aEThread.start();
        if (l > 0L) {
            AEThread aEThread2 = new AEThread("IPChecker2"){

                public void runSupport() {
                    try {
                        if (!ExternalIPCheckerServiceImpl.this.timeout_sem.reserve(l) && !ExternalIPCheckerServiceImpl.this.completed) {
                            ExternalIPCheckerServiceImpl.this.informFailure("timeout");
                            ExternalIPCheckerServiceImpl.this.setComplete();
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            };
            aEThread2.setDaemon(true);
            aEThread2.start();
        }
    }

    protected abstract void initiateCheckSupport();

    protected void setComplete() {
        this.completed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected String loadPage(String string) {
        try {
            String string2;
            Object object;
            int n;
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = null;
            InputStream inputStream = null;
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            int n2 = httpURLConnection.getResponseCode();
            if (n2 != 202 && n2 != 200) break block16;
            inputStream = httpURLConnection.getInputStream();
            String string3 = "";
            while (string3.length() < 4096 && (n = inputStream.read((byte[])(object = (Object)new byte[2048]))) >= 0) {
                string3 = string3 + new String((byte[])object, 0, n);
            }
            object = string3;
            Object var10_11 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            {
                block16: {
                    return object;
                }
                this.informFailure("httpinvalidresponse", "" + n2);
                string2 = null;
            }
            Object var10_12 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            return string2;
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
                catch (Throwable throwable2) {
                    Debug.printStackTrace(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.informFailure("httploadfail", throwable.toString());
            return null;
        }
    }

    protected String extractIPAddress(String string) {
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(46, n);
            if (n2 == -1) {
                this.informFailure("ipnotfound");
                return null;
            }
            if (n2 > 0 && Character.isDigit(string.charAt(n2 - 1))) {
                int n3;
                int n4;
                for (n4 = n2 - 1; n4 >= 0 && Character.isDigit(string.charAt(n4)); --n4) {
                }
                int n5 = 0;
                for (n3 = ++n4 + 1; n3 < string.length(); ++n3) {
                    char c = string.charAt(n3);
                    if (c == '.') {
                        ++n5;
                        continue;
                    }
                    if (!Character.isDigit(c)) break;
                }
                if (n5 == 3) {
                    return string.substring(n4, n3);
                }
            }
            n = n2 + 1;
        }
        this.informFailure("ipnotfound");
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informSuccess(String string) {
        try {
            this.this_mon.enter();
            if (!this.completed) {
                this.timeout_sem.releaseForever();
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ExternalIPCheckerServiceListener)this.listeners.elementAt(i)).checkComplete(this, string);
                }
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informFailure(String string) {
        try {
            this.this_mon.enter();
            this.informFailure(string, null);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informFailure(String string, String string2) {
        try {
            this.this_mon.enter();
            if (!this.completed) {
                this.timeout_sem.releaseForever();
                String string3 = MessageText.getString("IPChecker.external." + string);
                if (string2 != null) {
                    string3 = string3 + ": " + string2;
                }
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ExternalIPCheckerServiceListener)this.listeners.elementAt(i)).checkFailed(this, string3);
                }
            }
            Object var6_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportProgress(String string) {
        try {
            this.this_mon.enter();
            this.reportProgress(string, null);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportProgress(String string, String string2) {
        try {
            this.this_mon.enter();
            if (!this.completed) {
                String string3 = MessageText.getString(MSG_KEY_ROOT.concat(".").concat(string));
                if (string2 != null) {
                    string3 = string3.concat(": ").concat(string2);
                }
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ExternalIPCheckerServiceListener)this.listeners.elementAt(i)).reportProgress(this, string3);
                }
            }
            Object var6_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ExternalIPCheckerServiceListener externalIPCheckerServiceListener) {
        try {
            this.this_mon.enter();
            this.listeners.addElement(externalIPCheckerServiceListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ExternalIPCheckerServiceListener externalIPCheckerServiceListener) {
        try {
            this.this_mon.enter();
            this.listeners.removeElement(externalIPCheckerServiceListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }
}

