/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport;

import com.aelitis.azureus.core.impl.AzureusCoreImpl;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZBadPiece;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHandshake;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHave;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageEncoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZPeerExchange;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZRequestHint;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZStatReply;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZStatRequest;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZStylePeerExchange;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTAllowedFast;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTCancel;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTChoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTDHTPort;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHaveAll;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHaveNone;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTKeepAlive;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageEncoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRawMessage;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRejectRequest;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRequest;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTSuggestPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUnchoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUninterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessageEncoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.UTPeerExchange;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.peermanager.utils.AZPeerIdentityManager;
import com.aelitis.azureus.core.peermanager.utils.ClientIdentifier;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTHaveMessageAggregator;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTPieceMessageHandler;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTPieceMessageHandlerAdapter;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import com.aelitis.azureus.core.peermanager.utils.PeerMessageLimiter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.IPToHostNameResolverRequest;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTProvider;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEPeerTransportProtocol
extends LogRelation
implements PEPeerTransport {
    protected static final LogIDs LOGID = LogIDs.PEER;
    private volatile int _lastPiece = -1;
    protected final PEPeerControl manager;
    protected final DiskManager diskManager;
    protected final PiecePicker piecePicker;
    protected final int nbPieces;
    private final String peer_source;
    private byte[] peer_id;
    private final String ip;
    protected String ip_resolved;
    private IPToHostNameResolverRequest ip_resolver_request;
    private int port;
    private PeerItem peer_item_identity;
    private int tcp_listen_port = 0;
    private int udp_listen_port = 0;
    private int udp_non_data_port = 0;
    private InetAddress alternativeAddress;
    private byte crypto_level;
    protected PEPeerStats peer_stats;
    private final ArrayList requested = new ArrayList();
    private final AEMonitor requested_mon = new AEMonitor("PEPeerTransportProtocol:Req");
    private Map data;
    private long lastNeededUndonePieceChange;
    private boolean really_choked_by_other_peer = true;
    private boolean effectively_choked_by_other_peer = true;
    private long effectively_unchoked_time = -1L;
    protected boolean choking_other_peer = true;
    private boolean interested_in_other_peer = false;
    private boolean other_peer_interested_in_me = false;
    private long snubbed = 0L;
    private volatile BitFlags peerHavePieces = null;
    private volatile boolean availabilityAdded = false;
    private volatile boolean received_bitfield;
    private int[] piece_priority_offsets;
    private boolean handshake_sent;
    private boolean seeding = false;
    private static final byte RELATIVE_SEEDING_NONE = 0;
    private static final byte RELATIVE_SEEDING_UPLOAD_ONLY_INDICATED = 1;
    private static final byte RELATIVE_SEEDING_UPLOAD_ONLY_SEED = 2;
    private byte relativeSeeding = 0;
    private final boolean incoming;
    protected volatile boolean closing = false;
    private volatile int current_peer_state;
    private final NetworkConnection connection;
    private OutgoingBTPieceMessageHandler outgoing_piece_message_handler;
    private OutgoingBTHaveMessageAggregator outgoing_have_message_aggregator;
    private Connection plugin_connection;
    private boolean identityAdded = false;
    protected int connection_state = 0;
    private String client = "";
    private String client_peer_id = "";
    private String client_handshake = "";
    private String client_handshake_version = "";
    private int uniquePiece = -1;
    private int[] reserved_pieces = null;
    private int spreadTimeHint = 0;
    protected long last_message_sent_time = 0L;
    protected long last_message_received_time = 0L;
    protected long last_data_message_received_time = -1L;
    protected long last_good_data_time = -1L;
    protected long last_data_message_sent_time = -1L;
    private long connection_established_time = 0L;
    private int consecutive_no_request_count;
    private int messaging_mode = 1;
    private Message[] supported_messages = null;
    private byte other_peer_bitfield_version = 1;
    private byte other_peer_cancel_version = 1;
    private byte other_peer_choke_version = 1;
    private byte other_peer_handshake_version = 1;
    private byte other_peer_bt_have_version = 1;
    private byte other_peer_az_have_version = 1;
    private byte other_peer_interested_version = 1;
    private byte other_peer_keep_alive_version = 1;
    private byte other_peer_pex_version = 1;
    private byte other_peer_piece_version = 1;
    private byte other_peer_unchoke_version = 1;
    private byte other_peer_uninterested_version = 1;
    private byte other_peer_request_version = 1;
    private byte other_peer_suggest_piece_version = 1;
    private byte other_peer_have_all_version = 1;
    private byte other_peer_have_none_version = 1;
    private byte other_peer_reject_request_version = 1;
    private byte other_peer_allowed_fast_version = 1;
    private byte other_peer_bt_lt_ext_version = 1;
    private byte other_peer_az_request_hint_version = 1;
    private byte other_peer_az_bad_piece_version = 1;
    private byte other_peer_az_stats_request_version = 1;
    private byte other_peer_az_stats_reply_version = 1;
    private static final boolean DEBUG_FAST = false;
    private boolean ut_pex_enabled = false;
    private boolean fast_extension_enabled = false;
    private boolean ml_dht_enabled = false;
    private static final int ALLOWED_FAST_PIECE_OFFERED_NUM = 10;
    private static final int ALLOWED_FAST_OTHER_PEER_PIECE_MAX = 10;
    private static final Object KEY_ALLOWED_FAST_RECEIVED = new Object();
    private static final Object KEY_ALLOWED_FAST_SENT = new Object();
    private final AEMonitor closing_mon = new AEMonitor("PEPeerTransportProtocol:closing");
    private final AEMonitor general_mon = new AEMonitor("PEPeerTransportProtocol:data");
    private byte[] handshake_reserved_bytes = null;
    private LinkedHashMap recent_outgoing_requests;
    private AEMonitor recent_outgoing_requests_mon;
    private boolean has_received_initial_pex = false;
    private static final boolean SHOW_DISCARD_RATE_STATS;
    private static int requests_discarded;
    private static int requests_discarded_endgame;
    private static int requests_recovered;
    private static int requests_completed;
    private static final int REQUEST_HINT_MAX_LIFE = 150000;
    private int[] request_hint;
    private List peer_listeners_cow;
    private final AEMonitor peer_listeners_mon = new AEMonitor("PEPeerTransportProtocol:PL");
    protected static boolean ENABLE_LAZY_BITFIELD;
    private boolean priority_connection;
    private static final DisconnectedTransportQueue recentlyDisconnected;
    private static boolean fast_unchoke_new_peers;
    private static final Random rnd;
    private static final byte[] sessionSecret;
    private static boolean enable_upload_bias;
    private HashWrapper peerSessionID;
    private HashWrapper mySessionID;
    private boolean allowReconnect;
    private boolean is_optimistic_unchoke = false;
    private PeerExchangerItem peer_exchange_item = null;
    private boolean peer_exchange_supported = false;
    protected PeerMessageLimiter message_limiter;
    private boolean request_hint_supported;
    private boolean bad_piece_supported;
    private boolean stats_request_supported;
    private boolean stats_reply_supported;
    private boolean have_aggregation_disabled;
    private volatile boolean manual_lazy_bitfield_control;
    private volatile int[] manual_lazy_haves;
    static Map lt_ext_map;

    public PEPeerTransportProtocol(PEPeerControl pEPeerControl, String string, NetworkConnection networkConnection, Map map) {
        this.manager = pEPeerControl;
        this.peer_source = string;
        this.connection = networkConnection;
        this.data = map;
        this.incoming = true;
        this.diskManager = this.manager.getDiskManager();
        this.piecePicker = this.manager.getPiecePicker();
        this.nbPieces = this.diskManager.getNbPieces();
        InetSocketAddress inetSocketAddress = networkConnection.getEndpoint().getNotionalAddress();
        this.ip = inetSocketAddress.getAddress().getHostAddress();
        this.port = inetSocketAddress.getPort();
        this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.port, PeerItem.convertSourceID(string), (byte)0, 0, (byte)1, 0);
        this.plugin_connection = new ConnectionImpl(this.connection, this.incoming);
        this.peer_stats = this.manager.createPeerStats(this);
        this.changePeerState(10);
    }

    @Override
    public void start() {
        if (this.incoming) {
            this.connection.connect(3, new NetworkConnection.ConnectionListener(){

                public final int connectStarted(int n) {
                    PEPeerTransportProtocol.this.connection_state = 1;
                    return n;
                }

                public final void connectSuccess(ByteBuffer byteBuffer) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(PEPeerTransportProtocol.this, LOGID, "In: Established incoming connection"));
                    }
                    PEPeerTransportProtocol.this.generateSessionId();
                    PEPeerTransportProtocol.this.initializeConnection();
                    PEPeerTransportProtocol.this.sendBTHandshake();
                }

                public final void connectFailure(Throwable throwable) {
                    Debug.out("ERROR: incoming connect failure: ", throwable);
                    PEPeerTransportProtocol.this.closeConnectionInternally("ERROR: incoming connect failure [" + PEPeerTransportProtocol.this + "] : " + throwable.getMessage(), true, true);
                }

                public final void exceptionThrown(Throwable throwable) {
                    if (throwable.getMessage() == null) {
                        Debug.out(throwable);
                    }
                    PEPeerTransportProtocol.this.closeConnectionInternally("connection exception: " + throwable.getMessage(), false, true);
                }

                public String getDescription() {
                    return PEPeerTransportProtocol.this.getString();
                }
            });
        }
    }

    public PEPeerTransportProtocol(PEPeerControl pEPeerControl, String string, String string2, int n, int n2, boolean bl, boolean bl2, byte by, Map map) {
        ProtocolEndpoint protocolEndpoint;
        InetSocketAddress inetSocketAddress;
        boolean bl3;
        Boolean bl4;
        this.manager = pEPeerControl;
        this.diskManager = this.manager.getDiskManager();
        this.piecePicker = this.manager.getPiecePicker();
        this.nbPieces = this.diskManager.getNbPieces();
        this.lastNeededUndonePieceChange = Long.MIN_VALUE;
        this.peer_source = string;
        this.ip = string2;
        this.port = n;
        this.tcp_listen_port = n;
        this.udp_listen_port = n2;
        this.crypto_level = by;
        this.data = map;
        if (this.data != null && (bl4 = (Boolean)this.data.get(Peer.PR_PRIORITY_CONNECTION)) != null && bl4.booleanValue()) {
            this.setPriorityConnection(true);
        }
        this.udp_non_data_port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
        this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.tcp_listen_port, PeerItem.convertSourceID(string), (byte)0, n2, this.crypto_level, 0);
        this.incoming = false;
        this.peer_stats = this.manager.createPeerStats(this);
        if (this.port < 0 || this.port > 65535) {
            this.closeConnectionInternally("given remote port is invalid: " + this.port);
            this.connection = null;
            return;
        }
        boolean bl5 = bl3 = bl2 || NetworkManager.getCryptoRequired(this.manager.getAdapter().getCryptoLevel());
        if (this.isLANLocal()) {
            bl3 = false;
        }
        if (bl) {
            inetSocketAddress = new InetSocketAddress(this.ip, this.tcp_listen_port);
            protocolEndpoint = new ProtocolEndpointTCP(inetSocketAddress);
        } else {
            inetSocketAddress = new InetSocketAddress(this.ip, this.udp_listen_port);
            protocolEndpoint = new ProtocolEndpointUDP(inetSocketAddress);
        }
        ConnectionEndpoint connectionEndpoint = new ConnectionEndpoint(inetSocketAddress);
        connectionEndpoint.addProtocol(protocolEndpoint);
        this.connection = NetworkManager.getSingleton().createConnection(connectionEndpoint, new BTMessageEncoder(), new BTMessageDecoder(), bl3, !bl2, this.manager.getSecrets(by));
        this.plugin_connection = new ConnectionImpl(this.connection, this.incoming);
        this.changePeerState(10);
        ByteBuffer byteBuffer = null;
        if (bl3) {
            int n3;
            BTHandshake bTHandshake = new BTHandshake(this.manager.getHash(), this.manager.getPeerId(), this.manager.isExtendedMessagingEnabled(), this.other_peer_handshake_version);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this, LOGID, "Sending encrypted handshake with reserved bytes: " + ByteFormatter.nicePrint(bTHandshake.getReserved(), false)));
            }
            DirectByteBuffer[] directByteBufferArray = bTHandshake.getRawData();
            int n4 = 0;
            for (n3 = 0; n3 < directByteBufferArray.length; ++n3) {
                n4 += directByteBufferArray[n3].remaining((byte)9);
            }
            byteBuffer = ByteBuffer.allocate(n4);
            for (n3 = 0; n3 < directByteBufferArray.length; ++n3) {
                DirectByteBuffer directByteBuffer = directByteBufferArray[n3];
                byteBuffer.put(directByteBuffer.getBuffer((byte)9));
                directByteBuffer.returnToPool();
            }
            byteBuffer.flip();
            this.handshake_sent = true;
        }
        int n5 = this.manager.isSeeding() ? 4 : (this.manager.isRTA() ? (PeerClassifier.isAzureusIP(this.ip) ? 0 : 1) : (PeerClassifier.isAzureusIP(this.ip) ? 1 : 3));
        if (this.peer_source == "Plugin" && n5 > 2) {
            n5 = 2;
        }
        this.connection.connect(byteBuffer, n5, new NetworkConnection.ConnectionListener(){
            private boolean connect_ok;

            public final int connectStarted(int n) {
                PEPeerTransportProtocol.this.connection_state = 1;
                if (n <= 0) {
                    return n;
                }
                return PEPeerTransportProtocol.this.manager.getConnectTimeout(n);
            }

            public final void connectSuccess(ByteBuffer byteBuffer) {
                this.connect_ok = true;
                if (PEPeerTransportProtocol.this.closing) {
                    return;
                }
                PEPeerTransportProtocol.this.generateSessionId();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(PEPeerTransportProtocol.this, LOGID, "Out: Established outgoing connection"));
                }
                PEPeerTransportProtocol.this.initializeConnection();
                if (byteBuffer != null && byteBuffer.remaining() > 0) {
                    PEPeerTransportProtocol.this.connection.getOutgoingMessageQueue().addMessage(new BTRawMessage(new DirectByteBuffer(byteBuffer)), false);
                }
                PEPeerTransportProtocol.this.sendBTHandshake();
            }

            public final void connectFailure(Throwable throwable) {
                PEPeerTransportProtocol.this.closeConnectionInternally("failed to establish outgoing connection: " + throwable.getMessage(), true, true);
            }

            public final void exceptionThrown(Throwable throwable) {
                if (throwable.getMessage() == null) {
                    Debug.out("error.getMessage() == null", throwable);
                }
                PEPeerTransportProtocol.this.closeConnectionInternally("connection exception: " + throwable.getMessage(), !this.connect_ok, true);
            }

            public String getDescription() {
                return PEPeerTransportProtocol.this.getString();
            }
        });
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Out: Creating outgoing connection"));
        }
    }

    protected void initializeConnection() {
        if (this.closing) {
            return;
        }
        this.recent_outgoing_requests = new LinkedHashMap(16, 0.75f, true){

            public final boolean removeEldestEntry(Map.Entry entry) {
                return this.size() > 16;
            }
        };
        this.recent_outgoing_requests_mon = new AEMonitor("PEPeerTransportProtocol:ROR");
        this.message_limiter = new PeerMessageLimiter();
        this.outgoing_have_message_aggregator = new OutgoingBTHaveMessageAggregator(this.connection.getOutgoingMessageQueue(), this.other_peer_bt_have_version, this.other_peer_az_have_version);
        this.connection_established_time = SystemTime.getCurrentTime();
        this.connection_state = 2;
        this.changePeerState(20);
        this.registerForMessageHandling();
    }

    @Override
    public String getPeerSource() {
        return this.peer_source;
    }

    protected void closeConnectionInternally(String string, boolean bl, boolean bl2) {
        this.performClose(string, bl, false, bl2);
    }

    protected void closeConnectionInternally(String string) {
        this.performClose(string, false, false, false);
    }

    @Override
    public void closeConnection(String string) {
        this.performClose(string, false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performClose(String string, boolean bl, boolean bl2, boolean bl3) {
        try {
            this.closing_mon.enter();
            if (this.closing) {
                Object var6_5 = null;
                this.closing_mon.exit();
                return;
            }
            this.closing = true;
            this.interested_in_other_peer = false;
            this.lastNeededUndonePieceChange = Long.MAX_VALUE;
            if (this.isSnubbed()) {
                this.manager.decNbPeersSnubbed();
            }
            if (this.identityAdded) {
                if (this.peer_id != null) {
                    PeerIdentityManager.removeIdentity(this.manager.getPeerIdentityDataID(), this.peer_id, this.getPort());
                } else {
                    Debug.out("PeerIdentity added but peer_id == null !!!");
                }
                this.identityAdded = false;
            }
            this.changePeerState(40);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closing_mon.exit();
            throw throwable;
        }
        Object var6_6 = null;
        this.closing_mon.exit();
        this.cancelRequests();
        if (this.outgoing_have_message_aggregator != null) {
            this.outgoing_have_message_aggregator.destroy();
        }
        if (this.peer_exchange_item != null) {
            this.peer_exchange_item.destroy();
        }
        if (this.outgoing_piece_message_handler != null) {
            this.outgoing_piece_message_handler.destroy();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.ip_resolver_request != null) {
            this.ip_resolver_request.cancel();
        }
        this.removeAvailability();
        this.changePeerState(50);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Peer connection closed: " + string));
        }
        if (!bl2) {
            this.manager.peerConnectionClosed(this, bl, bl3);
        }
        this.setPriorityConnection(false);
        this.outgoing_have_message_aggregator = null;
        this.peer_exchange_item = null;
        this.outgoing_piece_message_handler = null;
        this.plugin_connection = null;
        if (this.peer_stats.getTotalDataBytesReceived() > 0L || this.peer_stats.getTotalDataBytesSent() > 0L || SystemTime.getCurrentTime() - this.connection_established_time > 30000L) {
            recentlyDisconnected.put(this.mySessionID, this);
        }
    }

    @Override
    public PEPeerTransport reconnect(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.isTCP() && (!bl || this.getUDPListenPort() <= 0);
        if (bl3 && this.getTCPListenPort() > 0 || !bl3 && this.getUDPListenPort() > 0) {
            boolean bl5 = this.getPeerItemIdentity().getHandshakeType() == 1;
            PEPeerTransport pEPeerTransport = PEPeerTransportFactory.createTransport(this.manager, this.getPeerSource(), bl2 && this.alternativeAddress != null ? this.alternativeAddress.getHostAddress() : this.getIp(), this.getTCPListenPort(), this.getUDPListenPort(), bl3, bl5, this.crypto_level, null);
            Logger.log(new LogEvent(new Object[]{this, pEPeerTransport}, LOGID, "attempting to reconnect, creating new connection"));
            if (pEPeerTransport instanceof PEPeerTransportProtocol) {
                PEPeerTransportProtocol pEPeerTransportProtocol = (PEPeerTransportProtocol)pEPeerTransport;
                pEPeerTransportProtocol.checkForReconnect(this.mySessionID);
                pEPeerTransportProtocol.alternativeAddress = this.alternativeAddress;
            }
            this.manager.addPeer(pEPeerTransport);
            return pEPeerTransport;
        }
        return null;
    }

    @Override
    public boolean isSafeForReconnect() {
        return this.allowReconnect;
    }

    private void checkForReconnect(HashWrapper hashWrapper) {
        PEPeerTransportProtocol pEPeerTransportProtocol = recentlyDisconnected.remove(hashWrapper);
        if (pEPeerTransportProtocol != null) {
            Logger.log(new LogEvent((Object)this, LOGID, 0, "reassociating stats from " + pEPeerTransportProtocol + " with this connection"));
            this.peerSessionID = pEPeerTransportProtocol.peerSessionID;
            this.peer_stats = pEPeerTransportProtocol.peer_stats;
            this.peer_stats.setPeer(this);
            this.setSnubbed(pEPeerTransportProtocol.isSnubbed());
            this.snubbed = pEPeerTransportProtocol.snubbed;
            this.last_good_data_time = pEPeerTransportProtocol.last_good_data_time;
        }
    }

    private void generateSessionId() {
        SHA1Hasher sHA1Hasher = new SHA1Hasher();
        sHA1Hasher.update(sessionSecret);
        sHA1Hasher.update(this.manager.getHash());
        sHA1Hasher.update(this.getIp().getBytes());
        this.mySessionID = sHA1Hasher.getHash();
        this.checkForReconnect(this.mySessionID);
    }

    private void addAvailability() {
        List list;
        if (!this.availabilityAdded && !this.closing && this.peerHavePieces != null && this.current_peer_state == 30 && (list = this.peer_listeners_cow) != null) {
            for (int i = 0; i < list.size(); ++i) {
                PEPeerListener pEPeerListener = (PEPeerListener)list.get(i);
                pEPeerListener.addAvailability(this, this.peerHavePieces);
            }
            this.availabilityAdded = true;
        }
    }

    private void removeAvailability() {
        if (this.availabilityAdded && this.peerHavePieces != null) {
            List list = this.peer_listeners_cow;
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    PEPeerListener pEPeerListener = (PEPeerListener)list.get(i);
                    pEPeerListener.removeAvailability(this, this.peerHavePieces);
                }
            }
            this.availabilityAdded = false;
        }
        this.peerHavePieces = null;
    }

    protected void sendBTHandshake() {
        if (!this.handshake_sent) {
            BTHandshake bTHandshake = new BTHandshake(this.manager.getHash(), this.manager.getPeerId(), this.manager.isExtendedMessagingEnabled(), this.other_peer_handshake_version);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this, LOGID, "Sending handshake with reserved bytes: " + ByteFormatter.nicePrint(bTHandshake.getReserved(), false)));
            }
            if (Constants.isCVSVersion()) {
                boolean bl;
                byte[] byArray = bTHandshake.getReserved();
                boolean bl2 = (byArray[0] & 0x80) == 128;
                boolean bl3 = bl = (byArray[5] & 0x10) == 16;
                if (bl && !bl2) {
                    Logger.log(new LogAlert((Object)this, false, 3, "AZMP support has failed in Azureus, please report this in the <a href=\"http://forum.vuze.com/forum.jspa?forumID=4\">CVS bug report forum</a>.\nDebug data: " + ByteFormatter.nicePrint(byArray)));
                }
            }
            this.connection.getOutgoingMessageQueue().addMessage(bTHandshake, false);
        }
    }

    private void sendLTHandshake() {
        InetAddress inetAddress;
        String string = "Azureus 4.5.0.4";
        int n = TCPNetworkManager.getSingleton().getTCPListeningPortNumber();
        String string2 = COConfigurationManager.getStringParameter("TCP.Listen.Port.Override");
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean bl = NetworkManager.getCryptoRequired(this.manager.getAdapter().getCryptoLevel());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("m", lt_ext_map);
        hashMap.put("v", string);
        hashMap.put("p", new Integer(n));
        hashMap.put("e", new Long(bl ? 1L : 0L));
        hashMap.put("upload_only", new Long(this.manager.isSeeding() && !ENABLE_LAZY_BITFIELD && !this.manual_lazy_bitfield_control ? 1L : 0L));
        InetAddress inetAddress2 = inetAddress = NetworkAdmin.getSingleton().hasIPV6Potential(true) ? NetworkAdmin.getSingleton().getDefaultPublicAddressV6() : null;
        if (inetAddress != null) {
            hashMap.put("ipv6", inetAddress.getAddress());
        }
        LTHandshake lTHandshake = new LTHandshake(hashMap, this.other_peer_bt_lt_ext_version);
        this.connection.getOutgoingMessageQueue().addMessage(lTHandshake, false);
    }

    private void sendAZHandshake() {
        int n;
        Message[] messageArray = MessageManager.getSingleton().getRegisteredMessages();
        String[] stringArray = new String[messageArray.length];
        byte[] byArray = new byte[messageArray.length];
        for (n = 0; n < messageArray.length; ++n) {
            stringArray[n] = messageArray[n].getID();
            byArray[n] = messageArray[n].getVersion();
        }
        n = TCPNetworkManager.getSingleton().getTCPListeningPortNumber();
        int n2 = UDPNetworkManager.getSingleton().getUDPListeningPortNumber();
        int n3 = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
        String string = COConfigurationManager.getStringParameter("TCP.Listen.Port.Override");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean bl = NetworkManager.getCryptoRequired(this.manager.getAdapter().getCryptoLevel());
        if (this.peerSessionID != null) {
            Logger.log(new LogEvent((Object)this, LOGID, 0, "notifying peer of reconnect attempt"));
        }
        AZHandshake aZHandshake = new AZHandshake(AZPeerIdentityManager.getAZPeerIdentity(), this.mySessionID, this.peerSessionID, "Azureus", "4.5.0.4", n, n2, n3, NetworkAdmin.getSingleton().hasIPV6Potential(true) ? NetworkAdmin.getSingleton().getDefaultPublicAddressV6() : null, stringArray, byArray, bl ? 1 : 0, this.other_peer_handshake_version, this.manager.isSeeding() && !ENABLE_LAZY_BITFIELD && !this.manual_lazy_bitfield_control);
        this.connection.getOutgoingMessageQueue().addMessage(aZHandshake, false);
    }

    @Override
    public int getPeerState() {
        return this.current_peer_state;
    }

    @Override
    public boolean isDownloadPossible() {
        if (!this.closing && !this.effectively_choked_by_other_peer) {
            if (this.lastNeededUndonePieceChange < this.piecePicker.getNeededUndonePieceChange()) {
                this.checkInterested();
                this.lastNeededUndonePieceChange = this.piecePicker.getNeededUndonePieceChange();
            }
            if (this.interested_in_other_peer && this.current_peer_state == 30) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPercentDoneInThousandNotation() {
        long l = this.getBytesDownloaded();
        return (int)(l * 1000L / this.diskManager.getTotalLength());
    }

    @Override
    public boolean transferAvailable() {
        return !this.effectively_choked_by_other_peer && this.interested_in_other_peer;
    }

    private void printRequestStats() {
        if (SHOW_DISCARD_RATE_STATS) {
            float f = (float)requests_discarded * 100.0f / ((float)(requests_completed + requests_recovered + requests_discarded) * 1.0f);
            float f2 = (float)requests_discarded_endgame * 100.0f / ((float)(requests_completed + requests_recovered + requests_discarded_endgame) * 1.0f);
            float f3 = (float)requests_recovered * 100.0f / ((float)(requests_recovered + requests_discarded) * 1.0f);
            System.out.println("c=" + requests_completed + " d=" + requests_discarded + " de=" + requests_discarded_endgame + " r=" + requests_recovered + " dp=" + f + "% dpe=" + f2 + "% rp=" + f3 + "%");
        }
    }

    private void checkSeed() {
        if (this.peerHavePieces != null && this.nbPieces > 0) {
            this.setSeed(this.peerHavePieces.nbSet == this.nbPieces);
        } else {
            this.setSeed(false);
        }
        if (this.manager.isSeeding() && this.isSeed()) {
            this.relativeSeeding = (byte)(this.relativeSeeding | 2);
        } else if (this.manager.isSeeding() && (this.relativeSeeding & 1) != 0) {
            this.relativeSeeding = (byte)(this.relativeSeeding | 2);
        } else if (this.peerHavePieces != null && this.nbPieces > 0) {
            int n = this.manager.getPiecePicker().getNbPiecesDone();
            DiskManagerPiece[] diskManagerPieceArray = this.diskManager.getPieces();
            boolean bl = true;
            if (!this.manager.isSeeding() && (this.relativeSeeding & 1) != 0) {
                for (int i = this.peerHavePieces.start; i <= this.peerHavePieces.end && (bl &= !this.peerHavePieces.flags[i] || diskManagerPieceArray[i].isDone() || !diskManagerPieceArray[i].isNeeded()); ++i) {
                }
            } else if (this.manager.isSeeding() && n <= this.peerHavePieces.nbSet) {
                for (int i = this.peerHavePieces.start; i <= this.peerHavePieces.end && (bl &= !diskManagerPieceArray[i].isDone() || this.peerHavePieces.flags[i]); ++i) {
                }
            } else {
                bl = false;
            }
            this.relativeSeeding = bl ? (byte)(this.relativeSeeding | 2) : (byte)(this.relativeSeeding & 0xFFFFFFFD);
        } else {
            this.relativeSeeding = (byte)(this.relativeSeeding & 0xFFFFFFFD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskManagerReadRequest request(int n, int n2, int n3) {
        DiskManagerReadRequest diskManagerReadRequest = this.manager.createDiskManagerRequest(n, n2, n3);
        if (this.current_peer_state != 30) {
            this.manager.requestCanceled(diskManagerReadRequest);
            return null;
        }
        boolean bl = false;
        try {
            this.requested_mon.enter();
            if (!this.requested.contains(diskManagerReadRequest)) {
                this.requested.add(diskManagerReadRequest);
                bl = true;
            }
            Object var7_6 = null;
            this.requested_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.requested_mon.exit();
            throw throwable;
        }
        if (bl) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTRequest(n, n2, n3, this.other_peer_request_version), false);
            this._lastPiece = n;
            try {
                this.recent_outgoing_requests_mon.enter();
                this.recent_outgoing_requests.put(diskManagerReadRequest, null);
                Object var9_9 = null;
                this.recent_outgoing_requests_mon.exit();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.recent_outgoing_requests_mon.exit();
                throw throwable;
            }
        }
        return diskManagerReadRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestIndex(DiskManagerReadRequest diskManagerReadRequest) {
        try {
            this.requested_mon.enter();
            int n = this.requested.indexOf(diskManagerReadRequest);
            Object var4_3 = null;
            this.requested_mon.exit();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.requested_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void sendCancel(DiskManagerReadRequest diskManagerReadRequest) {
        if (this.current_peer_state != 30) {
            return;
        }
        if (this.hasBeenRequested(diskManagerReadRequest)) {
            this.removeRequest(diskManagerReadRequest);
            this.connection.getOutgoingMessageQueue().addMessage(new BTCancel(diskManagerReadRequest.getPieceNumber(), diskManagerReadRequest.getOffset(), diskManagerReadRequest.getLength(), this.other_peer_cancel_version), false);
        }
    }

    @Override
    public void sendHave(int n) {
        if (this.current_peer_state != 30 || n == this.manager.getHiddenPiece()) {
            return;
        }
        boolean bl = !this.other_peer_interested_in_me && this.peerHavePieces != null && !this.peerHavePieces.flags[n];
        this.outgoing_have_message_aggregator.queueHaveMessage(n, bl || this.have_aggregation_disabled);
        this.checkInterested();
    }

    @Override
    public void sendChoke() {
        if (this.current_peer_state != 30) {
            return;
        }
        this.connection.getOutgoingMessageQueue().addMessage(new BTChoke(this.other_peer_choke_version), false);
        this.choking_other_peer = true;
        this.is_optimistic_unchoke = false;
        this.destroyPieceMessageHandler();
    }

    @Override
    public void sendUnChoke() {
        if (this.current_peer_state != 30) {
            return;
        }
        this.createPieceMessageHandler();
        this.choking_other_peer = false;
        this.connection.getOutgoingMessageQueue().addMessage(new BTUnchoke(this.other_peer_unchoke_version), false);
    }

    private void createPieceMessageHandler() {
        if (this.outgoing_piece_message_handler == null) {
            this.outgoing_piece_message_handler = new OutgoingBTPieceMessageHandler(this, this.connection.getOutgoingMessageQueue(), new OutgoingBTPieceMessageHandlerAdapter(){

                public void diskRequestCompleted(long l) {
                    PEPeerTransportProtocol.this.peer_stats.diskReadComplete(l);
                }
            }, this.other_peer_piece_version);
        }
    }

    private void destroyPieceMessageHandler() {
        if (this.outgoing_piece_message_handler != null) {
            this.outgoing_piece_message_handler.removeAllPieceRequests();
            this.outgoing_piece_message_handler.destroy();
            this.outgoing_piece_message_handler = null;
        }
    }

    private void sendKeepAlive() {
        if (this.current_peer_state != 30) {
            return;
        }
        if (this.outgoing_have_message_aggregator.hasPending()) {
            this.outgoing_have_message_aggregator.forceSendOfPending();
        } else {
            this.connection.getOutgoingMessageQueue().addMessage(new BTKeepAlive(this.other_peer_keep_alive_version), false);
        }
    }

    private void sendMainlineDHTPort() {
        if (!this.ml_dht_enabled) {
            return;
        }
        MainlineDHTProvider mainlineDHTProvider = PEPeerTransportProtocol.getDHTProvider();
        if (mainlineDHTProvider == null) {
            return;
        }
        BTDHTPort bTDHTPort = new BTDHTPort(mainlineDHTProvider.getDHTPort());
        this.connection.getOutgoingMessageQueue().addMessage(bTDHTPort, false);
    }

    @Override
    public void checkInterested() {
        if (this.closing || this.peerHavePieces == null || this.peerHavePieces.nbSet == 0) {
            return;
        }
        boolean bl = false;
        if (this.piecePicker.hasDownloadablePiece()) {
            if (!this.isSeed() && !this.isRelativeSeed()) {
                for (int i = this.peerHavePieces.start; i <= this.peerHavePieces.end; ++i) {
                    if (!this.peerHavePieces.flags[i] || !this.diskManager.isInteresting(i)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
        }
        if (bl && !this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTInterested(this.other_peer_interested_version), false);
        } else if (!bl && this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTUninterested(this.other_peer_uninterested_version), false);
        }
        this.interested_in_other_peer = bl;
    }

    private void sendBitField() {
        int n;
        int n2;
        int n3;
        if (this.closing) {
            return;
        }
        if (this.manager.isSuperSeedMode()) {
            return;
        }
        DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)12, (this.nbPieces + 7) / 8);
        DiskManagerPiece[] diskManagerPieceArray = this.diskManager.getPieces();
        int n4 = diskManagerPieceArray.length;
        HashSet<MutableInteger> hashSet = null;
        int[] nArray = null;
        if (ENABLE_LAZY_BITFIELD || this.manual_lazy_bitfield_control) {
            int n5;
            int n6;
            n3 = Math.min(n4, 8);
            n2 = n4 / 8 * 8;
            int n7 = n4 - n2;
            if (n7 == 0) {
                n7 = 8;
                n2 -= 8;
            }
            hashSet = new HashSet<MutableInteger>();
            n = rnd.nextInt(n3);
            if (diskManagerPieceArray[n].isDone()) {
                hashSet.add(new MutableInteger(n));
            }
            if (diskManagerPieceArray[n6 = n2 + rnd.nextInt(n7)].isDone()) {
                hashSet.add(new MutableInteger(n6));
            }
            int n8 = rnd.nextInt(16) + 4;
            for (n5 = 0; n5 < n8; ++n5) {
                int n9 = rnd.nextInt(n4);
                if (!diskManagerPieceArray[n9].isDone()) continue;
                hashSet.add(new MutableInteger(n9));
            }
            n5 = hashSet.size();
            if (n5 == 0) {
                hashSet = null;
            } else {
                int n10;
                int n11;
                nArray = new int[n5];
                Iterator iterator = hashSet.iterator();
                for (n11 = 0; n11 < n5; ++n11) {
                    nArray[n11] = n10 = ((MutableInteger)iterator.next()).getValue();
                }
                if (n5 > 1) {
                    for (n11 = 0; n11 < n5; ++n11) {
                        n10 = rnd.nextInt(n5);
                        if (n10 == n11) continue;
                        int n12 = nArray[n10];
                        nArray[n10] = nArray[n11];
                        nArray[n11] = n12;
                    }
                }
            }
        }
        n3 = 0;
        MutableInteger mutableInteger2 = new MutableInteger(0);
        n = this.manager.getHiddenPiece();
        for (n2 = 0; n2 < n4; ++n2) {
            if (n2 % 8 == 0) {
                n3 = 0;
            }
            n3 <<= 1;
            if (diskManagerPieceArray[n2].isDone() && n2 != n) {
                if (hashSet != null) {
                    mutableInteger2.setValue(n2);
                    if (!hashSet.contains(mutableInteger2)) {
                        ++n3;
                    }
                } else {
                    ++n3;
                }
            }
            if (n2 % 8 != 7) continue;
            directByteBuffer.put((byte)6, (byte)n3);
        }
        if (n2 % 8 != 0) {
            directByteBuffer.put((byte)6, (byte)(n3 <<= 8 - n2 % 8));
        }
        directByteBuffer.flip((byte)6);
        this.connection.getOutgoingMessageQueue().addMessage(new BTBitfield(directByteBuffer, this.other_peer_bitfield_version), false);
        if (nArray != null) {
            if (this.manual_lazy_bitfield_control) {
                this.manual_lazy_haves = nArray;
            } else {
                this.sendLazyHaves(nArray, false);
            }
        }
    }

    protected void sendLazyHaves(final int[] nArray, boolean bl) {
        if (bl) {
            if (this.current_peer_state == 30) {
                for (int n : nArray) {
                    this.connection.getOutgoingMessageQueue().addMessage(new BTHave(n, this.other_peer_bt_have_version), false);
                }
            }
        } else {
            SimpleTimer.addEvent("LazyHaveSender", SystemTime.getCurrentTime() + 1000L + (long)rnd.nextInt(2000), new TimerEventPerformer(){
                int next_have = 0;

                public void perform(TimerEvent timerEvent2) {
                    if (PEPeerTransportProtocol.this.current_peer_state == 30) {
                        int n = nArray[this.next_have++];
                        PEPeerTransportProtocol.this.connection.getOutgoingMessageQueue().addMessage(new BTHave(n, PEPeerTransportProtocol.this.other_peer_bt_have_version), false);
                        if (this.next_have < nArray.length && PEPeerTransportProtocol.this.current_peer_state == 30) {
                            SimpleTimer.addEvent("LazyHaveSender", SystemTime.getCurrentTime() + (long)rnd.nextInt(2000), this);
                        }
                    }
                }
            });
        }
    }

    @Override
    public byte[] getId() {
        return this.peer_id;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public InetAddress getAlternativeIPv6() {
        return this.alternativeAddress;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getTCPListenPort() {
        return this.tcp_listen_port;
    }

    @Override
    public int getUDPListenPort() {
        return this.udp_listen_port;
    }

    @Override
    public int getUDPNonDataListenPort() {
        return this.udp_non_data_port;
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public boolean isIncoming() {
        return this.incoming;
    }

    @Override
    public boolean isOptimisticUnchoke() {
        return this.is_optimistic_unchoke && !this.isChokedByMe();
    }

    @Override
    public void setOptimisticUnchoke(boolean bl) {
        this.is_optimistic_unchoke = bl;
    }

    @Override
    public PEPeerControl getControl() {
        return this.manager;
    }

    @Override
    public PEPeerManager getManager() {
        return this.manager;
    }

    @Override
    public PEPeerStats getStats() {
        return this.peer_stats;
    }

    @Override
    public int[] getPriorityOffsets() {
        return this.piece_priority_offsets;
    }

    @Override
    public boolean requestAllocationStarts(int[] nArray) {
        return false;
    }

    @Override
    public void requestAllocationComplete() {
    }

    @Override
    public BitFlags getAvailable() {
        return this.peerHavePieces;
    }

    @Override
    public boolean isPieceAvailable(int n) {
        if (this.peerHavePieces != null) {
            return this.peerHavePieces.flags[n];
        }
        return false;
    }

    @Override
    public boolean isChokingMe() {
        return this.effectively_choked_by_other_peer;
    }

    @Override
    public boolean isUnchokeOverride() {
        return this.really_choked_by_other_peer && !this.effectively_choked_by_other_peer;
    }

    @Override
    public boolean isChokedByMe() {
        return this.choking_other_peer;
    }

    @Override
    public boolean isInteresting() {
        return this.interested_in_other_peer;
    }

    @Override
    public boolean isInterested() {
        return this.other_peer_interested_in_me;
    }

    @Override
    public boolean isSeed() {
        return this.seeding;
    }

    @Override
    public boolean isRelativeSeed() {
        return (this.relativeSeeding & 2) != 0;
    }

    private void setSeed(boolean bl) {
        if (this.seeding != bl) {
            this.seeding = bl;
            PeerExchangerItem peerExchangerItem = this.peer_exchange_item;
            if (peerExchangerItem != null && bl) {
                peerExchangerItem.seedStatusChanged();
            }
        }
    }

    @Override
    public boolean isSnubbed() {
        return this.snubbed != 0L;
    }

    @Override
    public long getSnubbedTime() {
        if (this.snubbed == 0L) {
            return 0L;
        }
        long l = SystemTime.getCurrentTime();
        if (l < this.snubbed) {
            this.snubbed = l - 26L;
        }
        return l - this.snubbed;
    }

    @Override
    public void setSnubbed(boolean bl) {
        if (!this.closing) {
            long l = SystemTime.getCurrentTime();
            if (!bl) {
                if (this.snubbed != 0L) {
                    this.snubbed = 0L;
                    this.manager.decNbPeersSnubbed();
                }
            } else if (this.snubbed == 0L) {
                this.snubbed = l;
                this.manager.incNbPeersSnubbed();
            }
        }
    }

    @Override
    public void setUploadHint(int n) {
        this.spreadTimeHint = n;
    }

    @Override
    public int getUploadHint() {
        return this.spreadTimeHint;
    }

    @Override
    public void setUniqueAnnounce(int n) {
        this.uniquePiece = n;
    }

    @Override
    public int getUniqueAnnounce() {
        return this.uniquePiece;
    }

    @Override
    public Object getData(String string) {
        return this.getUserData(string);
    }

    @Override
    public void setData(String string, Object object) {
        this.setUserData(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object object) {
        block3: {
            try {
                this.general_mon.enter();
                if (this.data != null) break block3;
                Object var2_2 = null;
                Object var4_4 = null;
                this.general_mon.exit();
                return var2_2;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.general_mon.exit();
                throw throwable;
            }
        }
        Object v = this.data.get(object);
        Object var4_5 = null;
        this.general_mon.exit();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object object, Object object2) {
        try {
            this.general_mon.enter();
            if (this.data == null) {
                this.data = new LightHashMap();
            }
            if (object2 == null) {
                if (this.data.containsKey(object)) {
                    this.data.remove(object);
                    if (this.data.size() == 0) {
                        this.data = null;
                    }
                }
            } else {
                this.data.put(object, object2);
            }
            Object var4_3 = null;
            this.general_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.general_mon.exit();
            throw throwable;
        }
    }

    @Override
    public String getIPHostName() {
        if (this.ip_resolved == null) {
            this.ip_resolved = this.ip;
            this.ip_resolver_request = IPToHostNameResolver.addResolverRequest(this.ip_resolved, new IPToHostNameResolverListener(){

                public final void IPResolutionComplete(String string, boolean bl) {
                    PEPeerTransportProtocol.this.ip_resolved = string;
                }
            });
        }
        return this.ip_resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRequests() {
        if (!this.closing) {
            Message[] messageArray = new Message[]{new BTRequest(-1, -1, -1, this.other_peer_request_version)};
            this.connection.getOutgoingMessageQueue().removeMessagesOfType(messageArray, false);
        }
        if (this.requested != null && this.requested.size() > 0) {
            try {
                long l;
                this.requested_mon.enter();
                if (!(this.closing || (l = this.getTimeSinceGoodDataReceived()) != -1L && l <= 60000L)) {
                    this.setSnubbed(true);
                }
                for (int i = this.requested.size() - 1; i >= 0; --i) {
                    DiskManagerReadRequest diskManagerReadRequest = (DiskManagerReadRequest)this.requested.remove(i);
                    this.manager.requestCanceled(diskManagerReadRequest);
                }
                Object var4_5 = null;
                this.requested_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.requested_mon.exit();
                throw throwable;
            }
        }
    }

    @Override
    public int getMaxNbRequests() {
        return -1;
    }

    @Override
    public int getNbRequests() {
        return this.requested.size();
    }

    @Override
    public List getExpiredRequests() {
        ArrayList<DiskManagerReadRequest> arrayList = null;
        try {
            for (int i = this.requested.size() - 1; i >= 0; --i) {
                DiskManagerReadRequest diskManagerReadRequest = (DiskManagerReadRequest)this.requested.get(i);
                if (!diskManagerReadRequest.isExpired()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<DiskManagerReadRequest>();
                }
                arrayList.add(diskManagerReadRequest);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasBeenRequested(DiskManagerReadRequest diskManagerReadRequest) {
        try {
            this.requested_mon.enter();
            boolean bl = this.requested.contains(diskManagerReadRequest);
            Object var4_3 = null;
            this.requested_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.requested_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRequest(DiskManagerReadRequest diskManagerReadRequest) {
        try {
            this.requested_mon.enter();
            this.requested.remove(diskManagerReadRequest);
            Object var3_2 = null;
            this.requested_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.requested_mon.exit();
            throw throwable;
        }
        BTRequest bTRequest = new BTRequest(diskManagerReadRequest.getPieceNumber(), diskManagerReadRequest.getOffset(), diskManagerReadRequest.getLength(), this.other_peer_request_version);
        this.connection.getOutgoingMessageQueue().removeMessage(bTRequest, false);
        bTRequest.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRequestsTime(long l) {
        try {
            this.requested_mon.enter();
            int n = this.requested.size();
            for (int i = 0; i < n; ++i) {
                DiskManagerReadRequest diskManagerReadRequest = (DiskManagerReadRequest)this.requested.get(i);
                if (diskManagerReadRequest == null) continue;
                diskManagerReadRequest.resetTime(l);
            }
            Object var7_5 = null;
            this.requested_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.requested_mon.exit();
            throw throwable;
        }
    }

    public String toString() {
        if (this.connection != null && this.connection.isConnected()) {
            return this.connection + (this.isTCP() ? " [" : "(UDP) [") + this.client + "]";
        }
        return (this.isIncoming() ? "R: " : "L: ") + this.ip + ":" + this.port + (this.isTCP() ? " [" : "(UDP) [") + this.client + "]";
    }

    public String getString() {
        return this.toString();
    }

    @Override
    public void doKeepAliveCheck() {
        long l = SystemTime.getCurrentTime();
        long l2 = l - this.last_message_sent_time;
        if (this.last_message_sent_time == 0L || l2 < 0L) {
            this.last_message_sent_time = l;
            return;
        }
        if (l2 > 120000L) {
            this.sendKeepAlive();
            this.last_message_sent_time = l;
        }
    }

    @Override
    public boolean doTimeoutChecks() {
        if (this.connection != null) {
            this.connection.getOutgoingMessageQueue().setPriorityBoost(enable_upload_bias && !this.manager.isSeeding());
        }
        if (this.fast_extension_enabled) {
            this.checkAllowedFast();
        }
        long l = SystemTime.getCurrentTime();
        if (this.connection_state == 4) {
            if (this.last_message_received_time > l) {
                this.last_message_received_time = l;
            }
            if (this.last_data_message_received_time > l) {
                this.last_data_message_received_time = l;
            }
            if (l - this.last_message_received_time > 300000L && l - this.last_data_message_received_time > 300000L) {
                this.closeConnectionInternally("timed out while waiting for messages", false, true);
                return true;
            }
        } else if (this.connection_state == 2) {
            if (this.connection_established_time > l) {
                this.connection_established_time = l;
            } else if (l - this.connection_established_time > 180000L) {
                this.closeConnectionInternally("timed out while waiting for handshake");
                return true;
            }
        }
        return false;
    }

    @Override
    public void doPerformanceTuningCheck() {
        Transport transport = this.connection.getTransport();
        if (transport != null && this.peer_stats != null && this.outgoing_piece_message_handler != null) {
            long l = this.peer_stats.getDataSendRate() + this.peer_stats.getProtocolSendRate();
            if (l >= 3125000L) {
                transport.setTransportMode(2);
                this.outgoing_piece_message_handler.setRequestReadAhead(256);
            } else if (l >= 1250000L) {
                transport.setTransportMode(2);
                this.outgoing_piece_message_handler.setRequestReadAhead(128);
            } else if (l >= 125000L) {
                if (transport.getTransportMode() < 1) {
                    transport.setTransportMode(1);
                }
                this.outgoing_piece_message_handler.setRequestReadAhead(32);
            } else if (l >= 62500L) {
                this.outgoing_piece_message_handler.setRequestReadAhead(16);
            } else if (l >= 31250L) {
                this.outgoing_piece_message_handler.setRequestReadAhead(8);
            } else if (l >= 12500L) {
                this.outgoing_piece_message_handler.setRequestReadAhead(4);
            } else {
                this.outgoing_piece_message_handler.setRequestReadAhead(2);
            }
            long l2 = this.peer_stats.getDataReceiveRate() + this.peer_stats.getProtocolReceiveRate();
            if (l2 >= 1250000L) {
                transport.setTransportMode(2);
            } else if (l2 >= 125000L && transport.getTransportMode() < 1) {
                transport.setTransportMode(1);
            }
        }
    }

    @Override
    public int getConnectionState() {
        return this.connection_state;
    }

    @Override
    public long getTimeSinceLastDataMessageReceived() {
        if (this.last_data_message_received_time == -1L) {
            return -1L;
        }
        long l = SystemTime.getCurrentTime();
        if (this.last_data_message_received_time > l) {
            this.last_data_message_received_time = l;
        }
        return l - this.last_data_message_received_time;
    }

    @Override
    public long getTimeSinceGoodDataReceived() {
        if (this.last_good_data_time == -1L) {
            return -1L;
        }
        long l = SystemTime.getCurrentTime();
        if (this.last_good_data_time > l) {
            this.last_good_data_time = l;
        }
        return l - this.last_good_data_time;
    }

    @Override
    public long getTimeSinceLastDataMessageSent() {
        if (this.last_data_message_sent_time == -1L) {
            return -1L;
        }
        long l = SystemTime.getCurrentTime();
        if (this.last_data_message_sent_time > l) {
            this.last_data_message_sent_time = l;
        }
        return l - this.last_data_message_sent_time;
    }

    @Override
    public long getTimeSinceConnectionEstablished() {
        if (this.connection_established_time == 0L) {
            return 0L;
        }
        long l = SystemTime.getCurrentTime();
        if (this.connection_established_time > l) {
            this.connection_established_time = l;
        }
        return l - this.connection_established_time;
    }

    @Override
    public int getConsecutiveNoRequestCount() {
        return this.consecutive_no_request_count;
    }

    @Override
    public void setConsecutiveNoRequestCount(int n) {
        this.consecutive_no_request_count = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decodeBTHandshake(BTHandshake bTHandshake) {
        Object object;
        block22: {
            block21: {
                int n;
                boolean bl;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this, LOGID, "Received handshake with reserved bytes: " + ByteFormatter.nicePrint(bTHandshake.getReserved(), false)));
                }
                PeerIdentityDataID peerIdentityDataID = this.manager.getPeerIdentityDataID();
                if (this.getConnectionState() == 4) {
                    bTHandshake.destroy();
                    this.closeConnectionInternally("peer sent another handshake after the initial connect");
                }
                if (!Arrays.equals(this.manager.getHash(), bTHandshake.getDataHash())) {
                    this.closeConnectionInternally("handshake has wrong infohash");
                    bTHandshake.destroy();
                    return;
                }
                this.peer_id = bTHandshake.getPeerId();
                this.client_peer_id = this.client = StringInterner.intern(PeerClassifier.getClientDescription(this.peer_id));
                if (!PeerClassifier.isClientTypeAllowed(this.client)) {
                    this.closeConnectionInternally(this.client + " client type not allowed to connect, banned");
                    bTHandshake.destroy();
                    return;
                }
                if (Arrays.equals(this.manager.getPeerId(), this.peer_id)) {
                    this.manager.peerVerifiedAsSelf(this);
                    this.closeConnectionInternally("given peer id matches myself");
                    bTHandshake.destroy();
                    return;
                }
                boolean bl2 = PeerIdentityManager.containsIdentity(peerIdentityDataID, this.peer_id, this.getPort());
                boolean bl3 = false;
                boolean bl4 = bl = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || this.ip.equals("127.0.0.1");
                if (!bl && PeerIdentityManager.containsIPAddress(peerIdentityDataID, this.ip)) {
                    bl3 = true;
                }
                if (bl2) {
                    n = 1;
                    if (this.connection.isLANLocal() && (object = this.manager.getTransportFromIdentity(this.peer_id)) != null) {
                        String string = object.getIp();
                        if (!object.isLANLocal() || string.endsWith(".1") && !string.equals(this.ip)) {
                            Debug.outNoStack("Dropping existing non-lanlocal peer connection [" + object + "] in favour of [" + this + "]");
                            this.manager.removePeer((PEPeer)object);
                            n = 0;
                        }
                    }
                    if (n != 0) {
                        this.closeConnectionInternally("peer matches already-connected peer id");
                        bTHandshake.destroy();
                        return;
                    }
                }
                if (bl3) {
                    this.closeConnectionInternally("peer matches already-connected IP address, duplicate connections not allowed");
                    bTHandshake.destroy();
                    return;
                }
                n = this.manager.getMaxNewConnectionsAllowed();
                if (n == 0 && !this.manager.doOptimisticDisconnect(this.isLANLocal(), this.isPriorityConnection())) {
                    object = "too many existing peer connections [p" + PeerIdentityManager.getIdentityCount(peerIdentityDataID) + "/g" + PeerIdentityManager.getTotalIdentityCount() + ", pmx" + PeerUtils.MAX_CONNECTIONS_PER_TORRENT + "/gmx" + PeerUtils.MAX_CONNECTIONS_TOTAL + "/dmx" + this.manager.getMaxConnections() + "]";
                    this.closeConnectionInternally((String)object);
                    bTHandshake.destroy();
                    return;
                }
                try {
                    this.closing_mon.enter();
                    if (this.closing) {
                        this.closeConnectionInternally("connection already closing");
                        bTHandshake.destroy();
                        Object var10_10 = null;
                        this.closing_mon.exit();
                        return;
                    }
                    if (!PeerIdentityManager.addIdentity(peerIdentityDataID, this.peer_id, this.getPort(), this.ip)) {
                        this.closeConnectionInternally("peer matches already-connected peer id");
                        bTHandshake.destroy();
                        break block21;
                    }
                    this.identityAdded = true;
                    break block22;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    this.closing_mon.exit();
                    throw throwable;
                }
            }
            Object var10_11 = null;
            this.closing_mon.exit();
            return;
        }
        Object var10_12 = null;
        this.closing_mon.exit();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "In: has sent their handshake"));
        }
        this.handshake_reserved_bytes = bTHandshake.getReserved();
        this.ml_dht_enabled = (this.handshake_reserved_bytes[7] & 1) == 1;
        this.fast_extension_enabled = (this.handshake_reserved_bytes[7] & 4) != 0;
        this.messaging_mode = this.decideExtensionProtocol(bTHandshake);
        if (this.messaging_mode == 2) {
            if (Logger.isEnabled() && this.client.indexOf("Azureus") == -1) {
                Logger.log(new LogEvent(this, LOGID, "Handshake claims extended AZ messaging support... enabling AZ mode."));
            }
            this.ml_dht_enabled = false;
            object = this.connection.getTransport();
            int n = object.isEncrypted() ? (object.isTCP() ? 1 : 2) : 0;
            this.connection.getIncomingMessageQueue().setDecoder(new AZMessageDecoder());
            this.connection.getOutgoingMessageQueue().setEncoder(new AZMessageEncoder(n));
            this.sendAZHandshake();
            bTHandshake.destroy();
            return;
        }
        if (this.messaging_mode != 3) {
            this.client = ClientIdentifier.identifyBTOnly(this.client_peer_id, this.handshake_reserved_bytes);
            this.connection.getIncomingMessageQueue().getDecoder().resumeDecoding();
            this.initPostConnection(bTHandshake);
            return;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Enabling LT extension protocol support..."));
        }
        this.connection.getIncomingMessageQueue().setDecoder(new LTMessageDecoder());
        this.connection.getOutgoingMessageQueue().setEncoder(new LTMessageEncoder(this));
        this.generateSessionId();
        this.initPostConnection(bTHandshake);
        this.sendLTHandshake();
    }

    private int decideExtensionProtocol(BTHandshake bTHandshake) {
        boolean bl;
        boolean bl2;
        boolean bl3 = (bTHandshake.getReserved()[0] & 0x80) == 128;
        boolean bl4 = bl2 = (bTHandshake.getReserved()[5] & 0x10) == 16;
        if (!bl3) {
            if (bl2) {
                if (!this.manager.isExtendedMessagingEnabled()) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this, LOGID, "Ignoring peer's LT extension protocol support, as disabled for this download."));
                    }
                    return 1;
                }
                return 3;
            }
            return 1;
        }
        if (!bl2) {
            if (!this.manager.isExtendedMessagingEnabled()) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this, LOGID, "Ignoring peer's extended AZ messaging support, as disabled for this download."));
                }
                return 1;
            }
            if (this.client.indexOf("Plus!") != -1) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this, LOGID, "Handshake mistakingly indicates extended AZ messaging support...ignoring."));
                }
                return 1;
            }
            return 2;
        }
        boolean bl5 = (bTHandshake.getReserved()[5] & 2) == 2;
        boolean bl6 = (bTHandshake.getReserved()[5] & 1) == 1;
        String string = (bl5 == bl6 ? "Force " : "Prefer ") + (bl5 ? "AZMP" : "LTEP");
        String string2 = "Force AZMP";
        boolean bl7 = bl = bl5 || bl6;
        if (Logger.isEnabled()) {
            String string3 = "Peer supports both AZMP and LTEP: ";
            string3 = string3 + "\"" + string2 + "\"" + (bl7 ? ">" : "<") + (string2.equals(string) ? "= " : " ");
            string3 = string3 + "\"" + string + "\" - using " + (bl ? "AZMP" : "LTEP");
            Logger.log(new LogEvent(this, LOGID, string3));
        }
        return bl ? 2 : 3;
    }

    protected void decodeLTHandshake(LTHandshake lTHandshake) {
        Object object;
        String string = lTHandshake.getClientName();
        if (string != null) {
            this.client_handshake = StringInterner.intern(string);
            this.client = StringInterner.intern(ClientIdentifier.identifyLTEP(this.client_peer_id, this.client_handshake, this.peer_id));
        }
        if (lTHandshake.getTCPListeningPort() > 0) {
            object = lTHandshake.isCryptoRequested();
            byte by = object != null && ((Boolean)object).booleanValue() ? (byte)1 : 0;
            this.tcp_listen_port = lTHandshake.getTCPListeningPort();
            this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.tcp_listen_port, PeerItem.convertSourceID(this.peer_source), by, this.udp_listen_port, this.crypto_level, 0);
        }
        if (lTHandshake.isUploadOnly()) {
            this.relativeSeeding = (byte)(this.relativeSeeding | 1);
            this.checkSeed();
        }
        if (AddressUtils.isGlobalAddressV6(lTHandshake.getIPv6())) {
            this.alternativeAddress = lTHandshake.getIPv6();
        }
        object = (LTMessageEncoder)this.connection.getOutgoingMessageQueue().getEncoder();
        ((LTMessageEncoder)object).updateSupportedExtensions(lTHandshake.getExtensionMapping());
        this.ut_pex_enabled = ((LTMessageEncoder)object).supportsUTPEX();
        this.doPostHandshakeProcessing();
        lTHandshake.destroy();
    }

    protected void decodeAZHandshake(AZHandshake aZHandshake) {
        if (this.getConnectionState() == 4) {
            aZHandshake.destroy();
            this.closeConnectionInternally("peer sent another az-handshake after the intial connect");
        }
        this.client_handshake = StringInterner.intern(aZHandshake.getClient());
        this.client_handshake_version = StringInterner.intern(aZHandshake.getClientVersion());
        this.client = StringInterner.intern(ClientIdentifier.identifyAZMP(this.client_peer_id, this.client_handshake, this.client_handshake_version, this.peer_id));
        if (aZHandshake.getTCPListenPort() > 0) {
            this.tcp_listen_port = aZHandshake.getTCPListenPort();
            this.udp_listen_port = aZHandshake.getUDPListenPort();
            this.udp_non_data_port = aZHandshake.getUDPNonDataListenPort();
            byte by = aZHandshake.getHandshakeType() == 1 ? (byte)1 : 0;
            this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.tcp_listen_port, PeerItem.convertSourceID(this.peer_source), by, this.udp_listen_port, this.crypto_level, 0);
        }
        if (AddressUtils.isGlobalAddressV6(aZHandshake.getIPv6())) {
            this.alternativeAddress = aZHandshake.getIPv6();
        }
        if (aZHandshake.getReconnectSessionID() != null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 0, "received reconnect request ID: " + aZHandshake.getReconnectSessionID().toBase32String()));
            }
            this.checkForReconnect(aZHandshake.getReconnectSessionID());
        }
        if (aZHandshake.getRemoteSessionID() != null) {
            this.peerSessionID = aZHandshake.getRemoteSessionID();
        }
        if (aZHandshake.isUploadOnly()) {
            this.relativeSeeding = (byte)(this.relativeSeeding | 1);
            this.checkSeed();
        }
        String[] stringArray = aZHandshake.getMessageIDs();
        byte[] byArray = aZHandshake.getMessageVersions();
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (int i = 0; i < aZHandshake.getMessageIDs().length; ++i) {
            Message message = MessageManager.getSingleton().lookupMessage(stringArray[i]);
            if (message == null) continue;
            arrayList.add(message);
            String string = message.getID();
            byte by = byArray[i];
            if (string == "BT_BITFIELD") {
                this.other_peer_bitfield_version = by;
                continue;
            }
            if (string == "BT_CANCEL") {
                this.other_peer_cancel_version = by;
                continue;
            }
            if (string == "BT_CHOKE") {
                this.other_peer_choke_version = by;
                continue;
            }
            if (string == "BT_HANDSHAKE") {
                this.other_peer_handshake_version = by;
                continue;
            }
            if (string == "BT_HAVE") {
                this.other_peer_bt_have_version = by;
                continue;
            }
            if (string == "BT_INTERESTED") {
                this.other_peer_interested_version = by;
                continue;
            }
            if (string == "BT_KEEP_ALIVE") {
                this.other_peer_keep_alive_version = by;
                continue;
            }
            if (string == "BT_PIECE") {
                this.other_peer_piece_version = by;
                continue;
            }
            if (string == "BT_UNCHOKE") {
                this.other_peer_unchoke_version = by;
                continue;
            }
            if (string == "BT_UNINTERESTED") {
                this.other_peer_uninterested_version = by;
                continue;
            }
            if (string == "BT_REQUEST") {
                this.other_peer_request_version = by;
                continue;
            }
            if (string == "BT_SUGGEST_PIECE") {
                this.other_peer_suggest_piece_version = by;
                continue;
            }
            if (string == "BT_HAVE_ALL") {
                this.other_peer_have_all_version = by;
                continue;
            }
            if (string == "BT_HAVE_NONE") {
                this.other_peer_have_none_version = by;
                continue;
            }
            if (string == "BT_REJECT_REQUEST") {
                this.other_peer_reject_request_version = by;
                continue;
            }
            if (string == "BT_ALLOWED_FAST") {
                this.other_peer_allowed_fast_version = by;
                continue;
            }
            if (string == "AZ_PEER_EXCHANGE") {
                this.other_peer_pex_version = by;
                continue;
            }
            if (string == "AZ_REQUEST_HINT") {
                this.other_peer_az_request_hint_version = by;
                continue;
            }
            if (string == "AZ_HAVE") {
                this.other_peer_az_have_version = by;
                continue;
            }
            if (string == "AZ_BAD_PIECE") {
                this.other_peer_az_bad_piece_version = by;
                continue;
            }
            if (string == "AZ_STAT_REQ") {
                this.other_peer_az_stats_request_version = by;
                continue;
            }
            if (string == "AZ_STAT_REP") {
                this.other_peer_az_stats_reply_version = by;
                continue;
            }
            if (string != "BT_DHT_PORT") continue;
            this.ml_dht_enabled = true;
        }
        this.supported_messages = arrayList.toArray(new Message[arrayList.size()]);
        if (this.outgoing_piece_message_handler != null) {
            this.outgoing_piece_message_handler.setPieceVersion(this.other_peer_piece_version);
        }
        if (this.outgoing_have_message_aggregator != null) {
            this.outgoing_have_message_aggregator.setHaveVersion(this.other_peer_bt_have_version, this.other_peer_az_have_version);
        }
        this.initPostConnection(aZHandshake);
    }

    private void initPostConnection(Message message) {
        this.changePeerState(30);
        this.connection_state = 4;
        this.sendBitField();
        message.destroy();
        this.addAvailability();
        this.sendMainlineDHTPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeHaveAll(BTHaveAll bTHaveAll) {
        bTHaveAll.destroy();
        this.received_bitfield = true;
        try {
            this.closing_mon.enter();
            if (!this.closing) {
                BitFlags bitFlags;
                if (this.peerHavePieces == null) {
                    bitFlags = new BitFlags(this.nbPieces);
                } else {
                    bitFlags = this.peerHavePieces;
                    this.removeAvailability();
                }
                bitFlags.setAll();
                for (int i = 0; i < this.nbPieces; ++i) {
                    this.manager.updateSuperSeedPiece(this, i);
                }
                this.peerHavePieces = bitFlags;
                this.addAvailability();
                this.checkSeed();
                this.checkInterested();
            }
            Object var5_4 = null;
            this.closing_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closing_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeHaveNone(BTHaveNone bTHaveNone) {
        bTHaveNone.destroy();
        this.received_bitfield = true;
        try {
            this.closing_mon.enter();
            if (!this.closing) {
                BitFlags bitFlags;
                if (this.peerHavePieces == null) {
                    bitFlags = new BitFlags(this.nbPieces);
                } else {
                    bitFlags = this.peerHavePieces;
                    this.removeAvailability();
                }
                bitFlags.clear();
                this.peerHavePieces = bitFlags;
                this.addAvailability();
                this.checkSeed();
                this.checkInterested();
                this.checkFast(bitFlags);
            }
            Object var4_3 = null;
            this.closing_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.closing_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeBitfield(BTBitfield bTBitfield) {
        this.received_bitfield = true;
        DirectByteBuffer directByteBuffer = bTBitfield.getBitfield();
        byte[] byArray = new byte[(this.nbPieces + 7) / 8];
        if (directByteBuffer.remaining((byte)9) < byArray.length) {
            String string = this.toString() + " has sent invalid Bitfield: too short [" + directByteBuffer.remaining((byte)9) + "<" + byArray.length + "]";
            Debug.out(string);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, string));
            }
            bTBitfield.destroy();
            return;
        }
        directByteBuffer.get((byte)9, byArray);
        try {
            this.closing_mon.enter();
            if (this.closing) {
                bTBitfield.destroy();
            } else {
                BitFlags bitFlags;
                if (this.peerHavePieces == null) {
                    bitFlags = new BitFlags(this.nbPieces);
                } else {
                    bitFlags = this.peerHavePieces;
                    this.removeAvailability();
                }
                for (int i = 0; i < this.nbPieces; ++i) {
                    int n = i / 8;
                    byte by = byArray[n];
                    int n2 = 7 - i % 8;
                    byte by2 = (byte)(by >> n2);
                    if ((by2 & 1) != 1) continue;
                    bitFlags.set(i);
                    this.manager.updateSuperSeedPiece(this, i);
                }
                bTBitfield.destroy();
                this.peerHavePieces = bitFlags;
                this.addAvailability();
                this.checkSeed();
                this.checkInterested();
                this.checkFast(bitFlags);
            }
            Object var11_11 = null;
            this.closing_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.closing_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void setSuspendedLazyBitFieldEnabled(boolean bl) {
        this.manual_lazy_bitfield_control = bl;
        if (!bl) {
            int[] nArray = this.manual_lazy_haves;
            this.manual_lazy_haves = null;
            if (nArray != null) {
                this.sendLazyHaves(nArray, true);
            }
        }
    }

    protected void decodeMainlineDHTPort(BTDHTPort bTDHTPort) {
        int n = bTDHTPort.getDHTPort();
        bTDHTPort.destroy();
        if (!this.ml_dht_enabled) {
            return;
        }
        MainlineDHTProvider mainlineDHTProvider = PEPeerTransportProtocol.getDHTProvider();
        if (mainlineDHTProvider == null) {
            return;
        }
        try {
            mainlineDHTProvider.notifyOfIncomingPort(this.getIp(), n);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected void decodeChoke(BTChoke bTChoke) {
        bTChoke.destroy();
        if (!this.really_choked_by_other_peer) {
            this.really_choked_by_other_peer = true;
            this.calculatePiecePriorities();
            this.cancelRequests();
        }
    }

    protected void decodeUnchoke(BTUnchoke bTUnchoke) {
        bTUnchoke.destroy();
        if (this.really_choked_by_other_peer) {
            this.really_choked_by_other_peer = false;
            this.calculatePiecePriorities();
        }
    }

    protected void decodeInterested(BTInterested bTInterested) {
        bTInterested.destroy();
        boolean bl = this.other_peer_interested_in_me = !this.isSeed() && !this.isRelativeSeed();
        if (this.other_peer_interested_in_me && fast_unchoke_new_peers && this.isChokedByMe() && this.getData("fast_unchoke_done") == null) {
            this.setData("fast_unchoke_done", "");
            this.sendUnChoke();
        }
    }

    protected void decodeUninterested(BTUninterested bTUninterested) {
        bTUninterested.destroy();
        this.other_peer_interested_in_me = false;
        if (this.outgoing_have_message_aggregator != null) {
            this.outgoing_have_message_aggregator.forceSendOfPending();
        }
    }

    protected void decodeHave(BTHave bTHave) {
        int n = bTHave.getPieceNumber();
        bTHave.destroy();
        if (n >= this.nbPieces || n < 0) {
            this.closeConnectionInternally("invalid pieceNumber: " + n);
            return;
        }
        if (this.closing) {
            return;
        }
        if (this.peerHavePieces == null) {
            this.peerHavePieces = new BitFlags(this.nbPieces);
        }
        if (!this.peerHavePieces.flags[n]) {
            if (!this.interested_in_other_peer && this.diskManager.isInteresting(n)) {
                this.connection.getOutgoingMessageQueue().addMessage(new BTInterested(this.other_peer_interested_version), false);
                this.interested_in_other_peer = true;
            }
            this.peerHavePieces.set(n);
            int n2 = this.manager.getPieceLength(n);
            this.manager.havePiece(n, n2, this);
            this.checkSeed();
            this.other_peer_interested_in_me &= !this.isSeed() && !this.isRelativeSeed();
            this.peer_stats.hasNewPiece(n2);
        }
    }

    protected void decodeAZHave(AZHave aZHave) {
        int[] nArray = aZHave.getPieceNumbers();
        aZHave.destroy();
        if (this.closing) {
            return;
        }
        if (this.peerHavePieces == null) {
            this.peerHavePieces = new BitFlags(this.nbPieces);
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n >= this.nbPieces || n < 0) {
                this.closeConnectionInternally("invalid pieceNumber: " + n);
                return;
            }
            if (this.peerHavePieces.flags[n]) continue;
            bl2 = true;
            if (!bl && !this.interested_in_other_peer && this.diskManager.isInteresting(n)) {
                bl = true;
            }
            this.peerHavePieces.set(n);
            int n2 = this.manager.getPieceLength(n);
            this.manager.havePiece(n, n2, this);
            this.peer_stats.hasNewPiece(n2);
        }
        if (bl2) {
            this.checkSeed();
            this.other_peer_interested_in_me &= !this.isSeed() || !this.isRelativeSeed();
        }
        if (bl) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTInterested(this.other_peer_interested_version), false);
            this.interested_in_other_peer = true;
        }
    }

    protected long getBytesDownloaded() {
        if (this.peerHavePieces == null || this.peerHavePieces.flags.length == 0) {
            return 0L;
        }
        long l = this.peerHavePieces.flags[this.nbPieces - 1] ? (long)(this.peerHavePieces.nbSet - 1) * (long)this.diskManager.getPieceLength() + (long)this.diskManager.getPieceLength(this.nbPieces - 1) : (long)this.peerHavePieces.nbSet * (long)this.diskManager.getPieceLength();
        return Math.min(l, this.diskManager.getTotalLength());
    }

    @Override
    public long getBytesRemaining() {
        return this.diskManager.getTotalLength() - this.getBytesDownloaded();
    }

    @Override
    public void sendBadPiece(int n) {
        if (this.bad_piece_supported) {
            AZBadPiece aZBadPiece = new AZBadPiece(n, this.other_peer_az_bad_piece_version);
            this.connection.getOutgoingMessageQueue().addMessage(aZBadPiece, false);
        }
    }

    protected void decodeAZBadPiece(AZBadPiece aZBadPiece) {
        int n = aZBadPiece.getPieceNumber();
        aZBadPiece.destroy();
        this.manager.badPieceReported(this, n);
    }

    @Override
    public void sendStatsRequest(Map map) {
        if (this.stats_request_supported) {
            AZStatRequest aZStatRequest = new AZStatRequest(map, this.other_peer_az_stats_request_version);
            this.connection.getOutgoingMessageQueue().addMessage(aZStatRequest, false);
        }
    }

    protected void decodeAZStatsRequest(AZStatRequest aZStatRequest) {
        Map map = aZStatRequest.getRequest();
        aZStatRequest.destroy();
        this.manager.statsRequest(this, map);
    }

    @Override
    public void sendStatsReply(Map map) {
        if (this.stats_reply_supported) {
            AZStatReply aZStatReply = new AZStatReply(map, this.other_peer_az_stats_reply_version);
            this.connection.getOutgoingMessageQueue().addMessage(aZStatReply, false);
        }
    }

    protected void decodeAZStatsReply(AZStatReply aZStatReply) {
        Map map = aZStatReply.getReply();
        aZStatReply.destroy();
        this.manager.statsReply(this, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeRequest(BTRequest bTRequest) {
        int n = bTRequest.getPieceNumber();
        int n2 = bTRequest.getPieceOffset();
        int n3 = bTRequest.getLength();
        bTRequest.destroy();
        if (!this.manager.validateReadRequest(this, n, n2, n3)) {
            this.closeConnectionInternally("request for piece #" + n + ":" + n2 + "->" + (n2 + n3 - 1) + " is an invalid request");
            return;
        }
        if (this.manager.getHiddenPiece() == n) {
            this.closeConnectionInternally("request for piece #" + n + " is invalid as piece is hidden");
            return;
        }
        boolean bl = false;
        if (this.choking_other_peer) {
            try {
                this.general_mon.enter();
                int[][] nArray = (int[][])this.getUserData(KEY_ALLOWED_FAST_SENT);
                if (nArray != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i][0] != n || nArray[i][1] < n3) continue;
                        int[] nArray2 = nArray[i];
                        nArray2[1] = nArray2[1] - n3;
                        bl = true;
                        this.createPieceMessageHandler();
                        break;
                    }
                }
                Object var9_8 = null;
                this.general_mon.exit();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.general_mon.exit();
                throw throwable;
            }
        } else {
            bl = true;
        }
        if (bl) {
            if (this.outgoing_piece_message_handler == null || !this.outgoing_piece_message_handler.addPieceRequest(n, n2, n3)) {
                this.sendRejectRequest(n, n2, n3);
            }
            this.allowReconnect = true;
        } else {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this, LOGID, "decodeRequest(): peer request for piece #" + n + ":" + n2 + "->" + (n2 + n3 - 1) + " ignored as peer is currently choked."));
            }
            this.sendRejectRequest(n, n2, n3);
        }
    }

    @Override
    public void sendRejectRequest(DiskManagerReadRequest diskManagerReadRequest) {
        this.sendRejectRequest(diskManagerReadRequest.getPieceNumber(), diskManagerReadRequest.getOffset(), diskManagerReadRequest.getLength());
    }

    private void sendRejectRequest(int n, int n2, int n3) {
        if (this.fast_extension_enabled && !this.closing) {
            BTRejectRequest bTRejectRequest = new BTRejectRequest(n, n2, n3, this.other_peer_reject_request_version);
            this.connection.getOutgoingMessageQueue().addMessage(bTRejectRequest, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodePiece(BTPiece bTPiece) {
        final int n = bTPiece.getPieceNumber();
        final int n2 = bTPiece.getPieceOffset();
        DirectByteBuffer directByteBuffer = bTPiece.getPieceData();
        final int n3 = directByteBuffer.remaining((byte)9);
        Object object = new Object(){

            public final String toString() {
                return "decodePiece(): Peer has sent piece #" + n + ":" + n2 + "->" + (n2 + n3 - 1) + ", ";
            }
        };
        if (!this.manager.validatePieceReply(this, n, n2, directByteBuffer)) {
            this.peer_stats.bytesDiscarded(n3);
            this.manager.discarded(this, n3);
            ++requests_discarded;
            this.printRequestStats();
            bTPiece.destroy();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, object + "but piece block discarded as invalid."));
            }
            return;
        }
        DiskManagerReadRequest diskManagerReadRequest = this.manager.createDiskManagerRequest(n, n2, n3);
        boolean bl = true;
        if (this.hasBeenRequested(diskManagerReadRequest)) {
            this.removeRequest(diskManagerReadRequest);
            long l = SystemTime.getCurrentTime();
            this.resetRequestsTime(l);
            if (this.manager.isWritten(n, n2)) {
                this.peer_stats.bytesDiscarded(n3);
                this.manager.discarded(this, n3);
                if (this.manager.isInEndGameMode()) {
                    if (this.last_good_data_time != -1L && l - this.last_good_data_time <= 60000L) {
                        this.setSnubbed(false);
                    }
                    this.last_good_data_time = l;
                    ++requests_discarded_endgame;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 0, object + "but piece block ignored as already written in end-game mode."));
                    }
                } else {
                    if (!this.isSnubbed()) {
                        this.last_good_data_time = l;
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 1, object + "but piece block discarded as already written."));
                    }
                    ++requests_discarded;
                }
                this.printRequestStats();
            } else {
                this.manager.writeBlock(n, n2, directByteBuffer, this, false);
                if (this.last_good_data_time != -1L && l - this.last_good_data_time <= 60000L) {
                    this.setSnubbed(false);
                }
                this.last_good_data_time = l;
                ++requests_completed;
                bl = false;
            }
        } else if (!this.manager.isWritten(n, n2)) {
            boolean bl2;
            try {
                this.recent_outgoing_requests_mon.enter();
                bl2 = this.recent_outgoing_requests.containsKey(diskManagerReadRequest);
                Object var12_11 = null;
                this.recent_outgoing_requests_mon.exit();
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                this.recent_outgoing_requests_mon.exit();
                throw throwable;
            }
            if (bl2) {
                this.manager.writeBlock(n, n2, directByteBuffer, this, true);
                long l = SystemTime.getCurrentTime();
                if (this.last_good_data_time != -1L && l - this.last_good_data_time <= 60000L) {
                    this.setSnubbed(false);
                }
                this.resetRequestsTime(l);
                this.last_good_data_time = l;
                ++requests_recovered;
                this.printRequestStats();
                bl = false;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 0, object + "expired piece block data recovered as useful."));
                }
            } else {
                System.out.println("[" + this.client + "]" + object + "but expired piece block discarded as never requested.");
                this.peer_stats.bytesDiscarded(n3);
                this.manager.discarded(this, n3);
                ++requests_discarded;
                this.printRequestStats();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 3, object + "but expired piece block discarded as never requested."));
                }
            }
        } else {
            this.peer_stats.bytesDiscarded(n3);
            this.manager.discarded(this, n3);
            ++requests_discarded;
            this.printRequestStats();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 1, object + "but expired piece block discarded as already written."));
            }
        }
        if (bl) {
            bTPiece.destroy();
        } else {
            this.allowReconnect = true;
        }
    }

    protected void decodeCancel(BTCancel bTCancel) {
        int n = bTCancel.getPieceNumber();
        int n2 = bTCancel.getPieceOffset();
        int n3 = bTCancel.getLength();
        bTCancel.destroy();
        if (this.outgoing_piece_message_handler != null) {
            this.outgoing_piece_message_handler.removePieceRequest(n, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeRejectRequest(BTRejectRequest bTRejectRequest) {
        int n = bTRejectRequest.getPieceNumber();
        int n2 = bTRejectRequest.getPieceOffset();
        int n3 = bTRejectRequest.getLength();
        bTRejectRequest.destroy();
        DiskManagerReadRequest diskManagerReadRequest = this.manager.createDiskManagerRequest(n, n2, n3);
        if (this.hasBeenRequested(diskManagerReadRequest)) {
            this.removeRequest(diskManagerReadRequest);
            this.manager.requestCanceled(diskManagerReadRequest);
            try {
                int[] nArray;
                this.general_mon.enter();
                List list = (List)this.getUserData(KEY_ALLOWED_FAST_RECEIVED);
                if (list != null) {
                    list.remove(new Integer(n));
                    if (list.size() == 0) {
                        this.setUserData(KEY_ALLOWED_FAST_RECEIVED, null);
                    }
                }
                if ((nArray = this.piece_priority_offsets) != null) {
                    nArray[n] = Integer.MIN_VALUE;
                }
                this.calculatePiecePriorities();
                Object var9_8 = null;
                this.general_mon.exit();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.general_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeAllowedFast(BTAllowedFast bTAllowedFast) {
        int n = bTAllowedFast.getPieceNumber();
        bTAllowedFast.destroy();
        if (this.piecePicker.getNbPiecesDone() > 10) {
            return;
        }
        try {
            Integer n2;
            this.general_mon.enter();
            ArrayList<Integer> arrayList = (ArrayList<Integer>)this.getUserData(KEY_ALLOWED_FAST_RECEIVED);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>(10);
                this.setUserData(KEY_ALLOWED_FAST_RECEIVED, arrayList);
            }
            if (arrayList.size() < 20 && !arrayList.contains(n2 = new Integer(n)) && n2 >= 0 && n2 < this.nbPieces) {
                arrayList.add(n2);
                this.calculatePiecePriorities();
            }
            Object var6_5 = null;
            this.general_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.general_mon.exit();
            throw throwable;
        }
    }

    private void sendAllowFast(int n) {
        if (this.fast_extension_enabled) {
            BTAllowedFast bTAllowedFast = new BTAllowedFast(n, this.other_peer_allowed_fast_version);
            this.connection.getOutgoingMessageQueue().addMessage(bTAllowedFast, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculatePiecePriorities() {
        try {
            this.general_mon.enter();
            if (this.really_choked_by_other_peer) {
                List list = (List)this.getUserData(KEY_ALLOWED_FAST_RECEIVED);
                if (list == null) {
                    this.effectively_choked_by_other_peer = true;
                    this.piece_priority_offsets = null;
                } else {
                    int[] nArray = this.piece_priority_offsets;
                    if (nArray == null) {
                        nArray = new int[this.nbPieces];
                        Arrays.fill(nArray, Integer.MIN_VALUE);
                    }
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        nArray[n] = 0;
                    }
                    this.piece_priority_offsets = nArray;
                    if (this.effectively_choked_by_other_peer) {
                        this.effectively_choked_by_other_peer = false;
                        this.effectively_unchoked_time = SystemTime.getMonotonousTime();
                    }
                }
            } else {
                if (this.effectively_choked_by_other_peer) {
                    this.effectively_choked_by_other_peer = false;
                    this.effectively_unchoked_time = SystemTime.getMonotonousTime();
                }
                this.piece_priority_offsets = null;
            }
            Object var6_5 = null;
            this.general_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.general_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFast(BitFlags bitFlags) {
        if (this.fast_extension_enabled && !this.isSeed() && !this.isRelativeSeed() && PeerClassifier.fullySupportsFE(this.client_peer_id)) {
            int n;
            int[][] nArray;
            if (bitFlags.nbSet >= 10) {
                return;
            }
            try {
                this.general_mon.enter();
                nArray = (int[][])this.getUserData(KEY_ALLOWED_FAST_SENT);
                if (nArray == null) {
                    List<Integer> list = this.generateFastSet(10);
                    nArray = new int[list.size()][2];
                    n = this.diskManager.getPieceLength();
                    for (int i = 0; i < list.size(); ++i) {
                        int n2 = list.get(i);
                        nArray[i] = new int[]{n2, n * 2};
                    }
                    this.setUserData(KEY_ALLOWED_FAST_SENT, nArray);
                }
                Object var8_8 = null;
                this.general_mon.exit();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.general_mon.exit();
                throw throwable;
            }
            for (int i = 0; i < nArray.length; ++i) {
                n = nArray[i][0];
                if (bitFlags.flags[n]) continue;
                this.sendAllowFast(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllowedFast() {
        try {
            int[][] nArray;
            Object object;
            this.general_mon.enter();
            if (this.piecePicker.getNbPiecesDone() > 10 && (object = (List)this.getUserData(KEY_ALLOWED_FAST_RECEIVED)) != null) {
                this.setUserData(KEY_ALLOWED_FAST_RECEIVED, null);
                this.calculatePiecePriorities();
            }
            if ((object = this.peerHavePieces) != null && ((BitFlags)object).nbSet >= 10 && (nArray = (int[][])this.getUserData(KEY_ALLOWED_FAST_SENT)) != null) {
                this.setUserData(KEY_ALLOWED_FAST_SENT, null);
            }
            Object var4_3 = null;
            this.general_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.general_mon.exit();
            throw throwable;
        }
    }

    private void registerForMessageHandling() {
        this.connection.getIncomingMessageQueue().registerQueueListener(new IncomingMessageQueue.MessageQueueListener(){

            public final boolean messageReceived(Message message) {
                String string;
                long l;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(PEPeerTransportProtocol.this, LogIDs.NET, "Received [" + message.getDescription() + "] message"));
                }
                PEPeerTransportProtocol.this.last_message_received_time = l = SystemTime.getCurrentTime();
                if (message.getType() == 1) {
                    PEPeerTransportProtocol.this.last_data_message_received_time = l;
                }
                if ((string = message.getID()).equals("BT_PIECE")) {
                    PEPeerTransportProtocol.this.decodePiece((BTPiece)message);
                    return true;
                }
                if (PEPeerTransportProtocol.this.closing) {
                    message.destroy();
                    return true;
                }
                if (string.equals("BT_KEEP_ALIVE")) {
                    message.destroy();
                    if (!PEPeerTransportProtocol.this.message_limiter.countIncomingMessage(message.getID(), 6, 60000)) {
                        System.out.println(PEPeerTransportProtocol.this.manager.getDisplayName() + ": Incoming keep-alive message flood detected, dropping spamming peer connection." + PEPeerTransportProtocol.this);
                        PEPeerTransportProtocol.this.closeConnectionInternally("Incoming keep-alive message flood detected, dropping spamming peer connection.");
                    }
                    return true;
                }
                if (string.equals("BT_HANDSHAKE")) {
                    PEPeerTransportProtocol.this.decodeBTHandshake((BTHandshake)message);
                    return true;
                }
                if (string.equals("AZ_HANDSHAKE")) {
                    PEPeerTransportProtocol.this.decodeAZHandshake((AZHandshake)message);
                    return true;
                }
                if (string.equals("lt_handshake")) {
                    PEPeerTransportProtocol.this.decodeLTHandshake((LTHandshake)message);
                    return true;
                }
                if (string.equals("BT_BITFIELD")) {
                    PEPeerTransportProtocol.this.decodeBitfield((BTBitfield)message);
                    return true;
                }
                if (string.equals("BT_CHOKE")) {
                    PEPeerTransportProtocol.this.decodeChoke((BTChoke)message);
                    if (PEPeerTransportProtocol.this.choking_other_peer) {
                        PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(false, PEPeerTransportProtocol.this.manager.getPartitionID());
                    }
                    return true;
                }
                if (string.equals("BT_UNCHOKE")) {
                    PEPeerTransportProtocol.this.decodeUnchoke((BTUnchoke)message);
                    PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(true, PEPeerTransportProtocol.this.manager.getPartitionID());
                    return true;
                }
                if (string.equals("BT_INTERESTED")) {
                    PEPeerTransportProtocol.this.decodeInterested((BTInterested)message);
                    return true;
                }
                if (string.equals("BT_UNINTERESTED")) {
                    PEPeerTransportProtocol.this.decodeUninterested((BTUninterested)message);
                    return true;
                }
                if (string.equals("BT_HAVE")) {
                    PEPeerTransportProtocol.this.decodeHave((BTHave)message);
                    return true;
                }
                if (string.equals("BT_REQUEST")) {
                    PEPeerTransportProtocol.this.decodeRequest((BTRequest)message);
                    return true;
                }
                if (string.equals("BT_CANCEL")) {
                    PEPeerTransportProtocol.this.decodeCancel((BTCancel)message);
                    return true;
                }
                if (string.equals("BT_SUGGEST_PIECE")) {
                    PEPeerTransportProtocol.this.decodeSuggestPiece((BTSuggestPiece)message);
                    return true;
                }
                if (string.equals("BT_HAVE_ALL")) {
                    PEPeerTransportProtocol.this.decodeHaveAll((BTHaveAll)message);
                    return true;
                }
                if (string.equals("BT_HAVE_NONE")) {
                    PEPeerTransportProtocol.this.decodeHaveNone((BTHaveNone)message);
                    return true;
                }
                if (string.equals("BT_REJECT_REQUEST")) {
                    PEPeerTransportProtocol.this.decodeRejectRequest((BTRejectRequest)message);
                    return true;
                }
                if (string.equals("BT_ALLOWED_FAST")) {
                    PEPeerTransportProtocol.this.decodeAllowedFast((BTAllowedFast)message);
                    return true;
                }
                if (string.equals("BT_DHT_PORT")) {
                    PEPeerTransportProtocol.this.decodeMainlineDHTPort((BTDHTPort)message);
                    return true;
                }
                if (string.equals("AZ_PEER_EXCHANGE")) {
                    PEPeerTransportProtocol.this.decodePeerExchange((AZPeerExchange)message);
                    return true;
                }
                if (string.equals("ut_pex")) {
                    PEPeerTransportProtocol.this.decodePeerExchange((UTPeerExchange)message);
                    return true;
                }
                if (string.equals("AZ_REQUEST_HINT")) {
                    PEPeerTransportProtocol.this.decodeAZRequestHint((AZRequestHint)message);
                    return true;
                }
                if (string.equals("AZ_HAVE")) {
                    PEPeerTransportProtocol.this.decodeAZHave((AZHave)message);
                    return true;
                }
                if (string.equals("AZ_BAD_PIECE")) {
                    PEPeerTransportProtocol.this.decodeAZBadPiece((AZBadPiece)message);
                    return true;
                }
                if (string.equals("AZ_STAT_REQ")) {
                    PEPeerTransportProtocol.this.decodeAZStatsRequest((AZStatRequest)message);
                    return true;
                }
                if (string.equals("AZ_STAT_REP")) {
                    PEPeerTransportProtocol.this.decodeAZStatsReply((AZStatReply)message);
                    return true;
                }
                return false;
            }

            public final void protocolBytesReceived(int n) {
                PEPeerTransportProtocol.this.peer_stats.protocolBytesReceived(n);
                PEPeerTransportProtocol.this.manager.protocolBytesReceived(PEPeerTransportProtocol.this, n);
            }

            public final void dataBytesReceived(int n) {
                PEPeerTransportProtocol.this.last_data_message_received_time = SystemTime.getCurrentTime();
                PEPeerTransportProtocol.this.peer_stats.dataBytesReceived(n);
                PEPeerTransportProtocol.this.manager.dataBytesReceived(PEPeerTransportProtocol.this, n);
            }

            public boolean isPriority() {
                return false;
            }
        });
        this.connection.getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            public final boolean messageAdded(Message message) {
                return true;
            }

            public final void messageQueued(Message message) {
            }

            public final void messageRemoved(Message message) {
            }

            public final void messageSent(Message message) {
                long l;
                PEPeerTransportProtocol.this.last_message_sent_time = l = SystemTime.getCurrentTime();
                if (message.getType() == 1) {
                    PEPeerTransportProtocol.this.last_data_message_sent_time = l;
                }
                if (message.getID().equals("BT_UNCHOKE")) {
                    PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(true, PEPeerTransportProtocol.this.manager.getPartitionID());
                } else if (message.getID().equals("BT_CHOKE") && PEPeerTransportProtocol.this.effectively_choked_by_other_peer) {
                    PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(false, PEPeerTransportProtocol.this.manager.getPartitionID());
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(PEPeerTransportProtocol.this, LogIDs.NET, "Sent [" + message.getDescription() + "] message"));
                }
            }

            public final void protocolBytesSent(int n) {
                PEPeerTransportProtocol.this.peer_stats.protocolBytesSent(n);
                PEPeerTransportProtocol.this.manager.protocolBytesSent(PEPeerTransportProtocol.this, n);
            }

            public final void dataBytesSent(int n) {
                PEPeerTransportProtocol.this.peer_stats.dataBytesSent(n);
                PEPeerTransportProtocol.this.manager.dataBytesSent(PEPeerTransportProtocol.this, n);
            }

            public void flush() {
            }
        });
        this.connection.addRateLimiter(this.manager.getUploadLimitedRateGroup(), true);
        this.connection.addRateLimiter(this.manager.getDownloadLimitedRateGroup(), false);
        this.connection.startMessageProcessing();
    }

    @Override
    public void addRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        this.connection.addRateLimiter(limitedRateGroup, bl);
    }

    @Override
    public void removeRateLimiter(LimitedRateGroup limitedRateGroup, boolean bl) {
        this.connection.removeRateLimiter(limitedRateGroup, bl);
    }

    @Override
    public Connection getPluginConnection() {
        return this.plugin_connection;
    }

    @Override
    public Message[] getSupportedMessages() {
        return this.supported_messages;
    }

    @Override
    public boolean supportsMessaging() {
        return this.supported_messages != null;
    }

    @Override
    public int getMessagingMode() {
        return this.messaging_mode;
    }

    @Override
    public byte[] getHandshakeReservedBytes() {
        return this.handshake_reserved_bytes;
    }

    @Override
    public void setHaveAggregationEnabled(boolean bl) {
        this.have_aggregation_disabled = !bl;
    }

    @Override
    public boolean hasReceivedBitField() {
        return this.received_bitfield;
    }

    @Override
    public long getUnchokedForMillis() {
        long l = this.effectively_unchoked_time;
        if (this.effectively_choked_by_other_peer || l < 0L) {
            return -1L;
        }
        return SystemTime.getMonotonousTime() - l;
    }

    @Override
    public String getEncryption() {
        Transport transport = this.connection.getTransport();
        if (transport == null) {
            return "";
        }
        return transport.getEncryption(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PEPeerListener pEPeerListener) {
        try {
            this.peer_listeners_mon.enter();
            if (this.peer_listeners_cow == null) {
                this.peer_listeners_cow = new ArrayList();
            }
            ArrayList<PEPeerListener> arrayList = new ArrayList<PEPeerListener>(this.peer_listeners_cow);
            arrayList.add(pEPeerListener);
            this.peer_listeners_cow = arrayList;
            Object var4_3 = null;
            this.peer_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.peer_listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PEPeerListener pEPeerListener) {
        try {
            this.peer_listeners_mon.enter();
            if (this.peer_listeners_cow != null) {
                ArrayList arrayList = new ArrayList(this.peer_listeners_cow);
                arrayList.remove(pEPeerListener);
                if (arrayList.isEmpty()) {
                    arrayList = null;
                }
                this.peer_listeners_cow = arrayList;
            }
            Object var4_3 = null;
            this.peer_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.peer_listeners_mon.exit();
            throw throwable;
        }
    }

    private void changePeerState(int n) {
        List list;
        this.current_peer_state = n;
        if (this.current_peer_state == 30) {
            this.doPostHandshakeProcessing();
        }
        if ((list = this.peer_listeners_cow) != null) {
            for (int i = 0; i < list.size(); ++i) {
                PEPeerListener pEPeerListener = (PEPeerListener)list.get(i);
                pEPeerListener.stateChanged(this, this.current_peer_state);
            }
        }
    }

    private void doPostHandshakeProcessing() {
        if (this.manager.isPeerExchangeEnabled()) {
            PeerExchangerItem peerExchangerItem = this.peer_exchange_item;
            if (peerExchangerItem == null && this.canBePeerExchanged()) {
                peerExchangerItem = this.peer_exchange_item = this.manager.createPeerExchangeConnection(this);
            }
            if (peerExchangerItem != null) {
                if (this.ut_pex_enabled || this.peerSupportsMessageType("AZ_PEER_EXCHANGE")) {
                    this.peer_exchange_supported = true;
                    peerExchangerItem.enableStateMaintenance();
                } else {
                    peerExchangerItem.disableStateMaintenance();
                }
            }
        }
        this.request_hint_supported = this.peerSupportsMessageType("AZ_REQUEST_HINT");
        this.bad_piece_supported = this.peerSupportsMessageType("AZ_BAD_PIECE");
        this.stats_request_supported = this.peerSupportsMessageType("AZ_STAT_REQ");
        this.stats_reply_supported = this.peerSupportsMessageType("AZ_STAT_REP");
    }

    private boolean canBePeerExchanged() {
        if (this.client_peer_id != null) {
            boolean bl = !this.client_peer_id.startsWith("CacheLogic");
            return bl;
        }
        Debug.out("No client peer id!");
        return false;
    }

    private boolean peerSupportsMessageType(String string) {
        if (this.supported_messages != null) {
            for (int i = 0; i < this.supported_messages.length; ++i) {
                if (!this.supported_messages[i].getID().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void updatePeerExchange() {
        if (this.current_peer_state != 30) {
            return;
        }
        if (!this.peer_exchange_supported) {
            return;
        }
        PeerExchangerItem peerExchangerItem = this.peer_exchange_item;
        if (peerExchangerItem != null && this.manager.isPeerExchangeEnabled()) {
            PeerItem[] peerItemArray = peerExchangerItem.getNewlyAddedPeerConnections();
            PeerItem[] peerItemArray2 = peerExchangerItem.getNewlyDroppedPeerConnections();
            if (peerItemArray != null && peerItemArray.length > 0 || peerItemArray2 != null && peerItemArray2.length > 0) {
                if (this.ut_pex_enabled) {
                    this.connection.getOutgoingMessageQueue().addMessage(new UTPeerExchange(peerItemArray, peerItemArray2, null, 0), false);
                } else {
                    this.connection.getOutgoingMessageQueue().addMessage(new AZPeerExchange(this.manager.getHash(), peerItemArray, peerItemArray2, this.other_peer_pex_version), false);
                }
            }
        }
    }

    protected void decodePeerExchange(AZStylePeerExchange aZStylePeerExchange) {
        PeerItem[] peerItemArray = aZStylePeerExchange instanceof UTPeerExchange ? ((UTPeerExchange)aZStylePeerExchange).getAddedPeers(!this.manager.isSeeding() && !Constants.DOWNLOAD_SOURCES_PRETEND_COMPLETE) : aZStylePeerExchange.getAddedPeers();
        PeerItem[] peerItemArray2 = aZStylePeerExchange.getDroppedPeers();
        if (!this.message_limiter.countIncomingMessage(aZStylePeerExchange.getID(), 7, 120000)) {
            System.out.println(this.manager.getDisplayName() + ": Incoming PEX message flood detected, dropping spamming peer connection." + this);
            this.closeConnectionInternally("Incoming PEX message flood detected, dropping spamming peer connection.");
            return;
        }
        aZStylePeerExchange.destroy();
        if (peerItemArray != null && peerItemArray.length > aZStylePeerExchange.getMaxAllowedPeersPerVolley(!this.has_received_initial_pex, true) || peerItemArray2 != null && peerItemArray2.length > aZStylePeerExchange.getMaxAllowedPeersPerVolley(!this.has_received_initial_pex, false)) {
            this.closeConnectionInternally("Invalid PEX message received: too large, dropping likely poisoner peer connection.");
            return;
        }
        this.has_received_initial_pex = true;
        PeerExchangerItem peerExchangerItem = this.peer_exchange_item;
        if (this.peer_exchange_supported && peerExchangerItem != null && this.manager.isPeerExchangeEnabled()) {
            int n;
            if (peerItemArray != null) {
                for (n = 0; n < peerItemArray.length; ++n) {
                    PeerItem peerItem = peerItemArray[n];
                    this.manager.peerDiscovered(this, peerItem);
                    peerExchangerItem.addConnectedPeer(peerItem);
                }
            }
            if (peerItemArray2 != null) {
                for (n = 0; n < peerItemArray2.length; ++n) {
                    peerExchangerItem.dropConnectedPeer(peerItemArray2[n]);
                }
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Peer Exchange disabled for this download, dropping received exchange message"));
        }
    }

    @Override
    public boolean sendRequestHint(int n, int n2, int n3, int n4) {
        if (this.request_hint_supported) {
            AZRequestHint aZRequestHint = new AZRequestHint(n, n2, n3, n4, this.other_peer_az_request_hint_version);
            this.connection.getOutgoingMessageQueue().addMessage(aZRequestHint, false);
            return true;
        }
        return false;
    }

    protected void decodeSuggestPiece(BTSuggestPiece bTSuggestPiece) {
        int n = bTSuggestPiece.getPieceNumber();
        int n2 = 0;
        int n3 = this.manager.getPieceLength(n);
        int n4 = 150000;
        bTSuggestPiece.destroy();
        if (n4 > 150000) {
            n4 = 150000;
        }
        if (this.manager.validateHintRequest(this, n, n2, n3) && this.request_hint == null) {
            this.request_hint = new int[]{n, n2, n3};
        }
    }

    protected void decodeAZRequestHint(AZRequestHint aZRequestHint) {
        int n = aZRequestHint.getPieceNumber();
        int n2 = aZRequestHint.getOffset();
        int n3 = aZRequestHint.getLength();
        int n4 = aZRequestHint.getLife();
        aZRequestHint.destroy();
        if (n4 > 150000) {
            n4 = 150000;
        }
        if (this.manager.validateHintRequest(this, n, n2, n3) && this.request_hint == null) {
            this.request_hint = new int[]{n, n2, n3};
        }
    }

    @Override
    public int[] getRequestHint() {
        return this.request_hint;
    }

    @Override
    public void clearRequestHint() {
        this.request_hint = null;
    }

    @Override
    public PeerItem getPeerItemIdentity() {
        return this.peer_item_identity;
    }

    @Override
    public int[] getReservedPieceNumbers() {
        return this.reserved_pieces;
    }

    @Override
    public void addReservedPieceNumber(int n) {
        int[] nArray = this.reserved_pieces;
        if (nArray == null) {
            this.reserved_pieces = new int[]{n};
        } else {
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray.length] = n;
            this.reserved_pieces = nArray2;
        }
    }

    @Override
    public void removeReservedPieceNumber(int n) {
        int[] nArray = this.reserved_pieces;
        if (nArray != null) {
            if (nArray.length == 1) {
                if (nArray[0] == n) {
                    this.reserved_pieces = null;
                }
            } else {
                int[] nArray2 = new int[nArray.length - 1];
                int n2 = 0;
                boolean bl = false;
                for (int i = 0; i < nArray.length; ++i) {
                    int n3 = nArray[i];
                    if (bl || n3 != n) {
                        if (n2 == nArray2.length) {
                            return;
                        }
                        nArray2[n2++] = n3;
                        continue;
                    }
                    bl = true;
                }
                this.reserved_pieces = nArray2;
            }
        }
    }

    @Override
    public int getIncomingRequestCount() {
        if (this.outgoing_piece_message_handler == null) {
            return 0;
        }
        return this.outgoing_piece_message_handler.getRequestCount();
    }

    @Override
    public int getOutgoingRequestCount() {
        return this.getNbRequests();
    }

    @Override
    public int getOutboundDataQueueSize() {
        return this.connection.getOutgoingMessageQueue().getTotalSize();
    }

    @Override
    public boolean isStalledPendingLoad() {
        if (this.outgoing_piece_message_handler == null) {
            return false;
        }
        return this.outgoing_piece_message_handler.isStalledPendingLoad();
    }

    @Override
    public int[] getIncomingRequestedPieceNumbers() {
        if (this.outgoing_piece_message_handler == null) {
            return new int[0];
        }
        return this.outgoing_piece_message_handler.getRequestedPieceNumbers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getOutgoingRequestedPieceNumbers() {
        try {
            Object object;
            this.requested_mon.enter();
            int n = -1;
            int[] nArray = new int[this.requested.size()];
            int n2 = 0;
            for (int i = 0; i < this.requested.size(); ++i) {
                object = null;
                try {
                    object = (DiskManagerReadRequest)this.requested.get(i);
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                }
                if (object == null || n == object.getPieceNumber()) continue;
                n = object.getPieceNumber();
                nArray[n2++] = n;
            }
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            object = nArray2;
            Object var8_8 = null;
            this.requested_mon.exit();
            return object;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.requested_mon.exit();
            throw throwable;
        }
    }

    @Override
    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.connection.getIncomingMessageQueue().getPercentDoneOfCurrentMessage();
    }

    @Override
    public int getPercentDoneOfCurrentOutgoingRequest() {
        return this.connection.getOutgoingMessageQueue().getPercentDoneOfCurrentMessage();
    }

    @Override
    public String getRelationText() {
        String string = "";
        if (this.manager instanceof LogRelation) {
            string = ((LogRelation)((Object)this.manager)).getRelationText() + "; ";
        }
        string = string + "Peer: " + this.toString();
        return string;
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.manager};
    }

    @Override
    public int getLastPiece() {
        return this._lastPiece;
    }

    @Override
    public void setLastPiece(int n) {
        this._lastPiece = n;
    }

    @Override
    public boolean isLANLocal() {
        if (this.connection == null) {
            return AddressUtils.isLANLocalAddress(this.ip) == 1;
        }
        return this.connection.isLANLocal();
    }

    @Override
    public boolean isTCP() {
        return this.connection.getEndpoint().getProtocols()[0].getType() == 1;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int n) {
        this.connection.setUploadLimit(n);
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int n) {
        this.connection.setDownloadLimit(n);
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.connection.getUploadLimit();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.connection.getDownloadLimit();
    }

    @Override
    public String getClientNameFromPeerID() {
        return this.client_peer_id;
    }

    @Override
    public String getClientNameFromExtensionHandshake() {
        if (!this.client_handshake.equals("") && !this.client_handshake_version.equals("")) {
            return this.client_handshake + " " + this.client_handshake_version;
        }
        return this.client_handshake;
    }

    private static MainlineDHTProvider getDHTProvider() {
        return AzureusCoreImpl.getSingleton().getGlobalManager().getMainlineDHTProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPriorityConnection(boolean bl) {
        PEPeerTransportProtocol pEPeerTransportProtocol = this;
        synchronized (pEPeerTransportProtocol) {
            if (this.priority_connection == bl) {
                return;
            }
            this.priority_connection = bl;
        }
        this.manager.getAdapter().priorityConnectionChanged(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPriorityConnection() {
        PEPeerTransportProtocol pEPeerTransportProtocol = this;
        synchronized (pEPeerTransportProtocol) {
            return this.priority_connection;
        }
    }

    protected static List<Integer> generateFastSet(byte[] byArray, String string, int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            byte[] byArray2 = InetAddress.getByName(string).getAddress();
            if (byArray2.length == 4) {
                byte[] byArray3 = new byte[24];
                System.arraycopy(byArray2, 0, byArray3, 0, 3);
                System.arraycopy(byArray, 0, byArray3, 4, 20);
                n2 = Math.min(n2, n);
                while (arrayList.size() < n2) {
                    byArray3 = new SHA1Simple().calculateHash(byArray3);
                    int n3 = 0;
                    while (n3 < 20 && arrayList.size() < n2) {
                        long l;
                        Integer n4;
                        if (arrayList.contains(n4 = new Integer((int)((l = (long)(byArray3[n3++] << 24) & 0xFF000000L | (long)(byArray3[n3++] << 16) & 0xFF0000L | (long)(byArray3[n3++] << 8) & 0xFF00L | (long)byArray3[n3++] & 0xFFL) % (long)n)))) continue;
                        arrayList.add(n4);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Debug.out("Fast set generation failed", throwable);
        }
        return arrayList;
    }

    protected List<Integer> generateFastSet(int n) {
        return PEPeerTransportProtocol.generateFastSet(this.manager.getHash(), this.getIp(), this.nbPieces, n);
    }

    @Override
    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("ip=" + this.getIp() + ",in=" + this.isIncoming() + ",port=" + this.getPort() + ",cli=" + this.client + ",tcp=" + this.getTCPListenPort() + ",udp=" + this.getUDPListenPort() + ",oudp=" + this.getUDPNonDataListenPort() + ",p_state=" + this.getPeerState() + ",c_state=" + this.getConnectionState() + ",seed=" + this.isSeed() + "partialSeed=" + this.isRelativeSeed() + ",pex=" + this.peer_exchange_supported + ",closing=" + this.closing);
        indentWriter.println("    choked=" + this.effectively_choked_by_other_peer + "/" + this.really_choked_by_other_peer + ",choking=" + this.choking_other_peer + ",is_opt=" + this.is_optimistic_unchoke);
        indentWriter.println("    interested=" + this.interested_in_other_peer + ",interesting=" + this.other_peer_interested_in_me + ",snubbed=" + this.snubbed);
        indentWriter.println("    lp=" + this._lastPiece + ",up=" + this.uniquePiece + ",rp=" + this.reserved_pieces);
        indentWriter.println("    last_sent=" + this.last_message_sent_time + "/" + this.last_data_message_sent_time + ",last_recv=" + this.last_message_received_time + "/" + this.last_data_message_received_time + "/" + this.last_good_data_time);
        indentWriter.println("    conn_at=" + this.connection_established_time + ",cons_no_reqs=" + this.consecutive_no_request_count + ",discard=" + requests_discarded + "/" + requests_discarded_endgame + ",recov=" + requests_recovered + ",comp=" + requests_completed);
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[20];
        Arrays.fill(byArray, (byte)-86);
        try {
            List<Integer> list = PEPeerTransportProtocol.generateFastSet(byArray, "80.4.4.200", 9, 5);
            System.out.println(list);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        String string = System.getProperty("show.discard.rate.stats");
        SHOW_DISCARD_RATE_STATS = string != null && string.equals("1");
        requests_discarded = 0;
        requests_discarded_endgame = 0;
        requests_recovered = 0;
        requests_completed = 0;
        recentlyDisconnected = new DisconnectedTransportQueue();
        rnd = RandomUtils.SECURE_RANDOM;
        rnd.setSeed(SystemTime.getHighPrecisionCounter());
        sessionSecret = new byte[20];
        rnd.nextBytes(sessionSecret);
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Use Lazy Bitfield", "Peer.Fast.Initial.Unchoke.Enabled", "Bias Upload Enable"}, new ParameterListener(){

            public final void parameterChanged(String string) {
                String string2 = System.getProperty("azureus.lazy.bitfield");
                ENABLE_LAZY_BITFIELD = string2 != null && string2.equals("1");
                ENABLE_LAZY_BITFIELD |= COConfigurationManager.getBooleanParameter("Use Lazy Bitfield");
                fast_unchoke_new_peers = COConfigurationManager.getBooleanParameter("Peer.Fast.Initial.Unchoke.Enabled");
                enable_upload_bias = COConfigurationManager.getBooleanParameter("Bias Upload Enable");
            }
        });
        lt_ext_map = Collections.singletonMap("ut_pex", new Integer(1));
    }

    protected static class MutableInteger {
        private int value;

        protected MutableInteger(int n) {
            this.value = n;
        }

        protected void setValue(int n) {
            this.value = n;
        }

        protected int getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object instanceof MutableInteger) {
                return this.value == ((MutableInteger)object).value;
            }
            return false;
        }
    }

    private static final class DisconnectedTransportQueue
    extends LinkedHashMap {
        private static final long MAX_CACHE_AGE = 120000L;

        public DisconnectedTransportQueue() {
            super(20, 0.75f);
        }

        private void performCleaning() {
            if (this.size() > 20) {
                Iterator iterator = this.values().iterator();
                long l = SystemTime.getMonotonousTime();
                while (iterator.hasNext() && this.size() > 20) {
                    QueueEntry queueEntry = (QueueEntry)iterator.next();
                    if (l - queueEntry.addTime <= 120000L) break;
                    iterator.remove();
                }
            }
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 100;
        }

        public synchronized Object put(HashWrapper hashWrapper, PEPeerTransportProtocol pEPeerTransportProtocol) {
            this.performCleaning();
            return super.put(hashWrapper, new QueueEntry(pEPeerTransportProtocol));
        }

        public synchronized PEPeerTransportProtocol remove(HashWrapper hashWrapper) {
            this.performCleaning();
            QueueEntry queueEntry = (QueueEntry)super.remove(hashWrapper);
            if (queueEntry != null) {
                return queueEntry.transport;
            }
            return null;
        }

        private static final class QueueEntry {
            final PEPeerTransportProtocol transport;
            final long addTime = SystemTime.getMonotonousTime();

            public QueueEntry(PEPeerTransportProtocol pEPeerTransportProtocol) {
                this.transport = pEPeerTransportProtocol;
            }
        }
    }
}

