/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class TOTorrentXMLDeserialiser {
    public TOTorrent deserialise(File file) throws TOTorrentException {
        try {
            SimpleXMLParserDocument simpleXMLParserDocument = SimpleXMLParserDocumentFactory.create(file);
            TOTorrent tOTorrent = this.decodeRoot(simpleXMLParserDocument);
            return tOTorrent;
        }
        catch (SimpleXMLParserDocumentException simpleXMLParserDocumentException) {
            throw new TOTorrentException("XML Parse Fails: " + simpleXMLParserDocumentException.getMessage(), 6);
        }
    }

    protected TOTorrent decodeRoot(SimpleXMLParserDocument simpleXMLParserDocument) throws TOTorrentException {
        String string = simpleXMLParserDocument.getName();
        if (string.equalsIgnoreCase("TORRENT")) {
            TOTorrentImpl tOTorrentImpl = new TOTorrentImpl();
            SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = simpleXMLParserDocument.getChildren();
            URL uRL = null;
            byte[] byArray = null;
            byte[] byArray2 = null;
            for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
                Object object;
                SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = simpleXMLParserDocumentNodeArray[i];
                String string2 = simpleXMLParserDocumentNode.getName();
                if (string2.equalsIgnoreCase("ANNOUNCE_URL")) {
                    try {
                        uRL = new URL(simpleXMLParserDocumentNode.getValue());
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new TOTorrentException("ANNOUNCE_URL malformed", 6);
                    }
                }
                if (string2.equalsIgnoreCase("ANNOUNCE_LIST")) {
                    object = simpleXMLParserDocumentNode.getChildren();
                    TOTorrentAnnounceURLGroup tOTorrentAnnounceURLGroup = tOTorrentImpl.getAnnounceURLGroup();
                    TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = new TOTorrentAnnounceURLSet[((SimpleXMLParserDocumentNode[])object).length];
                    for (int j = 0; j < tOTorrentAnnounceURLSetArray.length; ++j) {
                        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray2 = object[j].getChildren();
                        URL[] uRLArray = new URL[simpleXMLParserDocumentNodeArray2.length];
                        for (int k = 0; k < uRLArray.length; ++k) {
                            try {
                                uRLArray[k] = new URL(simpleXMLParserDocumentNodeArray2[k].getValue());
                                continue;
                            }
                            catch (MalformedURLException malformedURLException) {
                                throw new TOTorrentException("ANNOUNCE_LIST malformed", 6);
                            }
                        }
                        tOTorrentAnnounceURLSetArray[j] = tOTorrentAnnounceURLGroup.createAnnounceURLSet(uRLArray);
                    }
                    tOTorrentAnnounceURLGroup.setAnnounceURLSets(tOTorrentAnnounceURLSetArray);
                    continue;
                }
                if (string2.equalsIgnoreCase("COMMENT")) {
                    tOTorrentImpl.setComment(this.readLocalisableString(simpleXMLParserDocumentNode));
                    continue;
                }
                if (string2.equalsIgnoreCase("CREATED_BY")) {
                    tOTorrentImpl.setCreatedBy(this.readLocalisableString(simpleXMLParserDocumentNode));
                    continue;
                }
                if (string2.equalsIgnoreCase("CREATION_DATE")) {
                    tOTorrentImpl.setCreationDate(this.readGenericLong(simpleXMLParserDocumentNode));
                    continue;
                }
                if (string2.equalsIgnoreCase("TORRENT_HASH")) {
                    byArray = this.readGenericBytes(simpleXMLParserDocumentNode);
                    continue;
                }
                if (string2.equalsIgnoreCase("TORRENT_HASH_OVERRIDE")) {
                    byArray2 = this.readGenericBytes(simpleXMLParserDocumentNode);
                    continue;
                }
                if (string2.equalsIgnoreCase("INFO")) {
                    this.decodeInfo(simpleXMLParserDocumentNode, tOTorrentImpl);
                    continue;
                }
                object = this.readGenericMapEntry(simpleXMLParserDocumentNode);
                tOTorrentImpl.addAdditionalProperty(object.name, object.value);
            }
            if (uRL == null) {
                throw new TOTorrentException("ANNOUNCE_URL missing", 6);
            }
            tOTorrentImpl.setAnnounceURL(uRL);
            if (byArray2 != null) {
                try {
                    tOTorrentImpl.setHashOverride(byArray2);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            if (byArray != null && !Arrays.equals(tOTorrentImpl.getHash(), byArray)) {
                throw new TOTorrentException("Hash differs - declared TORRENT_HASH and computed hash differ. If this really is the intent (unlikely) then remove the TORRENT_HASH element", 6);
            }
            return tOTorrentImpl;
        }
        throw new TOTorrentException("Invalid root element", 6);
    }

    protected void decodeInfo(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode, TOTorrentImpl tOTorrentImpl) throws TOTorrentException {
        byte[][] byArrayArray;
        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = simpleXMLParserDocumentNode.getChildren();
        Object var4_4 = null;
        long l = 0L;
        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray2 = null;
        for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
            Object object;
            SimpleXMLParserDocumentNode simpleXMLParserDocumentNode2 = simpleXMLParserDocumentNodeArray[i];
            String string = simpleXMLParserDocumentNode2.getName();
            if (string.equalsIgnoreCase("PIECE_LENGTH")) {
                tOTorrentImpl.setPieceLength(this.readGenericLong(simpleXMLParserDocumentNode2));
                continue;
            }
            if (string.equalsIgnoreCase("LENGTH")) {
                tOTorrentImpl.setSimpleTorrent(true);
                l = this.readGenericLong(simpleXMLParserDocumentNode2);
                continue;
            }
            if (string.equalsIgnoreCase("NAME")) {
                tOTorrentImpl.setName(this.readLocalisableString(simpleXMLParserDocumentNode2));
                continue;
            }
            if (string.equalsIgnoreCase("FILES")) {
                tOTorrentImpl.setSimpleTorrent(false);
                simpleXMLParserDocumentNodeArray2 = simpleXMLParserDocumentNode2.getChildren();
                continue;
            }
            if (string.equalsIgnoreCase("PIECES")) {
                object = simpleXMLParserDocumentNode2.getChildren();
                byArrayArray = new byte[((SimpleXMLParserDocumentNode[])object).length][];
                for (int j = 0; j < byArrayArray.length; ++j) {
                    byArrayArray[j] = this.readGenericBytes(object[j]);
                }
                tOTorrentImpl.setPieces(byArrayArray);
                continue;
            }
            object = this.readGenericMapEntry(simpleXMLParserDocumentNode2);
            tOTorrentImpl.addAdditionalInfoProperty(object.name, object.value);
        }
        if (tOTorrentImpl.isSimpleTorrent()) {
            tOTorrentImpl.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrent)tOTorrentImpl, 0L, l, new byte[][]{tOTorrentImpl.getName()})});
        } else {
            TOTorrentFileImpl[] tOTorrentFileImplArray = new TOTorrentFileImpl[simpleXMLParserDocumentNodeArray2.length];
            long l2 = 0L;
            for (int i = 0; i < tOTorrentFileImplArray.length; ++i) {
                Object object;
                int n;
                byArrayArray = simpleXMLParserDocumentNodeArray2[i];
                SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray3 = byArrayArray.getChildren();
                long l3 = 0L;
                boolean bl = false;
                Object object2 = null;
                Vector<mapEntry> vector = new Vector<mapEntry>();
                for (n = 0; n < simpleXMLParserDocumentNodeArray3.length; ++n) {
                    object = simpleXMLParserDocumentNodeArray3[n];
                    String string = object.getName();
                    if (string.equalsIgnoreCase("LENGTH")) {
                        l3 = this.readGenericLong((SimpleXMLParserDocumentNode)object);
                        bl = true;
                        continue;
                    }
                    if (string.equalsIgnoreCase("PATH")) {
                        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray4 = object.getChildren();
                        object2 = new byte[simpleXMLParserDocumentNodeArray4.length][];
                        for (int j = 0; j < simpleXMLParserDocumentNodeArray4.length; ++j) {
                            object2[j] = this.readLocalisableString(simpleXMLParserDocumentNodeArray4[j]);
                        }
                        continue;
                    }
                    vector.addElement(this.readGenericMapEntry((SimpleXMLParserDocumentNode)object));
                }
                if (!bl || object2 == null) {
                    throw new TOTorrentException("FILE element invalid (file length = " + l3 + ")", 6);
                }
                tOTorrentFileImplArray[i] = new TOTorrentFileImpl((TOTorrent)tOTorrentImpl, l2, l3, (byte[][])object2);
                l2 += l3;
                for (n = 0; n < vector.size(); ++n) {
                    object = (mapEntry)vector.elementAt(n);
                    tOTorrentFileImplArray[i].setAdditionalProperty(((mapEntry)object).name, ((mapEntry)object).value);
                }
            }
            tOTorrentImpl.setFiles(tOTorrentFileImplArray);
        }
    }

    protected mapEntry readGenericMapEntry(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) throws TOTorrentException {
        if (!simpleXMLParserDocumentNode.getName().equalsIgnoreCase("KEY")) {
            throw new TOTorrentException("Additional property invalid, must be KEY node", 6);
        }
        String string = simpleXMLParserDocumentNode.getAttribute("name").getValue();
        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = simpleXMLParserDocumentNode.getChildren();
        if (simpleXMLParserDocumentNodeArray.length != 1) {
            throw new TOTorrentException("Additional property invalid, KEY must have one child", 6);
        }
        String string2 = simpleXMLParserDocumentNodeArray[0].getName();
        Object object = this.readGenericValue(simpleXMLParserDocumentNodeArray[0]);
        return new mapEntry(string, object);
    }

    protected Object readGenericValue(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) throws TOTorrentException {
        String string = simpleXMLParserDocumentNode.getName();
        if (string.equalsIgnoreCase("BYTES")) {
            return this.readGenericBytes(simpleXMLParserDocumentNode);
        }
        if (string.equalsIgnoreCase("LONG")) {
            return this.readGenericLong(simpleXMLParserDocumentNode);
        }
        if (string.equalsIgnoreCase("LIST")) {
            return this.readGenericList(simpleXMLParserDocumentNode);
        }
        if (string.equalsIgnoreCase("MAP")) {
            return this.readGenericMap(simpleXMLParserDocumentNode);
        }
        throw new TOTorrentException("Additional property invalid, sub-key '" + string + "' not recognised", 6);
    }

    protected byte[] readGenericBytes(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) throws TOTorrentException {
        String string = simpleXMLParserDocumentNode.getValue();
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    protected Long readGenericLong(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) throws TOTorrentException {
        String string = simpleXMLParserDocumentNode.getValue();
        try {
            return new Long(string);
        }
        catch (Throwable throwable) {
            throw new TOTorrentException("long value invalid for '" + simpleXMLParserDocumentNode.getName() + "'", 6);
        }
    }

    protected Map readGenericMap(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) throws TOTorrentException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = simpleXMLParserDocumentNode.getChildren();
        for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
            mapEntry mapEntry2 = this.readGenericMapEntry(simpleXMLParserDocumentNodeArray[i]);
            hashMap.put(mapEntry2.name, mapEntry2.value);
        }
        return hashMap;
    }

    protected byte[] readLocalisableString(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) throws TOTorrentException {
        SimpleXMLParserDocumentAttribute simpleXMLParserDocumentAttribute = simpleXMLParserDocumentNode.getAttribute("encoding");
        if (simpleXMLParserDocumentAttribute == null || simpleXMLParserDocumentAttribute.getValue().equalsIgnoreCase("bytes")) {
            return this.readGenericBytes(simpleXMLParserDocumentNode);
        }
        try {
            return simpleXMLParserDocumentNode.getValue().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TOTorrentException("bytes invalid - unsupported encoding", 6);
        }
    }

    protected List readGenericList(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode) throws TOTorrentException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = simpleXMLParserDocumentNode.getChildren();
        for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
            arrayList.add(this.readGenericValue(simpleXMLParserDocumentNodeArray[i]));
        }
        return arrayList;
    }

    protected class mapEntry {
        String name;
        Object value;

        mapEntry(String string, Object object) {
            this.name = string;
            this.value = object;
        }
    }
}

