/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequest;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequestListener;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.ThreadPool;

public class ConcurrentHasher {
    protected static ConcurrentHasher singleton = new ConcurrentHasher();
    protected int processor_num;
    protected List<ConcurrentHasherRequest> requests = new LinkedList<ConcurrentHasherRequest>();
    protected List<SHA1Hasher> hashers = new ArrayList<SHA1Hasher>();
    protected AESemaphore request_sem = new AESemaphore("ConcHashReqQ");
    protected AESemaphore scheduler_sem = new AESemaphore("ConcHashSched");
    protected AEMonitor requests_mon = new AEMonitor("ConcurrentHasher:R");
    private static boolean friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");

    public static ConcurrentHasher getSingleton() {
        return singleton;
    }

    public static boolean concurrentHashingAvailable() {
        return ConcurrentHasher.getSingleton().processor_num > 1;
    }

    protected ConcurrentHasher() {
        this.processor_num = Runtime.getRuntime().availableProcessors();
        if (this.processor_num <= 0) {
            this.processor_num = 1;
        }
        for (int i = 0; i < this.processor_num + 1; ++i) {
            this.scheduler_sem.release();
        }
        final ThreadPool threadPool = new ThreadPool("ConcurrentHasher", 64);
        new AEThread2("ConcurrentHasher:scheduler", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Object var4_3;
                    SHA1Hasher sHA1Hasher;
                    ConcurrentHasherRequest concurrentHasherRequest;
                    ConcurrentHasher.this.request_sem.reserve();
                    try {
                        ConcurrentHasher.this.requests_mon.enter();
                        concurrentHasherRequest = ConcurrentHasher.this.requests.remove(0);
                        sHA1Hasher = ConcurrentHasher.this.hashers.size() == 0 ? new SHA1Hasher() : ConcurrentHasher.this.hashers.remove(ConcurrentHasher.this.hashers.size() - 1);
                        var4_3 = null;
                        ConcurrentHasher.this.requests_mon.exit();
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        ConcurrentHasher.this.requests_mon.exit();
                        throw throwable;
                    }
                    threadPool.run(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            Object v1;
                            block6: {
                                try {
                                    concurrentHasherRequest.run(sHA1Hasher);
                                    Object var2_1 = null;
                                }
                                catch (Throwable throwable) {
                                    Object v0;
                                    Object var2_2 = null;
                                    try {
                                        ConcurrentHasher.this.requests_mon.enter();
                                        ConcurrentHasher.this.hashers.add(sHA1Hasher);
                                        v0 = null;
                                    }
                                    catch (Throwable throwable2) {
                                        v0 = null;
                                    }
                                    Object var4_6 = v0;
                                    ConcurrentHasher.this.requests_mon.exit();
                                    throw throwable;
                                }
                                try {
                                    ConcurrentHasher.this.requests_mon.enter();
                                    ConcurrentHasher.this.hashers.add(sHA1Hasher);
                                    v1 = null;
                                    break block6;
                                }
                                catch (Throwable throwable) {
                                    v1 = null;
                                }
                                {
                                }
                            }
                            Object var4_5 = v1;
                            ConcurrentHasher.this.requests_mon.exit();
                        }
                    });
                }
            }
        }.start();
    }

    public ConcurrentHasherRequest addRequest(ByteBuffer byteBuffer) {
        return this.addRequest(byteBuffer, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentHasherRequest addRequest(ByteBuffer byteBuffer, ConcurrentHasherRequestListener concurrentHasherRequestListener, boolean bl) {
        ConcurrentHasherRequest concurrentHasherRequest = new ConcurrentHasherRequest(this, byteBuffer, concurrentHasherRequestListener, bl);
        this.scheduler_sem.reserve();
        try {
            this.requests_mon.enter();
            this.requests.add(concurrentHasherRequest);
            Object var6_5 = null;
            this.requests_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.requests_mon.exit();
            throw throwable;
        }
        this.request_sem.release();
        return concurrentHasherRequest;
    }

    public static void main(String[] stringArray) {
    }

    static /* synthetic */ boolean access$000() {
        return friendly_hashing;
    }

    static {
        COConfigurationManager.addParameterListener("diskmanager.friendly.hashchecking", new ParameterListener(){

            public void parameterChanged(String string) {
                friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");
            }
        });
    }
}

