/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class FileUtil {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String DIR_SEP = System.getProperty("file.separator");
    private static final int RESERVED_FILE_HANDLE_COUNT = 4;
    private static List reserved_file_handles = new ArrayList();
    private static AEMonitor class_mon = new AEMonitor("FileUtil:class");
    private static Method reflectOnUsableSpace;
    private static boolean sce_checked;
    private static String script_encoding;

    public static boolean isAncestorOf(File file, File file2) {
        if ((file = FileUtil.canonise(file)).equals(file2 = FileUtil.canonise(file2))) {
            return true;
        }
        String string = file.getPath();
        String string2 = file2.getPath();
        if (string.charAt(string.length() - 1) != File.separatorChar) {
            string = string + File.separatorChar;
        }
        return string2.startsWith(string);
    }

    public static File canonise(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public static String getCanonicalFileName(String string) {
        String string2 = string;
        try {
            string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public static File getUserFile(String string) {
        return new File(SystemProperties.getUserPath(), string);
    }

    public static File getApplicationFile(String string) {
        String string2 = SystemProperties.getApplicationPath();
        if (Constants.isOSX) {
            string2 = string2 + "/" + SystemProperties.getApplicationName() + ".app/Contents/";
        }
        return new File(string2, string);
    }

    public static boolean recursiveDelete(File file) {
        String string = COConfigurationManager.getStringParameter("Default save path");
        String string2 = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        try {
            string2 = new File(string2).getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (file.getCanonicalPath().equals(string2)) {
                System.out.println("FileUtil::recursiveDelete:: not allowed to delete the MoveTo dir !");
                return false;
            }
            if (file.getCanonicalPath().equals(string)) {
                System.out.println("FileUtil::recursiveDelete:: not allowed to delete the default data dir !");
                return false;
            }
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (FileUtil.recursiveDelete(fileArray[i])) continue;
                    return false;
                }
                if (!file.delete()) {
                    return false;
                }
            } else if (!file.delete()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean recursiveDeleteNoCheck(File file) {
        try {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (FileUtil.recursiveDeleteNoCheck(fileArray[i])) continue;
                    return false;
                }
                if (!file.delete()) {
                    return false;
                }
            } else if (!file.delete()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static long getFileOrDirectorySize(File file) {
        if (file.isFile()) {
            return file.length();
        }
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                l += FileUtil.getFileOrDirectorySize(fileArray[i]);
            }
        }
        return l;
    }

    protected static void recursiveEmptyDirDelete(File file, Set set, boolean bl) {
        try {
            String string = COConfigurationManager.getStringParameter("Default save path");
            String string2 = COConfigurationManager.getStringParameter("Completed Files Directory", "");
            if (string.trim().length() > 0) {
                string = new File(string).getCanonicalPath();
            }
            if (string2.trim().length() > 0) {
                string2 = new File(string2).getCanonicalPath();
            }
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    if (bl) {
                        Debug.out("Empty folder delete:  failed to list contents of directory " + file);
                    }
                    return;
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (file2.isDirectory()) {
                        FileUtil.recursiveEmptyDirDelete(fileArray[i], set, bl);
                        continue;
                    }
                    if (!set.contains(file2.getName().toLowerCase()) || file2.delete() || !bl) continue;
                    Debug.out("Empty folder delete: failed to delete file " + file2);
                }
                if (file.getCanonicalPath().equals(string2)) {
                    if (bl) {
                        Debug.out("Empty folder delete:  not allowed to delete the MoveTo dir !");
                    }
                    return;
                }
                if (file.getCanonicalPath().equals(string)) {
                    if (bl) {
                        Debug.out("Empty folder delete:  not allowed to delete the default data dir !");
                    }
                    return;
                }
                File[] fileArray2 = file.listFiles();
                if (fileArray2.length == 0) {
                    if (!file.delete() && bl) {
                        Debug.out("Empty folder delete:  failed to delete directory " + file);
                    }
                } else if (bl) {
                    Debug.out("Empty folder delete:  " + fileArray2.length + " file(s)/folder(s) still in \"" + file + "\" - first listed item is \"" + fileArray2[0].getName() + "\". Not removing.");
                }
            }
        }
        catch (Exception exception) {
            Debug.out(exception.toString());
        }
    }

    public static String convertOSSpecificChars(String string, boolean bl) {
        int n;
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '\"') continue;
            cArray[n] = 39;
        }
        if (!Constants.isOSX) {
            int n2;
            if (Constants.isWindows) {
                String string2 = "\\/:?*<>|";
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    if (string2.indexOf(cArray[n2]) == -1) continue;
                    cArray[n2] = 95;
                }
                if (bl) {
                    for (n2 = cArray.length - 1; n2 >= 0 && (cArray[n2] == '.' || cArray[n2] == ' '); --n2) {
                        cArray[n2] = 95;
                    }
                }
            }
            for (n = 0; n < cArray.length; ++n) {
                n2 = cArray[n];
                if (n2 != 47 && n2 != 13 && n2 != 10) continue;
                cArray[n] = 32;
            }
        }
        String string3 = new String(cArray);
        try {
            if (Constants.isWindows) {
                while (string3.endsWith(" ")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
            } else {
                String string4 = new File(string3).getCanonicalFile().toString();
                int n3 = string4.lastIndexOf(File.separator);
                string3 = string4.substring(n3 + 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string3;
    }

    public static void writeResilientConfigFile(String string, Map map) {
        File file = new File(SystemProperties.getUserPath());
        boolean bl = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        FileUtil.writeResilientFile(file, string, map, bl);
    }

    public static void writeResilientFile(File file, Map map) {
        FileUtil.writeResilientFile(file.getParentFile(), file.getName(), map, false);
    }

    public static boolean writeResilientFileWithResult(File file, String string, Map map) {
        return FileUtil.writeResilientFile(file, string, map);
    }

    public static void writeResilientFile(File file, String string, Map map, boolean bl) {
        FileUtil.writeResilientFile(file, string, map, bl, true);
    }

    public static void writeResilientFile(File file, String string, Map map, boolean bl, boolean bl2) {
        File file2;
        if (bl && (file2 = new File(file, string)).exists()) {
            FileUtil.backupFile(file2, bl2);
        }
        FileUtil.writeResilientFile(file, string, map);
    }

    /*
     * Exception decompiling
     */
    private static boolean writeResilientFile(File var0, String var1, Map var2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean resilientConfigFileExists(String string) {
        File file = new File(SystemProperties.getUserPath());
        boolean bl = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        return new File(file, string).exists() || bl && new File(file, string + ".bak").exists();
    }

    public static Map readResilientConfigFile(String string) {
        File file = new File(SystemProperties.getUserPath());
        boolean bl = COConfigurationManager.getBooleanParameter("Use Config File Backups");
        return FileUtil.readResilientFile(file, string, bl);
    }

    public static Map readResilientConfigFile(String string, boolean bl) {
        File file = new File(SystemProperties.getUserPath());
        if (!bl && new File(file, string + ".bak").exists()) {
            bl = true;
        }
        return FileUtil.readResilientFile(file, string, bl);
    }

    public static Map readResilientFile(File file) {
        return FileUtil.readResilientFile(file.getParentFile(), file.getName(), false, true);
    }

    public static Map readResilientFile(File file, String string, boolean bl) {
        return FileUtil.readResilientFile(file, string, bl, true);
    }

    public static Map readResilientFile(File file, String string, boolean bl, boolean bl2) {
        Map map;
        File file2 = new File(file, string + ".bak");
        if (bl) {
            bl = file2.exists();
        }
        if ((map = FileUtil.readResilientFileSupport(file, string, !bl, bl2)) == null && bl) {
            map = FileUtil.readResilientFileSupport(file, string + ".bak", false, bl2);
            if (map != null) {
                Debug.out("Backup file '" + file2 + "' has been used for recovery purposes");
                FileUtil.writeResilientFile(file, string, map, false);
            } else {
                map = FileUtil.readResilientFileSupport(file, string, true, true);
            }
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map readResilientFileSupport(File file, String string, boolean bl, boolean bl2) {
        try {
            Map map;
            class_mon.enter();
            try {
                FileUtil.getReservedFileHandles();
                Map map2 = null;
                try {
                    map2 = FileUtil.readResilientFile(string, file, string, 0, false, bl2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (map2 == null && bl && (map2 = FileUtil.readResilientFile(string, file, string, 0, true, bl2)) != null) {
                    Debug.out("File '" + string + "' has been partially recovered, information may have been lost!");
                }
                map = map2;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Map map3;
                try {
                    Debug.printStackTrace(throwable);
                    map3 = null;
                    Object var7_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_11 = null;
                    FileUtil.releaseReservedFileHandles();
                    throw throwable2;
                }
                FileUtil.releaseReservedFileHandles();
                Object var9_13 = null;
                class_mon.exit();
                return map3;
            }
            FileUtil.releaseReservedFileHandles();
            Object var9_12 = null;
            class_mon.exit();
            return map;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Map readResilientFile(String string, File file, String string2, int n, boolean bl, boolean bl2) {
        boolean bl3 = string2.endsWith(".saving");
        File file2 = new File(file, string2);
        if (!file2.exists() || file2.length() <= 1L) {
            if (bl3) {
                if (!bl && n == 1) {
                    Debug.out("Load of '" + string + "' fails, no usable file or backup");
                }
                return null;
            }
            if (!bl) {
                // empty if block
            }
            return FileUtil.readResilientFile(string, file, string2 + ".saving", 0, bl, true);
        }
        BufferedInputStream bufferedInputStream = null;
        int n2 = 5;
        while (true) {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file2), 16384);
            }
            catch (IOException iOException) {
                if (--n2 == 0) {
                    throw iOException;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Failed to open '" + file2.toString() + "', retrying", iOException));
                }
                Thread.sleep(500L);
                continue;
            }
            break;
        }
        BDecoder bDecoder = new BDecoder();
        if (bl) {
            bDecoder.setRecoveryMode(true);
        }
        Map map = bDecoder.decodeStream(bufferedInputStream, !bl2);
        if (bl3 && !bl) {
            Debug.out("Load of '" + string + "' had to revert to backup file");
        }
        Map map2 = map;
        Object var14_19 = null;
        try {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        return map2;
        catch (Throwable throwable) {
            Object object;
            block33: {
                try {
                    Debug.printStackTrace(throwable);
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                            bufferedInputStream = null;
                        }
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace(exception);
                    }
                    if (!bl) {
                        File file3;
                        int n3 = 0;
                        while (true) {
                            if (!(file3 = new File(file, file2.getName() + ".bad" + (n3 == 0 ? "" : "" + n3))).exists()) break;
                            ++n3;
                        }
                        object = file3;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Read of '" + string + "' failed, decoding error. " + "Renaming to " + ((File)object).getName()));
                        }
                        FileUtil.copyFile(file2, (File)object);
                    }
                    if (!bl3) break block33;
                    if (!bl) {
                        Debug.out("Load of '" + string + "' fails, no usable file or backup");
                    }
                    object = null;
                    Object var14_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_22 = null;
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace(exception);
                    }
                    throw throwable2;
                }
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                }
                return object;
            }
            object = FileUtil.readResilientFile(string, file, string2 + ".saving", 1, bl, true);
            Object var14_21 = null;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
            }
            return object;
        }
    }

    public static void deleteResilientFile(File file) {
        file.delete();
        new File(file.getParentFile(), file.getName() + ".bak").delete();
    }

    public static void deleteResilientConfigFile(String string) {
        File file = new File(SystemProperties.getUserPath());
        new File(file, string).delete();
        new File(file, string + ".bak").delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getReservedFileHandles() {
        try {
            class_mon.enter();
            while (reserved_file_handles.size() > 0) {
                InputStream inputStream = (InputStream)reserved_file_handles.remove(0);
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseReservedFileHandles() {
        try {
            try {
                class_mon.enter();
                File file = new File(SystemProperties.getUserPath() + ".lock");
                file.createNewFile();
                while (reserved_file_handles.size() < 4) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    reserved_file_handles.add(fileInputStream);
                }
                Object var3_3 = null;
                class_mon.exit();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var3_4 = null;
                class_mon.exit();
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public static void backupFile(String string, boolean bl) {
        FileUtil.backupFile(new File(string), bl);
    }

    public static void backupFile(File file, boolean bl) {
        if (file.length() > 0L) {
            File file2 = new File(file.getAbsolutePath() + ".bak");
            if (file2.exists()) {
                file2.delete();
            }
            if (bl) {
                FileUtil.copyFile(file, file2);
            } else {
                file.renameTo(file2);
            }
        }
    }

    public static boolean copyFile(String string, String string2) {
        return FileUtil.copyFile(new File(string), new File(string2));
    }

    public static boolean copyFile(File file, File file2) {
        try {
            FileUtil.copyFile((InputStream)new FileInputStream(file), new FileOutputStream(file2));
            return true;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return false;
        }
    }

    public static void copyFileWithException(File file, File file2) throws IOException {
        FileUtil.copyFile((InputStream)new FileInputStream(file), new FileOutputStream(file2));
    }

    public static boolean copyFile(File file, OutputStream outputStream, boolean bl) {
        try {
            FileUtil.copyFile((InputStream)new FileInputStream(file), outputStream, bl);
            return true;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        boolean bl = true;
        try {
            fileOutputStream = new FileOutputStream(file);
            bl = false;
            FileUtil.copyFile(inputStream, (OutputStream)fileOutputStream, true);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (bl) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw throwable;
        }
        try {
            if (bl) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream inputStream, File file, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        boolean bl2 = bl;
        try {
            fileOutputStream = new FileOutputStream(file);
            bl2 = false;
            FileUtil.copyFile(inputStream, (OutputStream)fileOutputStream, bl2);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (bl2) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw throwable;
        }
        try {
            if (bl2) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    public static void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        FileUtil.copyFile(inputStream, outputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        block9: {
            try {
                int n;
                if (!(inputStream instanceof BufferedInputStream)) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                byte[] byArray = new byte[131072];
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (bl) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                outputStream.close();
                throw throwable;
            }
            try {
                if (bl) {
                    inputStream.close();
                }
                break block9;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            {
            }
        }
        outputStream.close();
    }

    public static void copyFileOrDirectory(File file, File file2) throws IOException {
        if (!file.exists()) {
            throw new IOException("File '" + file.toString() + "' doesn't exist");
        }
        if (!file2.exists()) {
            throw new IOException("File '" + file2.toString() + "' doesn't exist");
        }
        if (!file2.isDirectory()) {
            throw new IOException("File '" + file2.toString() + "' is not a directory");
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            File file3 = new File(file2, file.getName());
            FileUtil.mkdirs(file3);
            for (int i = 0; i < fileArray.length; ++i) {
                File file4 = fileArray[i];
                FileUtil.copyFileOrDirectory(file4, file3);
            }
        } else {
            File file5 = new File(file2, file.getName());
            if (!FileUtil.copyFile(file, file5)) {
                throw new IOException("File copy from " + file + " to " + file5 + " failed");
            }
        }
    }

    public static File getFileOrBackup(String string) {
        try {
            File file = new File(string);
            if (file.length() <= 1L) {
                File file2 = new File(string + ".bak");
                if (file2.length() <= 1L) {
                    return null;
                }
                return file2;
            }
            return file;
        }
        catch (Exception exception) {
            Debug.out(exception);
            return null;
        }
    }

    public static File getJarFileFromClass(Class clazz) {
        try {
            File file;
            String string;
            String string2 = clazz.getName();
            string2 = string2.replace('.', '/') + ".class";
            URL uRL = clazz.getClassLoader().getResource(string2);
            if (uRL != null && (string = uRL.toExternalForm()).startsWith("jar:file:") && (file = FileUtil.getJarFileFromURL(string)) != null && file.exists()) {
                return file;
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return null;
    }

    public static File getJarFileFromURL(String string) {
        if (string.startsWith("jar:file:")) {
            if (!(string = string.replaceAll(" ", "%20")).startsWith("jar:file:/")) {
                string = "jar:file:/".concat(string.substring(9));
            }
            try {
                URI uRI;
                int n = string.lastIndexOf(33);
                String string2 = string.substring(4, n);
                try {
                    uRI = URI.create(string2);
                    if (!new File(uRI).exists()) {
                        throw new FileNotFoundException();
                    }
                }
                catch (Throwable throwable) {
                    string2 = "file:/" + UrlUtils.encode(string2.substring(6));
                    uRI = URI.create(string2);
                }
                File file = new File(uRI);
                return file;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return null;
    }

    public static boolean renameFile(File file, File file2) {
        return FileUtil.renameFile(file, file2, true);
    }

    public static boolean renameFile(File file, File file2, boolean bl) {
        return FileUtil.renameFile(file, file2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean renameFile(File file, File file2, boolean bl, FileFilter fileFilter) {
        Throwable throwable4;
        boolean bl2;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        boolean bl3;
        block34: {
            if (!file.exists()) {
                Debug.out("renameFile: source file '" + file + "' doesn't exist, failing");
                return false;
            }
            if (file2.exists() && (bl || file.isFile() || file2.isFile())) {
                Debug.out("renameFile: target file '" + file2 + "' already exists, failing");
                return false;
            }
            File file3 = file2.getParentFile();
            if (!file3.exists()) {
                FileUtil.mkdirs(file3);
            }
            if (file.isDirectory()) {
                File file4;
                File file5;
                int n;
                File[] fileArray = null;
                fileArray = fileFilter != null ? file.listFiles(fileFilter) : file.listFiles();
                if (fileArray == null) {
                    return true;
                }
                int n2 = 0;
                if (!file2.exists()) {
                    file2.mkdir();
                }
                for (n = 0; n < fileArray.length; ++n) {
                    file5 = fileArray[n];
                    file4 = new File(file2, file5.getName());
                    try {
                        if (!FileUtil.renameFile(file5, file4, bl, fileFilter)) break;
                        ++n2;
                        continue;
                    }
                    catch (Throwable throwable2) {
                        Debug.out("renameFile: failed to rename file '" + file5.toString() + "' to '" + file4.toString() + "'", throwable2);
                        break;
                    }
                }
                if (n2 == fileArray.length) {
                    File[] fileArray2 = file.listFiles();
                    if (fileArray2 != null && fileArray2.length > 0) {
                        if (fileFilter != null) return true;
                        Debug.out("renameFile: files remain in '" + file.toString() + "', not deleting");
                        return true;
                    } else {
                        if (file.delete()) return true;
                        Debug.out("renameFile: failed to delete '" + file.toString() + "'");
                    }
                    return true;
                }
                for (n = 0; n < n2; ++n) {
                    file5 = fileArray[n];
                    file4 = new File(file2, file5.getName());
                    try {
                        if (FileUtil.renameFile(file4, file5, false, null)) continue;
                        Debug.out("renameFile: recovery - failed to move file '" + file4.toString() + "' to '" + file5.toString() + "'");
                        continue;
                    }
                    catch (Throwable throwable3) {
                        Debug.out("renameFile: recovery - failed to move file '" + file4.toString() + "' to '" + file5.toString() + "'", throwable3);
                    }
                }
                return false;
            }
            if (!COConfigurationManager.getBooleanParameter("Copy And Delete Data Rather Than Move") && file.renameTo(file2)) {
                return true;
            }
            bl3 = false;
            fileInputStream = null;
            fileOutputStream = null;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[65536];
            while ((bl2 = fileInputStream.read(byArray)) > false) {
                fileOutputStream.write(byArray, 0, bl2 ? 1 : 0);
            }
            fileOutputStream.close();
            fileOutputStream = null;
            fileInputStream.close();
            fileInputStream = null;
            if (!file.delete()) {
                Debug.out("renameFile: failed to delete '" + file.toString() + "'");
                throw new Exception("Failed to delete '" + file.toString() + "'");
            }
            bl3 = true;
            bl2 = true;
            Object var12_21 = null;
            if (fileInputStream == null) break block34;
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable4) {
                // empty catch block
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable4) {
                // empty catch block
            }
        }
        if (bl3 || !file2.exists()) return bl2;
        file2.delete();
        return bl2;
        catch (Throwable throwable5) {
            Throwable throwable62;
            boolean bl4;
            block36: {
                try {
                    Debug.out("renameFile: failed to rename '" + file.toString() + "' to '" + file2.toString() + "'", throwable5);
                    bl4 = false;
                    Object var12_22 = null;
                    if (fileInputStream == null) break block36;
                }
                catch (Throwable throwable7) {
                    Throwable throwable82;
                    Object var12_23 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable82) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Throwable throwable82) {
                            // empty catch block
                        }
                    }
                    if (bl3 || !file2.exists()) throw throwable7;
                    file2.delete();
                    throw throwable7;
                }
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable62) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable62) {
                    // empty catch block
                }
            }
            if (bl3 || !file2.exists()) return bl4;
            file2.delete();
            return bl4;
        }
    }

    public static boolean writeStringAsFile(File file, String string) {
        try {
            return FileUtil.writeBytesAsFile2(file.getAbsolutePath(), string.getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return false;
        }
    }

    public static void writeBytesAsFile(String string, byte[] byArray) {
        FileUtil.writeBytesAsFile2(string, byArray);
    }

    public static boolean writeBytesAsFile2(String string, byte[] byArray) {
        try {
            File file = new File(string);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            return true;
        }
        catch (Throwable throwable) {
            Debug.out("writeBytesAsFile:: error: ", throwable);
            return false;
        }
    }

    public static boolean deleteWithRecycle(File file, boolean bl) {
        if (COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && !bl) {
            try {
                PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
                if (platformManager.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                    platformManager.performRecoverableFileDelete(file.getAbsolutePath());
                    return true;
                }
                return file.delete();
            }
            catch (PlatformManagerException platformManagerException) {
                return file.delete();
            }
        }
        return file.delete();
    }

    public static String translateMoveFilePath(String string, String string2, String string3) {
        if (!string3.startsWith(string)) {
            return null;
        }
        String string4 = string3.substring(string.length());
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string4.startsWith(File.separator)) {
            string4 = string4.substring(1);
        }
        return string2 + File.separator + string4;
    }

    public static void runAsTask(AzureusCoreOperationTask azureusCoreOperationTask) {
        AzureusCore azureusCore = AzureusCoreFactory.getSingleton();
        azureusCore.createOperation(2, azureusCoreOperationTask);
    }

    public static boolean mkdirs(File file) {
        String string;
        File file2;
        Pattern pattern;
        Matcher matcher;
        if (Constants.isOSX && (matcher = (pattern = Pattern.compile("^(/Volumes/[^/]+)")).matcher(file.getParent())).find() && !(file2 = new File(string = matcher.group())).isDirectory()) {
            Logger.log(new LogEvent(LOGID, 1, string + " is not mounted or not available."));
            return false;
        }
        return file.mkdirs();
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(File.separator);
        int n2 = string.lastIndexOf(46);
        if (n == string.length() - 1 || n2 == -1 || n > n2) {
            return "";
        }
        return string.substring(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file, int n, String string) throws IOException {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            string2 = FileUtil.readInputStreamAsString(fileInputStream, n, string);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file, int n) throws IOException {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            string = FileUtil.readInputStreamAsString(fileInputStream, n);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return string;
    }

    public static String readInputStreamAsString(InputStream inputStream, int n) throws IOException {
        return FileUtil.readInputStreamAsString(inputStream, n, "ISO-8859-1");
    }

    public static String readInputStreamAsString(InputStream inputStream, int n, String string) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(1024);
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) > 0) {
            stringBuffer.append(new String(byArray, 0, n2, string));
            if (n < 0 || stringBuffer.length() <= n) continue;
            stringBuffer.setLength(n);
            break;
        }
        return stringBuffer.toString();
    }

    public static String readInputStreamAsStringWithTruncation(InputStream inputStream, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        byte[] byArray = new byte[1024];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) > 0) {
                stringBuffer.append(new String(byArray, 0, n2, "ISO-8859-1"));
                if (n < 0 || stringBuffer.length() <= n) continue;
                stringBuffer.setLength(n);
                break;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileEndAsString(File file, int n) throws IOException {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n2;
            if (file.length() > (long)n) {
                fileInputStream.skip(file.length() - (long)n);
            }
            StringBuffer stringBuffer = new StringBuffer(1024);
            byte[] byArray = new byte[1024];
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                stringBuffer.append(new String(byArray, 0, n2, "ISO-8859-1"));
                if (stringBuffer.length() <= n) continue;
                stringBuffer.setLength(n);
                break;
            }
            string = stringBuffer.toString();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return string;
    }

    public static byte[] readInputStreamAsByteArray(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32768);
        byte[] byArray = new byte[32768];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsByteArray(File file) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
        byte[] byArray2 = new byte[32768];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n;
            while ((n = ((InputStream)fileInputStream).read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return byArray;
    }

    public static final boolean getUsableSpaceSupported() {
        return reflectOnUsableSpace != null;
    }

    public static final long getUsableSpace(File file) {
        try {
            return (Long)reflectOnUsableSpace.invoke((Object)file, new Object[0]);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static boolean canReallyWriteToAppDirectory() {
        if (!FileUtil.getApplicationFile("bogus").getParentFile().canWrite()) {
            return false;
        }
        if (Constants.isWindowsVistaOrHigher) {
            try {
                Object object;
                File file = FileUtil.getApplicationFile("_az_.dll");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(32);
                fileOutputStream.close();
                file.delete();
                File file2 = FileUtil.getApplicationFile("License.txt");
                if (!file2.exists()) {
                    file2 = FileUtil.getApplicationFile("GPL.txt");
                }
                if (!file2.exists() && (object = file.getParentFile().listFiles()) != null) {
                    for (File file3 : object) {
                        String string = file3.getName();
                        if (!string.endsWith(".txt") && !string.endsWith(".log")) continue;
                        file2 = file3;
                        break;
                    }
                }
                if (file2.exists()) {
                    object = new File(file2.getParentFile(), file2.getName() + ".bak");
                    ((File)object).delete();
                    file2.renameTo((File)object);
                    if (file2.exists()) {
                        return false;
                    }
                } else {
                    Debug.out("Failed to find a suitable file for the rename test");
                    return false;
                }
                ((File)object).renameTo(file2);
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptCharsetEncoding() {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            if (sce_checked) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return script_encoding;
            }
            sce_checked = true;
            String string = System.getProperty("file.encoding", null);
            String string2 = System.getProperty("sun.jnu.encoding", null);
            if (string == null || string2 == null || string.equals(string2)) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            try {
                String string3 = SystemProperties.getUserPath();
                if (!new String(string3.getBytes(string), string).equals(string3) && new String(string3.getBytes(string2), string2).equals(string3)) {
                    Debug.out("Script encoding determined to be " + string2 + " instead of " + string);
                    script_encoding = string2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return script_encoding;
        }
    }

    static {
        try {
            reflectOnUsableSpace = File.class.getMethod("getUsableSpace", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            reflectOnUsableSpace = null;
        }
    }
}

