/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.gudy.azureus2.core3.util.LightHashMap;

public class LightHashSet
extends AbstractSet
implements Cloneable {
    private static final Object THOMBSTONE = new Object();
    private static final Object NULLKEY = new Object();
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CAPACITY = 8;
    final float loadFactor;
    int size;
    Object[] data;

    public LightHashSet() {
        this(8, 0.75f);
    }

    public LightHashSet(int n) {
        this(n, 0.75f);
    }

    public LightHashSet(Collection collection) {
        this(0);
        if (collection instanceof LightHashSet) {
            LightHashSet lightHashSet = (LightHashSet)collection;
            this.size = lightHashSet.size;
            this.data = (Object[])lightHashSet.data.clone();
        } else {
            this.addAll(collection);
        }
    }

    public Object clone() {
        try {
            LightHashMap lightHashMap = (LightHashMap)super.clone();
            lightHashMap.data = (Object[])this.data.clone();
            return lightHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public LightHashSet(int n, float f) {
        int n2;
        if (f > 1.0f) {
            throw new IllegalArgumentException("Load factor must not be > 1");
        }
        this.loadFactor = f;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.data = new Object[n2];
    }

    public Iterator iterator() {
        return new HashIterator();
    }

    public boolean add(Object object) {
        this.checkCapacity(1);
        return this.addInternal(object, false);
    }

    public int size() {
        return this.size;
    }

    public boolean addAll(Collection collection) {
        this.checkCapacity(collection.size());
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.addInternal(iterator.next(), true);
        }
        return bl;
    }

    public int capacity() {
        return this.data.length;
    }

    public Object get(Object object) {
        int n;
        if (object == null) {
            object = NULLKEY;
        }
        if (this.keysEqual(this.data[n = this.nonModifyingFindIndex(object)], object)) {
            return this.data[n];
        }
        return null;
    }

    private boolean addInternal(Object object, boolean bl) {
        int n;
        if (object == null) {
            object = NULLKEY;
        }
        int n2 = n = bl ? this.nonModifyingFindIndex(object) : this.findIndex(object);
        if (this.data[n] == null || this.data[n] == THOMBSTONE) {
            this.data[n] = object;
            ++this.size;
            return true;
        }
        return false;
    }

    public boolean remove(Object object) {
        int n;
        if (this.size == 0) {
            return false;
        }
        if (object == null) {
            object = NULLKEY;
        }
        if (this.keysEqual(object, this.data[n = this.findIndex(object)])) {
            this.removeForIndex(n);
            return true;
        }
        return false;
    }

    private void removeForIndex(int n) {
        this.data[n] = THOMBSTONE;
        --this.size;
    }

    public void clear() {
        int n;
        this.size = 0;
        for (n = 1; n < 8; n <<= 1) {
        }
        this.data = new Object[n];
    }

    public boolean contains(Object object) {
        if (this.size == 0) {
            return false;
        }
        if (object == null) {
            object = NULLKEY;
        }
        return this.keysEqual(object, this.data[this.nonModifyingFindIndex(object)]);
    }

    private final boolean keysEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.hashCode() == object2.hashCode() && object.equals(object2);
    }

    private int findIndex(Object object) {
        int n = object.hashCode();
        int n2 = 1;
        int n3 = n & this.data.length - 1;
        int n4 = -1;
        int n5 = 0;
        int n6 = Math.min(this.data.length - this.size, 100);
        while (this.data[n3] != null && !this.keysEqual(this.data[n3], object)) {
            if (this.data[n3] == THOMBSTONE) {
                if (n4 == -1) {
                    n4 = n3;
                }
                if (++n5 * 2 > n6) {
                    this.compactify(0.0f);
                    n4 = -1;
                    n2 = 0;
                    n5 = 0;
                }
            }
            n3 = n + (n2 + n2 * n2 >> 1) & this.data.length - 1;
            ++n2;
        }
        if (n4 != -1 && !this.keysEqual(this.data[n3], object)) {
            return n4;
        }
        return n3;
    }

    private int nonModifyingFindIndex(Object object) {
        int n = object.hashCode();
        int n2 = n & this.data.length - 1;
        int n3 = -1;
        for (int i = 1; this.data[n2] != null && !this.keysEqual(this.data[n2], object) && i < this.data.length; ++i) {
            if (this.data[n2] == THOMBSTONE && n3 == -1) {
                n3 = n2;
            }
            n2 = n + (i + i * i >> 1) & this.data.length - 1;
        }
        if (n3 != -1 && !this.keysEqual(this.data[n2], object)) {
            return n3;
        }
        return n2;
    }

    private void checkCapacity(int n) {
        int n2 = this.data.length;
        if ((float)(this.size + n) < (float)n2 * this.loadFactor) {
            return;
        }
        int n3 = n2;
        while ((float)(n3 <<= 1) * this.loadFactor < (float)(this.size + n)) {
        }
        this.adjustCapacity(n3);
    }

    public void compactify(float f) {
        int n = 1;
        float f2 = Math.abs(f);
        if (f2 <= 0.0f || f2 >= 1.0f) {
            f2 = this.loadFactor;
        }
        while ((float)n * f2 < (float)(this.size + 1)) {
            n <<= 1;
        }
        if (n < this.data.length || f >= 0.0f) {
            this.adjustCapacity(n);
        }
    }

    private void adjustCapacity(int n) {
        Object[] objectArray = this.data;
        this.data = new Object[n];
        this.size = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || objectArray[i] == THOMBSTONE) continue;
            this.addInternal(objectArray[i], true);
        }
    }

    static void test() {
        int n;
        Random random = new Random();
        byte[] byArray = new byte[5];
        String[] stringArray = new String[975175];
        for (int i = 0; i < stringArray.length; ++i) {
            random.nextBytes(byArray);
            stringArray[i] = new String(byArray);
            stringArray[i].hashCode();
        }
        HashSet<String> hashSet = new HashSet<String>();
        LightHashSet lightHashSet = new LightHashSet();
        System.out.println("fill:");
        long l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            hashSet.add(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            lightHashSet.add(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("replace-fill:");
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            hashSet.add(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            lightHashSet.add(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("get:");
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            hashSet.contains(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            lightHashSet.contains(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("compactify light map");
        l = System.currentTimeMillis();
        lightHashSet.compactify(0.95f);
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("transfer to hashmap");
        l = System.currentTimeMillis();
        new HashSet(hashSet);
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        new HashSet(lightHashSet);
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("transfer to lighthashmap");
        l = System.currentTimeMillis();
        new LightHashSet(hashSet);
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        new LightHashSet(lightHashSet);
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("remove entry by entry");
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            hashSet.remove(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            lightHashSet.remove(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        System.out.println("Call with -Xmx300m -Xcomp -server");
        Thread.currentThread().setPriority(10);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        LightHashSet.test();
        System.out.println("-------------------------------------");
        System.gc();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        LightHashSet.test();
        System.out.println("\n\nPerforming sanity tests");
        Random random = new Random();
        byte[] byArray = new byte[25];
        String[] stringArray2 = new String[1048];
        for (int i = 0; i < stringArray2.length; ++i) {
            random.nextBytes(byArray);
            stringArray2[i] = new String(byArray);
            stringArray2[i].hashCode();
        }
        HashSet<String> hashSet = new HashSet<String>();
        LightHashSet lightHashSet = new LightHashSet();
        for (n2 = 0; n2 < stringArray2.length * 10; ++n2) {
            n = random.nextInt(stringArray2.length);
            hashSet.add(null);
            lightHashSet.add(null);
            if (!((Object)hashSet).equals(lightHashSet)) {
                System.out.println("Error 0");
            }
            hashSet.add(stringArray2[n]);
            lightHashSet.add(stringArray2[n]);
            if (((Object)hashSet).equals(lightHashSet)) continue;
            System.out.println("Error 1");
        }
        for (n2 = 0; n2 < stringArray2.length / 2; ++n2) {
            n = random.nextInt(stringArray2.length);
            hashSet.remove(stringArray2[n]);
            lightHashSet.remove(stringArray2[n]);
            if (((Object)hashSet).equals(lightHashSet)) continue;
            System.out.println("Error 2");
        }
        for (n2 = 0; n2 < stringArray2.length * 10; ++n2) {
            n = random.nextInt(stringArray2.length);
            hashSet.add(stringArray2[n]);
            hashSet.add(null);
            lightHashSet.add(stringArray2[n]);
            lightHashSet.add(null);
            if (((Object)hashSet).equals(lightHashSet)) continue;
            System.out.println("Error 3");
        }
        Iterator iterator = hashSet.iterator();
        Iterator iterator2 = lightHashSet.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            iterator2.next();
            iterator2.remove();
        }
        if (!((Object)hashSet).equals(lightHashSet)) {
            System.out.println("Error 4");
        }
        lightHashSet.clear();
        for (int i = 0; i < 100000; ++i) {
            random.nextBytes(byArray);
            String string = new String(byArray);
            lightHashSet.add(string);
            lightHashSet.contains(string);
            lightHashSet.remove(string);
        }
        System.out.println("checks done");
    }

    private class HashIterator
    implements Iterator {
        private int nextIdx = -1;
        private int currentIdx = -1;
        private Object[] itData;

        public HashIterator() {
            this.itData = LightHashSet.this.data;
            this.findNext();
        }

        private void findNext() {
            do {
                ++this.nextIdx;
            } while (this.nextIdx < this.itData.length && (this.itData[this.nextIdx] == null || this.itData[this.nextIdx] == THOMBSTONE));
        }

        public void remove() {
            if (this.currentIdx == -1) {
                throw new IllegalStateException("No entry to delete, use next() first");
            }
            if (this.itData != LightHashSet.this.data) {
                throw new ConcurrentModificationException("removal opperation not supported as concurrent structural modification occured");
            }
            LightHashSet.this.removeForIndex(this.currentIdx);
            this.currentIdx = -1;
        }

        public boolean hasNext() {
            return this.nextIdx < this.itData.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No more entries");
            }
            this.currentIdx = this.nextIdx;
            this.findNext();
            Object object = this.itData[this.currentIdx];
            return object != NULLKEY ? object : null;
        }
    }
}

