/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.protocol.magnet;

import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import org.gudy.azureus2.core3.util.Debug;

public class MagnetConnection2
extends HttpURLConnection {
    private static final String NL = "\r\n";
    private OutputStream output_stream;
    private InputStream input_stream;
    private LinkedList<String> status_list = new LinkedList();

    protected MagnetConnection2(URL uRL) {
        super(uRL);
    }

    public void connect() throws IOException {
        String string = "/download/" + this.getURL().toString().substring(7) + " HTTP/1.0" + NL + NL;
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream();
        pipedInputStream.connect(pipedOutputStream);
        this.input_stream = pipedInputStream;
        this.output_stream = pipedOutputStream;
        MagnetURIHandler.getSingleton().process(string, new ByteArrayInputStream(new byte[0]), pipedOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        int n;
        String string = "";
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2048];
        int n2 = 0;
        while ((n = this.input_stream.read(byArray)) != -1) {
            string = string + (char)byArray[0];
            byArray2[n2++] = byArray[0];
            if (!string.endsWith(NL)) continue;
            if ((string = string.trim()).length() == 0) break;
            if (string.startsWith("X-Report:")) {
                string = new String(byArray2, 0, n2, "UTF-8");
                string = string.substring(9);
                string = string.trim();
                LinkedList<String> linkedList = this.status_list;
                synchronized (linkedList) {
                    String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
                    if (this.status_list.size() == 0) {
                        this.status_list.addLast(string2);
                    } else if (!this.status_list.getLast().equals(string2)) {
                        this.status_list.addLast(string2);
                    }
                }
            }
            string = "";
            n2 = 0;
        }
        return this.input_stream;
    }

    public int getResponseCode() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseMessage() {
        LinkedList<String> linkedList = this.status_list;
        synchronized (linkedList) {
            if (this.status_list.size() == 0) {
                return "";
            }
            if (this.status_list.size() == 1) {
                return this.status_list.get(0);
            }
            return this.status_list.removeFirst();
        }
    }

    public boolean usingProxy() {
        return false;
    }

    public void disconnect() {
        try {
            this.output_stream.close();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        try {
            this.input_stream.close();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }
}

