/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.utils;

import java.io.InputStream;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploaderFactory;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourceuploader.ResourceUploaderFactoryImpl;

public class StaticUtilities {
    private static Formatters formatters;

    public static Formatters getFormatters() {
        return formatters;
    }

    public static ResourceDownloaderFactory getResourceDownloaderFactory() {
        return ResourceDownloaderFactoryImpl.getSingleton();
    }

    public static ResourceUploaderFactory getResourceUploaderFactory() {
        return ResourceUploaderFactoryImpl.getSingleton();
    }

    public static RSSFeed getRSSFeed(InputStream inputStream) throws SimpleXMLParserDocumentException {
        return PluginInitializer.getDefaultInterface().getUtilities().getRSSFeed(inputStream);
    }

    public static int promptUser(String string, String string2, String[] stringArray, int n) {
        UIInstance[] uIInstanceArray = PluginInitializer.getDefaultInterface().getUIManager().getUIInstances();
        if (uIInstanceArray.length > 0) {
            return uIInstanceArray[0].promptUser(string, string2, stringArray, n);
        }
        Debug.out("No UIInstances to handle prompt: " + string + "/" + string2);
        return -1;
    }

    public static UIManager getUIManager(long l) {
        final UIManager uIManager = PluginInitializer.getDefaultInterface().getUIManager();
        if (uIManager.getUIInstances().length == 0) {
            final AESemaphore aESemaphore = new AESemaphore("waitforui");
            uIManager.addUIListener(new UIManagerListener(){

                public void UIAttached(UIInstance uIInstance) {
                    uIManager.removeUIListener(this);
                    aESemaphore.releaseForever();
                }

                public void UIDetached(UIInstance uIInstance) {
                }
            });
            long l2 = l;
            while (uIManager.getUIInstances().length == 0 && !aESemaphore.reserve(1000L)) {
                if ((l2 -= 1000L) > 0L) continue;
                Debug.out("Timeout waiting for UI to attach");
                break;
            }
        }
        return uIManager;
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl");
            formatters = (Formatters)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

