/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ddb;

import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseContactImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseHelpers;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseKeyImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseValueImpl;

public class DDBaseTTTorrent
implements DistributedDatabaseTransferType,
DistributedDatabaseTransferHandler {
    private static final boolean TRACE = false;
    private static final byte CRYPTO_VERSION = 1;
    private DDBaseImpl ddb;
    private TorrentAttribute ta_sha1;
    private boolean crypto_tested;
    private boolean crypto_available;
    private List external_downloads;
    private Map data_cache = new LinkedHashMap(5, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 5;
        }
    };

    protected DDBaseTTTorrent(DDBaseImpl dDBaseImpl) {
        this.ddb = dDBaseImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownload(Download download) {
        DDBaseTTTorrent dDBaseTTTorrent = this;
        synchronized (dDBaseTTTorrent) {
            if (this.external_downloads == null) {
                this.external_downloads = new ArrayList();
            }
            this.external_downloads.add(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownload(Download download) {
        DDBaseTTTorrent dDBaseTTTorrent = this;
        synchronized (dDBaseTTTorrent) {
            if (this.external_downloads != null) {
                this.external_downloads.remove(download);
            }
            if (this.external_downloads.size() == 0) {
                this.external_downloads = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedDatabaseValue read(DistributedDatabaseContact distributedDatabaseContact, DistributedDatabaseTransferType distributedDatabaseTransferType, DistributedDatabaseKey distributedDatabaseKey) throws DistributedDatabaseException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            byte[] byArray = ((DDBaseKeyImpl)distributedDatabaseKey).getBytes();
            Object object5 = null;
            PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
            String string = pluginInterface.getUtilities().getFormatters().encodeBytesToString(byArray);
            if (this.ta_sha1 == null) {
                this.ta_sha1 = pluginInterface.getTorrentManager().getPluginAttribute("DDBaseTTTorrent::sha1");
            }
            Download[] downloadArray = pluginInterface.getDownloadManager().getDownloads();
            for (int i = 0; i < downloadArray.length; ++i) {
                object4 = downloadArray[i];
                if (object4.getTorrent() == null) continue;
                object3 = object4.getAttribute(this.ta_sha1);
                if (object3 == null) {
                    object3 = pluginInterface.getUtilities().getFormatters().encodeBytesToString(new SHA1Simple().calculateHash(object4.getTorrent().getHash()));
                    object4.setAttribute(this.ta_sha1, (String)object3);
                }
                if (!((String)object3).equals(string)) continue;
                object5 = object4;
                break;
            }
            if (object5 == null) {
                DDBaseTTTorrent dDBaseTTTorrent = this;
                synchronized (dDBaseTTTorrent) {
                    if (this.external_downloads != null) {
                        for (int i = 0; i < this.external_downloads.size(); ++i) {
                            object3 = (Download)this.external_downloads.get(i);
                            if (object3.getTorrent() == null) continue;
                            object2 = object3.getAttribute(this.ta_sha1);
                            if (object2 == null) {
                                object2 = pluginInterface.getUtilities().getFormatters().encodeBytesToString(new SHA1Simple().calculateHash(object3.getTorrent().getHash()));
                                object3.setAttribute(this.ta_sha1, (String)object2);
                            }
                            if (!((String)object2).equals(string)) continue;
                            object5 = object3;
                            break;
                        }
                    }
                }
            }
            String string2 = distributedDatabaseContact.getName();
            if (object5 == null) {
                object4 = "TorrentDownload: request from " + string2 + " for '" + pluginInterface.getUtilities().getFormatters().encodeBytesToString(byArray) + "' not found";
                this.ddb.log((String)object4);
                return null;
            }
            object4 = object5.getTorrent();
            if (object4.isPrivate()) {
                Debug.out("Attempt to download private torrent");
                this.ddb.log("TorrentDownload: request from " + string2 + "  for '" + object5.getName() + "' denied as it is private");
                return null;
            }
            object3 = "TorrentDownload: request from " + string2 + "  for '" + object5.getName() + "' OK";
            this.ddb.log((String)object3);
            object2 = new HashWrapper(object4.getHash());
            Object object6 = this.data_cache;
            synchronized (object6) {
                object = (Object[])this.data_cache.get(object2);
                if (object != null) {
                    object[1] = new Long(SystemTime.getCurrentTime());
                    return this.ddb.createValue((byte[])object[0]);
                }
            }
            object4 = object4.removeAdditionalProperties();
            object4.setDecentralisedBackupRequested(true);
            object6 = object4.writeToBEncodedData();
            object6 = this.encrypt(object4.getHash(), (byte[])object6);
            if (object6 == null) {
                return null;
            }
            object = this.data_cache;
            synchronized (object) {
                if (this.data_cache.size() == 0) {
                    final TimerEventPeriodic[] timerEventPeriodicArray = new TimerEventPeriodic[]{null};
                    timerEventPeriodicArray[0] = SimpleTimer.addPeriodicEvent("DDBTorrent:timeout", 30000L, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent timerEvent2) {
                            long l = SystemTime.getCurrentTime();
                            Map map = DDBaseTTTorrent.this.data_cache;
                            synchronized (map) {
                                Iterator iterator = DDBaseTTTorrent.this.data_cache.values().iterator();
                                while (iterator.hasNext()) {
                                    long l2 = (Long)((Object[])iterator.next())[1];
                                    if (l >= l2 && l - l2 <= 120000L) continue;
                                    iterator.remove();
                                }
                                if (DDBaseTTTorrent.this.data_cache.size() == 0) {
                                    timerEventPeriodicArray[0].cancel();
                                }
                            }
                        }
                    });
                }
                this.data_cache.put(object2, new Object[]{object6, new Long(SystemTime.getCurrentTime())});
            }
            return this.ddb.createValue(object6);
        }
        catch (Throwable throwable) {
            throw new DistributedDatabaseException("Torrent write fails", throwable);
        }
    }

    public void write(DistributedDatabaseContact distributedDatabaseContact, DistributedDatabaseTransferType distributedDatabaseTransferType, DistributedDatabaseKey distributedDatabaseKey, DistributedDatabaseValue distributedDatabaseValue) throws DistributedDatabaseException {
        throw new DistributedDatabaseException("not supported");
    }

    protected DistributedDatabaseValue read(DDBaseContactImpl dDBaseContactImpl, final DistributedDatabaseProgressListener distributedDatabaseProgressListener, DistributedDatabaseTransferType distributedDatabaseTransferType, DistributedDatabaseKey distributedDatabaseKey, long l) throws DistributedDatabaseException {
        byte[] byArray = ((DDBaseKeyImpl)distributedDatabaseKey).getBytes();
        byte[] byArray2 = new SHA1Simple().calculateHash(byArray);
        byte[] byArray3 = dDBaseContactImpl.getContact().read(new DHTPluginProgressListener(){

            public void reportSize(long l) {
                distributedDatabaseProgressListener.reportSize(l);
            }

            public void reportActivity(String string) {
                distributedDatabaseProgressListener.reportActivity(string);
            }

            public void reportCompleteness(int n) {
                distributedDatabaseProgressListener.reportCompleteness(n);
            }
        }, DDBaseHelpers.getKey(distributedDatabaseTransferType.getClass()).getHash(), byArray2, l);
        if (byArray3 == null) {
            return null;
        }
        if ((byArray3 = this.decrypt(byArray, byArray3)) == null) {
            return null;
        }
        return new DDBaseValueImpl(dDBaseContactImpl, byArray3, SystemTime.getCurrentTime(), -1L);
    }

    protected byte[] encrypt(byte[] byArray, byte[] byArray2) {
        if (!this.testCrypto()) {
            return null;
        }
        byte[] byArray3 = this.doCrypt(1, byArray, byArray2, 0);
        if (byArray3 == null) {
            byte[] byArray4 = new byte[byArray2.length + 2];
            byArray4[0] = 1;
            byArray4[1] = 0;
            System.arraycopy(byArray2, 0, byArray4, 2, byArray2.length);
            return byArray4;
        }
        byte[] byArray5 = new byte[byArray3.length + 2];
        byArray5[0] = 1;
        byArray5[1] = 1;
        System.arraycopy(byArray3, 0, byArray5, 2, byArray3.length);
        return byArray5;
    }

    protected byte[] decrypt(byte[] byArray, byte[] byArray2) {
        if (!this.testCrypto()) {
            return null;
        }
        if (byArray2[0] != 1) {
            Debug.out("Invalid crypto version received");
            return byArray2;
        }
        if (byArray2[1] == 0) {
            byte[] byArray3 = new byte[byArray2.length - 2];
            System.arraycopy(byArray2, 2, byArray3, 0, byArray3.length);
            return byArray3;
        }
        byte[] byArray4 = this.doCrypt(2, byArray, byArray2, 2);
        return byArray4;
    }

    protected byte[] doCrypt(int n, byte[] byArray, byte[] byArray2, int n2) {
        try {
            byte[] byArray3 = new byte[24];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, "DESede");
            Cipher cipher = Cipher.getInstance("DESede");
            cipher.init(n, secretKeySpec);
            return cipher.doFinal(byArray2, n2, byArray2.length - n2);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return null;
        }
    }

    protected boolean testCrypto() {
        if (!this.crypto_tested) {
            this.crypto_tested = true;
            try {
                Cipher.getInstance("DESede");
                this.crypto_available = true;
            }
            catch (Throwable throwable) {
                Logger.log(new LogAlert(false, "Unable to initialise cryptographic framework for magnet-based torrent downloads, please re-install Java", throwable));
            }
        }
        return this.crypto_available;
    }
}

