/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.disk;

import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerException;
import org.gudy.azureus2.plugins.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.plugins.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerImpl
implements DiskManager {
    private org.gudy.azureus2.core3.disk.DiskManager disk_manager;

    public DiskManagerImpl(org.gudy.azureus2.core3.disk.DiskManager diskManager) {
        this.disk_manager = diskManager;
    }

    public org.gudy.azureus2.core3.disk.DiskManager getDiskmanager() {
        return this.disk_manager;
    }

    public org.gudy.azureus2.plugins.disk.DiskManagerReadRequest read(int n, int n2, int n3, final org.gudy.azureus2.plugins.disk.DiskManagerReadRequestListener diskManagerReadRequestListener) throws DiskManagerException {
        if (!this.disk_manager.checkBlockConsistencyForRead("plugin", false, n, n2, n3)) {
            throw new DiskManagerException("read invalid - parameters incorrect or piece incomplete");
        }
        final DMRR dMRR = new DMRR(this.disk_manager.createReadRequest(n, n2, n3));
        this.disk_manager.enqueueReadRequest(dMRR.getDelegate(), new DiskManagerReadRequestListener(){

            public void readCompleted(DiskManagerReadRequest diskManagerReadRequest, DirectByteBuffer directByteBuffer) {
                diskManagerReadRequestListener.complete(dMRR, new PooledByteBufferImpl(directByteBuffer));
            }

            public void readFailed(DiskManagerReadRequest diskManagerReadRequest, Throwable throwable) {
                diskManagerReadRequestListener.failed(dMRR, new DiskManagerException("read failed", throwable));
            }

            public int getPriority() {
                return 0;
            }

            public void requestExecuted(long l) {
            }
        });
        return dMRR;
    }

    public DiskManagerWriteRequest write(final int n, final int n2, PooledByteBuffer pooledByteBuffer, final DiskManagerWriteRequestListener diskManagerWriteRequestListener) throws DiskManagerException {
        DirectByteBuffer directByteBuffer = ((PooledByteBufferImpl)pooledByteBuffer).getBuffer();
        if (!this.disk_manager.checkBlockConsistencyForWrite("plugin", n, n2, directByteBuffer)) {
            throw new DiskManagerException("write invalid - parameters incorrect");
        }
        final int n3 = directByteBuffer.remaining((byte)1);
        final DMWR dMWR = new DMWR(this.disk_manager.createWriteRequest(n, n2, directByteBuffer, null), n3);
        this.disk_manager.enqueueWriteRequest(dMWR.getDelegate(), new org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener(){

            public void writeCompleted(org.gudy.azureus2.core3.disk.DiskManagerWriteRequest diskManagerWriteRequest) {
                DiskManagerPiece[] diskManagerPieceArray = DiskManagerImpl.this.disk_manager.getPieces();
                DiskManagerPiece diskManagerPiece = diskManagerPieceArray[n];
                if (!diskManagerPiece.isDone()) {
                    int n4 = n2;
                    for (int i = 0; i < n3; i += 16384) {
                        diskManagerPiece.setWritten(n4 / 16384);
                        n4 += 16384;
                    }
                }
                diskManagerWriteRequestListener.complete(dMWR);
            }

            public void writeFailed(org.gudy.azureus2.core3.disk.DiskManagerWriteRequest diskManagerWriteRequest, Throwable throwable) {
                diskManagerWriteRequestListener.failed(dMWR, new DiskManagerException("read failed", throwable));
            }
        });
        return dMWR;
    }

    private class DMWR
    implements DiskManagerWriteRequest {
        private org.gudy.azureus2.core3.disk.DiskManagerWriteRequest request;
        private int length;

        private DMWR(org.gudy.azureus2.core3.disk.DiskManagerWriteRequest diskManagerWriteRequest, int n) {
            this.request = diskManagerWriteRequest;
        }

        private org.gudy.azureus2.core3.disk.DiskManagerWriteRequest getDelegate() {
            return this.request;
        }

        public int getPieceNumber() {
            return this.request.getPieceNumber();
        }

        public int getOffset() {
            return this.request.getOffset();
        }

        public int getLength() {
            return this.length;
        }
    }

    private class DMRR
    implements org.gudy.azureus2.plugins.disk.DiskManagerReadRequest {
        private DiskManagerReadRequest request;

        private DMRR(DiskManagerReadRequest diskManagerReadRequest) {
            this.request = diskManagerReadRequest;
        }

        private DiskManagerReadRequest getDelegate() {
            return this.request;
        }

        public int getPieceNumber() {
            return this.request.getPieceNumber();
        }

        public int getOffset() {
            return this.request.getOffset();
        }

        public int getLength() {
            return this.request.getLength();
        }
    }
}

