/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import java.net.InetSocketAddress;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;

public class GenericMessageEndpointImpl
implements GenericMessageEndpoint {
    private ConnectionEndpoint ce;

    public GenericMessageEndpointImpl(ConnectionEndpoint connectionEndpoint) {
        this.ce = connectionEndpoint;
    }

    public GenericMessageEndpointImpl(InetSocketAddress inetSocketAddress) {
        this.ce = new ConnectionEndpoint(inetSocketAddress);
    }

    public InetSocketAddress getNotionalAddress() {
        return this.ce.getNotionalAddress();
    }

    protected ConnectionEndpoint getConnectionEndpoint() {
        return this.ce;
    }

    public void addTCP(InetSocketAddress inetSocketAddress) {
        this.ce.addProtocol(new ProtocolEndpointTCP(inetSocketAddress));
    }

    public InetSocketAddress getTCP() {
        ProtocolEndpoint[] protocolEndpointArray = this.ce.getProtocols();
        for (int i = 0; i < protocolEndpointArray.length; ++i) {
            if (!(protocolEndpointArray[i] instanceof ProtocolEndpointTCP)) continue;
            return ((ProtocolEndpointTCP)protocolEndpointArray[i]).getAddress();
        }
        return null;
    }

    public void addUDP(InetSocketAddress inetSocketAddress) {
        this.ce.addProtocol(new ProtocolEndpointUDP(inetSocketAddress));
    }

    public InetSocketAddress getUDP() {
        ProtocolEndpoint[] protocolEndpointArray = this.ce.getProtocols();
        for (int i = 0; i < protocolEndpointArray.length; ++i) {
            if (!(protocolEndpointArray[i] instanceof ProtocolEndpointUDP)) continue;
            return ((ProtocolEndpointUDP)protocolEndpointArray[i]).getAddress();
        }
        return null;
    }
}

