/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class TorrentDownloaderImpl
implements TorrentDownloader {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    protected TorrentManagerImpl manager;
    protected URL url;
    protected ResourceDownloader downloader;
    protected boolean encoding_requested;
    protected String requested_encoding;
    protected boolean set_encoding;

    protected TorrentDownloaderImpl(TorrentManagerImpl torrentManagerImpl, URL uRL) {
        this.manager = torrentManagerImpl;
        this.url = uRL;
        this.downloader = ResourceDownloaderFactoryImpl.getSingleton().create(this.url);
    }

    protected TorrentDownloaderImpl(TorrentManagerImpl torrentManagerImpl, URL uRL, String string, String string2) {
        this.manager = torrentManagerImpl;
        this.url = uRL;
        this.set_encoding = true;
        this.downloader = ResourceDownloaderFactoryImpl.getSingleton().create(this.url, string, string2);
        this.downloader.addListener(new ResourceDownloaderAdapter(){

            public void reportActivity(ResourceDownloader resourceDownloader, String string) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "TorrentDownloader:" + string));
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Torrent download() throws TorrentException {
        TorrentImpl torrentImpl;
        InputStream inputStream = null;
        try {
            try {
                inputStream = this.downloader.download();
                TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(inputStream);
                if (this.encoding_requested) {
                    this.manager.tryToSetTorrentEncoding(tOTorrent, this.requested_encoding);
                } else if (this.set_encoding) {
                    this.manager.tryToSetDefaultTorrentEncoding(tOTorrent);
                }
                torrentImpl = new TorrentImpl(tOTorrent);
                Object var5_6 = null;
                if (inputStream == null) return torrentImpl;
            }
            catch (TorrentException torrentException) {
                throw torrentException;
            }
            catch (Throwable throwable) {
                throw new TorrentException("TorrentDownloader: download fails", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Debug.printStackTrace(iOException);
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            Debug.printStackTrace(iOException);
            return torrentImpl;
        }
        inputStream.close();
        return torrentImpl;
    }

    public Torrent download(String string) throws TorrentException {
        this.encoding_requested = true;
        this.requested_encoding = string;
        return this.download();
    }
}

