/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostAuthenticationListener;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostListener2;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationAdapter;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationListener;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWCHelper;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebContextImpl;

public class TrackerImpl
extends TrackerWCHelper
implements Tracker,
TRHostListener2,
TRHostAuthenticationListener {
    private static TrackerImpl singleton;
    private static AEMonitor class_mon;
    private List listeners = new ArrayList();
    private TRHost host;
    private List<TrackerAuthenticationListener> auth_listeners = new ArrayList<TrackerAuthenticationListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracker getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TrackerImpl(TRHostFactory.getSingleton());
            }
            TrackerImpl trackerImpl = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return trackerImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected TrackerImpl(TRHost tRHost) {
        this.setTracker(this);
        this.host = tRHost;
        this.host.addListener2(this);
    }

    public String getName() {
        return this.host.getName();
    }

    public void setEnableKeepAlive(boolean bl) {
        Debug.out("Keep alive setting ignored for tracker");
    }

    public URL[] getURLs() {
        URL[][] uRLArray = TRTrackerUtils.getAnnounceURLs();
        URL[] uRLArray2 = new URL[uRLArray.length];
        for (int i = 0; i < uRLArray2.length; ++i) {
            uRLArray2[i] = uRLArray[i][0];
        }
        return uRLArray2;
    }

    public InetAddress getBindIP() {
        return this.host.getBindIP();
    }

    public TrackerTorrent host(Torrent torrent, boolean bl) throws TrackerException {
        return this.host(torrent, bl, false);
    }

    public TrackerTorrent host(Torrent torrent, boolean bl, boolean bl2) throws TrackerException {
        TorrentImpl torrentImpl = (TorrentImpl)torrent;
        try {
            return new TrackerTorrentImpl(this.host.hostTorrent(torrentImpl.getTorrent(), bl, bl2));
        }
        catch (Throwable throwable) {
            throw new TrackerException("Tracker: host operation fails", throwable);
        }
    }

    public TrackerTorrent publish(Torrent torrent) throws TrackerException {
        TorrentImpl torrentImpl = (TorrentImpl)torrent;
        try {
            return new TrackerTorrentImpl(this.host.publishTorrent(torrentImpl.getTorrent()));
        }
        catch (Throwable throwable) {
            throw new TrackerException("Tracker: publish operation fails", throwable);
        }
    }

    public TrackerTorrent[] getTorrents() {
        TRHostTorrent[] tRHostTorrentArray = this.host.getTorrents();
        TrackerTorrent[] trackerTorrentArray = new TrackerTorrent[tRHostTorrentArray.length];
        for (int i = 0; i < tRHostTorrentArray.length; ++i) {
            trackerTorrentArray[i] = new TrackerTorrentImpl(tRHostTorrentArray[i]);
        }
        return trackerTorrentArray;
    }

    public TrackerTorrent getTorrent(Torrent torrent) {
        TRHostTorrent tRHostTorrent = this.host.getHostTorrent(((TorrentImpl)torrent).getTorrent());
        if (tRHostTorrent == null) {
            return null;
        }
        return new TrackerTorrentImpl(tRHostTorrent);
    }

    public TrackerWebContext createWebContext(int n, int n2) throws TrackerException {
        return new TrackerWebContextImpl(this, null, n, n2, null);
    }

    public TrackerWebContext createWebContext(String string, int n, int n2) throws TrackerException {
        return new TrackerWebContextImpl(this, string, n, n2, null);
    }

    public TrackerWebContext createWebContext(String string, int n, int n2, InetAddress inetAddress) throws TrackerException {
        return new TrackerWebContextImpl(this, string, n, n2, inetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void torrentAdded(TRHostTorrent tRHostTorrent) {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TrackerListener)this.listeners.get(i)).torrentAdded(new TrackerTorrentImpl(tRHostTorrent));
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void torrentChanged(TRHostTorrent tRHostTorrent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TrackerListener)this.listeners.get(i)).torrentChanged(new TrackerTorrentImpl(tRHostTorrent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void torrentRemoved(TRHostTorrent tRHostTorrent) {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TrackerListener)this.listeners.get(i)).torrentRemoved(new TrackerTorrentImpl(tRHostTorrent));
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TrackerListener trackerListener) {
        try {
            this.this_mon.enter();
            this.listeners.add(trackerListener);
            TrackerTorrent[] trackerTorrentArray = this.getTorrents();
            for (int i = 0; i < trackerTorrentArray.length; ++i) {
                trackerListener.torrentAdded(trackerTorrentArray[i]);
            }
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TrackerListener trackerListener) {
        try {
            this.this_mon.enter();
            this.listeners.remove(trackerListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public boolean authenticate(String string, URL uRL, String string2, String string3) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                TrackerAuthenticationListener trackerAuthenticationListener = this.auth_listeners.get(i);
                boolean bl = trackerAuthenticationListener instanceof TrackerAuthenticationAdapter ? ((TrackerAuthenticationAdapter)trackerAuthenticationListener).authenticate(string, uRL, string2, string3) : trackerAuthenticationListener.authenticate(uRL, string2, string3);
                if (!bl) continue;
                return true;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return false;
    }

    public byte[] authenticate(URL uRL, String string) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                byte[] byArray = this.auth_listeners.get(i).authenticate(uRL, string);
                if (byArray == null) continue;
                return byArray;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthenticationListener(TrackerAuthenticationListener trackerAuthenticationListener) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(trackerAuthenticationListener);
            if (this.auth_listeners.size() == 1) {
                this.host.addAuthenticationListener(this);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthenticationListener(TrackerAuthenticationListener trackerAuthenticationListener) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(trackerAuthenticationListener);
            if (this.auth_listeners.size() == 0) {
                this.host.removeAuthenticationListener(this);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void destroy() {
        super.destroy();
        this.auth_listeners.clear();
        this.host.removeAuthenticationListener(this);
        this.listeners.clear();
        this.host.close();
    }

    static {
        class_mon = new AEMonitor("Tracker");
    }
}

